<div>
    @include("admin.partials.messages")
    <div class="grid grid-cols-3 gap-8">
        <div class="col-span-2">
            <div class="font-semibold uppercase text-red-500 tracking-wide text-sm border-b border-red-500 mb-3 pb-1">Search Sites</div>
            <form wire:submit.prevent=" searchDuplicates() " class="flex items-end">
                    <input type="text" wire:model.defer="client_website" class="border-gray-300 grow">
                    <select wire:model.defer="website_status" class="border-gray-300">
                        <option value="all">All</option>
                        <option value="Acceptable">Acceptable</option>
                        <option value="Sudden Decline">Sudden Decline</option>
                        <option value="Acceptable in Worse Case">Acceptable in Worse Case</option>
                        <option value="Inflated Traffic">Inflated Traffic</option>
                        <option value="Need to Further Review">Need to Further Review</option>
                        <option value="Non Acceptable">Non Acceptable</option>
                        <option value="Acceptable but below 100">Acceptable but below 100</option>
                    </select>
                    <button class="bg-blue-700 text-white px-6 py-2 border border-blue-700 grow">Click here for Search</button>
            </form>

            <div>
                <div class="flex items-center justify-end"><button type="button" id="copyText" class="bg-black text-white text-xs rounded px-5 py-2">copy websites</button></div>
                <div class="overflow-auto h-[500px] border border-gray-400">
                    <table class="border-separate whitespace-nowrap table-auto w-full">
                        <thead class="bg-red-500 text-white">
                        <tr>
                            <th class="p-3 text-sm">Domain</th>
                            <th class="p-3 text-sm">Status</th>
                            <th class="p-3 text-sm">
                                @if($new_order->order_type == 'gp' && $new_order->fc )
                                    GP PRICE(FC)
                                @endif
                                @if($new_order->order_type == 'gp' && $new_order->fc == 0 )
                                    GP PRICE
                                @endif
                                @if($new_order->order_type == 'niche' && $new_order->fc)
                                    NICHE PRICE(FC)
                                @endif

                                @if($new_order->order_type == 'niche' && $new_order->fc == 0)
                                    NICHE PRICE
                                @endif

                            </th>
                            <th class="p-3 text-sm">Category</th>
                            <th class="p-3 text-sm">DR</th>
                            <th class="p-3 text-sm">RD</th>
                            <th class="p-3 text-sm">Traffic</th>
                            <th class="p-3 text-sm">DA</th>
                            <th class="p-3 text-sm">Spam Score</th>
                            <th class="p-3 text-sm">Traffic Source</th>

                        </tr>
                        </thead>
                        <tbody>
                        @foreach($orders as $order)
                            <tr class="cursor-pointer" wire:click="selectSite({{ $order->id }}) ">
                                <td class="border border-gray-300 p-3 text-xs text-center break-words"><div class="root_domain_copy">{{ $order->root_domain }}</div></td>
                                <td class="border border-gray-300 p-3 text-xs text-center break-words"><div>{{ $order->website_status }}</div> </td>
                                <td class="border border-gray-300 p-3 text-xs text-center">

                                    @if($new_order->order_type == 'gp' && $new_order->fc )
                                        <div>{{ $order->fc_gp }}</div>
                                    @endif
                                    @if($new_order->order_type == 'gp' && $new_order->fc == 0 )
                                            <div>{{ $order->gp_price }}</div>
                                    @endif
                                    @if($new_order->order_type == 'niche' && $new_order->fc)
                                            <div>{{ $order->fc_ne }}</div>
                                    @endif

                                    @if($new_order->order_type == 'niche' && $new_order->fc == 0)
                                            <div>{{ $order->niche_edit_price }}</div>
                                    @endif


                                </td>
                                <td class="border border-gray-300 p-3 text-xs text-center break-words"><div>{{ $order->category }}</div></td>
                                <td class="border border-gray-300 p-3 text-xs text-center break-words"><div>{{ $order->dr }}</div></td>
                                <td class="border border-gray-300 p-3 text-xs text-center break-words"><div>{{ $order->rd }}</div></td>
                                <td class="border border-gray-300 p-3 text-xs text-center break-words"><div>{{ $order->traffic_source }}</div></td>
                                <td class="border border-gray-300 p-3 text-xs text-center break-words"><div>{{ $order->da }}</div></td>
                                <td class="border border-gray-300 p-3 text-xs text-center break-words"><div>{{ $order->spam_score }}</div></td>
                                <td class="border border-gray-300 p-3 text-xs text-center break-words"><div>{{ $order->country_source }}</div></td>

                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                </div>

            </div>
        </div>
        <div class="col-span-1 ">
            <div class="font-semibold uppercase text-red-500 tracking-wide text-sm border-b border-red-500 mb-3 pb-1">Selected Sites {{ count($selected_orders) }}</div>
            <div>
                @if(count($selected_orders) > 0 )
                <table class="border-separate table-fixed w-full mt-4">
                    <thead class="bg-blue-700 text-white">
                        <tr>
                            <th class="p-3 text-sm">Domain</th>
                            <th class="p-3 text-sm">Price</th>
                            <th class="p-3 text-sm">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                    @foreach($selected_orders as $order)
                        <tr>
                            <td class="border border-gray-300 p-3 text-xs text-center break-words"><div>{{ $order->root_domain }}</div></td>

                            <td class="border border-gray-300 p-3 text-xs text-center">
                                @if($new_order->order_type == 'gp' && $new_order->fc == 1)
                                    <div>{{ $order->fc_gp }}</div>
                                @endif

                                @if($new_order->order_type == 'gp' && $new_order->fc != 1)
                                    <div>{{ $order->gp_price }}</div>
                                @endif

                                @if($new_order->order_type == 'niche' && $new_order->fc == 1)
                                    <div>{{ $order->fc_ne }}</div>
                                @endif

                                @if($new_order->order_type == 'niche' && $new_order->fc != 1)
                                    <div>{{ $order->niche_edit_price }}</div>
                                @endif
                            </td>
                            <td class="border border-gray-300 p-3 text-xs text-center break-words">
                                <button wire:click="deleteSite({{ $order->id }})" class="bg-red-500 text-white text-xs px-2 py-1">Delete</button>
                            </td>
                        </tr>
                        @if($new_order->order_type == "niche")
                            <tr>
                                <td colspan="3">
                                    <div class="flex items-start">
                                        <textarea placeholder="Copy Urls" wire:model="selected_sites.{{ $order->id }}.post_url" class="flex-1 w-full"></textarea>
                                        <textarea placeholder="Note" wire:model="selected_sites.{{ $order->id }}.note" class="flex-1 w-full"></textarea>
                                    </div>
                                </td>
                            </tr>
                        @else
                            <tr>
                                <td colspan="3">
                                    <div class="flex items-start">
                                        <textarea placeholder="Note" wire:model="selected_sites.{{ $order->id }}.note" class="flex-1 w-full"></textarea>
                                    </div>
                                </td>
                            </tr>
                        @endif
                    @endforeach
                    </tbody>
                </table>
                <div class="flex flex-col">
                    <form wire:submit.prevent="pushToManager()">
                        <textarea rows="4" class="w-full mx-0.5 border border-gray-400" wire:model.defer="note" placeholder="Note........."></textarea>
                        <button class="bg-red-500 text-white uppercase py-2 w-full" type="submit">PUSH to manager</button>
                    </form>
                </div>
                @endif
            </div>
        </div>
    </div>


    <script>
        $(function (){
           $('#copyText').on("click",function (){
                let root_domain = $('.root_domain_copy');

                if( root_domain.length === 0 ){

                }else{
                    let text = "";
                    for(let i=0;i<root_domain.length;i++){
                        text += root_domain[i].textContent + "\n";
                    }

                    navigator.clipboard.writeText(text);
                    alert("Copied");
                }

           });
        });
    </script>

</div>
