@php use App\Project\NewOrderStatus; @endphp
<div class="w-full">
    <table class="table-fixed w-full">
        <thead class="bg-slate-700">
            <tr>
                <th class="break-words px-2 py-4 text-xs border border-gray-200 text-white bg-slate-700 z-50 sticky left-0 top-0 ">
                    <input type="search" wire:model.debounce.150ms="order_id" class="text-black text-xs border-0" placeholder="Order Id">
                </th>
                <th class="px-2 py-4 text-xs border border-gray-200 text-white bg-slate-700 sticky top-0">
                    <input type="search" wire:model.debounce.150ms="blogger" class="text-black text-xs border-0" placeholder="Blogger">
                </th>
                <th class="px-2 py-4 text-xs border border-gray-200 text-white bg-slate-700 sticky top-0">
                    <input type="search" wire:model.debounce.150ms="root_domain" class="text-black text-xs border-0" placeholder="Root Domain">
                </th>
                <th class="px-2 py-4 text-xs border border-gray-200 text-white bg-slate-700 sticky top-0">Status</th>
                <th class="px-2 py-4 text-xs border border-gray-200 text-white bg-slate-700 sticky top-0">Action</th>
            </tr>
        </thead>
        <tbody>
            @foreach($orders as $order)
                <tr>
                    <td class="text-xs font-medium  px-2 py-3 border border-gray-200 text-center"> {{ $order->new_order_process->new_order->order_id }}</td>
                    <td class="text-xs font-medium  px-2 py-3 border border-gray-200 text-center">
                        {{ $order->vendor->name }} <br> ({{ $order->vendor->email }})
                    </td>
                    <td class="text-xs font-medium  px-2 py-3 border border-gray-200 text-center">{{ $order->new_site->root_domain }}</td>
                    <td class="text-xs font-medium  px-2 py-3 border border-gray-200 text-center">
                        @switch($order->status)
                            @case(NewOrderStatus::$BLOGGER_PUSHED_BACK_TO_MANAGER_WITH_SUCCESS)
                                <span class="bg-green-700 text-white px-3 py-2 rounded text-xs">Accepted</span>
                            @break

                            @case(NewOrderStatus::$BLOGGER_PUSHED_BACK_TO_MANAGER_WITH_REJECTION)
                                <span class="bg-green-700 text-white px-3 py-2 rounded text-xs">Rejected</span>
                            @break
                        @endswitch
                    </td>
                    <td class="text-xs font-medium  px-2 py-3 border border-gray-200 text-center">
                        @if(request()->routeIs("manager.pending_approvals_for_bloggers"))
                        <a class="bg-blue-700 text-white text-xs px-3 py-1 rounded" href="{{ route("manager.pending_approvals_for_bloggers_details",$order->id) }}">View Details</a>
                        @endif
                    </td>
                </tr>
                <tr>
                    <td colspan="5" class="text-xs font-medium  px-2 py-3 border border-gray-200 text-center">

                        @if(request()->routeIs("manager.rejected_orders_from_bloggers"))
                                <div class="flex items-center space-x-8 border-b border-gray-200 pb-4 mb-4">
                                    <div class="w-48 font-bold">Reason</div>
                                    <div>{{ $order->reject_reason }}</div>
                                </div>
                        @endif
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>
