@php use App\Project\NewOrderStatus; @endphp
<div>
    <div>
        @include("admin.partials.messages")
    </div>
    <table class="table-fixed w-full border border-gray-300 border-separate">
        <tr>
            <th class="text-xs p-3 text-gray-700 border border-gray-300 w-48">Order No.</th>
            <td class="text-xs p-3 text-gray-700 border border-gray-300">{{ $order->new_order_process->new_order->order_id }}</td>
        </tr>
        <tr>
            <th class="text-xs p-3 text-gray-700 border border-gray-300 w-48">Blogger Details</th>
            <td class="text-xs p-3 text-gray-700 border border-gray-300">{{ $order->vendor->name }} <span class="text-black font-bold">({{ $order->vendor->email }})</span></td>
        </tr>
        <tr>
            <th class="text-xs p-3 text-gray-700 border border-gray-300 w-48">Root Domain</th>
            <td class="text-xs p-3 text-gray-700 border border-gray-300">{{ $order->new_site->root_domain }}</td>
        </tr>
        @if($order->new_order_process->new_order->order_type == "niche")
            <tr>
                <th class="text-xs p-3 text-gray-700 border border-gray-300 w-48">Post Urls</th>
                <td class="text-xs p-3 text-gray-700 border border-gray-300">{{ $order->url }}</td>
            </tr>

            <tr>
                <th class="text-xs p-3 text-gray-700 border border-gray-300 w-48">
                    @if($order->type == 'replace')
                        Replace With
                    @else
                        Insert After
                    @endif
                </th>
                <td class="text-xs p-3 text-gray-700 border border-gray-300">{!! $order->insert_after !!}}</td>
            </tr>

            <tr>
                <th class="text-xs p-3 text-gray-700 border border-gray-300 w-48">
                    @if($order->type == 'replace')
                        Replace Statement
                    @else
                        Insert Statement
                    @endif
                </th>
                <td class="text-xs p-3 text-gray-700 border border-gray-300">{!! $order->statement !!}}</td>
            </tr>


       @endif

        @if($order->new_order_process->new_order->order_type == "gp")
            <tr>
                <th class="text-xs p-3 text-gray-700 border border-gray-300 w-48">Anchor</th>
                <td class="text-xs p-3 text-gray-700 border border-gray-300">{{ $order->anchor }}</td>
            </tr>
            <tr>
                <th class="text-xs p-3 text-gray-700 border border-gray-300 w-48">Title</th>
                <td class="text-xs p-3 text-gray-700 border border-gray-300">{{ $order->title }}</td>
            </tr>
            <tr>
                <th class="text-xs p-3 text-gray-700 border border-gray-300 w-48">Doc Urls</th>
                <td class="text-xs p-3 text-gray-700 border border-gray-300">{{ $order->doc_urls }}</td>
            </tr>
            <tr>
                <th class="text-xs p-3 text-gray-700 border border-gray-300 w-48">Doc File</th>
                <td class="text-xs p-3 text-gray-700 border border-gray-300">{{ $order->upload_doc_file }}</td>
            </tr>
        @else
            <tr>
                <th class="text-xs p-3 text-gray-700 border border-gray-300 w-48">Anchor</th>
                <td class="text-xs p-3 text-gray-700 border border-gray-300">{{ $order->anchor }}</td>
            </tr>
            <tr>
                <th class="text-xs p-3 text-gray-700 border border-gray-300 w-48">Url</th>
                <td class="text-xs p-3 text-gray-700 border border-gray-300">{{ $order->ourl }}</td>
            </tr>

        @endif

        <tr>
            <th class="text-xs p-3 text-gray-700 border border-gray-300 w-48">Link Verification</th>
            <td class="text-xs p-3 text-gray-700 border border-gray-300">{{ $order->verify }}</td>
        </tr>
        <tr>
            <th class="text-xs p-3 text-gray-700 border border-gray-300 w-48">Status</th>
            <td class="text-xs p-3 text-gray-700 border border-gray-300">
                @switch($order->status)
                    @case(NewOrderStatus::$BLOGGER_PUSHED_BACK_TO_MANAGER_WITH_SUCCESS)
                        <span class="bg-green-700 text-white px-3 py-1.5 rounded text-xs">Accepted</span>
                        @break

                    @case(NewOrderStatus::$BLOGGER_PUSHED_BACK_TO_MANAGER_WITH_REJECTION)
                        <span class="bg-green-700 text-white px-3 py-1.5 rounded text-xs">Rejected</span>
                        @break
                @endswitch
            </td>
        </tr>
        <tr>
            <th class="text-xs p-3 text-gray-700 border border-gray-300 w-48">Submit URL</th>
            <td class="text-xs p-3 text-gray-700 border border-gray-300">{{ $order->submit_url }}</td>
        </tr>
        <tr>
            <th class="text-xs p-3 text-gray-700 border border-gray-300 w-48"></th>
            <td class="text-xs p-3 text-gray-700 border border-gray-300">
                <form wire:submit.prevent="verifiedFinished" wire:loading.remove>
                    @csrf
                    <button class="bg-green-700 text-white text-xs px-4 py-3">Verified and Finished</button>
                </form>
                <div wire:loading.block wire:target="verifiedFinished">
                    <p>Loading...Please Wait...</p>
                </div>

            </td>
        </tr>
        <tr>
            <td></td>
            <td class="text-xs p-3 text-gray-700 border border-gray-300">
                <form wire:submit.prevent="Rejected" class="flex items-center">
                    @csrf
                    <textarea wire:model.defer="rejected_reason" class="flex-1" rows="3"></textarea>
                    <div wire:loading.block wire:target="Rejected">
                        <p>Loading...Please Wait...</p>
                    </div>
                    <div wire:loading.remove>
                        <button class="ml-3 bg-red-700 text-white text-xs px-10 py-5">Reject Post</button>
                    </div>
                </form>

            </td>
        </tr>
    </table>
</div>
