<div class="w-[3000px]">
    <div class="">
        <div class="">
            <table class="table-fixed w-full">
                <thead class="bg-slate-700">
                <tr>
                    <th class="break-words px-2 py-4 text-xs border border-gray-200 text-white bg-slate-700 z-50 sticky left-0 top-0 ">Order Id</th>
                    <th class="px-2 py-4 text-xs border border-gray-200 text-white bg-slate-700 sticky top-0">Team</th>
                    <th class="px-2 py-4 text-xs border border-gray-200 text-white bg-slate-700 sticky top-0">Client Name</th>
                    <th class="px-2 py-4 text-xs border border-gray-200 text-white bg-slate-700 sticky top-0">Client Website</th>
                    <th class="px-2 py-4 text-xs border border-gray-200 text-white bg-slate-700 sticky top-0">No of Links</th>
                    <th class="px-2 py-4 text-xs border border-gray-200 text-white bg-slate-700 sticky top-0">Order Type</th>
                    <th class="px-2 py-4 text-xs border border-gray-200 text-white bg-slate-700 sticky top-0">Order Package</th>
                    <th class="px-2 py-4 text-xs border border-gray-200 text-white bg-slate-700 sticky top-0">Message</th>
                    <th class="px-2 py-4 text-xs border border-gray-200 text-white bg-slate-700 sticky top-0">Status</th>
{{--                    <th class="px-2 py-4 text-xs border border-gray-200 text-white bg-slate-700 sticky top-0">Action</th>--}}
                </tr>
                <tr>
                    <th class="px-2 py-2 text-xs border border-gray-200 text-gray-800 bg-slate-700 z-50 sticky left-0 top-0 ">
                        <input type="text" class="px-2 py-1 text-xs w-full" wire:model.debounce.150ms="order_id">
                    </th>
                    <th class="px-2 py-2 text-xs border border-gray-200 text-gray-800 bg-slate-700 z-50 sticky left-0 top-0 ">
                        <input type="text" class="px-2 py-1 text-xs w-full" wire:model.debounce.150ms="team">
                    </th>
                    <th class="px-2 py-2 text-xs border border-gray-200 text-gray-800 bg-slate-700 z-50 sticky left-0 top-0 ">
                        <input type="text" class="px-2 py-1 text-xs w-full" wire:model.debounce.150ms="client_name">
                    </th>
                    <th class="px-2 py-2 text-xs border border-gray-200 text-gray-800 bg-slate-700 z-50 sticky left-0 top-0 ">
                        <input type="text" class="px-2 py-1 text-xs w-full" wire:model.debounce.150ms="client_website">
                    </th>
                    <th class="px-2 py-2 text-xs border border-gray-200 text-gray-800 bg-slate-700 z-50 sticky left-0 top-0 ">
                        <input type="text" class="px-2 py-1 text-xs w-full" wire:model.debounce.150ms="no_of_links">
                    </th>
                    <th class="px-2 py-2 text-xs border border-gray-200 text-gray-800 bg-slate-700 z-50 sticky left-0 top-0 ">
                        <input type="text" class="px-2 py-1 text-xs w-full" wire:model.debounce.150ms="order_type">
                    </th>
                    <th class="px-2 py-2 text-xs border border-gray-200 text-gray-800 bg-slate-700 z-50 sticky left-0 top-0 ">
                        <input type="text" class="px-2 py-1 text-xs w-full" wire:model.debounce.150ms="order_package">
                    </th>
                    <th class="px-2 py-2 text-xs border border-gray-200 text-gray-800 bg-slate-700 z-50 sticky left-0 top-0 ">
                        <input type="text" class="px-2 py-1 text-xs w-full" wire:model.debounce.150ms="message">
                    </th>
                    <th class="px-2 py-2 text-xs border border-gray-200 text-gray-800 bg-slate-700 z-50 sticky left-0 top-0 ">
                    </th>
                </tr>
                </thead>
                <tbody>
                    @foreach($new_orders as $new_order)


                        <tr >

                            <td class="text-sm px-2 py-3 border border-gray-200 text-slate-700 text-center sticky bg-white z-20 left-0">{{ $new_order->order_id }}</td>
                            <td class="text-sm px-2 py-3 border border-gray-200 text-center">{{ optional($new_order->team)->name }} <strong class="text-red-400">({{ optional($new_order->team)->email }})</strong></td>
                            <td class="text-sm px-2 py-3 border border-gray-200 text-center">{{ $new_order->client_name }}</td>
                            <td class="text-sm px-2 py-3 border border-gray-200 text-center">{{ $new_order->client_website }}</td>
                            <td class="text-sm px-2 py-3 border border-gray-200 text-center">{{ $new_order->no_of_links }}</td>
                            <td class="text-sm px-2 py-3 border border-gray-200 text-center">{{ $new_order->order_type }}</td>
                            <td class="text-sm px-2 py-3 border border-gray-200 text-center">{{ $new_order->order_package }}</td>
                            <td class="text-sm px-2 py-3 border border-gray-200 text-center">{{ Illuminate\Support\Str::limit($new_order->message,100) }}
                                <div x-data="{ show: false }">
                                    <div x-show="show" style="z-index: 9999" class="fixed inset-0 overflow-y-auto" aria-labelledby="modal-title" role="dialog" aria-modal="true">
                                        <div class="flex items-end justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">

                                            <div class="fixed inset-0 bg-gray-500 bg-opacity-75 transition-opacity" aria-hidden="true"></div>

                                            <!-- This element is to trick the browser into centering the modal contents. -->
                                            <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>


                                            <div @click.outside="show=false" class="relative inline-block align-bottom bg-white rounded-lg px-4 pt-5 pb-4 text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-6xl sm:w-full sm:p-6">
                                                <div class="sm:flex sm:items-start">
                                                    <div class="mx-auto flex-shrink-0 flex items-center justify-center h-12 w-12 rounded-full bg-blue-100 sm:mx-0 sm:h-10 sm:w-10">
                                                        <!-- Heroicon name: outline/exclamation -->
                                                        <svg class="h-6 w-6 text-blue-600" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor" aria-hidden="true">
                                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z" />
                                                        </svg>
                                                    </div>
                                                    <div class="mt-3 text-center sm:mt-0 sm:ml-4 sm:text-left">
                                                        <h3 class="text-lg leading-6 font-medium text-gray-900" id="modal-title">Message</h3>
                                                        <div class="mt-2">
                                                            <p class="text-sm text-gray-500">{!! $new_order->message !!}</p>
                                                        </div>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                    <div class="text-right">
                                        <button type="button" class="text-xs text-red-400" @click="show=!show">read more</button>
                                    </div>
                                </div>
                            </td>
                            <td class="text-sm px-2 py-3 border border-gray-200 text-center sticky">
                                @if($new_order->new_order_status === App\Project\NewOrderStatus::$PENDING_ORDER)
                                    Pending
                                @endif
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>
