@php use Carbon\Carbon; @endphp
<div>
    @foreach($threads as $thread)
        <div class="bg-gray-100 p-4 border border-gray-300 mb-4">
            <a href="
                    @switch(auth()->user()->role)
                        @case('manager') {{ route("manager.messages.detail",$thread->id) }} @break
                        @case('team') {{ route("team.messages.threads",$thread->id) }} @break
                        @case('writer') {{ route("writer.messages.detail",$thread->id) }} @break
                        @case('vendor') {{ route("vendor.messages.detail",$thread->id) }} @break
                    @endswitch
                    ">
                <div class="flex items-center justify-between border-b border-gray-200 mb-1 pb-1">
                    <div class="text-xs font-semibold">
                        <span>Thread Created by:</span>
                        <span class="text-red-500">{{ $thread->owner->name }} ({{ $thread->owner->role }})</span>
                    </div>
                    <div class="text-xs font-semibold">
                        <span>Last Updated: </span>
                        <span class="text-red-500">
                            @if($thread->last_updated)
                                {{ Carbon::parse($thread->last_updated->created_at)->diffForHumans() }}
                            @else
                                {{ Carbon::parse($thread->created_at)->diffForHumans() }}
                            @endif

                        </span>
                    </div>
                </div>
                <div class="flex items-center space-x-2 text-xs mt-2">
                    <span class="font-semibold">Subject :</span>
                    <span>{{ $thread->subject }}</span>
                </div>
                <div class="flex items-center justify-between">
                    <div class="mt-3 flex items-center space-x-1">
                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-4 h-4 text-red-500">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M20.25 8.511c.884.284 1.5 1.128 1.5 2.097v4.286c0 1.136-.847 2.1-1.98 2.193-.34.027-.68.052-1.02.072v3.091l-3-3c-1.354 0-2.694-.055-4.02-.163a2.115 2.115 0 01-.825-.242m9.345-8.334a2.126 2.126 0 00-.476-.095 48.64 48.64 0 00-8.048 0c-1.131.094-1.976 1.057-1.976 2.192v4.286c0 .837.46 1.58 1.155 1.951m9.345-8.334V6.637c0-1.621-1.152-3.026-2.76-3.235A48.455 48.455 0 0011.25 3c-2.115 0-4.198.137-6.24.402-1.608.209-2.76 1.614-2.76 3.235v6.226c0 1.621 1.152 3.026 2.76 3.235.577.075 1.157.14 1.74.194V21l4.155-4.155" />
                        </svg>
                        <span class="text-xs font-bold">{{ $thread->messages_count }}</span>
                    </div>

                    <div class="flex items-center space-x-4">
                        <div class="text-xs font-medium px-3 py-2 border border-gray-400 text-gray-500">{{ $thread->owner->name }} <span class=" text-red-400">({{ $thread->owner->role }})</span></div>
                        <div class="text-xs font-medium px-3 py-2 border border-gray-400 text-gray-500">{{ $thread->user->name }} <span class="text-red-400">({{ $thread->user->role }})</span></div>
                    </div>
                </div>

            </a>
        </div>
    @endforeach
</div>
