@php use Carbon\Carbon; @endphp
<div>

    @include("admin.partials.messages")

    <div class="flex items-start">
        <div class="flex-1">
            <div class="bg-white shadow">
            <div class="font-bold text-gray-800 p-3 border-b border-gray-300">
                <span class="text-sm">{{ $thread->owner->name }} ({{ $thread->owner->role }})</span>
                <span class="text-xs text-gray-500 font-medium">posted on {{ Carbon::parse($thread->created_at)->diffForHumans() }}</span>
            </div>
            <div class="p-4">
                <div class="text-gray-500 text-sm leading-6 ">
                    {{ $thread->subject }}
                </div>
            </div>
        </div>

            <div class="bg-white text-lg mt-4 text-red-500 font-semibold p-3">
                {{ count($messages) }} Replies
            </div>

           <div class="ml-6">
               @if(count($messages) > 0)
                   @foreach($messages as $message)
                        <div class="bg-white shadow mt-4">
                   <div class="font-bold text-gray-800 p-3 border-b border-gray-300">
                       <span class="text-sm">{{ $message->user->name }} ({{ $message->user->role }})</span>
                       <span class="text-xs text-gray-500 font-medium">posted on {{ Carbon::parse($message->created_at)->diffForHumans() }}</span>
                   </div>
                   <div class="p-4">
                       <div class="text-gray-500 text-sm leading-6 ">
                           {{ $message->message }}
                       </div>
                   </div>
               </div>
                   @endforeach
               @endif
           </div>

        </div>

        <form wire:submit.prevent="postMessage" class="w-64 ml-8 bg-white shadow" method="POST">
            <div class="text-black font-bold border-b border-gray-300 p-3">Write a Reply</div>
            @csrf
            <div class="flex flex-col">
                <textarea wire:model.defer="message" class="border-0 border-gray-300 focus:ring-0 p-2 text-xs flex-1" rows="4" placeholder="Enter Message...."></textarea>
                <button class="bg-gray-800 text-white text-xs border border-gray-800 py-2 px-7 ">Post</button>
            </div>
        </form>

    </div>




{{--    <div class="mt-3 border border-gray-400 p-4">--}}

{{--        <div class="w-2/3 flex items-start bg-gray-700 py-2 px-4">--}}
{{--            <img src="/images/man.png" class="w-8 h-8">--}}
{{--            <div class="ml-4">--}}
{{--                <div class="text-xs text-white leading-6">Lorem ipsum dolor sit amet, consectetur adipisicing elit. Architecto cupiditate deserunt dolorem inventore iste officiis qui saepe sed sint veniam.</div>--}}
{{--                <div class="text-xs text-white font-semibold text-right mt-1 tracking-wider">--}}
{{--                    <span>Admin</span>--}}
{{--                    <span>|</span>--}}
{{--                    <span>2022-12-14 13:25:49</span>--}}
{{--                </div>--}}
{{--            </div>--}}
{{--        </div>--}}

{{--        <div class="flex items-start justify-end mt-8">--}}
{{--            <div class="w-2/3 flex items-start bg-gray-100 border border-gray-300 py-2 px-4">--}}
{{--                <div class="flex-1">--}}
{{--                    <div class="text-xs text-gray-800 leading-6">Lorem ipsum dolor sit amet, consectetur adipisicing elit. Debitis, nesciunt.</div>--}}
{{--                    <div class="text-xs text-gray-800 font-semibold text-left mt-1 tracking-wider">--}}
{{--                        <span>Narinder</span>--}}
{{--                        <span>|</span>--}}
{{--                        <span>2022-12-14 13:25:49</span>--}}
{{--                    </div>--}}
{{--                </div>--}}
{{--                <img src="/images/man.png" class="w-8 h-8 ml-4 ">--}}
{{--            </div>--}}
{{--        </div>--}}

{{--    </div>--}}

</div>
