<div>
    <h1 class="bg-gray-600 flex items-center justify-between text-white text-xl font-bold py-3 px-3">
        <span>Send</span>
    </h1>
    @include("front.partials._messages")
    <form wire:submit.prevent="sendMoney">
        @csrf
        <div class="mt-4 flex flex-col space-y-6">
            <div>
                <label>Amount</label>
                <span class="font-bold text-lg">{{ $histories->sum('price') }}</span>
            </div>

            <table class="table-auto w-full mt-6">
                <thead class="bg-gray-100 ">
                <tr>
                    <th class="text-left py-3 px-4 text-sm">Date</th>
                    <th class="text-left py-3 px-4">Order Id</th>
                    <th class="text-left py-3 px-4 text-sm">Amount</th>
                </tr>
                </thead>
                @foreach($histories as $history)
                    <tr class="border-b border-gray-200">

                        <td class="py-3 px-4 text-xs text-left">{{ $history->created_at->toDayDateTimeString() }}</td>
                        <td class="py-3 px-4 text-xs text-left">
                            <div class="border-b border-gray-300 pb-1 mb-2">
                                {{ optional(optional(optional($history->new_order_process_detail)->new_order_process)->new_order)->order_id }}
                            </div>
                            <div class="flex items-center space-x-2">
                                <span class="font-black">URL:</span>
                                <span>{{ optional($history->new_order_process_detail)->submit_url }}</span>
                            </div>
                        </td>
                        <td class="py-3 px-4 text-left">
                            <div class="flex flex-col">
                                <div>{{ $history->price }}</div>

                            </div>

                        </td>
                    </tr>
                @endforeach

            </table>

            <div>
                <label>Remarks</label>
                <textarea class="textbox-class" wire:model="remarks" placeholder="Remarks" rows="4"></textarea>
            </div>

            <div>
                <button type="submit" class="bg-pink-700 text-white py-3 w-full rounded">Send</button>
            </div>

        </div>

    </form>
</div>
