@php use App\Project\NewOrderStatus; @endphp
<div>
    <div class="border-b border-gray-300 mb-3 pb-1 flex items-center justify-between">
        <span class="text-xs text-gray-500">
            Showing {{ $orders->firstItem() }} to {{ $orders->lastItem() }} of {{ $orders->total() }} results
        </span>
    </div>
    <div class="overflow-x-auto mb-3" style="height: 550px;overflow: auto">
        <table class="whitespace-nowrap border border-gray-300 border-separate">
            <thead class="bg-pink-700 ">
            <tr>
                <th class="text-sm border border-gray-300 px-6 py-3 sticky top-0 bg-pink-700 text-white">Order Date</th>
                <th class="text-sm border border-gray-300 px-6 py-3 sticky top-0 bg-pink-700 text-white">Manager</th>
                <th class="text-sm border border-gray-300 px-6 py-3 sticky top-0 bg-pink-700 text-white">
                    <div class="flex items-center space-x-2">
                        <input type="search" wire:model.debounce.150ms="order_id" placeholder="Order Id" class="text-xs text-gray-700">
                        <svg wire:click="sortOperations('new_orders.order_id')" xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 320 512" class="w-4 h-4 text-white"><!--! Font Awesome Free 6.4.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2023 Fonticons, Inc. --><path d="M137.4 41.4c12.5-12.5 32.8-12.5 45.3 0l128 128c9.2 9.2 11.9 22.9 6.9 34.9s-16.6 19.8-29.6 19.8H32c-12.9 0-24.6-7.8-29.6-19.8s-2.2-25.7 6.9-34.9l128-128zm0 429.3l-128-128c-9.2-9.2-11.9-22.9-6.9-34.9s16.6-19.8 29.6-19.8H288c12.9 0 24.6 7.8 29.6 19.8s2.2 25.7-6.9 34.9l-128 128c-12.5 12.5-32.8 12.5-45.3 0z" fill="currentColor"/></svg>
                    </div>
                </th>
                <th class="text-sm border border-gray-300 px-6 py-3 sticky top-0 bg-pink-700 text-white">
                    <div class="flex items-center space-x-2">
                        <input type="search" wire:model.debounce.150ms="client_name" placeholder="Client Name" class="text-xs text-gray-700">
                        <svg wire:click="sortOperations('new_orders.client_name')" xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 320 512" class="w-4 h-4 text-white"><!--! Font Awesome Free 6.4.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2023 Fonticons, Inc. --><path d="M137.4 41.4c12.5-12.5 32.8-12.5 45.3 0l128 128c9.2 9.2 11.9 22.9 6.9 34.9s-16.6 19.8-29.6 19.8H32c-12.9 0-24.6-7.8-29.6-19.8s-2.2-25.7 6.9-34.9l128-128zm0 429.3l-128-128c-9.2-9.2-11.9-22.9-6.9-34.9s16.6-19.8 29.6-19.8H288c12.9 0 24.6 7.8 29.6 19.8s2.2 25.7-6.9 34.9l-128 128c-12.5 12.5-32.8 12.5-45.3 0z" fill="currentColor"/></svg>
                    </div>
                </th>
                <th class="text-sm border border-gray-300 px-6 py-3 sticky top-0 bg-pink-700 text-white">
                    <select wire:model="status" class="text-xs text-black">
                        <option value="all">All</option>
                        <option value="completed">Completed</option>
                        <option value="in_process">In Process</option>
                        <option value="pending">Pending</option>
                        <option value="manager">Manager</option>
                        <option value="team">Team</option>
                        <option value="writer">Writer</option>
                        <option value="blogger">Blogger</option>
                    </select>
                </th>
                <th class="text-sm border border-gray-300 px-6 py-3 sticky top-0 bg-pink-700 text-white">Client Website</th>
                <th class="text-sm border border-gray-300 px-6 py-3 sticky top-0 bg-pink-700 text-white">No of Links</th>
                <th class="text-sm border border-gray-300 px-6 py-3 sticky top-0 bg-pink-700 text-white">Order Type</th>
                <th class="text-sm border border-gray-300 px-6 py-3 sticky top-0 bg-pink-700 text-white">Package</th>
                <th class="text-sm border border-gray-300 px-6 py-3 sticky top-0 bg-pink-700 text-white">Category</th>
                <th class="text-sm border border-gray-300 px-6 py-3 sticky top-0 bg-pink-700 text-white">Action</th>
            </tr>
            </thead>
            <tbody>
                @foreach($orders as $order)
                    <tr>
                        <td class="text-sm border border-gray-300 px-6 py-3">{{ $order->created_at->toDayDateTimeString() }}</td>
                        <td class="text-sm border border-gray-300 px-6 py-3">{{ $order->name }}</td>
                        <td class="text-sm border border-gray-300 px-6 py-3">
                            <a href="{{ route("admin.orders.details",$order->id) }}" class="underline flex items-center justify-between">
                                  <span>
                                    @if($order->type == 'new') New Order @endif
                                      @if($order->type == 'sub') Sub Order @endif
                                </span>
                                <span>{{ $order->order_id }}</span>
                            </a>
                        </td>
                        <td class="text-sm border border-gray-300 px-6 py-3">{{ $order->client_name }}</td>
                        <td class="text-sm border border-gray-300 px-6 py-3">
                            <div class="flex items-center justify-between text-xs">
                                @if(($order->total == $order->total1) && $order->total != 0 && $order->total1 !=0 )
                                    <span style="background: green;color: white;padding:6px"> Completed</span>
                                @elseif( ( $order->new_order_status == NewOrderStatus::$PENDING_ORDER ) || ($order->new_order_status == NewOrderStatus::$MANAGER_CREATED_ORDER_AND_PUSHED_TO_TEAM) )
                                    <span style="background: red;color: white;padding:6px">Pending</span>
                                @else
                                    <span style="background: blue;color: white;padding:6px">In Process</span>
                                @endif
                                <div class="ml-10">
                                    {{ new_order_status($order->new_order_status) }}
                                </div>
                            </div>
                        </td>
                        <td class="text-sm border border-gray-300 px-6 py-3">{{ $order->client_website }}</td>
                        <td class="text-sm border border-gray-300 px-6 py-3">{{ $order->no_of_links }}</td>
                        <td class="text-sm border border-gray-300 px-6 py-3">{{ $order->order_type }}</td>
                        <td class="text-sm border border-gray-300 px-6 py-3">{{ $order->order_package }}</td>
                        <td class="text-sm border border-gray-300 px-6 py-3">{{ $order->category }}</td>

                        <td class="text-sm border border-gray-300 px-6 py-3">
                            <a href="{{ route("admin.orders.details",$order->id) }}" class="bg-blue-500 text-white px-3 py-1 text-xs">details</a>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
    <div>
        {{ $orders->links() }}
    </div>
</div>
