@php use App\Models\NewOrderProcessDetail;use App\Project\NewOrderStatus;use Carbon\Carbon;use Illuminate\Support\Facades\Auth; @endphp
<div class="bg-white p-4 shadow">
    @include("admin.partials.messages")
    <div class="border-b border-gray-300 mb-3 pb-1 flex items-center justify-between">
        <span class="text-xs text-gray-500">
            Showing {{ $bloggers->firstItem() }} to {{ $bloggers->lastItem() }} of {{ $bloggers->total() }} results
        </span>

        <span wire:loading.flex class="loader"></span>

    </div>



    <div class="overflow-x-auto mb-3" style="height: 550px;overflow: auto">
        <table class="whitespace-nowrap border border-gray-300 border-separate">
            <thead class="bg-pink-700 text-white">
            <tr>
                <td class="text-sm border border-gray-300 px-6 py-3 sticky top-0 bg-pink-700 text-white">#</td>
                <td class="text-sm border border-gray-300 px-6 py-3 sticky top-0 bg-pink-700 text-white">
                    <input type="search" placeholder="Name..." wire:model.debounce.150ms="name"
                           class="text-xs p-1 text-black">
                </td>
                <td class="text-sm border border-gray-300 px-6 py-3 sticky top-0 bg-pink-700 text-white">
                    <input type="search" placeholder="Email..." wire:model.debounce.150ms="email"
                           class="text-xs p-1 text-black">
                </td>
                <td class="text-sm border border-gray-300 px-6 py-3 sticky top-0 bg-pink-700 text-white">Last Login</td>
                <td class="text-sm border border-gray-300 px-6 py-3 sticky top-0 bg-pink-700 text-white">Total Logins
                </td>
                @if($request_segment == 'bloggers')

                    <td class="text-sm border border-gray-300 px-6 py-3 sticky top-0 bg-pink-700 text-white">
                        Total Orders
                    </td>
                    <td class="text-sm border border-gray-300 px-6 py-3 sticky top-0 bg-pink-700 text-white">Pending
                        Orders
                    </td>
                    <td class="text-sm border border-gray-300 px-6 py-3 sticky top-0 bg-pink-700 text-white">Completed
                        Orders
                    </td>
                    <td class="text-sm border border-gray-300 px-6 py-3 sticky top-0 bg-pink-700 text-white">
                        Wallet
                    </td>
                    <td class="text-sm border border-gray-300 px-6 py-3 sticky top-0 bg-pink-700 text-white">
                        Performance
                    </td>
                @endif

                @if($request_segment  == 'teams' || $request_segment  == 'managers' || $request_segment  == 'writers')
                    <td class="text-sm border border-gray-300 px-6 py-3 sticky top-0 bg-pink-700 text-white">
                        Permission
                    </td>
                @endif

                <td class="text-sm border border-gray-300 px-6 py-3 sticky top-0 bg-pink-700 text-white">Account
                    Status
                </td>
            </tr>
            </thead>
            <tbody>
            @php $i = $bloggers->firstItem(); @endphp
            @foreach($bloggers as $blogger)

                <tr>
                    <td class="text-sm border border-gray-300 px-6 py-3">{{ $i++ }}</td>
                    <td class="text-sm border border-gray-300 px-6 py-3">{{ $blogger->name }}</td>
                    <td class="text-sm border border-gray-300 px-6 py-3">{{ $blogger->email }}</td>
                    <td class="text-sm border border-gray-300 px-6 py-3">{{ $blogger->current_login ? Carbon::parse($blogger->current_login)->toDayDateTimeString() : "" }}</td>
                    <td class="text-sm border border-gray-300 px-6 py-3">{{ $blogger->login_count ?? 0 }}</td>
                    @if($request_segment  == 'bloggers')
                        @php
                            $pending_orders= NewOrderProcessDetail::where('vendor_id',$blogger->id)->whereIn('status',[NewOrderStatus::$MANAGER_PUSHED_TO_BLOGGER,NewOrderStatus::$MANAGER_DISAPPROVED_AND_PUSHED_BACK_TO_BLOGGER])->count();
                            $completed_orders= NewOrderProcessDetail::where('vendor_id',$blogger->id)->whereIn('status',[NewOrderStatus::$MANAGER_VERIFIED_AND_FINISHED])->count();
                        @endphp
                        <td class="text-sm border border-gray-300 px-6 py-3">{{ $pending_orders + $completed_orders  }}</td>
                        <td class="text-sm border border-gray-300 px-6 py-3">
                            {{ $pending_orders ?? 0 }} <a href="{{ route("admin.bloggers.pending_orders",$blogger->id) }}" class="text-xs font-bold underline">view</a>
                        </td>
                        <td class="text-sm border border-gray-300 px-6 py-3">{{ $completed_orders ?? 0 }} <a href="{{ route("admin.bloggers.completed_orders",$blogger->id) }}" class="text-xs font-bold underline">view</a></td>
                        <td class="text-sm border border-gray-300 px-6 py-3">{{ admin_vendor_balance($blogger->id) }}
                            <a href="{{ route("admin.bloggers.wallet_history",$blogger->id) }}" class="text-xs font-bold underline">view</a>
                        </td>
                        <td class="text-sm border border-gray-300 px-6 py-3">
                            <a class="text-xs bg-blue-500 px-3 py-1 rounded text-white" href="{{ route("admin.members.performance",$blogger->id) }}">Peformance</a>
                        </td>
                    @endif
                    @if(request()->segment(2) == 'teams' || request()->segment(2) == 'managers' || request()->segment(2) == 'writers')
                        <td class="text-sm border border-gray-300 px-6 py-3">
                            <a href="{{ route("admin.permission",$blogger->id) }}" class="text-xs cursor-pointer text-center bg-purple-700 px-3 py-1 rounded text-white">Permissions</a>
                        </td>
                    @endif
                    <td class="text-sm border border-gray-300 px-6 py-3">
                        @if($blogger->status == 1)
                            <div wire:click="changeStatus({{ $blogger->id }})"
                                 class="text-xs cursor-pointer text-center bg-green-700 px-3 py-1 rounded text-white">
                                Active
                            </div>
                        @else
                            <div wire:click="changeStatus({{ $blogger->id }})"
                                 class="text-xs cursor-pointer text-center bg-red-700 px-3 py-1 rounded text-white">
                                Blocked
                            </div>
                        @endif
                    </td>
                </tr>
            @endforeach
            </tbody>
        </table>
    </div>

    <div>
        {{ $bloggers->links() }}
    </div>


</div>
