@extends("frontend.layouts.master")

@section("container")
    <div class="pb-8 bg-white mx-auto max-w-lg shadow-lg mt-8 mb-8">
        <h2 class="pt-4 text-center text-4xl mb-8 font-great-vibes font-medium">
            <span class="primary_color">
                Create
            </span>
            <span class="">
                New Account
            </span>
        </h2>

        <div class="px-8">
            <!-- Session Status -->
            <x-auth-session-status class="mb-4" :status="session('status')" />
            <x-auth-session-status class="mb-4 bg-red-100 px-6 py-4 border text-red-600 border-red-200" :status="session('error')" />
            <x-auth-validation-errors class="mb-4" :errors="$errors" />
            <form method="POST" action="{{ route("register") }}">
                @csrf

                <!-- Name -->
                <div>
                    <x-label for="name" :value="__('Name')" />

                    <x-input id="name" class="block mt-1 w-full" type="text" name="name" :value="old('name')" required autofocus />
                </div>

                <!-- Email Address -->
                <div class="mt-4">
                    <x-label for="email" :value="__('Email')" />

                    <x-input id="email" class="block mt-1 w-full" type="email" name="email" :value="old('email')" required />
                </div>

                <!-- Password -->
                <div class="mt-4">
                    <x-label for="password" :value="__('Password')" />

                    <x-input id="password" class="block mt-1 w-full"
                             type="password"
                             name="password"
                             required autocomplete="new-password" />
                </div>

                <!-- Confirm Password -->
                <div class="mt-4">
                    <x-label for="password_confirmation" :value="__('Confirm Password')" />

                    <x-input id="password_confirmation" class="block mt-1 w-full"
                             type="password"
                             name="password_confirmation" required />
                </div>


                <div class="mt-4">
                    <x-label for="whatsapp" :value="__('Whatsapp')" />

                    <x-input id="whatsapp" class="block mt-1 w-full" type="text" name="whatsapp" :value="old('whatsapp')" />
                </div>

                <div class="mt-4">
                    <x-label for="skype" :value="__('Skype')" />

                    <x-input id="skype" class="block mt-1 w-full" type="text" name="skype" :value="old('skype')" />
                </div>


                <div class="flex items-center justify-end mt-4">
                    <a class="underline text-sm text-gray-600 hover:text-gray-900" href="#">
                        {{ __('Already registered?') }}
                    </a>

                    <x-button class="ml-4">
                        {{ __('Register') }}
                    </x-button>
                </div>
            </form>
        </div>
    </div>

@endsection
