@extends("frontend.layouts.master")

@section("container")
    <div class="pb-8 bg-white mx-auto max-w-lg shadow-lg mt-8 mb-8">
        <h2 class="pt-4 text-center text-4xl mb-8 font-great-vibes font-medium">
            <span class="primary_color">
                Log
            </span>
            <span class="">
                in
            </span>
        </h2>

        <div class="px-8">

            <!-- Session Status -->
            <x-auth-session-status class="mb-4" :status="session('status')" />
            <x-auth-session-status class="mb-4 bg-red-100 px-6 py-4 border text-red-600 border-red-200" :status="session('error')" />
            <!-- Validation Errors -->
            <x-auth-validation-errors class="mb-4" :errors="$errors" />

            <form method="POST" action="{{ route('login.check') }}">
                @csrf
                <div class="mt-4">
                    <div class="mt-1">
                        <input type="text" name="email" autofocus class="textbox-class py-4 " placeholder="Enter your Email Id">
                    </div>
                </div>


                <div class="mt-4">
                    <div class="mt-1 relative"  x-data="{ view : false }">
                        <div class="absolute right-4 inset-y-0 flex items-center">
                            <svg @click="view=true" x-show="!view" xmlns="http://www.w3.org/2000/svg" class="cursor-pointer h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M13.875 18.825A10.05 10.05 0 0112 19c-4.478 0-8.268-2.943-9.543-7a9.97 9.97 0 011.563-3.029m5.858.908a3 3 0 114.243 4.243M9.878 9.878l4.242 4.242M9.88 9.88l-3.29-3.29m7.532 7.532l3.29 3.29M3 3l3.59 3.59m0 0A9.953 9.953 0 0112 5c4.478 0 8.268 2.943 9.543 7a10.025 10.025 0 01-4.132 5.411m0 0L21 21" />
                            </svg>
                            <svg @click="view=false" x-show="view" xmlns="http://www.w3.org/2000/svg" class="cursor-pointer h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                                <path stroke-linecap="round" stroke-linejoin="round" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
                            </svg>
                        </div>
                        <input x-bind:type="view ? 'text' : 'password'" type="password" name="password" class="textbox-class py-4 " placeholder="Enter Password">
                    </div>
                </div>

                <div class="flex   mt-4 items-center justify-between">
                    <div class="block">
                        <label for="remember_me" class="inline-flex items-center">
                            <input id="remember_me" type="checkbox" class="rounded border-gray-300 text-indigo-600 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50" name="remember">
                            <span class="ml-2 text-sm text-gray-600">{{ __('Remember me') }}</span>
                        </label>
                    </div>

                    @if (Route::has('password.request'))
                        <a class="underline text-sm text-gray-600 hover:text-gray-900" href="{{ route('password.request') }}">
                            {{ __('Forgot your password?') }}
                        </a>
                    @endif
                </div>

                <div class="mt-6">
                    <button class="bg_primary_color rounded-lg shadow text-white w-full py-4 text-lg font-medium uppercase">Login</button>
                </div>




            </form>





        </div>


    </div>
@endsection
