@extends("frontend.layouts.master")

@section("container")
    <div class="">
        <div class="flex items-start ">
            <div class="flex-1 mr-40">
                <div>
                    <span class="text-gray-800 text-4xl font-black">Consult</span>
                </div>
                <div class="flex items-end mt-2">
                    <span class="text-primary-color text-7xl font-black">Our Experts</span>
                    <div class="ml-2 bg-primary-color mb-2 h-1 w-24"></div>
                </div>
                <div class="mt-8 text-gray-600 leading-8">
                    Publishers might have detailed questions on areas like creating their account, adding their sites and accessing money from their wallets. Our experts and support teams are always ready and available to help them with any of the above concerns. All you need to do is fill in the Contact Form on the right, write down the details that are asked for and wait for our support team to get in touch with you. We try to address all the concerns of our publishers within 24-48 hours.
                </div>
            </div>

            <div class="w-1/3">
                <img src="/images/127.png" >
            </div>
        </div>


        <div>
            <div class="">
                <div class="text-center mt-24 font-black text-3xl">
                    <span class="text-primary-color">Connect with</span> us
                </div>
            </div>

            <div id="contact" class="bg-white p-8 mt-20 shadow-2xl shadow-blue-300">
                @include('admin.partials.messages')
                @if (count($errors) > 0)
                    <div class="rounded-md bg-red-50 p-4 mb-4">
                        <div class="flex">
                            <div class="flex-shrink-0">
                                <svg class="h-5 w-5 text-red-400" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true">
                                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd" />
                                </svg>
                            </div>
                            <div class="ml-3">
                                <h3 class="text-sm font-medium text-red-800">
                                    There were {{ count($errors->all()) }} errors with your submission
                                </h3>
                                <div class="mt-2 text-sm text-red-700">
                                    <ul class="list-disc pl-5 space-y-1">
                                        @foreach ($errors->all() as $error)
                                            <li>{{ $error }}</li>
                                        @endforeach
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>


                @endif
                <form action="{{ route("contact") }}" method="POST">
                    <input type="hidden" name="route" value="contact">
                    @csrf
                    <div class="grid grid-cols-2 gap-8">
                        <div>
                            <input type="text" name="name" class="px-4 py-4 bg-gray-100 border border-gray-200 w-full focus:ring-0" placeholder="Name">
                        </div>
                        <div>
                            <select class="px-4 py-4 bg-gray-100 border border-gray-200 w-full focus:ring-0" name="subject">
                                <option value="">Choose Subject</option>
                                <option value="account">Account</option>
                                <option value="site">Site</option>
                                <option value="wallet">Wallet</option>
                            </select>
                        </div>
                        <div>
                            <input type="text" name="email" class="px-4 py-4 bg-gray-100 border border-gray-200 w-full focus:ring-0" placeholder="Email ID">
                        </div>
                        <div>
                            <input type="text" name="phone" class="px-4 py-4 bg-gray-100 border border-gray-200 w-full focus:ring-0" placeholder="Phone">
                        </div>
                        <div class="col-span-2">
                            <textarea rows="6" name="message" class="px-4 py-4 bg-gray-100 border border-gray-200 w-full focus:ring-0" placeholder="Your Message here"></textarea>
                        </div>
                        <div class="col-span-2">
                            <button class="bg-primary-color text-white w-full py-3">Send Message</button>
                        </div>
                    </div>


                </form>
            </div>




        </div>

    </div>
@endsection
