@php use App\Models\Career; @endphp
@extends("frontend.layouts.master")

@section("container")
<?php
    $careers= Career::where('active',1)->get();
?>

<div class="">
    <div class="bg-white p-6 mt-4">

        <div class="flex items-end justify-center">
            <div class="text-center mt-6 font-black text-3xl">
                <span class="text-primary-color">Jobs</span> List
            </div>
            <div class="ml-2 bg-black mb-2 h-1 w-24"></div>
        </div>


        <div class="mb-8 mt-8">
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
                @foreach($careers as $career)
                    <div class="bg-gray-100 p-6 shadow">
                        <h2 class="text-gray-700 text-lg font-medium tracking-tighter">{{ $career->title }}</h2>
                        <div class="h-0.5 bg-gray-200/50 w-full mt-2"></div>
                        <div class="grid grid-cols-2 mt-6">
                            <div>
                                <p class="text-sm font-medium primary_color">Required Experience</p>
                                <div class="text-gray-700 text-xs font-medium mt-1">{{ $career->experience }}</div>
                            </div>
                            <div >
                                <p class="text-sm font-medium primary_color">Qualification:	</p>
                                <div class="text-gray-700 text-xs font-medium mt-1">{{ $career->qualification }}</div>
                            </div>
                        </div>
                        <div class="mt-6">
                            <p class="text-sm font-medium primary_color">Required Skills</p>
                            <div class="text-gray-700 text-xs font-medium mt-1">{{ $career->skills }}</div>
                        </div>
                        <div class="mt-6 flex items-center justify-center">
                            <a href="{{ route("submit_profile",$career->id) }}" class="bg_primary_color shadow rounded-full text-xs text-white tracking-tighter px-6 py-2">Apply Now</a>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </div>
</div>
@endsection
