@php use App\Project\NewOrderStatus;use Carbon\Carbon; @endphp
<x-filament-panels::page>
    <style>
        .order_detail{
            border-collapse: collapse;
            font-size: 13px;
        }
        .order_detail th{
            padding: 10px 20px;
            border:1px solid #737373;
            color: #525252;
            background: #d4d4d4;

        }
        .order_detail td{
            padding: 10px 20px;
            text-align: center;
            border:1px solid #737373;
            color: #525252;
        }
        .box{
            background: #d4d4d4;
            font-size: 13px;
            margin-bottom: 10px;
        }
        .box h2{
            font-weight: bold;
            color: #262626;
            font-size: 14px;
            margin-bottom: 7px;
        }
        .box .time{
            background: #262626;
            color: #f5f5f5;
            font-size: 11px;
            font-weight: bold;
            padding: 7px;
        }
        .box .inner{
            padding: 10px;
        }
        .box p{

        }
        .box p span{
            text-decoration: underline;
        }
        .box .table-container{
            background: white;
            padding: 10px;
            /*display: inline-block;*/
            margin-top: 10px;
        }
        .box table{
            width: 100%;
        }
        .box th{
            text-align: left;
            padding: 10px;
            font-size: 12px;
            border-bottom: 1px solid #CCCCCC;
        }
        .box td{
            text-align: left;
            padding:  10px;
            font-size: 12px;

        }
        .box .note_class{
            background: #f3f3f3;
            font-weight: bold;
        }
        .box .empty_class{
            border-bottom: 1px solid #CCCCCC;
        }
        .box .empty_class td{
            padding: 0;
        }
    </style>
    <div class="bg-white p-4 shadow">
        @if($order)
            <div>
                <div class="bg-gray-800 text-white p-3 text-xs">Message</div>
                <div class="p-3">
                    {!! $order->message !!}
                </div>
            </div>

            <div class="">
                <div class="">
                    <table class="order_detail" style="width: 100%;margin-bottom: 16px;">
                        <tr>
                            <th >Status</th>
                            <th >Order Id</th>
                            <th >Client Name</th>
                            <th >Client Website</th>
                            <th >No of Links</th>
                            <th >Order Type</th>
                            <th >Order Package</th>
                        </tr>
                        <tr>
                            <td >{{ order_status($order->new_order_status) }}</td>

                            <td >{{ $order->order_id }}</td>
                            <td >{{ $order->client_name }}</td>
                            <td >{{ $order->client_website }}</td>
                            <td >{{ $order->no_of_links }}</td>
                            <td >{{ $order->order_type }}</td>
                            <td >{{ $order->order_package }}</td>
                        </tr>

                    </table>
                </div>


            <div class="">

                <div class="">
                    <div class="box">

                        <div class="time">{{ Carbon::parse($order->created_at)->toDayDateTimeString() }}</div>
                        <div class="inner">
                            <h2 class="">New Order Created</h2>

                            <p class="">
                                Order Assigned to Team: <span class="">{{ $order->team->name }} ({{ $order->team->email }})</span>
                            </p>
                        </div>
                    </div>


                    @foreach($order->new_order_processes as $process)

                        @if($process->status == NewOrderStatus::$TEAM_PUSHED_TO_MANAGER)
                            <div class="box">
                                <div class="time">{{ $process->created_at }}</div>
                                <div class="inner">

                                    <h2 >
                                        {{ new_order_status($process->status) }}
                                    </h2>

                                    <div class="table-container">
                                        <table class="">
                                            <tr>
                                                <th class="">Root Domain</th>
                                                <th class="">Price</th>
                                                <th class="">Url</th>
                                            </tr>
                                            @foreach($process->new_order_process_details  as $detail)
                                                <tr>
                                                    <td class="">{{ $detail->new_site->root_domain }}</td>
                                                    <td class="">{{ $detail->price }}</td>
                                                    <td class="">
                                                        {{ $detail->url }}
                                                    </td>
                                                </tr>
                                            @endforeach
                                            <tr class="note_class">
                                                <td class="">Note</td>
                                                <td colspan="2" class="">
                                                    {{ $process->note }}
                                                </td>
                                            </tr>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        @endif


                        @if($process->status == NewOrderStatus::$MANAGER_DISAPPROVED_POST_TEAM)
                            <div class="box">
                                <div class="time">{{ $process->created_at }}</div>

                                <div class="inner">

                                    <h2 >
                                        {{ new_order_status($process->status) }}
                                    </h2>

                                    <div class="table-container">
                                        <table class="">
                                            <tr class="note_class">
                                                <td class="">Note</td>
                                                <td colspan="2" class="">
                                                    {{ $process->note }}
                                                </td>
                                            </tr>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        @endif

                    @endforeach


                </div>
            </div>
        @endif
    </div>

</x-filament-panels::page>
