@php use App\Project\NewOrderStatus;use Carbon\Carbon; @endphp
<x-filament-panels::page>
    <style>
        .order_detail{
            border-collapse: collapse;
            font-size: 13px;
        }
        .order_detail th{
            padding: 10px 20px;
            border:1px solid #737373;
            color: #525252;
            background: #d4d4d4;

        }
        .order_detail td{
            padding: 10px 20px;
            text-align: center;
            border:1px solid #737373;
            color: #525252;
        }
        .box{
            background: #d4d4d4;
            font-size: 13px;
            margin-bottom: 10px;
        }
        .box h2{
            font-weight: bold;
            color: #262626;
            font-size: 14px;
            margin-bottom: 7px;
        }
        .box .time{
            background: #262626;
            color: #f5f5f5;
            font-size: 11px;
            font-weight: bold;
            padding: 7px;
        }
        .box .inner{
            padding: 10px;
        }
        .box p{

        }
        .box p span{
            text-decoration: underline;
        }
        .box .table-container{
            background: white;
            padding: 10px;
            /*display: inline-block;*/
            margin-top: 10px;
        }
        .box table{
            width: 100%;
        }
        .box th{
            text-align: left;
            padding: 10px;
            font-size: 12px;
            border-bottom: 1px solid #CCCCCC;
        }
        .box td{
            text-align: left;
            padding:  10px;
            font-size: 12px;

        }
        .box .note_class{
            background: #f3f3f3;
            font-weight: bold;
        }
        .box .empty_class{
            border-bottom: 1px solid #CCCCCC;
        }
        .box .empty_class td{
            padding: 0;
        }
    </style>
    <div class="bg-white p-4 shadow mt-6">
        @if($order)
            <div>
                <div class="bg-gray-800 text-white p-3 text-xs">Message</div>
                <div class="p-3">
                    {!! $order->message !!}
                </div>
            </div>
            <div class="">
                <table class="order_detail" style="width: 100%;margin-bottom: 16px;">
                    <tr>
                        <th class="">Status</th>
                        <th class="">Order Id</th>
                        <th class="">Client Name</th>
                        <th class="">Client Website</th>
                        <th class="">No of Links</th>
                        <th class="">Order Type</th>
                        <th class="">Order Package</th>
                    </tr>
                    <tr>

                        <td class="">{{ order_status($order->new_order_status) }}</td>

                        <td class="">{{ $order->order_id }}</td>


                        <td class="">{{ $order->client_name }}</td>

                        <td class="">{{ $order->client_website }}</td>


                        <td class="">{{ $order->no_of_links }}</td>

                        <td class="">{{ $order->order_type }}</td>

                        <td class="">{{ $order->order_package }}</td>
                    </tr>

                </table>
            </div>
            <div  >

                <div>
                    <div class="box">
                        <div class="">
                            <div class="time">{{ Carbon::parse($order->created_at)->toDayDateTimeString() }}</div>
                            <div class="inner">
                                <h2 class="">New Order Created</h2>

                                <p class="">
                                    Order Assigned to Team: <span class="">{{ $order->team->name }} </span>
                                </p>
                            </div>
                        </div>
                    </div>


                    @foreach($order->new_order_processes as $process)
                        <div class="box">
                            <div class="time">{{ Carbon::parse($process->created_at)->toDayDateTimeString() }}</div>
                            <div class="inner">

                                <h2 class="">
                                    {{ new_order_status($process->status) }}
                                </h2>


                                @if($process->status == NewOrderStatus::$TEAM_PUSHED_TO_MANAGER)
                                    <div class="table-container">
                                        <table >
                                            <tr>
                                                <th class="">Root Domain</th>
                                                <th class="">Price</th>
                                                @if($order->order_type == "niche")
                                                    <th class="">Url</th>
                                                @endif
                                            </tr>
                                            @foreach($process->new_order_process_details  as $detail)
                                                <tr>
                                                    <td class="">{{ $detail->new_site->root_domain }}</td>
                                                    <td class="">{{ $detail->price }}</td>
                                                    @if($order->order_type == "niche")
                                                        <td class="">
                                                            {{ $detail->url }}
                                                        </td>
                                                    @endif
                                                </tr>
                                            @endforeach
                                            <tr class="note_class">
                                                <td class="">Note</td>
                                                <td colspan="2" class="">
                                                    {{ $process->note }}
                                                </td>
                                            </tr>
                                        </table>
                                    </div>
                                @endif


                                @if($process->status == NewOrderStatus::$MANAGER_DISAPPROVED_POST_TEAM)
                                    <div class="table-container">
                                        <table class="">
                                            <tr>
                                                <td class="">Note</td>
                                                <td colspan="2" class="">
                                                    {{ $process->note }}
                                                </td>
                                            </tr>
                                        </table>
                                    </div>
                                @endif


                                @if( $process->status == NewOrderStatus::$MANAGER_PUSHED_TO_WRITER )
                                    <div class="table-container">
                                        <div class="flex items-center space-x-3 bg-gray-200 p-3 text-xs font-semibold">
                                            <span>Writer:</span> <span>{{ $process->writer->name }}</span>
                                        </div>
                                        <table class="">


                                            @foreach($process->new_order_process_details  as $detail)
                                                <tr>
                                                    <td class="">Root
                                                        Domain
                                                    </td>
                                                    <td class="">{{ $detail->new_site->root_domain }}</td>
                                                </tr>
                                                <tr>
                                                    <td class="">Url</td>
                                                    <td class="">{{ $detail->ourl }}</td>
                                                </tr>
                                                <tr>
                                                    <td class="">Anchor</td>
                                                    <td class="">{{ $detail->anchor }}</td>
                                                </tr>
                                                <tr>
                                                    <td class="">Post URL</td>
                                                    <td class="">{{ $detail->url }}</td>
                                                </tr>
                                                @if($order->order_type == "gp")
                                                    <tr>
                                                        <td class="">Title</td>
                                                        <td class="">{{ $detail->title }}</td>
                                                    </tr>
                                                @endif

                                                <tr class="empty_class">
                                                    <td></td>
                                                    <td></td>
                                                </tr>

                                            @endforeach

                                            <tr class="note_class">
                                                <td class="">Note</td>
                                                <td class="">
                                                    {{ $process->note }}
                                                </td>
                                            </tr>
                                        </table>
                                    </div>
                                @endif

                                @if( $process->status == NewOrderStatus::$WRITER_PUSHED_TO_MANAGER )
                                    <div class="table-container">
                                        <div class="flex items-center space-x-3 bg-gray-200 p-3 text-xs font-semibold">
                                            <span>Writer:</span> <span>{{ $process->writer->name }}</span>
                                        </div>
                                        <table class="">

                                            @foreach($process->new_order_process_details  as $detail)

                                                <tr>
                                                    <td class="">Root
                                                        Domain
                                                    </td>
                                                    <td class="">{{ $detail->new_site->root_domain }}</td>
                                                </tr>
                                                @if($order->order_type == "gp" )
                                                    <tr>
                                                        <td class="">Upload Doc File
                                                        </td>
                                                        <td class="">
                                                            @if($detail->upload_doc_file)
                                                                <a href="{{ url("/upload/".$detail->upload_doc_file) }}"
                                                                   class="">Click
                                                                    to Download</a>
                                                            @endif
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td class="">Doc URLS</td>
                                                        <td class=" ">
                                                            <div
                                                                class=" w-full">{{ $detail->doc_urls }}</div>
                                                        </td>
                                                    </tr>
                                                @endif

                                                @if($order->order_type == "niche" )
                                                    <tr>
                                                        <td class="">Type</td>
                                                        <td class=" ">
                                                            <div class=" w-full">{{ $detail->type }}</div>
                                                        </td>
                                                    </tr>
                                                    @if($detail->type == 'insert')
                                                        <tr>
                                                            <td class="">Insert
                                                                After
                                                            </td>
                                                            <td class=" ">
                                                                <div
                                                                    class=" w-full">{!! $detail->insert_after !!}</div>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td class="">Insert
                                                                Statement
                                                            </td>
                                                            <td class=" ">
                                                                <div
                                                                    class=" w-full">{!! $detail->statement !!}</div>
                                                            </td>
                                                        </tr>
                                                    @endif

                                                    @if($detail->type == 'replace')
                                                        <tr>
                                                            <td class="">Replace
                                                                With
                                                            </td>
                                                            <td class=" ">
                                                                <div
                                                                    class=" w-full">{!! $detail->insert_after !!}</div>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td class="">Replace
                                                                Statement
                                                            </td>
                                                            <td class=" ">
                                                                <div
                                                                    class=" w-full">{!! $detail->statement !!}</div>
                                                            </td>
                                                        </tr>
                                                    @endif

                                                @endif
                                                <tr>
                                                    <td class="">Url</td>
                                                    <td class="">{{ $detail->ourl }}</td>
                                                </tr>
                                                <tr>
                                                    <td class="">Anchor</td>
                                                    <td class="">{{ $detail->anchor }}</td>
                                                </tr>
                                                <tr>
                                                    <td class="">POST Url</td>
                                                    <td class="">{{ $detail->url }}</td>
                                                </tr>
                                                <tr>
                                                    <td class="">Note</td>
                                                    <td class="">{{ $detail->note }}</td>
                                                </tr>

                                                <tr class="empty_class">
                                                    <td></td>
                                                    <td></td>
                                                </tr>
                                            @endforeach

                                        </table>
                                    </div>
                                @endif


                                @if( $process->status == NewOrderStatus::$MANAGER_REJECTED_AND_PUSHED_BACK_TO_WRITER )
                                    <div class="table-container">
                                        <div class="flex items-center space-x-3 bg-gray-200 p-3 text-xs font-semibold">
                                            <span>Writer:</span> <span>{{ $process->writer->name }}</span>
                                        </div>
                                        <table class="">
                                            <tr class="note_class">
                                                <td class="">Note</td>
                                                <td class="">
                                                    {{ $process->note }}
                                                </td>
                                            </tr>
                                        </table>
                                    </div>
                                @endif

                                @if( $process->status == NewOrderStatus::$MANAGER_PUSHED_TO_BLOGGER )
                                    <div class="table-container">
                                        <table class="">

                                            @foreach($process->new_order_process_details  as $detail)
                                                <tr>
                                                    <td class=" bg-red-200">Root
                                                        Domain
                                                    </td>
                                                    <td class=" bg-red-200">{{ $detail->new_site->root_domain }}</td>
                                                </tr>

                                                <tr>
                                                    <td class="">Blogger Email</td>
                                                    <td class="">{{ $detail->new_site->uploaded_user->email }}</td>
                                                </tr>
                                                @if($detail->status == NewOrderStatus::$BLOGGER_PUSHED_BACK_TO_MANAGER_WITH_REJECTION)
                                                    <tr>
                                                        <td class=" font-bold" style="background: red;color: white;">Blogger Rejected the Order</td>
                                                        <td class=" font-bold" style="background: red;color: white;">{{ Carbon::parse($detail->updated_at)->toDateTimeString() }}</td>
                                                    </tr>
                                                @endif
                                                @if($detail->status == NewOrderStatus::$BLOGGER_PUSHED_BACK_TO_MANAGER_WITH_SUCCESS)
                                                    <tr>
                                                        <td class=" font-bold">Blogger
                                                            Pushed to Manager
                                                        </td>
                                                        <td class=" font-bold">{{ Carbon::parse($detail->updated_at)->toDateTimeString() }}</td>
                                                    </tr>
                                                    <tr>
                                                        <td class="">Url</td>
                                                        <td class=" ">{{ $detail->submit_url }}</td>
                                                    </tr>
                                                @endif

                                                @if($detail->status == NewOrderStatus::$MANAGER_DISAPPROVED_AND_PUSHED_BACK_TO_BLOGGER)
                                                    <tr>
                                                        <td class=" font-bold">Manager
                                                            Rejected and Pushed Back to Blogger
                                                        </td>
                                                        <td class=" font-bold">{{ Carbon::parse($detail->updated_at)->toDateTimeString() }}</td>
                                                    </tr>
                                                    <tr>
                                                        <td class="">Note</td>
                                                        <td class="">{{ $detail->note }}</td>
                                                    </tr>
                                                @endif

                                                @if($detail->status == NewOrderStatus::$MANAGER_VERIFIED_AND_FINISHED)
                                                    <tr>
                                                        <td class=" font-bold"
                                                            style="background: green;color: white">Manager Verified and
                                                            Complete Order
                                                        </td>
                                                        <td class=" font-bold"
                                                            style="background: green;color: white">{{ Carbon::parse($detail->updated_at)->toDateTimeString() }}</td>
                                                    </tr>
                                                    <tr>
                                                        <td class="">Url</td>
                                                        <td class=" ">{{ $detail->submit_url }}</td>
                                                    </tr>
                                                @endif

                                                <tr class="empty_class">
                                                    <td></td>
                                                    <td></td>
                                                </tr>

                                            @endforeach

                                        </table>
                                    </div>
                                @endif


                            </div>
                        </div>
                    @endforeach


                </div>
            </div>
        @endif
    </div>
</x-filament-panels::page>
