@php use App\Filament\Blogger\Pages\ChangePassword;use App\Filament\Blogger\Pages\UpdateProfile;use Carbon\Carbon;use Illuminate\Support\Facades\Auth; @endphp
<x-filament-panels::page>

    <x-filament::section>
        <x-slot name="heading">
            User Profile
        </x-slot>

        <div style="display: flex;align-items: start;">
            <div style="width: 200px;">
                <img src="/{{ Auth::user()->profile_image ?? "images/user.jpg" }}"
                     style="width: 170px;object-fit: cover;">
            </div>
            <div style="flex: 1">
                <div class="mt-8 " style="display: flex;align-items: center;justify-content: space-between">
                    <div>
                        <div class="text-3xl font-bold text-black">{{ $user->name }}</div>
                        <div class="mt-2 text-lg">Blogger</div>

                        <div style="display: flex;">
                            <div style="margin-top: 3rem;">
                                <div style="font-size: 2rem;font-weight: 700;" class="">{{ vendor_balance() }}</div>
                                <div>Balance</div>
                            </div>

                            <div style="margin-top: 3rem;margin-left: 5rem;">
                                <div style="font-size: 2rem;font-weight: 700;" class="">Active</div>
                                <div>Status</div>
                            </div>
                        </div>


                    </div>

                    <div style="display: flex;flex-direction: column;">
                        <a href="{{ UpdateProfile::getUrl() }}"
                           style="background: rgb(252 101 39);color: white;text-align:center;padding:8px 30px;border-radius: 5px;">Edit
                            Profile</a>
                        <a href="{{ ChangePassword::getUrl() }}"
                           style="background: rgb(252 101 39);color: white;text-align:center;padding:8px 30px;border-radius: 5px;margin-top: 14px;">Change
                            Password</a>
                    </div>

                </div>

                <div
                    style="color: #888;font-size: 1.5rem;border-top: 1px solid #CCCCCC;margin-top: 20px;padding-top: 20px;margin-bottom: 20px;">
                    Basic Information
                </div>

                <div class="flex-1 max-w-3xl">
                    <div style="margin-bottom: 15px;" class="flex items-start justify-between mb-3">
                        <div class="font-black">Email Address</div>
                        <div>{{ Auth::user()->email }}</div>
                    </div>
                    <div style="margin-bottom: 15px;" class="flex items-start justify-between mb-3">
                        <div class="font-black">Joined On</div>
                        <div>{{ Carbon::parse(Auth::user()->created_at)->toFormattedDateString() }}</div>
                    </div>
                    <div style="margin-bottom: 15px;" class="flex items-start justify-between mb-3">
                        <div class="font-black">Country</div>
                        <div>{{ optional(Auth::user()->country)->name }}</div>
                    </div>
                    <div style="margin-bottom: 15px;" class="flex items-start justify-between mb-3">
                        <div class="font-black">Whatsapp</div>
                        <div>{{ Auth::user()->whatsapp }}</div>
                    </div>
                    <div style="margin-bottom: 15px;" class="flex items-start justify-between mb-3">
                        <div class="font-black">Skype</div>
                        <div>{{ Auth::user()->skype }}</div>
                    </div>
                    <div style="margin-bottom: 15px;" class="flex items-start justify-between mb-3">
                        <div class="font-black">Access Role</div>
                        <div>Blogger</div>
                    </div>

                </div>

                @if( Auth::user()->country_id == 1 )
                    <div
                        style="color: #888;font-size: 1.5rem;border-top: 1px solid #CCCCCC;margin-top: 20px;padding-top: 20px;margin-bottom: 20px;">
                        For Indian Users
                    </div>
                    <div class="flex-1 max-w-3xl">
                        <div style="margin-bottom: 15px;" class="flex items-start justify-between mb-3">
                            <div class="font-black">Aadhar Number</div>
                            <div>{{ Auth::user()->aadhar_number }}</div>
                        </div>
                        <div style="margin-bottom: 15px;" class="flex items-start justify-between mb-3">
                            <div class="font-black">Pancard Number</div>
                            <div>{{ Auth::user()->pancard_number }}</div>
                        </div>
                        <div style="margin-bottom: 15px;" class="flex items-start justify-between mb-3">
                            <div class="font-black">GST Number</div>
                            <div>{{ Auth::user()->gst_number }}</div>
                        </div>


                    </div>
                @endif
            </div>
        </div>

    </x-filament::section>


    <x-filament-actions::modals/>

</x-filament-panels::page>
