<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\OnDemandScanning;

class SbomReferenceIntotoPayload extends \Google\Collection
{
  protected $collection_key = 'subject';
  protected $internal_gapi_mappings = [
        "type" => "_type",
  ];
  /**
   * Identifier for the schema of the Statement.
   *
   * @var string
   */
  public $type;
  protected $predicateDataType = '';
  /**
   * URI identifying the type of the Predicate.
   *
   * @var string
   */
  public $predicateType;
  protected $subjectType = Subject::class;
  protected $subjectDataType = 'array';

  /**
   * Identifier for the schema of the Statement.
   *
   * @param string $type
   */
  public function setType($type)
  {
    $this->type = $type;
  }
  /**
   * @return string
   */
  public function getType()
  {
    return $this->type;
  }
  /**
   * Additional parameters of the Predicate. Includes the actual data about the
   * SBOM.
   *
   * @param SbomReferenceIntotoPredicate $predicate
   */
  public function setPredicate(SbomReferenceIntotoPredicate $predicate)
  {
    $this->predicate = $predicate;
  }
  /**
   * @return SbomReferenceIntotoPredicate
   */
  public function getPredicate()
  {
    return $this->predicate;
  }
  /**
   * URI identifying the type of the Predicate.
   *
   * @param string $predicateType
   */
  public function setPredicateType($predicateType)
  {
    $this->predicateType = $predicateType;
  }
  /**
   * @return string
   */
  public function getPredicateType()
  {
    return $this->predicateType;
  }
  /**
   * Set of software artifacts that the attestation applies to. Each element
   * represents a single software artifact.
   *
   * @param Subject[] $subject
   */
  public function setSubject($subject)
  {
    $this->subject = $subject;
  }
  /**
   * @return Subject[]
   */
  public function getSubject()
  {
    return $this->subject;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(SbomReferenceIntotoPayload::class, 'Google_Service_OnDemandScanning_SbomReferenceIntotoPayload');
