

<?php $__env->startSection('title', 'Leadership Board'); ?>

<?php $__env->startSection('content'); ?>
    <div class="p-6">
        <!-- Header -->
        <div class="flex flex-col md:flex-row md:items-center justify-between mb-8">
            <div>
                <h1 class="text-2xl font-bold text-gray-800">Overview</h1>
            </div>

            <!-- Date Range Filter -->
            <div class="mt-4 md:mt-0 bg-white border border-gray-300 rounded px-2 py-1 flex items-center shadow-sm text-sm">
                <form method="GET" action="<?php echo e(route('admin.leadership-board.index')); ?>" class="flex items-center space-x-2">
                    <span class="text-gray-600 mr-2 font-medium">Period:</span>
                    <select name="month" class="bg-transparent border-none text-gray-700 font-semibold focus:ring-0 cursor-pointer py-1 pl-2 pr-6 text-sm">
                        <?php $__currentLoopData = $months; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $num => $name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($num); ?>" <?php echo e($month == $num ? 'selected' : ''); ?>><?php echo e($name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <span class="text-gray-400">/</span>
                    <select name="year" class="bg-transparent border-none text-gray-700 font-semibold focus:ring-0 cursor-pointer py-1 pl-2 pr-6 text-sm">
                        <?php $__currentLoopData = $years; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $y): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($y); ?>" <?php echo e($year == $y ? 'selected' : ''); ?>><?php echo e($y); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <button type="submit" class="bg-gray-100 hover:bg-gray-200 text-gray-600 font-medium py-1 px-3 rounded text-xs ml-2 border border-gray-200 transition-colors">
                        Apply
                    </button>
                </form>
            </div>
        </div>

        <!-- Performance Section -->
        <div class="mb-8">
            <div class="flex items-center justify-between mb-4">
                <h2 class="text-lg font-semibold text-gray-700">Performance</h2>
                <button class="text-gray-400 hover:text-gray-600">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M12 5v.01M12 12v.01M12 19v.01M12 6a1 1 0 110-2 1 1 0 010 2zm0 7a1 1 0 110-2 1 1 0 010 2zm0 7a1 1 0 110-2 1 1 0 010 2z">
                        </path>
                    </svg>
                </button>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-5 gap-4">
                <!-- Total Sales -->
                <div class="bg-white p-4 rounded shadow-sm border border-gray-100">
                    <div class="text-sm text-gray-500 mb-1">Total sales</div>
                    <div class="flex items-end justify-between">
                        <div class="text-xl font-bold text-gray-800">₹<?php echo e(number_format($stats['total_sales'], 2)); ?></div>
                        <div
                            class="text-xs px-1.5 py-0.5 rounded <?php echo e($changes['total_sales'] >= 0 ? 'bg-green-100 text-green-700' : 'bg-red-100 text-red-700'); ?>">
                            <?php echo e($changes['total_sales']); ?>%
                        </div>
                    </div>
                </div>

                <!-- Net Sales -->
                <div class="bg-white p-4 rounded shadow-sm border border-gray-100">
                    <div class="text-sm text-gray-500 mb-1">Net sales</div>
                    <div class="flex items-end justify-between">
                        <div class="text-xl font-bold text-gray-800">₹<?php echo e(number_format($stats['net_sales'], 2)); ?></div>
                        <div
                            class="text-xs px-1.5 py-0.5 rounded <?php echo e($changes['net_sales'] >= 0 ? 'bg-green-100 text-green-700' : 'bg-red-100 text-red-700'); ?>">
                            <?php echo e($changes['net_sales']); ?>%
                        </div>
                    </div>
                </div>

                <!-- Orders -->
                <div class="bg-white p-4 rounded shadow-sm border border-gray-100">
                    <div class="text-sm text-gray-500 mb-1">Orders</div>
                    <div class="flex items-end justify-between">
                        <div class="text-xl font-bold text-gray-800"><?php echo e(number_format($stats['orders_count'])); ?></div>
                        <div
                            class="text-xs px-1.5 py-0.5 rounded <?php echo e($changes['orders_count'] >= 0 ? 'bg-green-100 text-green-700' : 'bg-red-100 text-red-700'); ?>">
                            <?php echo e($changes['orders_count']); ?>%
                        </div>
                    </div>
                </div>

                <!-- Products Sold -->
                <div class="bg-white p-4 rounded shadow-sm border border-gray-100">
                    <div class="text-sm text-gray-500 mb-1">Products sold</div>
                    <div class="flex items-end justify-between">
                        <div class="text-xl font-bold text-gray-800"><?php echo e(number_format($stats['products_sold'])); ?></div>
                        <div
                            class="text-xs px-1.5 py-0.5 rounded <?php echo e($changes['products_sold'] >= 0 ? 'bg-green-100 text-green-700' : 'bg-red-100 text-red-700'); ?>">
                            <?php echo e($changes['products_sold']); ?>%
                        </div>
                    </div>
                </div>

                <!-- Variations Sold -->
                <div class="bg-white p-4 rounded shadow-sm border border-gray-100">
                    <div class="text-sm text-gray-500 mb-1">Variations Sold</div>
                    <div class="flex items-end justify-between">
                        <div class="text-xl font-bold text-gray-800"><?php echo e(number_format($stats['variations_sold'])); ?></div>
                        <div
                            class="text-xs px-1.5 py-0.5 rounded <?php echo e($changes['variations_sold'] >= 0 ? 'bg-green-100 text-green-700' : 'bg-red-100 text-red-700'); ?>">
                            <?php echo e($changes['variations_sold']); ?>%
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Charts Section -->
        <div>
            <div class="flex items-center justify-between mb-4">
                <h2 class="text-lg font-semibold text-gray-700">Charts</h2>
                <div class="flex items-center space-x-2">
                    <select
                        class="text-sm border-gray-300 rounded shadow-sm focus:border-indigo-500 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                        <option>By day</option>
                    </select>
                    <div class="flex border border-gray-300 rounded overflow-hidden">
                        <button class="px-2 py-1 bg-gray-100 text-gray-600 hover:bg-gray-200">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M16 8v8m-4-5v5m-4-2v2m-2 4h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z">
                                </path>
                            </svg>
                        </button>
                        <button class="px-2 py-1 bg-white text-gray-400 hover:text-gray-600">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M7 12l3-3 3 3 4-4M8 21l4-4 4 4M3 4h18M4 4h16v12a1 1 0 01-1 1H5a1 1 0 01-1-1V4z">
                                </path>
                            </svg>
                        </button>
                    </div>
                    <button class="text-gray-400 hover:text-gray-600">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M12 5v.01M12 12v.01M12 19v.01M12 6a1 1 0 110-2 1 1 0 010 2zm0 7a1 1 0 110-2 1 1 0 010 2zm0 7a1 1 0 110-2 1 1 0 010 2z">
                            </path>
                        </svg>
                    </button>
                </div>
            </div>

            <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
                <!-- Net Sales Chart -->
                <div class="bg-white p-4 rounded shadow-sm border border-gray-100">
                    <h3 class="text-sm font-semibold text-gray-700 mb-4">Net sales</h3>
                    <div class="relative h-64">
                        <canvas id="netSalesChart"></canvas>
                    </div>
                </div>

                <!-- Orders Chart -->
                <div class="bg-white p-4 rounded shadow-sm border border-gray-100">
                    <h3 class="text-sm font-semibold text-gray-700 mb-4">Orders</h3>
                    <div class="relative h-64">
                        <canvas id="ordersChart"></canvas>
                    </div>
                </div>
            </div>
        </div>

        <!-- Revenue Section -->
        <div class="mt-8 bg-white rounded-lg shadow-sm border border-gray-200">
            <div class="px-6 py-4 border-b border-gray-200 flex justify-between items-center">
                <h2 class="text-lg font-semibold text-gray-800">Revenue</h2>
                <div class="flex items-center space-x-2">
                    <a href="<?php echo e(route('admin.leadership-board.pdf', ['year' => $year, 'month' => $month])); ?>" class="inline-flex items-center px-3 py-1.5 bg-white border border-gray-300 rounded-md font-medium text-gray-700 text-sm hover:bg-gray-50 shadow-sm transition-colors">
                        <svg class="w-4 h-4 mr-2 text-gray-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-4l-4 4m0 0l-4-4m4 4V4"></path>
                        </svg>
                        Download PDF
                    </a>
                </div>
            </div>
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Date</th>
                            <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Orders</th>
                            <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Gross Sales</th>
                            <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Returns</th>
                            <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Coupons</th>
                            <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Net Sales</th>
                            <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Taxes</th>
                            <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Shipping</th>
                            <th scope="col" class="px-6 py-3 text-right text-xs font-bold text-gray-700 uppercase tracking-wider">Total Sales</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        <?php $__empty_1 = true; $__currentLoopData = $revenueData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900"><?php echo e(\Carbon\Carbon::parse($row['date'])->format('F j, Y')); ?></td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 text-right">
                                    <a href="<?php echo e(route('admin.orders.index')); ?>?date=<?php echo e(\Carbon\Carbon::parse($row['date'])->format('Y-m-d')); ?>" class="text-indigo-600 hover:text-indigo-900"><?php echo e($row['orders']); ?></a>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 text-right">₹<?php echo e(number_format($row['gross_sales'], 2)); ?></td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 text-right">₹<?php echo e(number_format($row['returns'], 2)); ?></td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 text-right">₹<?php echo e(number_format($row['coupons'], 2)); ?></td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 text-right">₹<?php echo e(number_format($row['net_sales'], 2)); ?></td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 text-right">₹<?php echo e(number_format($row['taxes'], 2)); ?></td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 text-right">₹<?php echo e(number_format($row['shipping'], 2)); ?></td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm font-bold text-gray-900 text-right">₹<?php echo e(number_format($row['total_sales'], 2)); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="9" class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 text-center">No data found for this period.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>

    <?php $__env->startPush('scripts'); ?>
        <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
        <script>
            const salesData = <?php echo json_encode($dailySales, 15, 512) ?>;
            const ordersData = <?php echo json_encode($dailyOrders, 15, 512) ?>;

            const labels = Object.keys(salesData);
            const salesValues = Object.values(salesData);
            const ordersValues = Object.values(ordersData);

            // Sales Chart
            new Chart(document.getElementById('netSalesChart'), {
                type: 'line',
                data: {
                    labels: labels,
                    datasets: [{
                        label: 'Net Sales',
                        data: salesValues,
                        borderColor: '#3b82f6', // Blue 500
                        backgroundColor: 'rgba(59, 130, 246, 0.1)',
                        borderWidth: 2,
                        fill: true,
                        tension: 0.4
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: { display: false }
                    },
                    scales: {
                        y: {
                            beginAtZero: true,
                            grid: { color: '#f3f4f6' }
                        },
                        x: {
                            grid: { display: false }
                        }
                    }
                }
            });

            // Orders Chart
            new Chart(document.getElementById('ordersChart'), {
                type: 'line', // Can be bar if preferred
                data: {
                    labels: labels,
                    datasets: [{
                        label: 'Orders',
                        data: ordersValues,
                        borderColor: '#f59e0b', // Amber 500
                        backgroundColor: 'rgba(245, 158, 11, 0.1)',
                        borderWidth: 2,
                        fill: true,
                        tension: 0.4
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: { display: false }
                    },
                    scales: {
                        y: {
                            beginAtZero: true,
                            ticks: { stepSize: 1 },
                            grid: { color: '#f3f4f6' }
                        },
                        x: {
                            grid: { display: false }
                        }
                    }
                }
            });
        </script>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/truetransit/public_html/hairniche.in/resources/views/admin/leadership_board/index.blade.php ENDPATH**/ ?>