<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Add Delivery Agent - Hair Niche Admin</title>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <?php echo $__env->make('admin.partials.styles', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
</head>

<body class="bg-gray-50 flex h-screen overflow-hidden">
    <?php echo $__env->make('admin.partials.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <div class="flex-1 flex flex-col h-screen overflow-hidden">
        <header class="h-16 flex items-center px-6 bg-white border-b border-gray-200">
            <h2 class="text-2xl font-semibold text-gray-800">Add New Delivery Agent</h2>
        </header>
        <main class="flex-1 overflow-x-hidden overflow-y-auto bg-gray-50 p-6">
            <div class="max-w-4xl mx-auto">

                <?php if($errors->any()): ?>
                    <div class="mb-6 bg-red-50 border-l-4 border-red-500 p-4 rounded-r-lg text-red-700">
                        <ul class="list-disc list-inside">
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <li><?php echo e($error); ?></li> <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                <?php endif; ?>

                <form action="<?php echo e(route('admin.delivery-agents.store')); ?>" method="POST" enctype="multipart/form-data"
                    class="space-y-8" x-data="{
                    documents: [{id: 1, type: '', number: ''}],
                    vehicles: [{id: 1, type: '', vehicle_number: '', model: ''}],
                    addDocument() { this.documents.push({id: Date.now(), type: '', number: ''}); },
                    removeDocument(index) { this.documents.splice(index, 1); },
                    addVehicle() { this.vehicles.push({id: Date.now(), type: '', vehicle_number: '', model: ''}); },
                    removeVehicle(index) { this.vehicles.splice(index, 1); }
                }">
                    <?php echo csrf_field(); ?>

                    <!-- Login Credentials -->
                    <div class="bg-white rounded-xl shadow-sm p-6 border border-gray-100">
                        <h3 class="text-lg font-bold text-gray-900 mb-6 border-b pb-4 flex items-center">
                            <svg class="w-5 h-5 mr-2 text-blue-600" fill="none" stroke="currentColor"
                                viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M15 7a2 2 0 012 2m4 0a6 6 0 01-7.743 5.743L11 17H9v2H7v2H4a1 1 0 01-1-1v-2.586a1 1 0 01.293-.707l5.964-5.964A6 6 0 1121 9z">
                                </path>
                            </svg>
                            Login Credentials
                        </h3>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div>
                                <label class="block text-sm font-semibold text-gray-700 mb-1">Full Name <span
                                        class="text-red-500">*</span></label>
                                <input type="text" name="name" value="<?php echo e(old('name')); ?>" required
                                    placeholder="e.g. John Doe"
                                    class="w-full rounded-lg border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2.5 transition-all bg-gray-50 focus:bg-white">
                            </div>
                            <div>
                                <label class="block text-sm font-semibold text-gray-700 mb-1">Email Address <span
                                        class="text-red-500">*</span></label>
                                <input type="email" name="email" value="<?php echo e(old('email')); ?>" required
                                    placeholder="e.g. john@example.com"
                                    class="w-full rounded-lg border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2.5 transition-all bg-gray-50 focus:bg-white">
                            </div>
                            <div class="md:col-span-2" x-data="{ 
                                    password: '', 
                                    show: false,
                                    strength: 0,
                                    rules: {
                                        length: false,
                                        upper: false,
                                        lower: false,
                                        number: false,
                                        special: false
                                    },
                                    checkStrength() {
                                        const p = this.password;
                                        this.rules.length = p.length >= 8;
                                        this.rules.upper = /[A-Z]/.test(p);
                                        this.rules.lower = /[a-z]/.test(p);
                                        this.rules.number = /[0-9]/.test(p);
                                        this.rules.special = /[^A-Za-z0-9]/.test(p);
                                        
                                        this.strength = Object.values(this.rules).filter(Boolean).length;
                                    },
                                    generate() {
                                        const lower = 'abcdefghijklmnopqrstuvwxyz';
                                        const upper = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
                                        const nums = '0123456789';
                                        const special = '!@#$%^&*';
                                        let pass = '';
                                        pass += lower[Math.floor(Math.random() * lower.length)];
                                        pass += upper[Math.floor(Math.random() * upper.length)];
                                        pass += nums[Math.floor(Math.random() * nums.length)];
                                        pass += special[Math.floor(Math.random() * special.length)];
                                        const all = lower + upper + nums + special;
                                        for(let i=0; i<8; i++) pass += all[Math.floor(Math.random() * all.length)];
                                        
                                        this.password = pass.split('').sort(() => 0.5 - Math.random()).join('');
                                        this.checkStrength();
                                    }
                                }">
                                <label class="block text-sm font-semibold text-gray-700 mb-1">Password <span
                                        class="text-red-500">*</span></label>
                                <div class="flex flex-col md:flex-row gap-4">
                                    <div class="flex-1 space-y-2">
                                        <div class="relative">
                                            <input :type="show ? 'text' : 'password'" name="password" x-model="password"
                                                @input="checkStrength()" required placeholder="Enter strong password"
                                                class="w-full rounded-lg border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2.5 bg-gray-50 focus:bg-white pr-10">
                                            <button type="button" @click="show = !show"
                                                class="absolute inset-y-0 right-0 pr-3 flex items-center text-gray-400 hover:text-gray-600 focus:outline-none">
                                                <svg x-show="!show" class="h-5 w-5" fill="none" viewBox="0 0 24 24"
                                                    stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        stroke-width="2"
                                                        d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
                                                </svg>
                                                <svg x-show="show" x-cloak class="h-5 w-5" fill="none"
                                                    viewBox="0 0 24 24" stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        stroke-width="2"
                                                        d="M13.875 18.825A10.05 10.05 0 0112 19c-4.478 0-8.268-2.943-9.543-7a9.97 9.97 0 011.563-3.029m5.858.908a3 3 0 114.243 4.243M9.878 9.878l4.242 4.242M9.88 9.88l-3.29-3.29m7.532 7.532l3.29 3.29M3 3l3.59 3.59m0 0A9.953 9.953 0 0112 5c4.478 0 8.268 2.943 9.543 7a10.025 10.025 0 01-4.132 5.411m0 0L21 21" />
                                                </svg>
                                            </button>
                                        </div>
                                        <!-- Strength Bar -->
                                        <div class="h-1.5 w-full bg-gray-200 rounded-full overflow-hidden">
                                            <div class="h-full transition-all duration-300" :class="{
                                                    'bg-red-500 w-1/5': strength <= 1,
                                                    'bg-orange-500 w-2/5': strength == 2,
                                                    'bg-yellow-500 w-3/5': strength == 3,
                                                    'bg-blue-500 w-4/5': strength == 4,
                                                    'bg-green-500 w-full': strength == 5
                                                }"></div>
                                        </div>
                                    </div>
                                    <button type="button" @click="generate()"
                                        class="px-4 py-2.5 bg-gray-100 text-gray-700 rounded-lg border border-gray-300 text-sm font-medium hover:bg-gray-200 transition-colors h-fit whitespace-nowrap">
                                        Generate
                                    </button>
                                </div>

                                <!-- Rules List -->
                                <div class="mt-3 flex flex-wrap gap-x-6 gap-y-2 text-xs">
                                    <span :class="rules.length ? 'text-green-600 font-medium' : 'text-gray-500'">
                                        <span x-text="rules.length ? '✓' : '○'"></span> Min 8 chars
                                    </span>
                                    <span :class="rules.upper ? 'text-green-600 font-medium' : 'text-gray-500'">
                                        <span x-text="rules.upper ? '✓' : '○'"></span> Uppercase
                                    </span>
                                    <span :class="rules.lower ? 'text-green-600 font-medium' : 'text-gray-500'">
                                        <span x-text="rules.lower ? '✓' : '○'"></span> Lowercase
                                    </span>
                                    <span :class="rules.number ? 'text-green-600 font-medium' : 'text-gray-500'">
                                        <span x-text="rules.number ? '✓' : '○'"></span> Number
                                    </span>
                                    <span :class="rules.special ? 'text-green-600 font-medium' : 'text-gray-500'">
                                        <span x-text="rules.special ? '✓' : '○'"></span> Special Char
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Personal Information -->
                    <div class="bg-white rounded-xl shadow-sm p-6 border border-gray-100">
                        <h3 class="text-lg font-bold text-gray-900 mb-6 border-b pb-4 flex items-center">
                            <svg class="w-5 h-5 mr-2 text-blue-600" fill="none" stroke="currentColor"
                                viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                            </svg>
                            Profile Information
                        </h3>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div class="md:col-span-2">
                                <label class="block text-sm font-semibold text-gray-700 mb-2">Profile Picture</label>
                                <div class="flex items-center space-x-4">
                                    <div
                                        class="flex-shrink-0 h-16 w-16 bg-gray-100 rounded-full border border-gray-200 flex items-center justify-center text-gray-400">
                                        <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z">
                                            </path>
                                        </svg>
                                    </div>
                                    <input type="file" name="profile_image"
                                        class="block w-full text-sm text-gray-500 file:mr-4 file:py-2.5 file:px-4 file:rounded-lg file:border-0 file:text-sm file:font-semibold file:bg-blue-50 file:text-blue-700 hover:file:bg-blue-100 cursor-pointer">
                                </div>
                            </div>
                            <div>
                                <label class="block text-sm font-semibold text-gray-700 mb-1">Phone Number <span
                                        class="text-red-500">*</span></label>
                                <input type="text" name="phone" value="<?php echo e(old('phone')); ?>" required
                                    placeholder="e.g. 9876543210"
                                    class="w-full rounded-lg border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2.5 transition-all focus:bg-white bg-gray-50">
                            </div>
                            <div>
                                <label class="block text-sm font-semibold text-gray-700 mb-1">Alternate Phone
                                    (Optional)</label>
                                <input type="text" name="alternate_phone" value="<?php echo e(old('alternate_phone')); ?>"
                                    placeholder="e.g. 9876543210"
                                    class="w-full rounded-lg border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2.5 transition-all focus:bg-white bg-gray-50">
                            </div>
                            <div>
                                <label class="block text-sm font-semibold text-gray-700 mb-1">Date of Birth</label>
                                <input type="date" name="dob" value="<?php echo e(old('dob')); ?>"
                                    class="w-full rounded-lg border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2.5 transition-all focus:bg-white bg-gray-50">
                            </div>
                            <div>
                                <label class="block text-sm font-semibold text-gray-700 mb-1">Gender</label>
                                <select name="gender"
                                    class="w-full rounded-lg border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2.5 transition-all focus:bg-white bg-gray-50">
                                    <option value="">Select Gender</option>
                                    <option value="Male">Male</option>
                                    <option value="Female">Female</option>
                                    <option value="Other">Other</option>
                                </select>
                            </div>
                            <div>
                                <label class="block text-sm font-semibold text-gray-700 mb-1">Father's Name</label>
                                <input type="text" name="father_name" value="<?php echo e(old('father_name')); ?>"
                                    placeholder="Enter Father's Name"
                                    class="w-full rounded-lg border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2.5 transition-all focus:bg-white bg-gray-50">
                            </div>
                            <div>
                                <label class="block text-sm font-semibold text-gray-700 mb-1">Spouse Name
                                    (Optional)</label>
                                <input type="text" name="spouse_name" value="<?php echo e(old('spouse_name')); ?>"
                                    placeholder="Enter Spouse Name"
                                    class="w-full rounded-lg border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2.5 transition-all focus:bg-white bg-gray-50">
                            </div>
                            <div class="md:col-span-2">
                                <label class="block text-sm font-semibold text-gray-700 mb-1">Full Address <span
                                        class="text-red-500">*</span></label>
                                <textarea name="address" rows="3" required
                                    placeholder="Enter complete residential address"
                                    class="w-full rounded-lg border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2.5 transition-all focus:bg-white bg-gray-50"><?php echo e(old('address')); ?></textarea>
                            </div>
                        </div>
                    </div>

                    <!-- Documents (Multiple) -->
                    <div class="bg-white rounded-xl shadow-sm p-6 border border-gray-100">
                        <div class="flex items-center justify-between mb-4 border-b pb-2">
                            <h3 class="text-lg font-medium text-gray-900">Documents & KYC</h3>
                            <button type="button" @click="addDocument()"
                                class="text-sm bg-blue-50 text-blue-600 px-3 py-1 rounded hover:bg-blue-100">+ Add
                                Document</button>
                        </div>

                        <template x-for="(doc, index) in documents" :key="doc.id">
                            <div
                                class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-4 p-4 border rounded-lg bg-gray-50 relative">
                                <button type="button" @click="removeDocument(index)" x-show="documents.length > 1"
                                    class="absolute top-2 right-2 text-red-500 hover:text-red-700">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M6 18L18 6M6 6l12 12"></path>
                                    </svg>
                                </button>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Type</label>
                                    <select :name="'documents['+index+'][type]'" required
                                        class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2">
                                        <option value="">Select Type</option>
                                        <option value="Aadhar Card">Aadhar Card</option>
                                        <option value="Voter ID">Voter ID</option>
                                        <option value="Driving License">Driving License</option>
                                        <option value="PAN Card">PAN Card</option>
                                        <option value="Other">Other</option>
                                    </select>
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Number</label>
                                    <input type="text" :name="'documents['+index+'][number]'" placeholder="ID Number"
                                        required
                                        class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2">
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Image</label>
                                    <input type="file" :name="'documents['+index+'][image]'" required
                                        class="mt-1 block w-full text-sm text-gray-500 file:mr-2 file:py-1 file:px-3 file:rounded-full file:border-0 file:text-xs file:font-semibold file:bg-blue-50 file:text-blue-700 hover:file:bg-blue-100">
                                </div>
                            </div>
                        </template>
                    </div>

                    <!-- Vehicles (Multiple) -->
                    <div class="bg-white rounded-xl shadow-sm p-6 border border-gray-100">
                        <div class="flex items-center justify-between mb-4 border-b pb-2">
                            <h3 class="text-lg font-medium text-gray-900">Vehicles</h3>
                            <button type="button" @click="addVehicle()"
                                class="text-sm bg-blue-50 text-blue-600 px-3 py-1 rounded hover:bg-blue-100">+ Add
                                Vehicle</button>
                        </div>

                        <template x-for="(vehicle, index) in vehicles" :key="vehicle.id">
                            <div
                                class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-4 p-4 border rounded-lg bg-gray-50 relative">
                                <button type="button" @click="removeVehicle(index)" x-show="vehicles.length > 1"
                                    class="absolute top-2 right-2 text-red-500 hover:text-red-700">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M6 18L18 6M6 6l12 12"></path>
                                    </svg>
                                </button>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Type</label>
                                    <select :name="'vehicles['+index+'][type]'" required
                                        class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2">
                                        <option value="">Select Type</option>
                                        <option value="Bike">Bike</option>
                                        <option value="Scooter">Scooter</option>
                                        <option value="Van">Van</option>
                                        <option value="Truck">Truck</option>
                                        <option value="Other">Other</option>
                                    </select>
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Vehicle Number</label>
                                    <input type="text" :name="'vehicles['+index+'][vehicle_number]'"
                                        placeholder="XX-00-XX-0000" required
                                        class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2">
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Model</label>
                                    <input type="text" :name="'vehicles['+index+'][model]'"
                                        placeholder="e.g. Honda Activa"
                                        class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2">
                                </div>
                            </div>
                        </template>
                    </div>

                    <div class="flex justify-end gap-3 pt-4">
                        <a href="<?php echo e(route('admin.delivery-agents.index')); ?>"
                            class="px-4 py-2 border border-gray-300 rounded-md shadow-sm text-sm font-medium text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                            Cancel
                        </a>
                        <button type="submit"
                            class="px-6 py-2 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                            Create Agent
                        </button>
                    </div>
                </form>
            </div>
        </main>
    </div>
</body>

</html><?php /**PATH /home/truetransit/public_html/hairniche.in/resources/views/admin/delivery_agents/create.blade.php ENDPATH**/ ?>