<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Products - Lugani Admin</title>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Inter', sans-serif;
        }

        [x-cloak] {
            display: none !important;
        }
    </style>
</head>

<body class="bg-gray-50 flex h-screen overflow-hidden" x-data>

    <?php echo $__env->make('admin.partials.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <div class="flex-1 flex flex-col h-screen overflow-hidden">
        <header class="h-16 flex items-center justify-between px-6 bg-white border-b border-gray-200">
            <div class="flex items-center">
                <h2 class="text-2xl font-semibold text-gray-800">Products</h2>
            </div>
            <div class="flex items-center space-x-4">
                <!-- Search Form -->
                <form id="filterForm" action="<?php echo e(route('admin.products.index')); ?>" method="GET"
                    class="relative flex items-center space-x-2">

                    <!-- Searchable Category Filter -->
                    <div x-data="categoryFilter()" class="relative w-64 mr-2" @click.away="open = false">
                        <input type="hidden" name="category" :value="selected">

                        <!-- Trigger Button -->
                        <button type="button" @click="open = !open"
                            class="relative w-full bg-white border border-gray-300 rounded-md shadow-sm pl-3 pr-10 py-2 text-left cursor-default focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500 sm:text-sm h-[38px]">
                            <span class="block truncate" x-text="selectedName"></span>
                            <span class="absolute inset-y-0 right-0 flex items-center pr-2 pointer-events-none">
                                <svg class="h-5 w-5 text-gray-400" xmlns="http://www.w3.org/2000/svg"
                                    viewBox="0 0 20 20" fill="currentColor">
                                    <path fill-rule="evenodd"
                                        d="M10 3a1 1 0 01.707.293l3 3a1 1 0 01-1.414 1.414L10 5.414 7.707 7.707a1 1 0 01-1.414-1.414l3-3A1 1 0 0110 3zm-3.707 9.293a1 1 0 011.414 0L10 14.586l2.293-2.293a1 1 0 011.414 1.414l-3 3a1 1 0 01-1.414 0l-3-3a1 1 0 010-1.414z"
                                        clip-rule="evenodd" />
                                </svg>
                            </span>
                        </button>

                        <!-- Dropdown Menu -->
                        <div x-show="open" x-transition:enter="transition ease-out duration-100"
                            x-transition:enter-start="transform opacity-0 scale-95"
                            x-transition:enter-end="transform opacity-100 scale-100"
                            x-transition:leave="transition ease-in duration-75"
                            x-transition:leave-start="transform opacity-100 scale-100"
                            x-transition:leave-end="transform opacity-0 scale-95"
                            class="absolute z-50 mt-1 w-full bg-white shadow-lg max-h-60 rounded-md py-1 text-base ring-1 ring-black ring-opacity-5 overflow-auto focus:outline-none sm:text-sm"
                            x-cloak>

                            <!-- Search Input -->
                            <div class="sticky top-0 z-10 bg-white px-2 py-2 border-b border-gray-100">
                                <div class="relative">
                                    <div class="absolute inset-y-0 left-0 pl-2 flex items-center pointer-events-none">
                                        <svg class="h-4 w-4 text-gray-400" xmlns="http://www.w3.org/2000/svg"
                                            viewBox="0 0 20 20" fill="currentColor">
                                            <path fill-rule="evenodd"
                                                d="M8 4a4 4 0 100 8 4 4 0 000-8zM2 8a6 6 0 1110.89 3.476l4.817 4.817a1 1 0 01-1.414 1.414l-4.816-4.816A6 6 0 012 8z"
                                                clip-rule="evenodd" />
                                        </svg>
                                    </div>
                                    <input type="text" x-model="search" @click.stop
                                        class="block w-full pl-8 pr-2 py-1 border border-gray-200 rounded-md text-sm focus:border-blue-500 focus:ring-1 focus:ring-blue-500 focus:outline-none"
                                        placeholder="Search categories..." autofocus>
                                </div>
                            </div>

                            <!-- Options -->
                            <ul class="pt-1">
                                <!-- All Categories Option -->
                                <li @click="select('')"
                                    class="cursor-pointer select-none relative py-2 pl-3 pr-9 hover:bg-blue-50 text-gray-900">
                                    <span class="font-normal block truncate"
                                        :class="{ 'font-semibold': selected === '' }">
                                        All Categories
                                    </span>
                                    <span x-show="selected === ''"
                                        class="text-blue-600 absolute inset-y-0 right-0 flex items-center pr-4">
                                        <svg class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor">
                                            <path fill-rule="evenodd"
                                                d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z"
                                                clip-rule="evenodd" />
                                        </svg>
                                    </span>
                                </li>

                                <!-- Filtered Options -->
                                <template x-for="cat in filteredCategories" :key="cat.id">
                                    <li @click="select(cat.id)"
                                        class="cursor-pointer select-none relative py-2 pl-3 pr-9 hover:bg-blue-50 text-gray-900">
                                        <span class="font-normal block truncate"
                                            :class="{ 'font-semibold': selected == cat.id }" x-text="cat.name">
                                        </span>
                                        <span x-show="selected == cat.id"
                                            class="text-blue-600 absolute inset-y-0 right-0 flex items-center pr-4">
                                            <svg class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor">
                                                <path fill-rule="evenodd"
                                                    d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z"
                                                    clip-rule="evenodd" />
                                            </svg>
                                        </span>
                                    </li>
                                </template>
                                <li x-show="filteredCategories.length === 0"
                                    class="py-2 pl-3 pr-9 text-gray-500 italic text-sm">
                                    No categories found.
                                </li>
                            </ul>
                        </div>
                    </div>

                    <div class="relative w-64" x-data="productAutocomplete()" @click.away="showSuggestions = false">
                        <span class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none">
                            <svg class="h-5 w-5 text-gray-400" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"
                                fill="currentColor">
                                <path fill-rule="evenodd"
                                    d="M8 4a4 4 0 100 8 4 4 0 000-8zM2 8a6 6 0 1110.89 3.476l4.817 4.817a1 1 0 01-1.414 1.414l-4.816-4.816A6 6 0 012 8z"
                                    clip-rule="evenodd" />
                            </svg>
                        </span>
                        <input type="text" name="search" x-model.debounce.300ms="query" placeholder="Search products..."
                            autocomplete="off" @focus="showSuggestions = true"
                            class="block w-full pl-10 pr-3 py-2 border border-gray-300 rounded-md leading-5 bg-white placeholder-gray-500 focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500 sm:text-sm h-[38px]">

                        <!-- Autocomplete Dropdown -->
                        <div x-show="showSuggestions && suggestions.length > 0"
                            x-transition:enter="transition ease-out duration-100"
                            x-transition:enter-start="opacity-0 scale-95" x-transition:enter-end="opacity-100 scale-100"
                            x-transition:leave="transition ease-in duration-75"
                            x-transition:leave-start="opacity-100 scale-100" x-transition:leave-end="opacity-0 scale-95"
                            class="absolute z-50 mt-1 w-full bg-white shadow-lg rounded-md py-1 text-base ring-1 ring-black ring-opacity-5 overflow-auto max-h-60 sm:text-sm"
                            x-cloak>
                            <ul>
                                <template x-for="product in suggestions" :key="product.id">
                                    <li @click="selectSuggestion(product)"
                                        class="cursor-pointer select-none relative py-2 pl-3 pr-9 hover:bg-blue-50 text-gray-900">
                                        <div class="flex flex-col">
                                            <span class="font-medium truncate" x-text="product.name"></span>
                                        </div>
                                    </li>
                                </template>
                            </ul>
                        </div>
                    </div>
                </form>

                <a href="<?php echo e(route('admin.products.export-pdf')); ?>"
                    class="inline-flex items-center p-2 border border-gray-300 shadow-sm text-sm font-medium rounded-md text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500"
                    title="Export PDF">
                    <svg class="h-5 w-5 text-gray-500" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-4l-4 4m0 0l-4-4m4 4V4" />
                    </svg>
                </a>

                <a href="<?php echo e(route('admin.products.create')); ?>"
                    class="inline-flex items-center p-2 border border-transparent text-sm font-medium rounded-md shadow-sm text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500"
                    title="Add Product">
                    <svg class="h-5 w-5" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                        <path fill-rule="evenodd"
                            d="M10 5a1 1 0 011 1v3h3a1 1 0 110 2h-3v3a1 1 0 11-2 0v-3H6a1 1 0 110-2h3V6a1 1 0 011-1z"
                            clip-rule="evenodd" />
                    </svg>
                </a>
            </div>
        </header>

        <!-- Tool Bar -->
        <div class="bg-white border-b border-gray-200 px-6 py-3 flex items-center justify-between">
            <span
                class="px-3 py-1 bg-blue-100 text-blue-800 rounded-full text-xs font-semibold"><?php echo e($products->total()); ?>

                total products</span>

            <form action="<?php echo e(route('admin.products.import')); ?>" method="POST" enctype="multipart/form-data"
                class="flex items-center space-x-3">
                <?php echo csrf_field(); ?>
                <div class="relative group">
                    <a href="<?php echo e(route('admin.products.sample')); ?>"
                        class="text-green-600 hover:text-green-800 p-1 block">
                        <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M14 2H6c-1.1 0-1.99.9-1.99 2L4 20c0 1.1.89 2 1.99 2H18c1.1 0 2-.9 2-2V8l-6-6zm2 16H8v-2h8v2zm0-4H8v-2h8v2zm-3-5V3.5L18.5 9H13z" />
                        </svg>
                    </a>
                    <div
                        class="absolute bottom-full mb-2 left-1/2 transform -translate-x-1/2 hidden group-hover:block bg-gray-800 text-white text-xs rounded py-1 px-2 whitespace-nowrap">
                        Download Sample Excel
                    </div>
                </div>

                <div class="relative">
                    <input type="file" name="file" onchange="this.form.submit()"
                        class="absolute inset-0 w-full h-full opacity-0 cursor-pointer">
                    <a href="#"
                        class="inline-flex items-center p-2 border border-gray-300 shadow-sm text-sm font-medium rounded-md text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500"
                        title="Bulk Upload">
                        <svg class="h-5 w-5 text-gray-500" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-8l-4-4m0 0L8 8m4-4v12" />
                        </svg>
                    </a>
                </div>
            </form>
        </div>

        <main class="flex-1 overflow-x-hidden overflow-y-auto bg-gray-50 p-6">

            <?php if(session('success')): ?>
                <div class="mb-6 bg-green-50 border-l-4 border-green-500 p-4 rounded-r-lg flex items-center">
                    <svg class="h-5 w-5 text-green-400 mr-3" viewBox="0 0 20 20" fill="currentColor">
                        <path fill-rule="evenodd"
                            d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z"
                            clip-rule="evenodd" />
                    </svg>
                    <p class="text-sm text-green-700"><?php echo e(session('success')); ?></p>
                </div>
            <?php endif; ?>

            <?php if(session('error')): ?>
                <div class="mb-6 bg-red-50 border-l-4 border-red-500 p-4 rounded-r-lg flex items-center">
                    <svg class="h-5 w-5 text-red-400 mr-3" viewBox="0 0 20 20" fill="currentColor">
                        <path fill-rule="evenodd"
                            d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z"
                            clip-rule="evenodd" />
                    </svg>
                    <p class="text-sm text-red-700"><?php echo e(session('error')); ?></p>
                </div>
            <?php endif; ?>

            <?php if($errors->any()): ?>
                <div class="mb-6 bg-red-50 border-l-4 border-red-500 p-4 rounded-r-lg">
                    <div class="flex">
                        <div class="flex-shrink-0">
                            <svg class="h-5 w-5 text-red-400" viewBox="0 0 20 20" fill="currentColor">
                                <path fill-rule="evenodd"
                                    d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z"
                                    clip-rule="evenodd" />
                            </svg>
                        </div>
                        <div class="ml-3">
                            <h3 class="text-sm font-medium text-red-800">There were <?php echo e($errors->count()); ?> errors with your
                                submission</h3>
                            <div class="mt-2 text-sm text-red-700">
                                <ul class="list-disc pl-5 space-y-1">
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <div class="bg-white rounded-xl shadow-sm overflow-hidden">
                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-3 py-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider cursor-pointer hover:bg-gray-100 transition-colors group select-none"
                                    onclick="window.location.href='<?php echo e(route('admin.products.index', array_merge(request()->query(), ['sort' => 'name', 'direction' => request('direction') == 'asc' ? 'desc' : 'asc']))); ?>'">
                                    <div class="flex items-center space-x-1">
                                        <span>Product</span>
                                        <?php if(request('sort') == 'name'): ?>
                                            <?php if(request('direction') == 'asc'): ?>
                                                <!-- Ascending -->
                                                <svg class="h-4 w-4 text-blue-500" xmlns="http://www.w3.org/2000/svg"
                                                    viewBox="0 0 20 20" fill="currentColor">
                                                    <path fill-rule="evenodd"
                                                        d="M14.707 12.707a1 1 0 01-1.414 0L10 9.414l-3.293 3.293a1 1 0 01-1.414-1.414l4-4a1 1 0 011.414 0l4 4a1 1 0 010 1.414z"
                                                        clip-rule="evenodd" />
                                                </svg>
                                            <?php else: ?>
                                                <!-- Descending -->
                                                <svg class="h-4 w-4 text-blue-500" xmlns="http://www.w3.org/2000/svg"
                                                    viewBox="0 0 20 20" fill="currentColor">
                                                    <path fill-rule="evenodd"
                                                        d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z"
                                                        clip-rule="evenodd" />
                                                </svg>
                                            <?php endif; ?>
                                        <?php else: ?>
                                            <!-- Default / Not Sorted -->
                                            <svg class="h-4 w-4 text-gray-400 opacity-0 group-hover:opacity-100 transition-opacity"
                                                xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                                                <path fill-rule="evenodd"
                                                    d="M5 10a1 1 0 011-1h8a1 1 0 110 2H6a1 1 0 01-1-1z"
                                                    clip-rule="evenodd" />
                                            </svg>
                                            <!-- Alternatively use up/down arrows -->
                                            <svg class="h-4 w-4 text-gray-300" xmlns="http://www.w3.org/2000/svg"
                                                fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M7 16V4m0 0L3 8m4-4l4 4m6 0v12m0 0l4-4m-4 4l-4-4" />
                                            </svg>
                                        <?php endif; ?>
                                    </div>
                                </th>
                                <th class="px-3 py-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider cursor-pointer hover:bg-gray-100 transition-colors group select-none"
                                    onclick="window.location.href='<?php echo e(route('admin.products.index', array_merge(request()->query(), ['sort' => 'category', 'direction' => request('direction') == 'asc' ? 'desc' : 'asc']))); ?>'">
                                    <div class="flex items-center space-x-1">
                                        <span>Category</span>
                                        <?php if(request('sort') == 'category'): ?>
                                            <?php if(request('direction') == 'asc'): ?>
                                                <svg class="h-4 w-4 text-blue-500" xmlns="http://www.w3.org/2000/svg"
                                                    viewBox="0 0 20 20" fill="currentColor">
                                                    <path fill-rule="evenodd"
                                                        d="M14.707 12.707a1 1 0 01-1.414 0L10 9.414l-3.293 3.293a1 1 0 01-1.414-1.414l4-4a1 1 0 011.414 0l4 4a1 1 0 010 1.414z"
                                                        clip-rule="evenodd" />
                                                </svg>
                                            <?php else: ?>
                                                <svg class="h-4 w-4 text-blue-500" xmlns="http://www.w3.org/2000/svg"
                                                    viewBox="0 0 20 20" fill="currentColor">
                                                    <path fill-rule="evenodd"
                                                        d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z"
                                                        clip-rule="evenodd" />
                                                </svg>
                                            <?php endif; ?>
                                        <?php else: ?>
                                            <svg class="h-4 w-4 text-gray-300" xmlns="http://www.w3.org/2000/svg"
                                                fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M7 16V4m0 0L3 8m4-4l4 4m6 0v12m0 0l4-4m-4 4l-4-4" />
                                            </svg>
                                        <?php endif; ?>
                                    </div>
                                </th>
                                <th
                                    class="px-3 py-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    Price (SP)</th>
                                <th
                                    class="px-3 py-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    Reseller Price</th>
                                <th
                                    class="px-3 py-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    Variations</th>
                                <th
                                    class="px-3 py-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    Sold</th>
                                <th
                                    class="px-3 py-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    Status</th>
                                <th
                                    class="px-3 py-2 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    Actions</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-200">
                            <?php $__empty_1 = true; $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr class="hover:bg-gray-50 transition-colors">
                                    <td class="px-3 py-2 whitespace-nowrap">
                                        <div class="flex items-center">
                                            <div class="h-10 w-10 flex-shrink-0">
                                                <?php if($product->images->isNotEmpty()): ?>
                                                    <img class="h-10 w-10 rounded-lg object-cover"
                                                        src="<?php echo e($product->images->first()->image_path); ?>"
                                                        alt="<?php echo e($product->name); ?>">
                                                <?php else: ?>
                                                    <div
                                                        class="h-10 w-10 bg-gray-200 rounded-lg flex items-center justify-center text-gray-500 text-xs">
                                                        No Img</div>
                                                <?php endif; ?>
                                            </div>
                                            <div class="ml-4">
                                                <div class="text-sm font-medium text-gray-900"><?php echo e($product->name); ?></div>
                                                <div class="text-xs text-gray-500">SKU: <?php echo e($product->id); ?></div>
                                            </div>
                                        </div>
                                    </td>
                                    <td class="px-3 py-2 whitespace-nowrap text-sm text-gray-500">
                                        <?php echo e($product->category->name); ?>

                                        <?php if($product->subcategory): ?>
                                            <span class="text-xs text-gray-400">/ <?php echo e($product->subcategory->name); ?></span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="px-3 py-2 whitespace-nowrap text-sm text-gray-900">
                                        ₹<?php echo e(number_format($product->sp, 2)); ?>

                                        <span
                                            class="text-xs text-gray-500 line-through ml-1">₹<?php echo e(number_format($product->mrp, 2)); ?></span>
                                    </td>
                                    <td class="px-3 py-2 whitespace-nowrap text-sm text-blue-600 font-semibold">
                                        ₹<?php echo e(number_format($product->reseller_price ?? $product->sp, 2)); ?>

                                    </td>
                                    <td class="px-3 py-2 whitespace-nowrap text-sm text-gray-500">
                                        <div class="flex items-center space-x-2">
                                            <span
                                                class="bg-gray-100 text-gray-600 px-2 py-0.5 rounded-full text-xs font-medium border border-gray-200">
                                                <?php echo e($product->variations_count); ?>

                                            </span>
                                            <a href="<?php echo e(route('admin.products.edit', $product->id)); ?>#variations"
                                                class="p-1 text-blue-600 hover:bg-blue-50 rounded transition-colors group relative"
                                                title="View Variations">
                                                <svg class="h-4 w-4" xmlns="http://www.w3.org/2000/svg" fill="none"
                                                    viewBox="0 0 24 24" stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
                                                </svg>
                                                <span
                                                    class="absolute bottom-full left-1/2 transform -translate-x-1/2 mb-2 px-2 py-1 text-xs font-medium text-white bg-gray-900 rounded-md opacity-0 group-hover:opacity-100 transition-opacity whitespace-nowrap z-10 pointer-events-none">View
                                                    Variations</span>
                                            </a>
                                        </div>
                                    </td>
                                    <td class="px-3 py-2 whitespace-nowrap text-sm text-gray-500">
                                        <a href="<?php echo e(route('admin.products.sales', $product->id)); ?>"
                                            class="text-blue-600 hover:text-blue-800 font-semibold hover:underline"
                                            title="View Sales History">
                                            <?php echo e($product->total_sold_qty ?? 0); ?>

                                        </a>
                                    </td>
                                    <td class="px-3 py-2 whitespace-nowrap">
                                        <!-- Toggle Button -->
                                        <label class="relative inline-flex items-center cursor-pointer">
                                            <input type="checkbox" onclick="toggleStatus(<?php echo e($product->id); ?>)"
                                                class="sr-only peer" <?php echo e($product->status ? 'checked' : ''); ?>>
                                            <div
                                                class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-blue-300 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-blue-600">
                                            </div>
                                        </label>
                                    </td>
                                    <td class="px-3 py-2 whitespace-nowrap text-right text-sm font-medium">
                                        <div class="flex items-center justify-end space-x-2">
                                            <!-- View on Website -->
                                            <a href="<?php echo e(route('shop.product', $product->slug)); ?>" target="_blank"
                                                class="p-2 text-gray-600 hover:bg-gray-100 rounded-lg transition-colors group relative">
                                                <svg class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
                                                </svg>
                                                <span
                                                    class="absolute bottom-full left-1/2 transform -translate-x-1/2 mb-2 px-2 py-1 text-xs font-medium text-white bg-gray-900 rounded-md opacity-0 group-hover:opacity-100 transition-opacity whitespace-nowrap z-10 pointer-events-none">View
                                                    on Website</span>
                                            </a>
                                            <!-- Sales History -->
                                            <a href="<?php echo e(route('admin.products.sales', $product->id)); ?>"
                                                class="p-2 text-green-600 hover:bg-green-50 rounded-lg transition-colors group relative">
                                                <svg class="h-5 w-5" xmlns="http://www.w3.org/2000/svg" fill="none"
                                                    viewBox="0 0 24 24" stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z" />
                                                </svg>
                                                <span
                                                    class="absolute bottom-full left-1/2 transform -translate-x-1/2 mb-2 px-2 py-1 text-xs font-medium text-white bg-gray-900 rounded-md opacity-0 group-hover:opacity-100 transition-opacity whitespace-nowrap z-10 pointer-events-none">Sales
                                                    History</span>
                                            </a>
                                            <!-- Duplicate Button -->
                                            <button type="button"
                                                @click="$dispatch('open-duplicate-modal', { productId: <?php echo e($product->id); ?> })"
                                                class="p-2 text-indigo-600 hover:bg-indigo-50 rounded-lg transition-colors group relative"
                                                title="Duplicate">
                                                <svg class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M8 7v8a2 2 0 002 2h6M8 7V5a2 2 0 012-2h4.586a1 1 0 01.707.293l4.414 4.414a1 1 0 01.293.707V15a2 2 0 01-2 2h-2M8 7H6a2 2 0 00-2 2v10a2 2 0 002 2h8a2 2 0 002-2v-2" />
                                                </svg>
                                                <span
                                                    class="absolute bottom-full left-1/2 transform -translate-x-1/2 mb-2 px-2 py-1 text-xs font-medium text-white bg-gray-900 rounded-md opacity-0 group-hover:opacity-100 transition-opacity whitespace-nowrap z-10 pointer-events-none">Duplicate</span>
                                            </button>
                                            <!-- Quick Edit Button -->
                                            <button type="button"
                                                @click="$dispatch('open-quick-edit-modal', { productId: <?php echo e($product->id); ?> })"
                                                class="p-2 text-yellow-600 hover:bg-yellow-50 rounded-lg transition-colors group relative"
                                                title="Quick Edit">
                                                <svg class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M13 10V3L4 14h7v7l9-11h-7z" />
                                                </svg>
                                                <span
                                                    class="absolute bottom-full left-1/2 transform -translate-x-1/2 mb-2 px-2 py-1 text-xs font-medium text-white bg-gray-900 rounded-md opacity-0 group-hover:opacity-100 transition-opacity whitespace-nowrap z-10 pointer-events-none">Quick
                                                    Edit</span>
                                            </button>
                                            <!-- Edit Button -->
                                            <a href="<?php echo e(route('admin.products.edit', $product->id)); ?>"
                                                class="p-2 text-blue-600 hover:bg-blue-50 rounded-lg transition-colors group relative">
                                                <svg class="h-5 w-5" xmlns="http://www.w3.org/2000/svg" fill="none"
                                                    viewBox="0 0 24 24" stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z" />
                                                </svg>
                                                <span
                                                    class="absolute bottom-full left-1/2 transform -translate-x-1/2 mb-2 px-2 py-1 text-xs font-medium text-white bg-gray-900 rounded-md opacity-0 group-hover:opacity-100 transition-opacity whitespace-nowrap z-10 pointer-events-none">Edit</span>
                                            </a>
                                            <!-- Delete Button -->
                                            <form action="<?php echo e(route('admin.products.destroy', $product->id)); ?>" method="POST"
                                                class="inline-block"
                                                onsubmit="return confirm('Are you sure you want to delete this product?');">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button type="submit"
                                                    class="p-2 text-red-600 hover:bg-red-50 rounded-lg transition-colors group relative"
                                                    title="Delete Product">
                                                    <svg class="h-5 w-5" xmlns="http://www.w3.org/2000/svg" fill="none"
                                                        viewBox="0 0 24 24" stroke="currentColor">
                                                        <path stroke-linecap="round" stroke-linejoin="round"
                                                            stroke-width="2"
                                                            d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16" />
                                                    </svg>
                                                    <span
                                                        class="absolute bottom-full left-1/2 transform -translate-x-1/2 mb-2 px-2 py-1 text-xs font-medium text-white bg-gray-900 rounded-md opacity-0 group-hover:opacity-100 transition-opacity whitespace-nowrap z-10 pointer-events-none">
                                                        Delete
                                                    </span>
                                                </button>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="5" class="px-6 py-6 text-center text-gray-500">
                                        No products found. <a href="<?php echo e(route('admin.products.create')); ?>"
                                            class="text-blue-600 hover:underline">Add one</a>
                                    </td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="mt-4">
                <?php echo e($products->links()); ?>

            </div>
        </main>

        <!-- Duplicate Product Modal -->
        <div x-data="duplicateModal()" @open-duplicate-modal.window="openModal($event.detail.productId)" x-show="isOpen"
            class="fixed z-50 inset-0 overflow-y-auto" x-cloak>
            <div class="flex items-end justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
                <div x-show="isOpen" x-transition:enter="ease-out duration-300" x-transition:enter-start="opacity-0"
                    x-transition:enter-end="opacity-100" x-transition:leave="ease-in duration-200"
                    x-transition:leave-start="opacity-100" x-transition:leave-end="opacity-0"
                    class="fixed inset-0 transition-opacity" aria-hidden="true">
                    <div class="absolute inset-0 bg-gray-500 opacity-75"></div>
                </div>

                <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>

                <div x-show="isOpen" x-transition:enter="ease-out duration-300"
                    x-transition:enter-start="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
                    x-transition:enter-end="opacity-100 translate-y-0 sm:scale-100"
                    x-transition:leave="ease-in duration-200"
                    x-transition:leave-start="opacity-100 translate-y-0 sm:scale-100"
                    x-transition:leave-end="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
                    class="relative z-50 inline-block align-bottom bg-white rounded-lg text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-lg sm:w-full">

                    <form action="<?php echo e(route('admin.products.duplicate')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="product_id" :value="productId">

                        <div class="bg-white px-4 pt-5 pb-4 sm:p-6 sm:pb-4">
                            <div class="sm:flex sm:items-start">
                                <div
                                    class="mx-auto flex-shrink-0 flex items-center justify-center h-12 w-12 rounded-full bg-indigo-100 sm:mx-0 sm:h-10 sm:w-10">
                                    <svg class="h-6 w-6 text-indigo-600" fill="none" viewBox="0 0 24 24"
                                        stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M8 7v8a2 2 0 002 2h6M8 7V5a2 2 0 012-2h4.586a1 1 0 01.707.293l4.414 4.414a1 1 0 01.293.707V15a2 2 0 01-2 2h-2M8 7H6a2 2 0 00-2 2v10a2 2 0 002 2h8a2 2 0 002-2v-2" />
                                    </svg>
                                </div>
                                <div class="mt-3 text-center sm:mt-0 sm:ml-4 sm:text-left w-full">
                                    <h3 class="text-lg leading-6 font-medium text-gray-900" id="modal-title">
                                        Duplicate Product
                                    </h3>
                                    <div class="mt-2">
                                        <p class="text-sm text-gray-500 mb-4">
                                            Select the destination category for the copy. A new product will be created
                                            in draft mode.
                                        </p>

                                        <div class="mb-4">
                                            <label class="block text-sm font-medium text-gray-700 mb-1">Parent
                                                Category</label>
                                            <select name="d_category_id" x-model="selectedCategory"
                                                @change="fetchSubcategories()" required
                                                class="block w-full border-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm border p-2">
                                                <option value="">Select Category</option>
                                                <template x-for="cat in categories" :key="cat.id">
                                                    <option :value="cat.id" x-text="cat.name"></option>
                                                </template>
                                            </select>
                                        </div>

                                        <div>
                                            <label class="block text-sm font-medium text-gray-700 mb-1">Sub
                                                Category</label>
                                            <select name="d_subcategory_id" x-model="selectedSubCategory"
                                                :disabled="!selectedCategory" required
                                                class="block w-full border-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm border p-2 disabled:bg-gray-100 disabled:text-gray-400">
                                                <option value="">Select Sub Category</option>
                                                <template x-for="sub in subcategories" :key="sub.id">
                                                    <option :value="sub.id" x-text="sub.name"></option>
                                                </template>
                                            </select>
                                            <div x-show="isLoadingSubs" class="text-xs text-blue-500 mt-1">Loading
                                                subcategories...</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="bg-gray-50 px-4 py-3 sm:px-6 sm:flex sm:flex-row-reverse">
                            <button type="submit" :disabled="!selectedSubCategory"
                                class="w-full inline-flex justify-center rounded-md border border-transparent shadow-sm px-4 py-2 bg-indigo-600 text-base font-medium text-white hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 sm:ml-3 sm:w-auto sm:text-sm disabled:opacity-50 disabled:cursor-not-allowed">
                                Duplicate
                            </button>
                            <button type="button" @click="closeModal()"
                                class="mt-3 w-full inline-flex justify-center rounded-md border border-gray-300 shadow-sm px-4 py-2 bg-white text-base font-medium text-gray-700 hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 sm:mt-0 sm:ml-3 sm:w-auto sm:text-sm">
                                Cancel
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <!-- Quick Edit Modal -->
        <div x-data="quickEditModal()" @open-quick-edit-modal.window="openModal($event.detail.productId)"
            x-show="isOpen" class="fixed z-50 inset-0 overflow-y-auto" x-cloak>
            <div class="flex items-end justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
                <div x-show="isOpen" x-transition:enter="ease-out duration-300" x-transition:enter-start="opacity-0"
                    x-transition:enter-end="opacity-100" x-transition:leave="ease-in duration-200"
                    x-transition:leave-start="opacity-100" x-transition:leave-end="opacity-0"
                    class="fixed inset-0 transition-opacity" aria-hidden="true">
                    <div class="absolute inset-0 bg-gray-500 opacity-75"></div>
                </div>

                <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>

                <div x-show="isOpen" x-transition:enter="ease-out duration-300"
                    x-transition:enter-start="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
                    x-transition:enter-end="opacity-100 translate-y-0 sm:scale-100"
                    x-transition:leave="ease-in duration-200"
                    x-transition:leave-start="opacity-100 translate-y-0 sm:scale-100"
                    x-transition:leave-end="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
                    class="relative z-50 inline-block align-bottom bg-white rounded-lg text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-6xl sm:w-full">

                    <div class="bg-white px-4 pt-5 pb-4 sm:p-6 sm:pb-4">
                        <div class="sm:flex sm:items-start">
                            <div class="mt-3 text-center sm:mt-0 sm:ml-4 sm:text-left w-full">
                                <h3 class="text-lg leading-6 font-medium text-gray-900 mb-4" id="modal-title">
                                    Quick Edit Variations
                                </h3>

                                <div x-show="isLoading" class="flex justify-center py-10">
                                    <svg class="animate-spin h-8 w-8 text-blue-600" xmlns="http://www.w3.org/2000/svg"
                                        fill="none" viewBox="0 0 24 24">
                                        <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor"
                                            stroke-width="4"></circle>
                                        <path class="opacity-75" fill="currentColor"
                                            d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z">
                                        </path>
                                    </svg>
                                </div>

                                <form id="quickEditForm" @submit.prevent="submit" x-show="!isLoading"
                                    class="overflow-x-auto">
                                    <table class="min-w-full divide-y divide-gray-200 text-xs">
                                        <thead class="bg-gray-50">
                                            <tr>
                                                <th
                                                    class="px-2 py-2 text-left font-medium text-gray-500 uppercase tracking-wider w-1/6">
                                                    Variation</th>
                                                <th
                                                    class="px-2 py-2 text-left font-medium text-gray-500 uppercase tracking-wider">
                                                    <div class="flex items-center space-x-1">
                                                        <span>MRP</span>
                                                        <input type="checkbox" title="Copy to all"
                                                            @change="copyToAll('mrp')"
                                                            class="ml-1 h-3 w-3 text-blue-600 border-gray-300 rounded focus:ring-blue-500">
                                                    </div>
                                                </th>
                                                <th
                                                    class="px-2 py-2 text-left font-medium text-gray-500 uppercase tracking-wider">
                                                    <div class="flex items-center space-x-1">
                                                        <span>SP</span>
                                                        <input type="checkbox" title="Copy to all"
                                                            @change="copyToAll('sp')"
                                                            class="ml-1 h-3 w-3 text-blue-600 border-gray-300 rounded focus:ring-blue-500">
                                                    </div>
                                                </th>
                                                <th
                                                    class="px-2 py-2 text-left font-medium text-gray-500 uppercase tracking-wider">
                                                    <div class="flex items-center space-x-1">
                                                        <span>Reseller</span>
                                                        <input type="checkbox" title="Copy to all"
                                                            @change="copyToAll('reseller_price')"
                                                            class="ml-1 h-3 w-3 text-blue-600 border-gray-300 rounded focus:ring-blue-500">
                                                    </div>
                                                </th>
                                                <th
                                                    class="px-2 py-2 text-left font-medium text-gray-500 uppercase tracking-wider">
                                                    <div class="flex items-center space-x-1">
                                                        <span>Stock</span>
                                                        <input type="checkbox" title="Copy to all"
                                                            @change="copyToAll('stock')"
                                                            class="ml-1 h-3 w-3 text-blue-600 border-gray-300 rounded focus:ring-blue-500">
                                                    </div>
                                                </th>
                                            </tr>
                                        </thead>
                                        <tbody class="bg-white divide-y divide-gray-200">
                                            <template x-for="(v, index) in variations" :key="v.id">
                                                <tr>
                                                    <td class="px-2 py-1 whitespace-nowrap text-gray-900">
                                                        <span x-text="v.name"></span>
                                                        <input type="hidden" :name="'variations['+index+'][id]'"
                                                            :value="v.id">
                                                    </td>
                                                    <td class="px-2 py-1 whitespace-nowrap">
                                                        <input type="number" step="0.01"
                                                            :name="'variations['+index+'][mrp]'" x-model="v.mrp"
                                                            class="block w-20 p-1 border-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 text-xs">
                                                    </td>
                                                    <td class="px-2 py-1 whitespace-nowrap">
                                                        <input type="number" step="0.01"
                                                            :name="'variations['+index+'][sp]'" x-model="v.sp"
                                                            class="block w-20 p-1 border-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 text-xs">
                                                    </td>
                                                    <td class="px-2 py-1 whitespace-nowrap">
                                                        <input type="number" step="0.01"
                                                            :name="'variations['+index+'][reseller_price]'"
                                                            x-model="v.reseller_price"
                                                            class="block w-20 p-1 border-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 text-xs">
                                                    </td>
                                                    <td class="px-2 py-1 whitespace-nowrap">
                                                        <input type="number" :name="'variations['+index+'][stock]'"
                                                            x-model="v.stock"
                                                            class="block w-16 p-1 border-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 text-xs">
                                                    </td>
                                                </tr>
                                            </template>
                                        </tbody>
                                    </table>

                                    <div class="mt-4 flex justify-end space-x-3">
                                        <button type="button" @click="closeModal()"
                                            class="rounded-md border border-gray-300 bg-white py-2 px-4 text-sm font-medium text-gray-700 shadow-sm hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2">Cancel</button>
                                        <button type="submit"
                                            class="inline-flex justify-center rounded-md border border-transparent bg-blue-600 py-2 px-4 text-sm font-medium text-white shadow-sm hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2">Update
                                            Variations</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        function duplicateModal() {
            return {
                isOpen: false,
                productId: null,
                categories: <?php echo json_encode($categories, 15, 512) ?>,
                subcategories: [],
                selectedCategory: '',
                selectedSubCategory: '',
                isLoadingSubs: false,

                openModal(id) {
                    this.productId = id;
                    this.selectedCategory = '';
                    this.selectedSubCategory = '';
                    this.subcategories = [];
                    this.isOpen = true;
                },

                closeModal() {
                    this.isOpen = false;
                },

                async fetchSubcategories() {
                    if (!this.selectedCategory) {
                        this.subcategories = [];
                        return;
                    }
                    this.isLoadingSubs = true;
                    // Reset subcat
                    this.selectedSubCategory = '';
                    try {
                        const res = await fetch(`/admin/categories/${this.selectedCategory}/subcategories`);
                        this.subcategories = await res.json();
                    } catch (e) {
                        console.error('Error fetching subcategories:', e);
                    }
                    this.isLoadingSubs = false;
                }
            }
        }

        function quickEditModal() {
            return {
                isOpen: false,
                productId: null,
                variations: [],
                isLoading: false,

                openModal(id) {
                    this.productId = id;
                    this.variations = [];
                    this.isOpen = true;
                    this.fetchVariations();
                },

                closeModal() {
                    this.isOpen = false;
                },

                async fetchVariations() {
                    this.isLoading = true;
                    try {
                        const res = await fetch(`/admin/products/${this.productId}/variations`);
                        this.variations = await res.json();
                    } catch (e) {
                        console.error(e);
                        alert('Failed to load variations');
                    }
                    this.isLoading = false;
                },

                copyToAll(field) {
                    if (this.variations.length === 0) return;
                    const val = this.variations[0][field];
                    this.variations.forEach((v, idx) => {
                        if (idx !== 0) v[field] = val;
                    });
                },

                async submit() {
                    const form = document.getElementById('quickEditForm');
                    const data = new FormData(form);

                    try {
                        const res = await fetch(`/admin/products/${this.productId}/quick-update-variations`, {
                            method: 'POST',
                            headers: {
                                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                            },
                            body: data
                        });

                        const text = await res.text();
                        let result;
                        try {
                            result = JSON.parse(text);
                        } catch (e) {
                            console.error("Server response was not JSON:", text);
                            throw new Error("Server error: " + res.status + ". See console for details.");
                        }

                        if (result.success) {
                            alert('Updated successfully');
                            this.closeModal();
                            window.location.reload();
                        } else {
                            alert('Error updating: ' + (result.message || 'Unknown error'));
                        }
                    } catch (e) {
                        console.error(e);
                        alert('Error submitting form: ' + e.message);
                    }
                }
            }
        }

        function categoryFilter() {
            return {
                open: false,
                search: '',
                selected: '<?php echo e(request('category')); ?>',
                categories: <?php echo json_encode($categories->map(function ($cat) {
                    return ['id' => $cat->id, 'name' => $cat->name];
                }), 512) ?>,

                get filteredCategories() {
                    if (this.search === '') {
                        return this.categories;
                    }
                    return this.categories.filter(cat => {
                        return cat.name.toLowerCase().includes(this.search.toLowerCase());
                    });
                },

                get selectedName() {
                    if (!this.selected) return 'All Categories';
                    // items come from DB as integers usually, but request is string. Loose comparison or toString needed.
                    const cat = this.categories.find(c => c.id == this.selected);
                    return cat ? cat.name : 'All Categories';
                },

                select(id) {
                    this.selected = id;
                    this.open = false;
                    // Submit form
                    this.$nextTick(() => {
                        document.getElementById('filterForm').submit();
                    });
                }
            }
        }

        function productAutocomplete() {
            return {
                query: '<?php echo e(request('search')); ?>',
                suggestions: [],
                showSuggestions: false,

                init() {
                    this.$watch('query', (value) => {
                        if (value === '') {
                            this.suggestions = [];
                            document.getElementById('filterForm').submit();
                            return;
                        }

                        if (!value || value.length < 2) {
                            this.suggestions = [];
                            return;
                        }

                        fetch(`<?php echo e(route('admin.products.search-suggestions')); ?>?query=${encodeURIComponent(value)}`)
                            .then(res => res.json())
                            .then(data => {
                                this.suggestions = data;
                            })
                            .catch(err => {
                                console.error('Error fetching suggestions:', err);
                            });
                    });
                },

                selectSuggestion(product) {
                    this.query = product.name;
                    this.showSuggestions = false;
                    // Submit form to filter by this specific product
                    this.$nextTick(() => {
                        document.getElementById('filterForm').submit();
                    });
                }
            }
        }

        async function toggleStatus(productId) {
            try {
                const response = await fetch(`/admin/products/${productId}/toggle-status`, {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                    }
                });

                const data = await response.json();

                if (data.success) {
                    console.log('Status updated successfully');
                } else {
                    console.error('Failed to update status');
                }
            } catch (error) {
                console.error('Error updating status:', error);
            }
        }
    </script>
</body>

</html><?php /**PATH /home/truetransit/public_html/hairniche.in/resources/views/admin/products/index.blade.php ENDPATH**/ ?>