

<?php $__env->startSection('title', 'Shopping Cart'); ?>

<?php $__env->startSection('content'); ?>
    <div class="bg-white">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
            <h1 class="text-3xl font-medium tracking-tight text-gray-800">Shopping Cart</h1>

            <?php if(session('success')): ?>
                <div class="rounded-md bg-green-50 p-4 mt-4">
                    <div class="flex">
                        <div class="flex-shrink-0">
                            <svg class="h-5 w-5 text-green-400" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"
                                fill="currentColor" aria-hidden="true">
                                <path fill-rule="evenodd"
                                    d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z"
                                    clip-rule="evenodd" />
                            </svg>
                        </div>
                        <div class="ml-3">
                            <p class="text-sm font-medium text-green-800"><?php echo e(session('success')); ?></p>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <?php if(session('error')): ?>
                <div class="rounded-md bg-red-50 p-4 mt-4">
                    <div class="flex">
                        <div class="flex-shrink-0">
                            <svg class="h-5 w-5 text-red-400" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"
                                fill="currentColor" aria-hidden="true">
                                <path fill-rule="evenodd"
                                    d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z"
                                    clip-rule="evenodd" />
                            </svg>
                        </div>
                        <div class="ml-3">
                            <p class="text-sm font-medium text-red-800"><?php echo e(session('error')); ?></p>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <div class="mt-12 lg:grid lg:grid-cols-12 lg:gap-x-12 lg:items-start xl:gap-x-16">
                <!-- Cart Items Section -->
                <section aria-labelledby="cart-heading" class="lg:col-span-8">
                    <h2 id="cart-heading" class="sr-only">Items in your shopping cart</h2>

                    <?php if($cart && $cart->items->count() > 0): ?>
                        <ul role="list" class="divide-y divide-gray-200 border-t border-b border-gray-200">
                            <?php $__currentLoopData = $cart->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="flex py-6 sm:py-10">
                                    <div class="flex-shrink-0">
                                        <?php
                                            $img = null;
                                            if ($item->variation && $item->variation->image_path) {
                                                $img = $item->variation->image_path;
                                            } else {
                                                $mainImage = $item->product->images->sortBy('sort_order')->first();
                                                $img = $mainImage ? $mainImage->image_path : null;
                                            }
                                            $imagePath = $img ?? 'https://placehold.co/200x200?text=No+Image';
                                        ?>
                                        <div
                                            class="h-24 w-24 sm:h-32 sm:w-32 rounded-xl border border-gray-100 overflow-hidden bg-gray-50">
                                            <img src="<?php echo e($imagePath); ?>" alt="<?php echo e($item->product->name); ?>"
                                                class="h-full w-full object-center object-cover hover:scale-105 transition-transform duration-500">
                                        </div>
                                    </div>

                                    <div class="ml-4 flex-1 flex flex-col justify-between sm:ml-6">
                                        <div class="relative pr-9 sm:grid sm:grid-cols-2 sm:gap-x-6 sm:pr-0">
                                            <div>
                                                <div class="flex justify-between">
                                                    <h3
                                                        class="text-lg font-medium text-gray-800 hover:text-indigo-600 transition-colors">
                                                        <a href="<?php echo e(route('shop.product', $item->product->slug)); ?>">
                                                            <?php echo e($item->product->name); ?>

                                                        </a>
                                                    </h3>
                                                </div>
                                                <div class="mt-1 flex text-sm">
                                                    <?php if($item->variation): ?>
                                                        <p
                                                            class="text-gray-500 font-medium bg-gray-50 px-2 py-0.5 rounded-md inline-block border border-gray-100">
                                                            <?php $__currentLoopData = $item->variation->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <?php echo e($option->attribute_value); ?>

                                                                <?php if(!$loop->last): ?> / <?php endif; ?>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </p>
                                                    <?php endif; ?>
                                                </div>
                                                <p class="mt-2 text-lg font-semibold text-gray-800 tracking-tight">
                                                    ₹<?php echo e(number_format($item->price, 2)); ?>

                                                </p>
                                            </div>

                                            <div class="mt-4 sm:mt-0 sm:pr-9">
                                                <form action="<?php echo e(route('cart.update', $item->id)); ?>" method="POST"
                                                    class="flex items-center">
                                                    <?php echo csrf_field(); ?>
                                                    <label for="quantity-<?php echo e($item->id); ?>" class="sr-only">Quantity,
                                                        <?php echo e($item->product->name); ?></label>
                                                    <div class="relative rounded-md shadow-sm w-24">
                                                        <select id="quantity-<?php echo e($item->id); ?>" name="quantity"
                                                            onchange="this.form.submit()"
                                                            class="block w-full rounded-lg border-gray-300 py-1.5 pl-3 pr-8 text-base font-medium text-gray-700 bg-white focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm">
                                                            <?php for($i = 1; $i <= 10; $i++): ?>
                                                                <option value="<?php echo e($i); ?>" <?php echo e($item->quantity == $i ? 'selected' : ''); ?>>
                                                                    <?php echo e($i); ?>

                                                                </option>
                                                            <?php endfor; ?>
                                                        </select>
                                                    </div>
                                                </form>

                                                <div class="absolute top-0 right-0 flex sm:bottom-0 sm:top-auto">
                                                    <!-- Move to Wishlist -->
                                                    <form action="<?php echo e(route('cart.move_to_wishlist', $item->id)); ?>" method="POST"
                                                        class="mr-3">
                                                        <?php echo csrf_field(); ?>
                                                        <button type="submit"
                                                            class="group p-2 rounded-full hover:bg-pink-50 transition-colors"
                                                            title="Move to Wishlist">
                                                            <svg class="h-5 w-5 text-gray-400 group-hover:text-pink-500 transition-colors"
                                                                xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                                                stroke="currentColor">
                                                                <path stroke-linecap="round" stroke-linejoin="round"
                                                                    stroke-width="2"
                                                                    d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z" />
                                                            </svg>
                                                        </button>
                                                    </form>

                                                    <!-- Remove -->
                                                    <a href="<?php echo e(route('cart.remove', $item->id)); ?>"
                                                        class="group p-2 rounded-full hover:bg-rose-50 transition-colors"
                                                        title="Remove from Cart">
                                                        <span class="sr-only">Remove</span>
                                                        <svg class="h-5 w-5 text-gray-400 group-hover:text-rose-500 transition-colors"
                                                            xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"
                                                            fill="currentColor">
                                                            <path fill-rule="evenodd"
                                                                d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z"
                                                                clip-rule="evenodd" />
                                                        </svg>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    <?php else: ?>
                        <!-- Empty Cart State -->
                        <div class="text-center py-20 bg-gray-50 rounded-3xl border-2 border-dashed border-gray-200">
                            <div class="mx-auto h-24 w-24 bg-indigo-50 rounded-full flex items-center justify-center mb-6">
                                <svg class="h-12 w-12 text-indigo-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                                        d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z" />
                                </svg>
                            </div>
                            <h3 class="mt-2 text-xl font-semibold text-gray-800">Your cart is empty</h3>
                            <p class="mt-2 text-gray-500 max-w-sm mx-auto mb-8">Before you proceed to checkout, you must add
                                some products to your shopping cart.</p>
                            <a href="<?php echo e(route('shop.index')); ?>"
                                class="inline-flex items-center px-8 py-4 border border-transparent shadow-lg text-sm font-semibold rounded-xl text-white bg-gradient-to-r from-indigo-500 to-purple-600 hover:from-indigo-600 hover:to-purple-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 transition-all transform hover:-translate-y-1">
                                Start Shopping
                                <svg class="ml-2 -mr-1 h-5 w-5" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"
                                    fill="currentColor">
                                    <path fill-rule="evenodd"
                                        d="M10.293 3.293a1 1 0 011.414 0l6 6a1 1 0 010 1.414l-6 6a1 1 0 01-1.414-1.414L14.586 11H3a1 1 0 110-2h11.586l-4.293-4.293a1 1 0 010-1.414z"
                                        clip-rule="evenodd" />
                                </svg>
                            </a>
                        </div>
                    <?php endif; ?>
                </section>

                <!-- Order Summary Section -->
                <?php if($cart && $cart->items->count() > 0): ?>
                    <section aria-labelledby="summary-heading"
                        class="mt-16 bg-white rounded-2xl shadow-xl shadow-gray-200/50 border border-gray-100 px-6 py-8 sm:p-8 lg:mt-0 lg:col-span-4 sticky top-24">
                        <h2 id="summary-heading" class="text-xl font-medium text-gray-800 mb-6 flex items-center">
                            Order Summary
                        </h2>

                        <dl class="space-y-4">
                            <?php
                                $subtotal = $cart->items->sum(function ($item) {
                                    return $item->price * $item->quantity;
                                });
                                $shipping = 0;
                                $total = $subtotal + $shipping;
                            ?>

                            <div class="flex items-center justify-between pb-4 border-b border-gray-100">
                                <dt class="text-sm text-gray-600">Subtotal</dt>
                                <dd class="text-base font-semibold text-gray-800">₹<?php echo e(number_format($subtotal, 2)); ?></dd>
                            </div>



                            <div class="flex items-center justify-between pt-6 border-t border-gray-200">
                                <dt class="text-lg font-semibold text-gray-800">Order Total</dt>
                                <dd class="text-2xl font-bold text-indigo-600">₹<?php echo e(number_format($total, 2)); ?></dd>
                            </div>
                        </dl>

                        <p class="mt-2 text-xs text-gray-500 text-center">Shipping & taxes calculated at checkout</p>

                        <div class="mt-8">
                            <a href="<?php echo e(route('cart.checkout.check')); ?>"
                                class="w-full bg-gray-900 border border-transparent rounded-xl shadow-lg py-4 px-4 text-base font-semibold text-white hover:bg-gray-800 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-offset-gray-50 focus:ring-gray-900 block text-center transition-all transform hover:-translate-y-1">
                                Proceed to Checkout
                            </a>
                        </div>

                        <div class="mt-6 flex justify-center">
                            <a href="<?php echo e(route('shop.index')); ?>"
                                class="group flex items-center text-sm font-medium text-gray-500 hover:text-indigo-600 transition-colors">
                                <svg class="mr-2 h-4 w-4 transform group-hover:-translate-x-1 transition-transform" fill="none"
                                    viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M10 19l-7-7m0 0l7-7m-7 7h18" />
                                </svg>
                                Continue Shopping
                            </a>
                        </div>

                        <!-- Trust Badges -->
                        <div class="mt-8 pt-8 border-t border-gray-100 grid grid-cols-3 gap-4 text-center">
                            <div class="flex flex-col items-center">
                                <svg class="w-6 h-6 text-gray-400 mb-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                                        d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z" />
                                </svg>
                                <span class="text-[10px] font-medium text-gray-500">Secure Payment</span>
                            </div>
                            <div class="flex flex-col items-center">
                                <svg class="w-6 h-6 text-gray-400 mb-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                                        d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4" />
                                </svg>
                                <span class="text-[10px] font-medium text-gray-500">Free Shipping</span>
                            </div>
                            <div class="flex flex-col items-center">
                                <svg class="w-6 h-6 text-gray-400 mb-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                                        d="M16 15v-1a4 4 0 00-4-4H8m0 0l3 3m-3-3l3-3m9 14V5a2 2 0 00-2-2H6a2 2 0 00-2 2v16l4-2 4 2 4-2 4 2z" />
                                </svg>
                                <span class="text-[10px] font-medium text-gray-500">30 Day Returns</span>
                            </div>
                        </div>
                    </section>
                <?php endif; ?>
            </div>

            <?php if(isset($crossSellProducts) && $crossSellProducts->count() > 0): ?>
                <div class="mt-24">
                    <h2 class="text-2xl font-bold tracking-tight text-gray-900 mb-8">You may also like</h2>
                    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-y-10 gap-x-6 xl:gap-x-8">
                        <?php $__currentLoopData = $crossSellProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div
                                class="group relative bg-white border border-gray-100 rounded-2xl p-4 hover:shadow-xl transition-all duration-300">
                                <div
                                    class="aspect-w-1 aspect-h-1 w-full overflow-hidden rounded-xl bg-gray-200 group-hover:opacity-75 relative">
                                    <?php
                                        $imageUrl = $product->images->sortBy('sort_order')->first()?->image_path ?? 'https://placehold.co/300x300?text=No+Image';
                                    ?>
                                    <img src="<?php echo e($imageUrl); ?>" alt="<?php echo e($product->name); ?>"
                                        class="h-full w-full object-cover object-center">

                                    <!-- Quick Add Overlay -->
                                    <div
                                        class="absolute inset-0 flex items-end justify-center opacity-0 group-hover:opacity-100 transition-opacity duration-300 pb-4">
                                        <form action="<?php echo e(route('cart.add')); ?>" method="POST" class="w-10/12">
                                            <?php echo csrf_field(); ?>
                                            <input type="hidden" name="product_id" value="<?php echo e($product->id); ?>">
                                            <input type="hidden" name="quantity" value="1">
                                            <button type="submit"
                                                class="w-full bg-white text-gray-900 font-bold py-2 px-4 rounded-lg shadow-lg hover:bg-gray-50 transition-colors text-sm">
                                                Add to Cart
                                            </button>
                                        </form>
                                    </div>
                                </div>
                                <div class="mt-4 flex justify-between">
                                    <div>
                                        <h3 class="text-sm font-medium text-gray-700">
                                            <a href="<?php echo e(route('shop.product', $product->slug)); ?>">
                                                <span aria-hidden="true" class="absolute inset-0"></span>
                                                <?php echo e($product->name); ?>

                                            </a>
                                        </h3>
                                        <p class="mt-1 text-sm text-gray-500"><?php echo e($product->category->name ?? ''); ?></p>
                                    </div>
                                    <p class="text-sm font-bold text-gray-900">₹<?php echo e(number_format($product->sp, 2)); ?></p>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.shop', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/truetransit/public_html/hairniche.in/resources/views/shop/cart.blade.php ENDPATH**/ ?>