<div class="w-full md:w-1/4 mb-6 md:mb-0">
    <!-- Desktop Profile Summary (Hidden on Mobile) -->
    <div
        class="hidden md:block bg-gray-50/50 p-6 rounded-3xl shadow-lg border border-gray-100 sticky top-24 transition-all duration-300 hover:shadow-xl backdrop-blur-sm mb-6">
        <div class="text-center relative">
            <div
                class="h-24 w-24 rounded-full mx-auto flex items-center justify-center overflow-hidden bg-gradient-to-tr from-emerald-100 to-teal-200 border-4 border-white shadow-md">
                <?php if(Auth::user()->profile_photo_path): ?>
                    <img class="h-full w-full object-cover" src="<?php echo e(Storage::url(Auth::user()->profile_photo_path)); ?>"
                        alt="<?php echo e(Auth::user()->name); ?>" />
                <?php else: ?>
                    <span
                        class="text-3xl font-bold text-emerald-700 uppercase tracking-widest"><?php echo e(substr(Auth::user()->name, 0, 2)); ?></span>
                <?php endif; ?>
            </div>
            <div class="absolute bottom-0 right-1/2 translate-x-10 translate-y-2">
                <div class="bg-green-500 h-4 w-4 rounded-full border-2 border-white" title="Active"></div>
            </div>
            <h3 class="mt-4 text-xl font-bold text-gray-800 tracking-wide"><?php echo e(Auth::user()->name); ?></h3>
            <p class="text-sm text-gray-500 font-medium"><?php echo e(Auth::user()->email); ?></p>
        </div>
    </div>

    <!-- Responsive Navigation -->
    <div
        class="bg-white md:bg-gray-50/50 p-2 md:p-6 rounded-2xl md:rounded-3xl shadow-sm md:shadow-lg border border-gray-100 md:sticky md:top-[calc(24px+160px+24px)] transition-all duration-300 backdrop-blur-sm">
        <nav
            class="flex md:flex-col overflow-x-auto md:overflow-visible space-x-2 md:space-x-0 md:space-y-3 pb-2 md:pb-0 scrollbar-hide">
            <?php
                $menuItems = [
                    ['route' => 'user.dashboard', 'icon' => 'M4 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2V6zM14 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2V6zM4 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2v-2zM14 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2v-2z', 'label' => 'Dashboard', 'color' => 'blue'],
                    ['route' => 'user.profile', 'icon' => 'M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z', 'label' => 'Profile', 'color' => 'purple'],
                    ['route' => 'user.orders', 'icon' => 'M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z', 'label' => 'Orders', 'color' => 'amber'],
                    ['route' => 'user.addresses', 'icon' => 'M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z', 'label' => 'Addresses', 'color' => 'emerald'],
                    ['route' => 'user.gift-cards.index', 'icon' => 'M12 8v13m0-13V6a2 2 0 112 2h-2zm0 0V5.5A2.5 2.5 0 109.5 8H12zm-7 4h14M5 12a2 2 0 110-4h14a2 2 0 110 4M5 12v7a2 2 0 002 2h10a2 2 0 002-2v-7', 'label' => 'Gift Cards', 'color' => 'violet'],
                    ['route' => 'user.wallet', 'icon' => 'M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z', 'label' => 'Wallet', 'color' => 'teal'],
                    ['route' => 'user.wishlist', 'icon' => 'M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z', 'label' => 'Wishlist', 'color' => 'rose'],
                    ['route' => 'user.tickets.index', 'icon' => 'M18.364 5.636l-3.536 3.536m0 5.656l3.536 3.536M9.172 9.172L5.636 5.636m3.536 9.192l-3.536 3.536M21 12a9 9 0 11-18 0 9 9 0 0118 0zm-5 0a4 4 0 11-8 0 4 4 0 018 0z', 'label' => 'Tickets', 'color' => 'cyan'],
                    ['route' => 'user.settings', 'icon' => 'M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z', 'label' => 'Settings', 'color' => 'slate'],
                ];

                $colorMaps = [
                    'blue' => ['bg' => 'from-blue-500 to-indigo-600', 'hover' => 'hover:bg-blue-50 hover:text-blue-600', 'text' => 'text-blue-500', 'shadow' => 'shadow-indigo-200'],
                    'purple' => ['bg' => 'from-purple-500 to-fuchsia-600', 'hover' => 'hover:bg-purple-50 hover:text-purple-600', 'text' => 'text-purple-500', 'shadow' => 'shadow-purple-200'],
                    'amber' => ['bg' => 'from-amber-500 to-orange-600', 'hover' => 'hover:bg-amber-50 hover:text-amber-600', 'text' => 'text-amber-500', 'shadow' => 'shadow-amber-200'],
                    'emerald' => ['bg' => 'from-emerald-500 to-teal-600', 'hover' => 'hover:bg-emerald-50 hover:text-emerald-600', 'text' => 'text-emerald-500', 'shadow' => 'shadow-emerald-200'],
                    'violet' => ['bg' => 'from-violet-500 to-purple-600', 'hover' => 'hover:bg-violet-50 hover:text-violet-600', 'text' => 'text-violet-500', 'shadow' => 'shadow-violet-200'],
                    'teal' => ['bg' => 'from-teal-500 to-green-600', 'hover' => 'hover:bg-green-50 hover:text-green-600', 'text' => 'text-green-500', 'shadow' => 'shadow-green-200'],
                    'rose' => ['bg' => 'from-rose-500 to-pink-600', 'hover' => 'hover:bg-pink-50 hover:text-pink-600', 'text' => 'text-pink-500', 'shadow' => 'shadow-pink-200'],
                    'cyan' => ['bg' => 'from-cyan-500 to-blue-500', 'hover' => 'hover:bg-cyan-50 hover:text-cyan-600', 'text' => 'text-cyan-500', 'shadow' => 'shadow-cyan-200'],
                    'slate' => ['bg' => 'from-slate-600 to-gray-700', 'hover' => 'hover:bg-gray-100 hover:text-gray-800', 'text' => 'text-gray-600', 'shadow' => 'shadow-gray-300'],
                ];
            ?>

            <?php $__currentLoopData = $menuItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $isActive = request()->routeIs($item['route']);
                    $colors = $colorMaps[$item['color']];
                ?>
                <a href="<?php echo e(route($item['route'])); ?>"
                    class="group flex flex-col md:flex-row items-center justify-center md:justify-start flex-shrink-0 min-w-[70px] md:min-w-0 px-3 md:px-4 py-3 text-[10px] md:text-sm font-semibold rounded-xl md:rounded-2xl transition-all duration-200 <?php echo e($isActive ? 'bg-gradient-to-r ' . $colors['bg'] . ' text-white shadow-lg ' . $colors['shadow'] : 'text-gray-600 ' . $colors['hover']); ?>">
                    <svg class="h-5 w-5 mb-1 md:mb-0 md:mr-3 <?php echo e($isActive ? 'text-white' : 'text-gray-400 group-hover:' . $colors['text'] . ' transition-colors'); ?>"
                        fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="<?php echo e($item['icon']); ?>" />
                    </svg>
                    <span class="md:block"><?php echo e($item['label']); ?></span>
                </a>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            <!-- Mobile Logout Button -->
            <form action="<?php echo e(route('logout')); ?>" method="POST" class="inline-block md:hidden flex-shrink-0">
                <?php echo csrf_field(); ?>
                <button type="submit"
                    class="group flex flex-col items-center justify-center min-w-[70px] px-3 py-3 text-[10px] font-semibold text-rose-600 hover:bg-rose-50 rounded-xl transition-all duration-200">
                    <svg class="h-5 w-5 mb-1 text-rose-500 group-hover:text-rose-700 transition-colors" fill="none"
                        viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1" />
                    </svg>
                    <span>Logout</span>
                </button>
            </form>

            <!-- Desktop Logout (Hidden on Mobile) -->
            <form action="<?php echo e(route('logout')); ?>" method="POST"
                class="hidden md:block mt-4 border-t border-gray-100 pt-4 px-2">
                <?php echo csrf_field(); ?>
                <button type="submit"
                    class="group w-full flex items-center px-4 py-3 text-sm font-semibold text-rose-600 hover:bg-rose-50 rounded-2xl transition-all duration-200 hover:shadow-md">
                    <svg class="h-5 w-5 mr-3 text-rose-500 group-hover:text-rose-700 transition-colors" fill="none"
                        viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1" />
                    </svg>
                    Sign Out
                </button>
            </form>
        </nav>
    </div>
</div>

<style>
    .scrollbar-hide::-webkit-scrollbar {
        display: none;
    }

    .scrollbar-hide {
        -ms-overflow-style: none;
        scrollbar-width: none;
    }
</style><?php /**PATH /home/truetransit/public_html/hairniche.in/resources/views/user/partials/sidebar.blade.php ENDPATH**/ ?>