<?php if(isset($customOffers) && $customOffers->count() > 0): ?>
    <?php $__currentLoopData = $customOffers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $offer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        
        <div id="custom-offer-<?php echo e($offer->id); ?>" class="custom-offer-container mt-20 mb-10 <?php echo e($offer->bg_color && $offer->bg_color != '#ffffff' ? 'py-10' : ''); ?> <?php echo e($offer->target_element ? 'hidden' : ''); ?>" 
             style="background-color: <?php echo e($offer->bg_color ?? 'transparent'); ?>;">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="text-center mb-12">
                    <h2 class="tracking-tight font-serif mb-4"
                        style="color: <?php echo e($offer->heading_color ?? '#111827'); ?>; 
                               font-size: <?php echo e($offer->heading_font_size ?? '2.25rem'); ?>; 
                               font-weight: <?php echo e($offer->heading_font_weight ?? '700'); ?>;">
                        <?php echo e($offer->name); ?>

                    </h2>
                    <div class="w-24 h-1 bg-[#9B2D69] mx-auto"></div>
                </div>
                <?php if($offer->layout): ?>
                    <div class="grid gap-6 <?php echo e($offer->layout->columns == 1 ? 'grid-cols-1' : 
                        ($offer->layout->columns == 2 ? 'grid-cols-1 md:grid-cols-2' : 'grid-cols-1 md:grid-cols-3')); ?>">
                        <?php $__currentLoopData = $offer->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <a href="<?php echo e($item->redirect_url ?? '#'); ?>" class="block group relative overflow-hidden transition-all duration-300 hover:shadow-lg"
                               style="border-radius: <?php echo e($offer->border_radius ?? '0'); ?>; 
                                      box-shadow: <?php echo e($offer->box_shadow ?? 'none'); ?>;">
                                <div class="aspect-auto w-full bg-gray-100">
                                    <img src="<?php echo e(Storage::url($item->banner_image)); ?>" 
                                         alt="<?php echo e($item->alt_tag ?? 'Offer Banner'); ?>" 
                                         class="w-full h-full object-cover transform group-hover:scale-105 transition-transform duration-700 ease-in-out">
                                </div>
                            </a>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        
        <?php if (isset($component)) { $__componentOriginal5f271d6fa6ba399714bf07683518e8e7 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal5f271d6fa6ba399714bf07683518e8e7 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.custom-offer-script','data' => ['offer' => $offer]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('custom-offer-script'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['offer' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($offer)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal5f271d6fa6ba399714bf07683518e8e7)): ?>
<?php $attributes = $__attributesOriginal5f271d6fa6ba399714bf07683518e8e7; ?>
<?php unset($__attributesOriginal5f271d6fa6ba399714bf07683518e8e7); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal5f271d6fa6ba399714bf07683518e8e7)): ?>
<?php $component = $__componentOriginal5f271d6fa6ba399714bf07683518e8e7; ?>
<?php unset($__componentOriginal5f271d6fa6ba399714bf07683518e8e7); ?>
<?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php endif; ?>
<?php /**PATH /home/truetransit/public_html/hairniche.in/resources/views/components/custom-offers-container.blade.php ENDPATH**/ ?>