

<?php $__env->startSection('title', 'Checkout'); ?>

<?php $__env->startSection('content'); ?>
    <div class="bg-gray-50" x-data="checkoutData()" x-cloak>
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
            <h1 class="text-3xl font-bold tracking-tight text-gray-900 mb-8">Checkout</h1>

            <?php if(session('error')): ?>
                <div class="rounded-md bg-red-50 p-4 mb-6">
                    <div class="flex">
                        <div class="flex-shrink-0">
                            <!-- Heroicon name: solid/x-circle -->
                            <svg class="h-5 w-5 text-red-400" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"
                                fill="currentColor" aria-hidden="true">
                                <path fill-rule="evenodd"
                                    d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z"
                                    clip-rule="evenodd" />
                            </svg>
                        </div>
                        <div class="ml-3">
                            <h3 class="text-sm font-medium text-red-800">Error</h3>
                            <div class="mt-2 text-sm text-red-700">
                                <p><?php echo e(session('error')); ?></p>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <?php if(session('success')): ?>
                <div class="rounded-md bg-green-50 p-4 mb-6">
                    <div class="flex">
                        <div class="flex-shrink-0">
                            <!-- Heroicon name: solid/check-circle -->
                            <svg class="h-5 w-5 text-green-400" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"
                                fill="currentColor" aria-hidden="true">
                                <path fill-rule="evenodd"
                                    d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z"
                                    clip-rule="evenodd" />
                            </svg>
                        </div>
                        <div class="ml-3">
                            <h3 class="text-sm font-medium text-green-800">Success</h3>
                            <div class="mt-2 text-sm text-green-700">
                                <p><?php echo e(session('success')); ?></p>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <?php if($errors->any()): ?>
                <div class="rounded-md bg-red-50 p-4 mb-6">
                    <div class="flex">
                        <div class="flex-shrink-0">
                            <svg class="h-5 w-5 text-red-400" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"
                                fill="currentColor" aria-hidden="true">
                                <path fill-rule="evenodd"
                                    d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z"
                                    clip-rule="evenodd" />
                            </svg>
                        </div>
                        <div class="ml-3">
                            <h3 class="text-sm font-medium text-red-800">There were errors with your submission</h3>
                            <div class="mt-2 text-sm text-red-700">
                                <ul class="list-disc pl-5 space-y-1">
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <div class="lg:grid lg:grid-cols-12 lg:gap-x-12 lg:items-start xl:gap-x-16">
                <!-- Left Column: Information -->
                <section class="lg:col-span-7">
                    <form action="<?php echo e(route('checkout.process')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="coupon_code" :value="activeCoupon">
                        <input type="hidden" name="gift_card_code" :value="activeGiftCard">
                        <input type="hidden" name="redeem_points" :value="redeemPoints ? 1 : 0">

                        <!-- Contact Information -->
                        <div class="bg-white shadow-sm border border-gray-100 rounded-2xl p-6 sm:p-8 mb-6">
                            <div class="mb-6">
                                <h3 class="text-xl font-bold text-gray-900">Contact Information</h3>
                                <p class="mt-1 text-sm text-gray-500">We'll use this to communicate about your order.</p>
                            </div>

                            <div class="grid grid-cols-1 gap-y-6 gap-x-4 sm:grid-cols-6">
                                <div class="col-span-6 sm:col-span-3">
                                    <label for="name" class="block text-sm font-semibold text-gray-800 mb-1.5">Full
                                        Name</label>
                                    <input type="text" name="name" id="name" value="<?php echo e(old('name', $user->name ?? '')); ?>"
                                        class="block w-full rounded-lg border-gray-200 bg-gray-50 px-4 py-3 text-gray-900 focus:border-indigo-500 focus:bg-white focus:ring-2 focus:ring-indigo-500/20 shadow-sm transition-colors sm:text-sm placeholder-gray-400"
                                        <?php echo e($user ? 'readonly' : ''); ?> placeholder="John Doe">
                                    <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <p class="mt-2 text-sm text-red-600"><?php echo e($message); ?></p>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="col-span-6 sm:col-span-3">
                                    <label for="phone" class="block text-sm font-semibold text-gray-800 mb-1.5">Phone
                                        Number</label>
                                    <input type="text" name="phone" id="phone"
                                        value="<?php echo e(old('phone', $user->whatsapp_number ?? '')); ?>"
                                        class="block w-full rounded-lg border-gray-200 bg-gray-50 px-4 py-3 text-gray-900 focus:border-indigo-500 focus:bg-white focus:ring-2 focus:ring-indigo-500/20 shadow-sm transition-colors sm:text-sm placeholder-gray-400"
                                        placeholder="+91 9876543210">
                                    <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <p class="mt-2 text-sm text-red-600"><?php echo e($message); ?></p>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="col-span-6">
                                    <label for="email" class="block text-sm font-semibold text-gray-800 mb-1.5">Email
                                        Address</label>
                                    <input type="email" name="email" id="email"
                                        value="<?php echo e(old('email', $user->email ?? '')); ?>"
                                        class="block w-full rounded-lg border-gray-200 bg-gray-50 px-4 py-3 text-gray-900 focus:border-indigo-500 focus:bg-white focus:ring-2 focus:ring-indigo-500/20 shadow-sm transition-colors sm:text-sm placeholder-gray-400"
                                        <?php echo e($user ? 'readonly' : ''); ?> placeholder="you@example.com">
                                    <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <p class="mt-2 text-sm text-red-600"><?php echo e($message); ?></p>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>

                        <!-- Shipping Address -->
                        <div class="bg-white shadow-sm border border-gray-100 rounded-2xl p-6 sm:p-8 mb-6">
                            <div class="mb-6">
                                <h3 class="text-xl font-bold text-gray-900">Shipping Address</h3>
                                <p class="mt-1 text-sm text-gray-500">Where should we deliver your order?</p>
                            </div>

                            <?php if($addresses->count() > 0): ?>
                                <div class="space-y-3 mb-8">
                                    <label class="block text-sm font-semibold text-gray-800 mb-3">Saved Addresses</label>
                                    <div class="grid grid-cols-1 gap-4">
                                        <?php $__currentLoopData = $addresses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $address): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="relative flex items-start p-4 border rounded-xl hover:bg-gray-50 transition-colors cursor-pointer"
                                                :class="selectedAddress == '<?php echo e($address->id); ?>' ? 'border-indigo-500 ring-1 ring-indigo-500 bg-indigo-50/10' : 'border-gray-200'">
                                                <div class="flex h-5 items-center">
                                                    <input id="address-<?php echo e($address->id); ?>" name="address_id" type="radio"
                                                        value="<?php echo e($address->id); ?>"
                                                        class="h-4 w-4 text-indigo-600 border-gray-300 focus:ring-indigo-500"
                                                        x-model="selectedAddress">
                                                </div>
                                                <label for="address-<?php echo e($address->id); ?>"
                                                    class="ml-3 block text-sm cursor-pointer w-full">
                                                    <span
                                                        class="block font-bold text-gray-900"><?php echo e($address->name ?? $user->name); ?></span>
                                                    <span class="block text-gray-500 mt-1"><?php echo e($address->address_line1); ?>,
                                                        <?php echo e($address->city); ?>, <?php echo e($address->state); ?> -
                                                        <?php echo e($address->postal_code); ?></span>
                                                    <span
                                                        class="block text-gray-500 text-xs mt-1 uppercase tracking-wider font-semibold"><?php echo e($address->country); ?></span>
                                                </label>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                        <!-- New Address Option -->
                                        <div class="relative flex items-start p-4 border rounded-xl hover:bg-gray-50 transition-colors cursor-pointer"
                                            :class="selectedAddress == 'new' ? 'border-indigo-500 ring-1 ring-indigo-500 bg-indigo-50/10' : 'border-gray-200'">
                                            <div class="flex h-5 items-center">
                                                <input id="address-new" name="address_id" type="radio" value="new"
                                                    class="h-4 w-4 text-indigo-600 border-gray-300 focus:ring-indigo-500"
                                                    x-model="selectedAddress">
                                            </div>
                                            <label for="address-new"
                                                class="ml-3 block text-sm font-medium text-gray-900 cursor-pointer w-full flex items-center">
                                                <svg class="h-5 w-5 text-gray-400 mr-2" fill="none" viewBox="0 0 24 24"
                                                    stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M12 4v16m8-8H4" />
                                                </svg>
                                                Add a new address
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            <?php else: ?>
                                <input type="hidden" name="address_id" value="new">
                            <?php endif; ?>

                            <!-- New Address Form -->
                            <div x-show="selectedAddress === 'new'" x-collapse class="border-t border-gray-100 pt-6 mt-6">
                                <h4 class="text-sm font-bold text-gray-900 uppercase tracking-wide mb-4">New Address Details
                                </h4>
                                <div class="grid grid-cols-1 gap-y-6 gap-x-4 sm:grid-cols-6">
                                    <div class="col-span-6">
                                        <label for="address_line1"
                                            class="block text-sm font-semibold text-gray-800 mb-1.5">Street Address</label>
                                        <input type="text" name="address_line1" id="address_line1"
                                            value="<?php echo e(old('address_line1')); ?>"
                                            class="block w-full rounded-lg border-gray-200 bg-gray-50 px-4 py-3 text-gray-900 focus:border-indigo-500 focus:bg-white focus:ring-2 focus:ring-indigo-500/20 shadow-sm transition-colors sm:text-sm placeholder-gray-400"
                                            placeholder="House number and street name">
                                        <?php $__errorArgs = ['address_line1'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <p class="mt-2 text-sm text-red-600"><?php echo e($message); ?></p>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <div class="col-span-6 sm:col-span-3">
                                        <label for="city"
                                            class="block text-sm font-semibold text-gray-800 mb-1.5">City</label>
                                        <input type="text" name="city" id="city" value="<?php echo e(old('city')); ?>"
                                            x-model="newAddressCity"
                                            class="block w-full rounded-lg border-gray-200 bg-gray-50 px-4 py-3 text-gray-900 focus:border-indigo-500 focus:bg-white focus:ring-2 focus:ring-indigo-500/20 shadow-sm transition-colors sm:text-sm placeholder-gray-400">
                                        <?php $__errorArgs = ['city'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <p class="mt-2 text-sm text-red-600"><?php echo e($message); ?></p>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <div class="col-span-6 sm:col-span-3">
                                        <label for="state" class="block text-sm font-semibold text-gray-800 mb-1.5">State /
                                            Province</label>
                                        <input type="text" name="state" id="state" value="<?php echo e(old('state')); ?>"
                                            class="block w-full rounded-lg border-gray-200 bg-gray-50 px-4 py-3 text-gray-900 focus:border-indigo-500 focus:bg-white focus:ring-2 focus:ring-indigo-500/20 shadow-sm transition-colors sm:text-sm placeholder-gray-400">
                                        <?php $__errorArgs = ['state'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <p class="mt-2 text-sm text-red-600"><?php echo e($message); ?></p>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <div class="col-span-6 sm:col-span-3">
                                        <label for="postal_code"
                                            class="block text-sm font-semibold text-gray-800 mb-1.5">ZIP / Postal
                                            Code</label>
                                        <input type="text" name="postal_code" id="postal_code"
                                            value="<?php echo e(old('postal_code')); ?>"
                                            class="block w-full rounded-lg border-gray-200 bg-gray-50 px-4 py-3 text-gray-900 focus:border-indigo-500 focus:bg-white focus:ring-2 focus:ring-indigo-500/20 shadow-sm transition-colors sm:text-sm placeholder-gray-400">
                                        <?php $__errorArgs = ['postal_code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <p class="mt-2 text-sm text-red-600"><?php echo e($message); ?></p>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <div class="col-span-6 sm:col-span-3">
                                        <label for="country"
                                            class="block text-sm font-semibold text-gray-800 mb-1.5">Country</label>
                                        <select id="country" name="country" x-model="newAddressCountry"
                                            class="block w-full rounded-lg border-gray-200 bg-gray-50 px-4 py-3 text-gray-900 focus:border-indigo-500 focus:bg-white focus:ring-2 focus:ring-indigo-500/20 shadow-sm transition-colors sm:text-sm">
                                            <option value="India">India</option>
                                            <option value="United States">United States</option>
                                            <option value="Canada">Canada</option>
                                            <option value="United Kingdom">United Kingdom</option>
                                            <option value="Australia">Australia</option>
                                            <option value="Germany">Germany</option>
                                            <option value="France">France</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Buttons -->
                        <div class="flex justify-end pt-6">
                            <button type="submit"
                                class="w-full sm:w-auto bg-gray-900 border border-transparent rounded-xl shadow-lg py-4 px-8 text-base font-bold text-white hover:bg-gray-800 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-gray-900 transition-all transform hover:-translate-y-0.5">
                                Continue to Payment
                            </button>
                        </div>
                    </form>
                </section>

                <!-- Right Column: Order Summary -->
                <section class="mt-16 lg:mt-0 lg:col-span-5 bg-gray-50">
                    <div class="bg-white shadow sm:rounded-lg">
                        <div class="px-4 py-5 sm:p-6">
                            <h2 class="text-lg font-medium text-gray-900 mb-4">Order Summary</h2>

                            <!-- Coupon Code -->
                            <div class="mb-6">
                                <label for="coupon_code" class="block text-sm font-medium text-gray-700">Discount
                                    Code</label>
                                <div class="mt-1 flex rounded-md shadow-sm">
                                    <input type="text" name="coupon_code" id="coupon_code" x-model="couponCode"
                                        class="focus:ring-indigo-500 focus:border-indigo-500 flex-1 block w-full rounded-none rounded-l-md sm:text-sm border-gray-300"
                                        placeholder="Enter coupon code">
                                    <button type="button" @click="applyCoupon"
                                        class="-ml-px relative inline-flex items-center space-x-2 px-4 py-2 border border-gray-300 text-sm font-medium rounded-r-md text-gray-700 bg-gray-50 hover:bg-gray-100 focus:outline-none focus:ring-1 focus:ring-indigo-500 focus:border-indigo-500">
                                        Apply
                                    </button>
                                </div>
                                <p x-show="couponMessage" x-text="couponMessage"
                                    :class="couponSuccess ? 'text-green-600' : 'text-red-600'" class="mt-2 text-sm"></p>
                            </div>

                            <?php if(isset($coupons) && $coupons->isNotEmpty()): ?>
                                <div class="mb-6 border-t border-gray-200 pt-4">
                                    <h3 class="text-sm font-medium text-gray-900 mb-3">Available Coupons</h3>
                                    <div class="space-y-3 max-h-60 overflow-y-auto pr-1">
                                        <?php $__currentLoopData = $coupons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $coupon): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div
                                                class="border border-gray-200 rounded-md p-3 relative hover:border-indigo-300 transition-colors bg-white">
                                                <div class="flex justify-between items-start">
                                                    <div>
                                                        <p class="font-bold text-indigo-600 text-sm"><?php echo e($coupon->code); ?></p>
                                                        <p class="text-xs text-gray-600 mt-1">
                                                            <?php if($coupon->type === 'percentage'): ?>
                                                                <?php echo e($coupon->value); ?>% Off
                                                            <?php else: ?>
                                                                ₹<?php echo e(number_format($coupon->value, 0)); ?> Off
                                                            <?php endif; ?>
                                                            <?php if($coupon->min_spend > 0): ?>
                                                                (Min. Order: ₹<?php echo e(number_format($coupon->min_spend, 0)); ?>)
                                                            <?php endif; ?>
                                                        </p>
                                                        <?php if($coupon->valid_until): ?>
                                                            <p class="text-[10px] text-gray-400 mt-0.5">Expires:
                                                                <?php echo e($coupon->valid_until->format('d M Y')); ?>

                                                            </p>
                                                        <?php endif; ?>
                                                    </div>
                                                    <button type="button"
                                                        @click="couponCode = '<?php echo e($coupon->code); ?>'; applyCoupon();"
                                                        class="text-xs bg-indigo-50 text-indigo-700 px-2 py-1 rounded hover:bg-indigo-100 font-medium">
                                                        Apply
                                                    </button>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            <?php endif; ?>
                            <?php if($settings->gift_card_enabled): ?>
                                <div class="mb-6 border-t border-gray-200 pt-6">
                                    <h3 class="text-sm font-medium text-gray-900 mb-4">Gift Card</h3>

                                    <!-- Input -->
                                    <div class="mb-4">
                                        <div class="mt-1 flex rounded-md shadow-sm">
                                            <input type="text" x-model="giftCardCodeInput"
                                                class="focus:ring-indigo-500 focus:border-indigo-500 flex-1 block w-full rounded-none rounded-l-md sm:text-sm border-gray-300"
                                                placeholder="Enter gift card code">
                                            <button type="button" @click="applyGiftCard"
                                                class="-ml-px relative inline-flex items-center space-x-2 px-4 py-2 border border-gray-300 text-sm font-medium rounded-r-md text-gray-700 bg-gray-50 hover:bg-gray-100 focus:outline-none focus:ring-1 focus:ring-indigo-500 focus:border-indigo-500">
                                                Apply
                                            </button>
                                        </div>
                                        <p x-show="giftCardMessage" x-text="giftCardMessage"
                                            :class="giftCardSuccess ? 'text-green-600' : 'text-red-600'" class="mt-2 text-sm">
                                        </p>
                                    </div>

                                    <!-- My Gift Cards List -->
                                    <?php
                                        // Fetch Gift Cards where user is recipient
                                        $myGiftCards = \App\Models\GiftCard::active()
                                            ->where('recipient_email', $user->email)
                                            ->get();
                                    ?>

                                    <?php if($myGiftCards->count() > 0): ?>
                                        <div class="mt-4">
                                            <p class="text-xs text-gray-500 mb-2 font-medium uppercase tracking-wide">Your Available
                                                Cards:</p>
                                            <div class="space-y-2">
                                                <?php $__currentLoopData = $myGiftCards; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $card): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="flex justify-between items-center border border-gray-200 rounded p-2 bg-white hover:bg-gray-50 cursor-pointer"
                                                        @click="giftCardCodeInput = '<?php echo e($card->code); ?>'; applyGiftCard()">
                                                        <div>
                                                            <span class="font-bold text-gray-800 text-sm"><?php echo e($card->code); ?></span>
                                                            <span class="text-xs text-gray-500 block">Value: ₹<?php echo e($card->amount); ?></span>
                                                        </div>
                                                        <span class="text-xs text-indigo-600 font-medium">Use</span>
                                                    </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                        </div>
                                    <?php endif; ?>

                                    <input type="hidden" name="gift_card_code" :value="activeGiftCard">
                                </div>
                            <?php endif; ?>


                            <!-- Wallet Redemption -->
                            <?php if($settings->wallet_enabled && isset($walletBalance)): ?>
                                <div class="mb-6 border-t border-gray-200 pt-6">
                                    <div class="flex items-center justify-between">
                                        <div>
                                            <h3 class="text-sm font-medium text-gray-900">Wallet Balance</h3>
                                            <p class="text-sm text-gray-500"><?php echo e($walletBalance); ?> Points (Value:
                                                ₹<?php echo e(number_format($walletBalance / ($settings->wallet_exchange_rate > 0 ? $settings->wallet_exchange_rate : 100), 2)); ?>)
                                            </p>
                                        </div>
                                    </div>

                                    <?php if($walletBalance >= $settings->wallet_min_points_redeem): ?>
                                        <div class="mt-4 flex items-center">
                                            <input id="redeem_points" name="redeem_points" type="checkbox" value="1"
                                                x-model="redeemPoints"
                                                class="h-4 w-4 text-indigo-600 focus:ring-indigo-500 border-gray-300 rounded">
                                            <label for="redeem_points" class="ml-2 block text-sm text-gray-900">
                                                Redeem Points for discount
                                            </label>
                                        </div>
                                    <?php else: ?>
                                        <p class="mt-2 text-xs text-red-500">Minimum <?php echo e($settings->wallet_min_points_redeem); ?>

                                            points required to redeem.</p>
                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>

                            <div class="mt-6 flow-root">
                                <ul class="-my-6 divide-y divide-gray-200">
                                    <?php $__currentLoopData = $cart->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="flex py-6">
                                            <div
                                                class="h-20 w-20 flex-shrink-0 overflow-hidden rounded-md border border-gray-200">
                                                <?php
                                                    $img = null;
                                                    if ($item->variation && $item->variation->image_path) {
                                                        $img = $item->variation->image_path;
                                                    } else {
                                                        $mainImage = $item->product->images->sortBy('sort_order')->first();
                                                        $img = $mainImage ? $mainImage->image_path : null;
                                                    }
                                                    $imagePath = $img ? $img : 'https://placehold.co/200x200?text=No+Image';
                                                ?>
                                                <img src="<?php echo e($imagePath); ?>" alt="<?php echo e($item->product->name); ?>"
                                                    class="h-full w-full object-cover object-center">
                                            </div>

                                            <div class="ml-4 flex flex-1 flex-col">
                                                <div>
                                                    <div class="flex justify-between text-base font-medium text-gray-900">
                                                        <h3>
                                                            <a
                                                                href="<?php echo e(route('shop.product', $item->product->slug)); ?>"><?php echo e($item->product->name); ?></a>
                                                        </h3>
                                                        <p class="ml-4">₹<?php echo e(number_format($item->price * $item->quantity, 2)); ?>

                                                        </p>
                                                    </div>
                                                    <p class="mt-1 text-sm text-gray-500">
                                                        <?php if($item->variation): ?>
                                                            <?php $__currentLoopData = $item->variation->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <?php echo e($option->attribute_value); ?>

                                                                <?php if(!$loop->last): ?> / <?php endif; ?>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        <?php endif; ?>
                                                    </p>
                                                </div>
                                                <div class="flex flex-1 items-end justify-between text-sm">
                                                    <p class="text-gray-500">Qty <?php echo e($item->quantity); ?></p>
                                                </div>
                                            </div>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>

                            <dl class="mt-10 space-y-6 text-sm font-medium text-gray-500 border-t border-gray-200 pt-6">
                                <?php
                                    $subtotal = $cart->items->sum(function ($item) {
                                        return $item->price * $item->quantity;
                                    });
                                ?>
                                <div class="flex justify-between">
                                    <dt>Subtotal</dt>
                                    <dd class="text-gray-900">₹<?php echo e(number_format($subtotal, 2)); ?></dd>
                                </div>

                                <div class="flex justify-between">
                                    <dt>Shipping</dt>
                                    <dd class="text-gray-900">
                                        <span x-show="shippingCost > 0">₹<span
                                                x-text="shippingCost.toFixed(2)"></span></span>
                                        <span x-show="shippingCost == 0" class="text-green-600 font-bold">Free</span>
                                    </dd>
                                </div>
                                <div x-show="freeShippingEnabled && shippingCost > 0"
                                    class="text-xs text-blue-600 text-right mt-1">
                                    Add ₹<span x-text="(freeShippingThreshold - subtotal).toFixed(2)"></span> more for Free
                                    Shipping!
                                </div>
                                <div x-show="freeShippingEnabled && shippingCost == 0"
                                    class="text-xs text-green-600 text-right mt-1 font-medium">
                                    You are eligible for Free Shipping!
                                </div>

                                <div class="flex justify-between" x-show="discountAmount > 0">
                                    <dt class="flex text-green-600">
                                        Discount
                                        <span
                                            class="ml-2 rounded-full bg-green-200 text-xs text-green-800 py-0.5 px-2 self-center"
                                            x-text="activeCoupon"></span>
                                    </dt>
                                    <dd class="text-green-600">-₹<span x-text="discountAmount.toFixed(2)"></span></dd>
                                </div>

                                <div class="flex justify-between" x-show="giftCardDiscount > 0">
                                    <dt class="flex text-green-600">
                                        Gift Card
                                        <span
                                            class="ml-2 rounded-full bg-green-200 text-xs text-green-800 py-0.5 px-2 self-center"
                                            x-text="activeGiftCard"></span>
                                    </dt>
                                    <dd class="text-green-600">-₹<span x-text="giftCardDiscount.toFixed(2)"></span></dd>
                                </div>
                                <div class="flex justify-between" x-show="walletDiscount > 0">
                                    <dt class="flex">
                                        Points Redeemed
                                    </dt>
                                    <dd>-₹<span x-text="walletDiscount.toFixed(2)"></span></dd>
                                </div>

                                <div class="flex justify-between border-t border-gray-200 pt-6 text-base text-gray-900">
                                    <dt>Total</dt>
                                    <dd class="text-base">₹<span x-text="calculateTotal(<?php echo e($subtotal); ?>).toFixed(2)"></span>
                                    </dd>
                                </div>
                            </dl>
                        </div>
                    </div>
                </section>
            </div>
        </div>
    </div>

    <?php $__env->startPush('scripts'); ?>
        <script>
            function checkoutData() {
                return {
                    addresses: <?php echo json_encode($addresses, 15, 512) ?>,
                    selectedAddress: '<?php echo e(old('address_id', $addresses->firstWhere('is_default', 1)->id ?? ($addresses->first()->id ?? 'new'))); ?>',
                    newAddressCountry: '<?php echo e(old('country', 'India')); ?>',
                    newAddressCity: '<?php echo e(old('city')); ?>',
                    shippingCost: 0,
                    couponCode: '',
                    activeCoupon: '',
                    discountAmount: 0,
                    couponMessage: '',
                    couponSuccess: false,
                    subtotal: <?php echo e($subtotal); ?>,
                    nationalCost: <?php echo e($settings->shipping_national_amount ?? 0); ?>,
                    internationalCost: <?php echo e($settings->shipping_international_amount ?? 0); ?>,
                    localCost: <?php echo e($settings->shipping_local_amount ?? 0); ?>,
                    storeCity: '<?php echo e($currentStore ? $currentStore->city : ""); ?>',
                    storeCountry: '<?php echo e($currentStore ? $currentStore->country : ""); ?>',
                    freeShippingEnabled: <?php echo e($settings->free_shipping_enabled ? 'true' : 'false'); ?>,
                    freeShippingThreshold: <?php echo e($settings->min_order_amount_for_free_shipping ?? 0); ?>,

                    // Wallet Data
                    walletEnabled: <?php echo e($settings->wallet_enabled ? 'true' : 'false'); ?>,
                    walletBalance: <?php echo e($walletBalance ?? 0); ?>,
                    minRedeemPoints: <?php echo e($settings->wallet_min_points_redeem ?? 0); ?>,
                    exchangeRate: <?php echo e($settings->wallet_exchange_rate ?? 100); ?>,
                    redeemPoints: false,
                    walletDiscount: 0,

                    // Gift Card Data
                    giftCardCodeInput: '',
                    activeGiftCard: '',
                    giftCardDiscount: 0,
                    giftCardMessage: '',
                    giftCardSuccess: false,
                    giftCardRemainder: 0,
                    giftCardValue: 0,

                    init() {
                        // Watch for address selection changes
                        this.$watch('selectedAddress', (value) => {
                            this.handleAddressChange(value);
                        });

                        // Watch for country changes in the new address form
                        this.$watch('newAddressCountry', (value) => {
                            if (this.selectedAddress === 'new') {
                                this.updateShipping(this.newAddressCity, value);
                            }
                        });

                        this.$watch('newAddressCity', (value) => {
                            if (this.selectedAddress === 'new') {
                                this.updateShipping(value, this.newAddressCountry);
                            }
                        });


                        // Initial Calculation - Force update next tick to ensure data is ready
                        this.$nextTick(() => {
                            this.handleAddressChange(this.selectedAddress);
                        });
                    },

                    handleAddressChange(addressId) {
                        if (addressId === 'new') {
                            this.updateShipping(this.newAddressCity, this.newAddressCountry);
                        } else {
                            // Find the address in the injected array
                            // Note: addressId might be string from radio value, id in DB is int
                            const addr = this.addresses.find(a => a.id == addressId);
                            if (addr) {
                                this.updateShipping(addr.city, addr.country);
                            } else {
                                // Fallback if address not found (shouldn't happen with correct data)
                                console.warn('Address not found for ID:', addressId);
                            }
                        }
                    },

                    updateShipping(city, country) {
                        // Simple normalization
                        let normalizedCountry = country ? country.trim().toLowerCase() : 'india';
                        let normalizedCity = city ? city.trim().toLowerCase() : '';

                        let storeCtry = this.storeCountry ? this.storeCountry.trim().toLowerCase() : '';
                        let storeCty = this.storeCity ? this.storeCity.trim().toLowerCase() : '';


                        // Check for free shipping logic
                        if (this.freeShippingEnabled && this.freeShippingThreshold > 0) {
                            if (this.subtotal >= this.freeShippingThreshold) {
                                this.shippingCost = 0;
                                this.recalcGiftCardDiscount(); // Call recalc after shipping cost is set
                                return;
                            }
                        }

                        let cost = 0;

                        // If no store is selected/configured, fallback to simple country check
                        if (!storeCtry) {
                            if (normalizedCountry === 'india') {
                                cost = parseFloat(this.nationalCost);
                            } else {
                                cost = parseFloat(this.internationalCost);
                            }
                        } else {
                            if (normalizedCountry !== storeCtry) {
                                cost = parseFloat(this.internationalCost);
                            } else if (normalizedCity !== storeCty) {
                                cost = parseFloat(this.nationalCost);
                            } else {
                                cost = parseFloat(this.localCost);
                            }
                        }

                        this.shippingCost = cost;
                        this.recalcGiftCardDiscount();
                    },

                    recalcGiftCardDiscount() {
                        if (this.activeGiftCard && this.giftCardValue > 0) {
                            let payable = this.subtotal + this.shippingCost - this.discountAmount;
                            if (payable < 0) payable = 0;
                            this.giftCardDiscount = Math.min(payable, this.giftCardValue);
                        } else {
                            if (!this.activeGiftCard) {
                                this.giftCardDiscount = 0;
                            }
                        }
                    },

                    applyCoupon() {
                        this.couponMessage = '';
                        this.couponSuccess = false;

                        if (!this.couponCode) {
                            this.couponMessage = 'Please enter a coupon code.';
                            return;
                        }

                        fetch('<?php echo e(route('cart.coupon.validate')); ?>', {
                            method: 'POST',
                            headers: {
                                'Content-Type': 'application/json',
                                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                                'Accept': 'application/json'
                            },
                            body: JSON.stringify({
                                coupon_code: this.couponCode,
                                subtotal: this.subtotal
                            })
                        })
                            .then(response => response.json())
                            .then(data => {
                                if (data.valid) {
                                    this.couponSuccess = true;
                                    this.couponMessage = data.message;
                                    this.activeCoupon = data.code;
                                    this.discountAmount = parseFloat(data.discount_amount);
                                } else {
                                    this.couponMessage = data.message;
                                    this.activeCoupon = '';
                                    this.discountAmount = 0;
                                }
                            })
                            .catch(error => {
                                console.error('Error:', error);
                                this.couponMessage = 'An error occurred while validating the coupon.';
                                this.activeCoupon = '';
                                this.discountAmount = 0;
                            });
                    },

                    calculateTotal(subtotal) {
                        let totalBeforeWallet = subtotal + this.shippingCost - this.discountAmount - this.giftCardDiscount;
                        if (totalBeforeWallet < 0) totalBeforeWallet = 0;

                        this.walletDiscount = 0;
                        if (this.walletEnabled && this.redeemPoints && this.walletBalance >= this.minRedeemPoints) {
                            let maxWalletValue = this.walletBalance / this.exchangeRate;
                            // Discount cannot exceed total
                            this.walletDiscount = Math.min(maxWalletValue, totalBeforeWallet);
                            // Round to 2 decimals
                            this.walletDiscount = Math.round(this.walletDiscount * 100) / 100;
                        }

                        let finalTotal = totalBeforeWallet - this.walletDiscount;
                        return finalTotal > 0 ? finalTotal : 0;
                    },

                    applyGiftCard() {
                        this.giftCardMessage = '';
                        this.giftCardSuccess = false;

                        if (!this.giftCardCodeInput) {
                            this.giftCardMessage = 'Please enter a gift card code.';
                            return;
                        }

                        if (this.activeCoupon) {
                            this.giftCardMessage = 'Gift card cannot be used with coupon.';
                            return;
                        }

                        fetch('<?php echo e(route('cart.gift-card.validate')); ?>', {
                            method: 'POST',
                            headers: {
                                'Content-Type': 'application/json',
                                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                                'Accept': 'application/json'
                            },
                            body: JSON.stringify({
                                gift_card_code: this.giftCardCodeInput,
                                subtotal: this.subtotal,
                                has_coupon: this.activeCoupon ? true : false
                            })
                        })
                            .then(response => response.json())
                            .then(data => {
                                if (data.valid) {
                                    this.giftCardSuccess = true;
                                    this.giftCardMessage = data.message;

                                    this.activeGiftCard = data.code;
                                    this.giftCardValue = parseFloat(data.amount);

                                    this.recalcGiftCardDiscount();

                                    // Calculate remainder locally based on current Total (including shipping)
                                    let used = this.giftCardDiscount;
                                    let rem = this.giftCardValue - used;
                                    if (rem < 0) rem = 0;
                                    this.giftCardRemainder = rem;

                                    if (this.giftCardRemainder > 0) {
                                        this.giftCardMessage += ' (Remainder ₹' + this.giftCardRemainder.toFixed(2) + ' will be credited to wallet)';
                                    }
                                } else {
                                    this.giftCardMessage = data.message;
                                    this.activeGiftCard = '';
                                    this.giftCardValue = 0;
                                    this.giftCardDiscount = 0;
                                    this.giftCardRemainder = 0;
                                }
                            })
                            .catch(error => {
                                console.error('Error:', error);
                                this.giftCardMessage = 'Error validating gift card.';
                                this.activeGiftCard = '';
                                this.giftCardDiscount = 0;
                            });
                    }
                }
            }
        </script>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.shop', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/truetransit/public_html/hairniche.in/resources/views/shop/checkout.blade.php ENDPATH**/ ?>