

<?php $__env->startSection('title', $product->meta_title ?? $product->name); ?>

<?php $__env->startSection('meta_description', $product->meta_description ?? \Illuminate\Support\Str::limit(strip_tags($product->short_description), 160)); ?>

<?php $__env->startSection('meta_keywords', $product->meta_keywords ?? ''); ?>

<?php $__env->startPush('schema_markup'); ?>
    <?php if($product->schema_markup): ?>
        <?php echo $product->schema_markup; ?>

    <?php endif; ?>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Drift Zoom CSS/JS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/drift-zoom@1.5.1/dist/drift-basic.min.css">
    <script src="https://cdn.jsdelivr.net/npm/drift-zoom@1.5.1/dist/Drift.min.js"></script>
    <style>
        /* Drift Custom Styles */
        .drift-zoom-pane {
            background-color: white;
            border: 1px solid #e5e7eb;
            box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
            z-index: 100;
            border-radius: 0.5rem;
            /* Ensure the pane is visible */
        }

        /* Hide zoom on mobile if desired, or rely on JS condition */
    </style>

    <div class="bg-white">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
            <!-- Breadcrumb -->
            <nav class="flex mb-8 text-sm text-gray-500">
                <a href="<?php echo e(route('home')); ?>" class="hover:text-gray-900 transition-colors">Home</a>
                <span class="mx-2">/</span>
                <a href="<?php echo e(route('shop.index')); ?>" class="hover:text-gray-900 transition-colors">Shop</a>
                <span class="mx-2">/</span>
                <a href="<?php echo e(route('shop.category', $product->category->slug)); ?>"
                    class="hover:text-gray-900 transition-colors"><?php echo e($product->category->name); ?></a>
                <span class="mx-2">/</span>
                <span class="text-gray-900 font-medium"><?php echo e($product->name); ?></span>
            </nav>

            <div class="lg:grid lg:grid-cols-2 lg:gap-x-12 xl:gap-x-16" x-data="productData()">
                <!-- Product Images -->
                <div class="product-images relative z-20">
                    <div class="aspect-w-1 aspect-h-1 w-full overflow-hidden rounded-lg bg-gray-100 mb-4 cursor-crosshair">
                        <img id="main-image" :src="currentImage" :data-zoom="currentImage" alt="<?php echo e($product->name); ?>"
                            class="h-full w-full object-cover object-center">
                    </div>

                    <!-- Drift Zoom Pane Container (Absolute to the right) -->
                    <div id="drift-pane-container"
                        class="hidden lg:block absolute top-0 left-full ml-4 w-full h-full pointer-events-none"
                        style="z-index: 50;"></div>

                    <!-- Thumbnails -->
                    <?php if($product->images->count() > 1): ?>
                        <div class="grid grid-cols-4 gap-4 mt-4">
                            <?php $__currentLoopData = $product->images->sortBy('sort_order'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $thumbPath = $image->image_path;
                                ?>
                                <button @click="currentImage = '<?php echo e($thumbPath); ?>'"
                                    class="aspect-w-1 aspect-h-1 w-full overflow-hidden rounded-md bg-gray-100 hover:opacity-75 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-[#9B2D69]"
                                    :class="{ 'ring-2 ring-[#9B2D69]': currentImage === '<?php echo e($thumbPath); ?>' }">
                                    <img src="<?php echo e($thumbPath); ?>" alt="<?php echo e($product->name); ?>"
                                        class="h-full w-full object-cover object-center">
                                </button>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    <?php endif; ?>
                </div>

                <!-- Product Info -->
                <div class="mt-10 px-4 sm:mt-16 sm:px-0 lg:mt-0 relative z-10">
                    <h1 class="text-3xl font-bold tracking-tight text-gray-900"><?php echo e($product->name); ?></h1>

                    <!-- Ratings Summary -->
                    <?php
                        $avgRating = $product->publishedReviews->avg('rating');
                        $reviewCount = $product->publishedReviews->count();
                    ?>
                    <div class="mt-3 flex items-center">
                        <div class="flex items-center">
                            <?php for($i = 1; $i <= 5; $i++): ?>
                                <svg class="h-5 w-5 flex-shrink-0 <?php echo e($avgRating >= $i ? 'text-yellow-400' : ($avgRating >= $i - 0.5 ? 'text-yellow-400' : 'text-gray-300')); ?>"
                                    xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor"
                                    aria-hidden="true">
                                    <path
                                        d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z" />
                                </svg>
                            <?php endfor; ?>
                        </div>
                        <p class="sr-only"><?php echo e(number_format($avgRating, 1)); ?> out of 5 stars</p>
                        <a href="#reviews"
                            @click.prevent="openSection = 4; setTimeout(() => document.getElementById('reviews').scrollIntoView({ behavior: 'smooth' }), 100)"
                            class="ml-3 text-sm font-medium text-[#9B2D69] hover:text-[#7a2454]"><?php echo e($reviewCount); ?>

                            reviews</a>
                    </div>

                    <!-- ... rest of content ... -->

                    <script>
                        document.addEventListener('DOMContentLoaded', function () {
                            // Initialize Drift only on larger screens
                            if (window.innerWidth >= 1024) {
                                var drift = new Drift(document.querySelector('#main-image'), {
                                    paneContainer: document.querySelector('#drift-pane-container'),
                                    inlinePane: false,
                                    containInline: true,
                                    hoverBoundingBox: true,
                                    // Adjust zoomFactor if needed
                                    zoomFactor: 2
                                });
                            }
                        });
                    </script>

                    <div class="mt-3">
                        <h2 class="sr-only">Product information</h2>
                        <p class="text-3xl tracking-tight text-gray-900">
                            <span x-text="'₹' + currentPrice"></span>
                            <span x-show="currentMrp > currentPrice" class="ml-2 text-lg text-gray-500 line-through"
                                x-text="'₹' + currentMrp"></span>
                            <span x-show="currentMrp > currentPrice" class="ml-2 text-sm text-green-600 font-medium"
                                x-text="calculateDiscount() + '% OFF'"></span>
                        </p>
                        <div class="mt-2 flex items-center text-sm text-gray-500">
                            <svg class="h-4 w-4 mr-1.5 text-gray-400" xmlns="http://www.w3.org/2000/svg" fill="none"
                                viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4" />
                            </svg>
                            <span>Number of Units: <?php echo e($product->number_of_units ?? 1); ?> <?php echo e($product->unit_type); ?></span>
                        </div>
                    </div>

                    <div class="mt-6">
                        <h3 class="sr-only">Description</h3>
                        <div class="text-base text-gray-700 space-y-6">
                            <?php echo $product->short_description; ?>

                        </div>
                    </div>

                    <form class="mt-6" action="<?php echo e(route('cart.add')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="product_id" value="<?php echo e($product->id); ?>">
                        <input type="hidden" name="quantity" value="1"> <!-- Default 1 for now, or add quantity selector -->
                        <input type="hidden" name="variation_id" :value="selectedVariationId">

                        <!-- Variations -->
                        <?php if($product->variations->count() > 0): ?>
                            <div class="mt-4">
                                <h3 class="text-base font-bold text-gray-900 uppercase tracking-wide mb-1">Select Option</h3>
                                <div class="mt-2">
                                    <!-- Custom Premium Dropdown -->
                                    <div class="relative" x-data="{ open: false }" @click.away="open = false">
                                        <button type="button" @click="open = !open" 
                                            class="relative w-full cursor-pointer rounded-lg border-2 border-gray-300 bg-white py-3 pl-4 pr-10 text-left text-gray-900 shadow-sm focus:border-[#9B2D69] focus:outline-none focus:ring-2 focus:ring-[#9B2D69] sm:text-sm transition-all duration-200">
                                            <span class="block truncate font-bold text-gray-900">
                                                <span x-text="getSelectedVariationName()"></span>
                                            </span>
                                            <span class="pointer-events-none absolute inset-y-0 right-0 flex items-center pr-2">
                                                <svg class="h-5 w-5 text-gray-400" viewBox="0 0 20 20" fill="currentColor">
                                                    <path fill-rule="evenodd" d="M10 3a.75.75 0 01.55.24l3.25 3.5a.75.75 0 11-1.1 1.02L10 4.852 7.3 7.76a.75.75 0 01-1.1-1.02l3.25-3.5A.75.75 0 0110 3zm-3.71 9.29a.75.75 0 011.02 0L10 15.148l2.69-2.858a.75.75 0 111.1 1.02l-3.25 3.5a.75.75 0 01-1.1 0l-3.25-3.5a.75.75 0 010-1.02z" clip-rule="evenodd" />
                                                </svg>
                                            </span>
                                        </button>

                                        <ul x-show="open" x-cloak
                                            x-transition:enter="transition ease-out duration-100"
                                            x-transition:enter-start="opacity-0 scale-95"
                                            x-transition:enter-end="opacity-100 scale-100"
                                            class="absolute z-50 mt-1 max-h-60 w-full overflow-auto rounded-lg bg-white py-1 text-base shadow-xl ring-1 ring-black ring-opacity-5 focus:outline-none sm:text-sm">
                                            <?php $__currentLoopData = $product->variations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $variation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li @click="selectVariation(<?php echo e($variation->id); ?>); open = false"
                                                    class="relative cursor-pointer select-none py-3 px-4 text-gray-900 hover:bg-gray-50 transition-colors border-b border-gray-200 last:border-0"
                                                    :class="{ 'bg-pink-50': selectedVariationId === <?php echo e($variation->id); ?> }">
                                                    <div class="flex items-center justify-between">
                                                        <span class="block truncate" :class="{ 'font-bold': selectedVariationId === <?php echo e($variation->id); ?> }">
                                                            <?php $__currentLoopData = $variation->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <?php echo e($option->attribute_value); ?>

                                                                <?php if(!$loop->last): ?> / <?php endif; ?>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </span>
                                                        <div class="flex items-center gap-3">
                                                            <span class="font-bold text-[#9B2D69]">
                                                                ₹<?php echo e(number_format($variation->sp, 0)); ?>

                                                            </span>
                                                            <?php if($variation->stock <= 0): ?>
                                                                <span class="text-[10px] bg-red-100 text-red-600 px-2 py-0.5 rounded-full font-bold uppercase">Sold Out</span>
                                                            <?php endif; ?>
                                                        </div>
                                                    </div>
                                                </li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </ul>
                                    </div>
                                </div>
                                <!-- Stock Status Indicator -->
                                <p class="mt-2 text-sm"
                                    :class="{'text-green-600': isStockAvailable, 'text-red-600': !isStockAvailable}">
                                    <span
                                        x-text="isStockAvailable ? (currentStock <= <?php echo e($settings->min_stock_threshold ?? 5); ?> ? 'Only ' + currentStock + ' left!' : 'In Stock') : 'Out of Stock'"></span>
                                </p>
                            </div>
                        <?php endif; ?>

                        <div class="mt-10 flex">
                            <button type="submit"
                                class="flex max-w-xs flex-1 items-center justify-center rounded-md border border-transparent bg-[#9B2D69] px-8 py-3 text-base font-medium text-white hover:bg-[#7a2454] focus:outline-none focus:ring-2 focus:ring-[#9B2D69] focus:ring-offset-2 sm:w-full"
                                :disabled="!isStockAvailable"
                                :class="{ 'opacity-50 cursor-not-allowed': !isStockAvailable }">
                                <span x-text="isStockAvailable ? 'Add to cart' : 'Out of Stock'"></span>
                            </button>

                            <button type="button" @click="toggleWishlist()"
                                class="ml-4 h-12 w-12 flex items-center justify-center rounded-xl border border-gray-200 bg-white text-gray-400 hover:text-rose-600 hover:bg-rose-50 hover:border-rose-200 shadow-sm transition-all duration-200 focus:outline-none focus:ring-2 focus:ring-rose-500 focus:ring-offset-2">
                                <svg class="h-6 w-6 flex-shrink-0" xmlns="http://www.w3.org/2000/svg" fill="none"
                                    viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" aria-hidden="true">
                                    <path stroke-linecap="round" stroke-linejoin="round"
                                        d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z" />
                                </svg>
                                <span class="sr-only">Add to favorites</span>
                            </button>
                        </div>

                        <!-- Trust Badges -->
                        <div class="mt-8 grid grid-cols-3 gap-4 py-6 border-y border-gray-100">
                            <div class="flex flex-col items-center text-center">
                                <div class="flex items-center justify-center h-10 w-10 rounded-full bg-pink-50 mb-2">
                                    <svg class="h-6 w-6 text-[#9B2D69]" xmlns="http://www.w3.org/2000/svg" fill="none"
                                        viewBox="0 0 24 24" stroke="currentColor">
                                        <path d="M9 17a2 2 0 11-4 0 2 2 0 014 0zM19 17a2 2 0 11-4 0 2 2 0 014 0z" />
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M13 16V6a1 1 0 00-1-1H4a1 1 0 00-1 1v10a1 1 0 001 1h1m8-1a1 1 0 01-1 1H9m4-1V8a1 1 0 011-1h2.586a1 1 0 01.707.293l3.414 3.414a1 1 0 01.293.707V16a1 1 0 01-1 1h-1m-6-1a1 1 0 001 1h1M5 17a2 2 0 104 0m-4 0a2 2 0 114 0m6 0a2 2 0 104 0m-4 0a2 2 0 114 0" />
                                    </svg>
                                </div>
                                <span class="text-xs font-semibold text-gray-900">Fast Shipping</span>
                            </div>

                            <div class="flex flex-col items-center text-center">
                                <div class="flex items-center justify-center h-10 w-10 rounded-full bg-green-50 mb-2">
                                    <svg class="h-6 w-6 text-green-600" xmlns="http://www.w3.org/2000/svg" fill="none"
                                        viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M12 16v1m3.12-14.5a9.715 9.715 0 011.533.82l.384-.384a.75.75 0 011.06 1.06l-.384.384a9.733 9.733 0 01.819 1.533l.446-.148a.75.75 0 11.464 1.428l-.446.148c.192.62.316 1.272.366 1.942l.462.033a.75.75 0 11-.108 1.496l-.462-.033a9.737 9.737 0 01-.366 1.942l.446.148a.75.75 0 11-.464 1.428l-.446-.148a9.715 9.715 0 01-.819 1.533l.384.384a.75.75 0 11-1.06 1.06l-.384-.384a9.733 9.733 0 01-1.533.819l.148.446a.75.75 0 11-1.428.464l-.148-.446c-.62.192-1.272.316-1.942.366l-.033.462a.75.75 0 11-1.496-.108l.033-.462a9.737 9.737 0 01-1.942-.366l-.148.446a.75.75 0 11-1.428-.464l.148-.446a9.715 9.715 0 01-1.533-.819l-.384.384a.75.75 0 11-1.06-1.06l.384-.384a9.733 9.733 0 01-.819-1.533l-.446.148a.75.75 0 11-.464-1.428l.446-.148a9.737 9.737 0 01-.366-1.942l-.462-.033a.75.75 0 11.108-1.496l.462.033c.05-.67.174-1.321.366-1.942l-.446-.148a.75.75 0 11.464-1.428l.446.148a9.715 9.715 0 01.819-1.533l-.384-.384a.75.75 0 011.06-1.06l.384.384a9.733 9.733 0 011.533-.819l-.148-.446a.75.75 0 011.428-.464l.148.446c.62-.192 1.272-.316 1.942-.366l.033-.462a.75.75 0 011.496.108l-.033.462c.67-.05 1.321-.174 1.942-.366l.148.446a.75.75 0 011.428-.464l-.148-.446z" />
                                    </svg>
                                </div>
                                <span class="text-xs font-semibold text-gray-900">Best Price</span>
                            </div>

                            <div class="flex flex-col items-center text-center">
                                <div class="flex items-center justify-center h-10 w-10 rounded-full bg-blue-50 mb-2">
                                    <svg class="h-6 w-6 text-blue-600" xmlns="http://www.w3.org/2000/svg" fill="none"
                                        viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z" />
                                    </svg>
                                </div>
                                <span class="text-xs font-semibold text-gray-900">Secure Payment</span>
                            </div>
                        </div>
                    </form>

                    <section aria-labelledby="details-heading" class="mt-12">
                        <h2 id="details-heading" class="sr-only">Additional details</h2>
                        <div class="border-t divide-y divide-gray-200">
                            <?php if($product->long_description): ?>
                                <div>
                                    <h3>
                                        <button type="button"
                                            class="group relative flex w-full items-center justify-between py-6 text-left"
                                            @click="openSection = (openSection === 1 ? 0 : 1)">
                                            <span class="text-sm font-medium text-gray-900">Description</span>
                                            <span class="ml-6 flex items-center">
                                                <svg class="h-6 w-6 transform text-gray-400 group-hover:text-gray-500 transition-transform duration-200"
                                                    :class="{ '-rotate-180': openSection === 1 }" fill="none"
                                                    viewBox="0 0 24 24" stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M19 9l-7 7-7-7" />
                                                </svg>
                                            </span>
                                        </button>
                                    </h3>
                                    <div class="prose prose-sm pb-6" x-show="openSection === 1" x-cloak>
                                        <?php echo $product->long_description; ?>

                                    </div>
                                </div>
                            <?php endif; ?>

                            <!-- Additional Info Sections could go here (Shipping, Warranty etc) -->
                            <?php if($product->warranty_details): ?>
                                <div>
                                    <h3>
                                        <button type="button"
                                            class="group relative flex w-full items-center justify-between py-6 text-left"
                                            @click="openSection = (openSection === 2 ? 0 : 2)">
                                            <span class="text-sm font-medium text-gray-900">Warranty Information</span>
                                            <span class="ml-6 flex items-center">
                                                <svg class="h-6 w-6 transform text-gray-400 group-hover:text-gray-500 transition-transform duration-200"
                                                    :class="{ '-rotate-180': openSection === 2 }" fill="none"
                                                    viewBox="0 0 24 24" stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M19 9l-7 7-7-7" />
                                                </svg>
                                            </span>
                                        </button>
                                    </h3>
                                    <div class="prose prose-sm pb-6" x-show="openSection === 2" x-cloak>
                                        <?php echo $product->warranty_details; ?>

                                    </div>
                                </div>
                            <?php endif; ?>

                            <!-- Return Policy -->
                            <div>
                                <h3>
                                    <button type="button"
                                        class="group relative flex w-full items-center justify-between py-6 text-left"
                                        @click="openSection = (openSection === 3 ? 0 : 3)">
                                        <span class="text-sm font-medium text-gray-900">Return Policy</span>
                                        <span class="ml-6 flex items-center">
                                            <svg class="h-6 w-6 transform text-gray-400 group-hover:text-gray-500 transition-transform duration-200"
                                                :class="{ '-rotate-180': openSection === 3 }" fill="none"
                                                viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M19 9l-7 7-7-7" />
                                            </svg>
                                        </span>
                                    </button>
                                </h3>
                                <div class="prose prose-sm pb-6" x-show="openSection === 3" x-cloak>
                                    <?php if($product->is_returnable): ?>
                                        <p class="font-medium text-gray-900 mb-2">
                                            Returnable within
                                            <?php echo e($product->return_window_days ?? $settings->return_window_days ?? 7); ?> days of
                                            delivery.
                                        </p>
                                        <?php if($product->return_policy_desc): ?>
                                            <p><?php echo nl2br(e($product->return_policy_desc)); ?></p>
                                        <?php else: ?>
                                            <p>This product is eligible for returns under our general return policy conditions.</p>
                                        <?php endif; ?>
                                    <?php else: ?>
                                        <p class="text-red-600 font-medium">This product is not eligible for returns.</p>
                                    <?php endif; ?>
                                </div>
                            </div>

                            <!-- Customer Reviews -->
                            <div>
                                <h3>
                                    <button type="button"
                                        class="group relative flex w-full items-center justify-between py-6 text-left"
                                        @click="openSection = (openSection === 4 ? 0 : 4)">
                                        <span class="text-sm font-medium text-gray-900">Customer Reviews
                                            (<?php echo e($reviewCount); ?>)</span>
                                        <span class="ml-6 flex items-center">
                                            <svg class="h-6 w-6 transform text-gray-400 group-hover:text-gray-500 transition-transform duration-200"
                                                :class="{ '-rotate-180': openSection === 4 }" fill="none"
                                                viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M19 9l-7 7-7-7" />
                                            </svg>
                                        </span>
                                    </button>
                                </h3>
                                <div class="prose prose-sm pb-6" x-show="openSection === 4" x-cloak id="reviews">
                                    <?php if($product->publishedReviews->count() > 0): ?>
                                        <div class="space-y-4">
                                            <?php $__currentLoopData = $product->publishedReviews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $review): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="border-b border-gray-100 pb-4 last:border-0 last:pb-0">
                                                    <div class="flex items-center justify-between mb-1">
                                                        <h4 class="text-sm font-bold text-gray-900">
                                                            <?php echo e($review->user->name ?? 'Anonymous'); ?>

                                                        </h4>
                                                        <span
                                                            class="text-xs text-gray-500"><?php echo e($review->created_at->format('M d, Y')); ?></span>
                                                    </div>
                                                    <div class="flex items-center mb-2">
                                                        <?php for($i = 1; $i <= 5; $i++): ?>
                                                            <svg class="h-4 w-4 <?php echo e($review->rating >= $i ? 'text-yellow-400' : 'text-gray-300'); ?>"
                                                                xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"
                                                                fill="currentColor">
                                                                <path
                                                                    d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z" />
                                                            </svg>
                                                        <?php endfor; ?>
                                                    </div>
                                                    <?php if($review->comment): ?>
                                                        <p class="text-gray-600"><?php echo e($review->comment); ?></p>
                                                    <?php endif; ?>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    <?php else: ?>
                                        <p class="text-gray-500 italic">No reviews yet.</p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </section>
                </div>
            </div>

            <!-- Upsell Products -->
            <?php if(isset($upsellProducts) && $upsellProducts->count() > 0): ?>
                <div class="mt-16 border-t border-gray-200 pt-16">
                    <h2 class="text-2xl font-bold tracking-tight text-gray-900">You may also like</h2>
                    <div class="mt-8 grid grid-cols-1 gap-y-12 sm:grid-cols-2 sm:gap-x-6 lg:grid-cols-4 xl:gap-x-8">
                        <?php $__currentLoopData = $upsellProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $relatedProduct): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="group relative">
                                <div class="relative h-72 w-full overflow-hidden rounded-lg">
                                    <?php
                                        $rMainImage = $relatedProduct->images->sortBy('sort_order')->first();
                                        if ($rMainImage) {
                                            $rImagePath = $rMainImage->image_path;
                                        } else {
                                            $rVariationImage = $relatedProduct->variations->whereNotNull('image_path')->sortBy('sort_order')->first();
                                            $rImagePath = $rVariationImage
                                                ? $rVariationImage->image_path
                                                : 'https://placehold.co/600x600?text=No+Image';
                                        }
                                    ?>
                                    <img src="<?php echo e($rImagePath); ?>" alt="<?php echo e($relatedProduct->name); ?>"
                                        class="h-full w-full object-cover object-center group-hover:opacity-75">
                                    <!-- Wishlist Button -->
                                    <button type="button"
                                        onclick="event.preventDefault(); window.toggleWishlist(<?php echo e($relatedProduct->id); ?>)"
                                        class="absolute top-2 right-2 z-10 p-2 rounded-full bg-white/90 hover:bg-white text-gray-500 hover:text-red-500 transition-colors shadow-sm opacity-0 group-hover:opacity-100 focus:opacity-100"
                                        title="Add to Wishlist">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24"
                                            stroke="currentColor" stroke-width="2">
                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z" />
                                        </svg>
                                    </button>
                                </div>
                                <div class="relative mt-4">
                                    <h3 class="text-sm font-medium text-gray-900"><?php echo e($relatedProduct->name); ?></h3>
                                    <p class="mt-1 text-sm text-gray-500">
                                        <?php if($relatedProduct->variations->count() > 0): ?>
                                            ₹<?php echo e(number_format($relatedProduct->variations->min('sp'), 2)); ?>

                                        <?php else: ?>
                                            N/A
                                        <?php endif; ?>
                                    </p>
                                </div>
                                <div class="absolute inset-0 top-0 h-72 rounded-lg ring-1 ring-inset ring-black/10"></div>
                                <a href="<?php echo e(route('shop.product', $relatedProduct->slug)); ?>" class="absolute inset-0"><span
                                        class="sr-only">View details for <?php echo e($relatedProduct->name); ?></span></a>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <script>
        function productData() {
            return {
                openSection: 1,
                init() {
                    if (window.location.hash === '#reviews') {
                        this.openSection = 4;
                        setTimeout(() => {
                            const el = document.getElementById('reviews');
                            if (el) el.scrollIntoView({ behavior: 'smooth' });
                        }, 100);
                    }
                },
                selectedVariationId: <?php echo e($product->variations->first()->id ?? 'null'); ?>,
                currentPrice: <?php echo e($product->variations->first()->sp ?? 0); ?>,
                currentMrp: <?php echo e($product->variations->first()->mrp ?? 0); ?>,
                isStockAvailable: <?php echo e($product->variations->first()->stock ?? 0); ?> > 0,
                currentStock: <?php echo e($product->variations->first()->stock ?? 0); ?>,
                variations: <?php echo json_encode($product->variations, 15, 512) ?>,
                getSelectedVariationName() {
                    const variation = this.variations.find(v => v.id === this.selectedVariationId);
                    if (!variation) return 'Select Option';
                    
                    let name = variation.options.map(o => o.attribute_value).join(' / ');
                    return name + ' - ₹' + Number(variation.sp).toLocaleString('en-IN');
                },

                <?php
                    $firstImage = $product->images->sortBy('sort_order')->first();
                    $firstImagePath = $firstImage
                        ? $firstImage->image_path
                        : 'https://placehold.co/600x600?text=No+Image';
                ?>
                                                                                                                    currentImage: '<?php echo e($firstImagePath); ?>',

                selectVariation(id) {
                    this.selectedVariationId = id;
                    const variation = this.variations.find(v => v.id === id);
                    if (variation) {
                        this.currentPrice = variation.sp;
                        this.currentMrp = variation.mrp;
                        this.isStockAvailable = variation.stock > 0;
                        this.currentStock = variation.stock;
                        if (variation.image_path) {
                            this.currentImage = variation.image_path;
                        }
                    }
                },

                toggleWishlist() {
                    fetch('<?php echo e(route('wishlist.toggle')); ?>', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'Accept': 'application/json',
                            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                        },
                        body: JSON.stringify({ product_id: <?php echo e($product->id); ?> })
                    })
                        .then(async response => {
                            if (response.status === 401) {
                                window.location.href = '<?php echo e(route('login')); ?>';
                                return;
                            }

                            // Check for JSON content type
                            const contentType = response.headers.get("content-type");
                            if (!contentType || contentType.indexOf("application/json") === -1) {
                                // Not JSON, probably an error page
                                const text = await response.text();
                                console.log('Server returned non-JSON:', text);
                                throw new Error('Server returned unexpected response format.');
                            }

                            if (!response.ok) {
                                const data = await response.json().catch(() => ({}));
                                throw new Error(data.message || 'Server returned error ' + response.status);
                            }
                            return response.json();
                        })
                        .then(data => {
                            if (data) {
                                alert(data.message);
                            }
                        })
                        .catch(error => {
                            console.error('Error:', error);
                            alert('Something went wrong: ' + error.message);
                        });
                },

                calculateDiscount() {
                    if (this.currentMrp > this.currentPrice) {
                        return Math.round(((this.currentMrp - this.currentPrice) / this.currentMrp) * 100);
                    }
                    return 0;
                }
            }
        }
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.shop', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/truetransit/public_html/hairniche.in/resources/views/shop/show.blade.php ENDPATH**/ ?>