<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Create Custom Offer - Lugani Admin</title>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <?php echo $__env->make('admin.partials.styles', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <!-- Alpine.js is assumed to be loaded via app.js or CDN if not -->
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
</head>

<body class="bg-gray-50 flex h-screen overflow-hidden">
    <?php echo $__env->make('admin.partials.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <div class="flex-1 flex flex-col h-screen overflow-hidden">
        <header class="h-16 flex items-center justify-between px-6 bg-white border-b border-gray-200">
            <div class="flex items-center">
                <a href="<?php echo e(route('admin.settings.custom_offers.index')); ?>" class="mr-4 text-gray-500 hover:text-gray-700">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path>
                    </svg>
                </a>
                <h2 class="text-2xl font-semibold text-gray-800">Create Custom Offer</h2>
            </div>
        </header>

        <main class="flex-1 overflow-x-hidden overflow-y-auto bg-gray-50 p-6">
            <div class="max-w-4xl mx-auto">
                <?php if($errors->any()): ?>
                    <div class="mb-6 bg-red-50 border-l-4 border-red-500 p-4 rounded-r-lg">
                        <div class="flex">
                            <div class="flex-shrink-0">
                                <svg class="h-5 w-5 text-red-400" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd" />
                                </svg>
                            </div>
                            <div class="ml-3">
                                <h3 class="text-sm font-medium text-red-800">There were errors with your submission</h3>
                                <div class="mt-2 text-sm text-red-700">
                                    <ul class="list-disc pl-5 space-y-1">
                                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li><?php echo e($error); ?></li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

<form action="<?php echo e(route('admin.settings.custom_offers.store')); ?>" method="POST" enctype="multipart/form-data" 
      x-data="{ 
          selectedLayoutId: '<?php echo e(old('layout_id')); ?>', 
          layouts: <?php echo e(collect($layouts)->toJson()); ?>,
          placementPages: <?php echo e(json_encode(old('placement_pages', []))); ?>,
          targetElement: '<?php echo e(old('target_element')); ?>',
          isSubmitting: false,
          bgColor: '<?php echo e(old('bg_color', '#ffffff')); ?>',
          headingColor: '<?php echo e(old('heading_color', '#111827')); ?>',
          pageTargets: {
            'home': [
                { id: '#home-hero', label: 'Main Hero Slider' },
                { id: '#home-features', label: 'Features (Quality/Shipping)' },
                { id: '#home-best-sellers', label: 'Best Sellers Section' },
                { id: '#home-consultation', label: 'Video Consultation Form' },
                { id: '#home-collections', label: 'Browse Collections Grid' },
                { id: '#home-instagram', label: 'Instagram Feed' }
            ],
            'shop': [
                { id: '#shop-header', label: 'Shop Header Banner' },
                { id: '#shop-sidebar', label: 'Filters Sidebar' },
                { id: '#products-grid', label: 'Product Grid' }
            ],
            'global': [
                { id: 'header', label: 'Site Header (Nav)' },
                { id: 'footer', label: 'Site Footer' },
                { id: 'main', label: 'Main Webpage Content' }
            ]
          },
          get columns() {
              const layout = this.layouts.find(l => l.id == this.selectedLayoutId);
              return layout ? parseInt(layout.columns) : 0;
          }
      }"
      @submit="isSubmitting = true">
                    <?php echo csrf_field(); ?>
                    
                    <!-- Loader Overlay -->
                    <div x-show="isSubmitting" 
                         style="display: none;"
                         class="fixed inset-0 bg-gray-900 bg-opacity-50 z-50 flex items-center justify-center transition-opacity">
                        <div class="bg-white rounded-lg p-6 flex flex-col items-center shadow-xl">
                            <svg class="animate-spin h-10 w-10 text-blue-600 mb-4" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                                <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                                <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                            </svg>
                            <p class="text-gray-700 font-medium">Processing & Compressing Images...</p>
                            <p class="text-gray-500 text-sm mt-1">This may take a few moments.</p>
                        </div>
                    </div>

                    <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-6 mb-6">
                        <h3 class="text-lg font-medium text-gray-900 mb-4">Offer Details</h3>
                        <div class="grid grid-cols-1 gap-6">
                            <div>
                                <label for="name" class="block text-sm font-medium text-gray-700 mb-1">Offer Name</label>
                                <input type="text" name="name" id="name" value="<?php echo e(old('name')); ?>" required
                                    class="block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2.5">
                            </div>

                            <div>
                                <label for="layout_id" class="block text-sm font-medium text-gray-700 mb-1">Layout Style</label>
                                <select name="layout_id" id="layout_id" x-model="selectedLayoutId" required
                                    class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm">
                                    <option value="">Select a Layout</option>
                                    <?php $__currentLoopData = $layouts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $layout): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($layout->id); ?>"><?php echo e($layout->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Placement Pages (Optional)</label>
                                <div class="relative" x-data="{ open: false }">
                                    <button type="button" @click="open = !open" @click.away="open = false"
                                        class="relative w-full bg-white border border-gray-300 rounded-md shadow-sm pl-3 pr-10 py-2.5 text-left cursor-default focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500 sm:text-sm">
                                        <span class="block truncate" x-text="placementPages.length ? placementPages.length + ' pages selected' : 'Select pages'"></span>
                                        <span class="absolute inset-y-0 right-0 flex items-center pr-2 pointer-events-none">
                                            <svg class="h-5 w-5 text-gray-400" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true">
                                                <path fill-rule="evenodd" d="M10 3a1 1 0 01.707.293l3 3a1 1 0 01-1.414 1.414L10 5.414 7.707 7.707a1 1 0 01-1.414-1.414l3-3A1 1 0 0110 3zm-3.707 9.293a1 1 0 011.414 0L10 14.586l2.293-2.293a1 1 0 011.414 1.414l-3 3a1 1 0 01-1.414 0l-3-3a1 1 0 010-1.414z" clip-rule="evenodd" />
                                            </svg>
                                        </span>
                                    </button>

                                    <div x-show="open" class="absolute z-10 mt-1 w-full bg-white shadow-lg max-h-60 rounded-md py-1 text-base ring-1 ring-black ring-opacity-5 overflow-auto focus:outline-none sm:text-sm"
                                        style="display: none;">
                                        <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="flex items-center px-4 py-2 hover:bg-gray-100 cursor-pointer">
                                                <input id="page_<?php echo e($page->id); ?>" name="placement_pages[]" value="<?php echo e($page->slug); ?>" type="checkbox" x-model="placementPages"
                                                    class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded">
                                                <label for="page_<?php echo e($page->id); ?>" class="ml-3 block text-gray-900 w-full cursor-pointer">
                                                    <?php echo e($page->title); ?> <span class="text-gray-400 text-xs">(/<?php echo e($page->slug); ?>)</span>
                                                </label>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mt-6">
                            <div>
                                <label for="target_element" class="block text-sm font-medium text-gray-700 mb-1">Target Element Selector (Optional)</label>
                                <input type="text" name="target_element" id="target_element" x-model="targetElement"
                                    placeholder="#main-content, .hero-section"
                                    class="block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2.5">
                                <p class="mt-1 text-xs text-gray-500">CSS selector to place this offer relative to.</p>

                                <!-- Quick Select Helper -->
                                <div class="mt-3" x-show="placementPages.length > 0">
                                    <p class="text-xs font-semibold text-gray-600 mb-2">Refence IDs (Click to select):</p>
                                    <div class="flex flex-wrap gap-2">
                                        <!-- Global Targets -->
                                        <template x-for="target in pageTargets.global">
                                            <button type="button" @click="targetElement = target.id"
                                                class="inline-flex items-center px-2.5 py-1.5 border border-gray-200 shadow-sm text-xs font-medium rounded text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500"
                                                :class="targetElement === target.id ? 'ring-2 ring-indigo-500 border-indigo-500 bg-indigo-50' : ''">
                                                <span x-text="target.label"></span>
                                                <span class="ml-1.5 text-gray-400" x-text="'(' + target.id + ')'"></span>
                                            </button>
                                        </template>

                                        <!-- Page Specific Targets -->
                                        <template x-for="page in placementPages">
                                            <template x-if="pageTargets[page]">
                                                <template x-for="target in pageTargets[page]">
                                                    <button type="button" @click="targetElement = target.id"
                                                        class="inline-flex items-center px-2.5 py-1.5 border border-gray-200 shadow-sm text-xs font-medium rounded text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500"
                                                        :class="targetElement === target.id ? 'ring-2 ring-indigo-500 border-indigo-500 bg-indigo-50' : ''">
                                                        <span x-text="target.label"></span>
                                                        <span class="ml-1.5 text-gray-400" x-text="'(' + target.id + ')'"></span>
                                                    </button>
                                                </template>
                                            </template>
                                        </template>
                                    </div>
                                </div>
                            </div>
                            <div>
                                <label for="placement_position" class="block text-sm font-medium text-gray-700 mb-1">Placement Position</label>
                                <select name="placement_position" id="placement_position"
                                    class="block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2.5">
                                    <option value="after" selected>After (Default)</option>
                                    <option value="before">Before</option>
                                    <option value="inside_start">Inside (Start)</option>
                                    <option value="inside_end">Inside (End)</option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <!-- Custom Styling Section -->
                    <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-6 mb-6" x-data="{ open: false }">
                         <div class="flex justify-between items-center cursor-pointer" @click="open = !open">
                            <h3 class="text-lg font-medium text-gray-900">Custom Styling (Optional)</h3>
                            <button type="button" class="text-gray-500 hover:text-gray-700">
                                <svg class="w-5 h-5 transition-transform" :class="{ 'rotate-180': open }" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                                </svg>
                            </button>
                        </div>
                        
                        <div x-show="open" style="display: none;" class="mt-6 grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                            <div>
                                <label for="bg_color" class="block text-sm font-medium text-gray-700 mb-1">Background Color</label>
                                <div class="flex items-center">
                                    <input type="color" id="bg_color_picker" x-model="bgColor" class="h-9 w-9 border border-gray-300 rounded-l-md p-1 cursor-pointer">
                                    <input type="text" name="bg_color" id="bg_color" x-model="bgColor" placeholder="#ffffff" 
                                        class="flex-1 block w-full rounded-r-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2.5">
                                </div>
                            </div>

                            <div>
                                <label for="border_radius" class="block text-sm font-medium text-gray-700 mb-1">Border Radius</label>
                                <input type="text" name="border_radius" id="border_radius" value="0px" placeholder="e.g. 10px, 1rem"
                                    class="block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2.5">
                            </div>

                            <div>
                                <label for="box_shadow" class="block text-sm font-medium text-gray-700 mb-1">Box Shadow</label>
                                <select name="box_shadow" id="box_shadow"
                                    class="block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2.5">
                                    <option value="none" selected>None</option>
                                    <option value="0 1px 2px 0 rgb(0 0 0 / 0.05)">Small</option>
                                    <option value="0 4px 6px -1px rgb(0 0 0 / 0.1), 0 2px 4px -2px rgb(0 0 0 / 0.1)">Medium</option>
                                    <option value="0 10px 15px -3px rgb(0 0 0 / 0.1), 0 4px 6px -4px rgb(0 0 0 / 0.1)">Large</option>
                                    <option value="0 20px 25px -5px rgb(0 0 0 / 0.1), 0 8px 10px -6px rgb(0 0 0 / 0.1)">Extra Large</option>
                                    <option value="0 25px 50px -12px rgb(0 0 0 / 0.25)">2XL (Deep)</option>
                                    <option value="inset 0 2px 4px 0 rgb(0 0 0 / 0.05)">Inner Shadow</option>
                                    <option value="0 0 15px rgba(0,0,0,0.15)">Soft Glow</option>
                                    <option value="0 0 25px rgba(0,0,0,0.2)">Strong Glow</option>
                                    <option value="4px 4px 0px 0px rgba(0,0,0,1)">Hard Shadow (Retro)</option>
                                    <option value="0 8px 30px rgba(0,0,0,0.12)">Floating</option>
                                </select>
                            </div>

                            <div>
                                <label for="heading_font_size" class="block text-sm font-medium text-gray-700 mb-1">Heading Size</label>
                                <input type="text" name="heading_font_size" id="heading_font_size" value="2rem" placeholder="e.g. 2rem, 32px"
                                    class="block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2.5">
                            </div>

                             <div>
                                <label for="heading_font_weight" class="block text-sm font-medium text-gray-700 mb-1">Heading Weight</label>
                                <select name="heading_font_weight" id="heading_font_weight"
                                    class="block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2.5">
                                    <option value="400">Regular (400)</option>
                                    <option value="500">Medium (500)</option>
                                    <option value="600">Semi Bold (600)</option>
                                    <option value="700" selected>Bold (700)</option>
                                    <option value="800">Extra Bold (800)</option>
                                </select>
                            </div>

                            <div>
                                <label for="heading_color" class="block text-sm font-medium text-gray-700 mb-1">Heading Color</label>
                                <div class="flex items-center">
                                    <input type="color" id="heading_color_picker" x-model="headingColor" class="h-9 w-9 border border-gray-300 rounded-l-md p-1 cursor-pointer">
                                    <input type="text" name="heading_color" id="heading_color" x-model="headingColor" placeholder="#111827" 
                                        class="flex-1 block w-full rounded-r-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2.5">
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-6 mb-6" x-show="columns > 0">
                        <h3 class="text-lg font-medium text-gray-900 mb-4">Banner Items</h3>
                        <p class="text-sm text-gray-500 mb-6">Based on your selection, please upload <span x-text="columns" class="font-bold text-gray-900"></span> banner(s).</p>
                        
                        <div class="grid gap-6" :class="columns === 1 ? 'grid-cols-1' : (columns === 2 ? 'grid-cols-2' : 'grid-cols-3')">
                            <template x-for="i in columns" :key="i">
                                <div class="border border-gray-200 rounded-xl p-5 bg-gray-50 hover:shadow-md transition-shadow duration-200">
                                    <div class="flex items-center justify-between mb-4">
                                        <h4 class="font-semibold text-gray-800" x-text="'Column ' + i"></h4>
                                        <span class="px-2 py-1 bg-gray-200 text-gray-600 text-xs rounded-md font-medium">Image</span>
                                    </div>
                                    
                                    <div class="space-y-5">
                                        <div>
                                            <label class="block text-sm font-medium text-gray-700 mb-2">Banner Image *</label>
                                            <div class="mt-1 flex justify-center px-6 pt-5 pb-6 border-2 border-gray-300 border-dashed rounded-lg hover:border-blue-500 transition-colors bg-white">
                                                <div class="space-y-1 text-center">
                                                    <svg class="mx-auto h-12 w-12 text-gray-400" stroke="currentColor" fill="none" viewBox="0 0 48 48" aria-hidden="true">
                                                        <path d="M28 8H12a4 4 0 00-4 4v20m32-12v8m0 0v8a4 4 0 01-4 4H12a4 4 0 01-4-4v-4m32-4l-3.172-3.172a4 4 0 00-5.656 0L28 28M8 32l9.172-9.172a4 4 0 015.656 0L28 28m0 0l4 4m4-24h8m-4-4v8m-12 4h.02" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                                                    </svg>
                                                    <div class="flex text-sm text-gray-600 justify-center">
                                                        <label :for="'banner_image_' + i" class="relative cursor-pointer bg-white rounded-md font-medium text-blue-600 hover:text-blue-500 focus-within:outline-none focus-within:ring-2 focus-within:ring-offset-2 focus-within:ring-blue-500">
                                                            <span>Upload a file</span>
                                                            <input :id="'banner_image_' + i" name="banner_image[]" type="file" class="sr-only" required accept="image/*">
                                                        </label>
                                                    </div>
                                                    <p class="text-xs text-gray-500">PNG, JPG, GIF up to 5MB</p>
                                                </div>
                                            </div>
                                        </div>

                                        <div>
                                            <label class="block text-sm font-medium text-gray-700 mb-1">Redirect URL</label>
                                            <div class="relative rounded-md shadow-sm">
                                                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                                    <span class="text-gray-500 sm:text-sm">https://</span>
                                                </div>
                                                <input type="url" name="redirect_url[]" 
                                                    class="focus:ring-blue-500 focus:border-blue-500 block w-full pl-16 sm:text-sm border-gray-300 rounded-md py-2.5 border" 
                                                    placeholder="www.example.com">
                                            </div>
                                        </div>

                                        <div>
                                            <label class="block text-sm font-medium text-gray-700 mb-1">Alt Text</label>
                                            <input type="text" name="alt_tag[]" placeholder="Image description for SEO"
                                                class="shadow-sm focus:ring-blue-500 focus:border-blue-500 block w-full sm:text-sm border-gray-300 rounded-md py-2.5 border px-3">
                                        </div>
                                    </div>
                                </div>
                            </template>
                        </div>
                    </div>

                    <div class="flex justify-end">
                        <button type="submit"
                            :disabled="isSubmitting"
                            class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2 rounded-lg text-sm font-medium disabled:opacity-50 disabled:cursor-not-allowed flex items-center">
                            <svg x-show="isSubmitting" style="display: none;" class="animate-spin -ml-1 mr-3 h-5 w-5 text-white" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                                <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                                <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                            </svg>
                            <span x-text="isSubmitting ? 'Processing...' : 'Create Offer'">Create Offer</span>
                        </button>
                    </div>
                </form>
            </div>
        </main>
    </div>
</body>
</html>
<?php /**PATH /home/truetransit/public_html/hairniche.in/resources/views/admin/settings/custom_offers/create.blade.php ENDPATH**/ ?>