

<?php $__env->startPush('schema_markup'); ?>
    <?php
        $homeSchema = \App\Models\SeoSetting::where('page_name', 'home')->value('schema_markup');
    ?>
    <?php if($homeSchema): ?>
        <?php echo $homeSchema; ?>

    <?php endif; ?>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>

    <!-- Hero Section -->
    <style>
        .hero-slider-container {
            width: 100%;
            aspect-ratio: 16/9;
        }

        @media (min-width: 768px) {
            .hero-slider-container {
                width: 100%;
                aspect-ratio: auto;
                height: 550px;
            }
        }
    </style>
    <div id="home-hero" class="relative bg-gray-900 hero-slider-container flex items-center justify-center overflow-hidden"
        x-data="{ activeSlide: 0, slides: <?php echo e($sliders->count()); ?> }"
        x-init="setInterval(() => { activeSlide = activeSlide === slides - 1 ? 0 : activeSlide + 1 }, 5000)">
        <?php $__empty_1 = true; $__currentLoopData = $sliders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $slider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>

            <div class="absolute inset-0 w-full h-full transition-opacity duration-1000 ease-in-out"
                x-show="activeSlide === <?php echo e($index); ?>" x-transition:enter="transition ease-out duration-1000"
                x-transition:enter-start="opacity-0" x-transition:enter-end="opacity-100"
                x-transition:leave="transition ease-in duration-1000" x-transition:leave-start="opacity-100"
                x-transition:leave-end="opacity-0">

                <img src="<?php echo e(Str::startsWith($slider->image_path, ['http', 'https']) ? $slider->image_path : asset('storage/' . $slider->image_path)); ?>"
                    alt="<?php echo e($slider->alt_text ?? 'Slider Image'); ?>" class="absolute inset-0 w-full h-full object-cover">

                <div class="absolute inset-0 bg-black/20"></div>

                <?php if($slider->link): ?>
                    <a href="<?php echo e($slider->link); ?>" class="absolute inset-0 z-20"></a>
                <?php endif; ?>

                <div class="relative z-10 text-center text-white p-4 h-full flex flex-col justify-center items-center">
                    <?php if($slider->link): ?>
                        <a href="<?php echo e($slider->link); ?>"
                            class="inline-block bg-white text-gray-900 px-10 py-4 rounded-none font-medium hover:bg-gray-100 transition-transform hover:-translate-y-1 duration-300 uppercase tracking-widest text-sm relative z-30 pointer-events-auto mt-auto mb-20">
                            Shop Now
                        </a>
                    <?php endif; ?>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <!-- Fallback Static Slide if no sliders exist -->
            <img src="https://images.unsplash.com/photo-1441986300917-64674bd600d8?q=80&w=2070&auto=format&fit=crop" alt="Hero"
                class="absolute inset-0 w-full h-full object-cover opacity-60">
            <div class="relative z-10 text-center text-white p-4">
                <h1 class="text-5xl md:text-7xl font-bold mb-6 tracking-tight">Summer Collection</h1>
                <p class="text-xl md:text-2xl mb-8 font-light text-gray-200 max-w-2xl mx-auto">Discover the latest trends in
                    fashion and lifestyle. Elevate your everyday look with our curated selection.</p>
                <a href="#shop-all"
                    class="inline-block bg-white text-gray-900 px-10 py-4 rounded-none font-medium hover:bg-gray-100 transition-transform hover:-translate-y-1 duration-300 uppercase tracking-widest text-sm">Shop
                    Now</a>
            </div>
        <?php endif; ?>

        <!-- Slider Indicators -->
        <?php if($sliders->count() > 1): ?>
            <div class="absolute bottom-8 left-0 right-0 z-30 flex justify-center space-x-2">
                <?php $__currentLoopData = $sliders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $slider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <button @click="activeSlide = <?php echo e($index); ?>" class="w-3 h-3 rounded-full transition-colors duration-300"
                        :class="activeSlide === <?php echo e($index); ?> ? 'bg-white' : 'bg-white/50 hover:bg-white/80'"></button>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        <?php endif; ?>
    </div>


    <!-- Features Section -->
    <div id="home-features" class="bg-white py-8 md:py-16">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4 md:gap-8">
                <!-- Premium Quality -->
                <div
                    class="p-5 md:p-8 rounded-2xl md:rounded-3xl bg-gradient-to-br from-[#9B2D69] to-[#7a2454] text-white shadow-lg transform hover:-translate-y-1 transition-all duration-300">
                    <div class="flex items-start md:block gap-4 md:gap-0">
                        <div
                            class="w-12 h-12 md:w-14 md:h-14 bg-white/20 rounded-xl md:rounded-2xl flex items-center justify-center flex-shrink-0 mb-0 md:mb-6 backdrop-blur-sm">
                            <svg class="w-6 h-6 md:w-8 md:h-8 text-white" fill="none" viewBox="0 0 24 24"
                                stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                                    d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4" />
                            </svg>
                        </div>
                        <div>
                            <h3 class="font-bold text-lg md:text-xl mb-1 md:mb-3 tracking-wide">Premium Quality</h3>
                            <p class="text-pink-50 text-xs md:text-sm leading-relaxed">Sourced from the finest organic
                                farms, ensuring 100% purity and potency in every herb.</p>
                        </div>
                    </div>
                </div>

                <!-- Fast Shipping -->
                <div
                    class="p-5 md:p-8 rounded-2xl md:rounded-3xl bg-gradient-to-br from-[#9B2D69] to-[#7a2454] text-white shadow-lg transform hover:-translate-y-1 transition-all duration-300">
                    <div class="flex items-start md:block gap-4 md:gap-0">
                        <div
                            class="w-12 h-12 md:w-14 md:h-14 bg-white/20 rounded-xl md:rounded-2xl flex items-center justify-center flex-shrink-0 mb-0 md:mb-6 backdrop-blur-sm">
                            <svg class="w-6 h-6 md:w-8 md:h-8 text-white" fill="none" viewBox="0 0 24 24"
                                stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                                    d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z" />
                            </svg>
                        </div>
                        <div>
                            <h3 class="font-bold text-lg md:text-xl mb-1 md:mb-3 tracking-wide">Fast Shipping</h3>
                            <p class="text-pink-50 text-xs md:text-sm leading-relaxed">Quick and reliable delivery to bring
                                fresh organic goodness straight to your doorstep.</p>
                        </div>
                    </div>
                </div>

                <!-- Secure Payment -->
                <div
                    class="p-5 md:p-8 rounded-2xl md:rounded-3xl bg-gradient-to-br from-[#9B2D69] to-[#7a2454] text-white shadow-lg transform hover:-translate-y-1 transition-all duration-300">
                    <div class="flex items-start md:block gap-4 md:gap-0">
                        <div
                            class="w-12 h-12 md:w-14 md:h-14 bg-white/20 rounded-xl md:rounded-2xl flex items-center justify-center flex-shrink-0 mb-0 md:mb-6 backdrop-blur-sm">
                            <svg class="w-6 h-6 md:w-8 md:h-8 text-white" fill="none" viewBox="0 0 24 24"
                                stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                                    d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z" />
                            </svg>
                        </div>
                        <div>
                            <h3 class="font-bold text-lg md:text-xl mb-1 md:mb-3 tracking-wide">Secure Payment</h3>
                            <p class="text-pink-50 text-xs md:text-sm leading-relaxed">Safe and encrypted transactions
                                for a worry-free shopping experience.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Best Sellers Section -->
    <?php if(isset($bestSellers) && $bestSellers->count() > 0): ?>
        <div id="home-best-sellers" class="bg-pink-50 py-20">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="text-center mb-16">
                    <span class="text-[#9B2D69] font-serif italic text-sm mb-2 block">Customer Favorites</span>
                    <h2 class="text-3xl md:text-4xl font-bold tracking-tight text-gray-900 font-serif mb-4">Best Sellers of the
                        Month</h2>
                    <div class="w-24 h-1 bg-[#9B2D69] mx-auto"></div>
                    <p class="text-gray-500 max-w-2xl mx-auto mt-4">Discover our most loved products selected by customers like
                        you.</p>
                </div>

                <div class="grid grid-cols-2 sm:grid-cols-2 lg:grid-cols-4 gap-8">
                    <?php $__currentLoopData = $bestSellers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div
                            class="group relative bg-white rounded-xl overflow-hidden border border-gray-100 shadow-sm hover:shadow-2xl transition-all duration-300">
                            <!-- Product Card Content -->
                            <div class="aspect-[3/4] w-full overflow-hidden bg-gray-100 relative"
                                data-ajax-product-id="<?php echo e($product->id); ?>"
                                x-data="{ activeIndex: 0, get images() { return $store.productImages.data[<?php echo e($product->id); ?>] || ['https://placehold.co/400x600?text=Loading...'] } }">
                                <template x-if="images.length > 0">
                                <a href="<?php echo e(route('shop.product', $product->slug)); ?>" class="block h-full w-full"
                                    title="<?php echo e($product->name); ?>">
                                    <img :src="images[activeIndex]" alt="<?php echo e($product->name); ?>"
                                        class="h-full w-full object-cover object-center group-hover:scale-105 transition-transform duration-700 ease-in-out">
                                </a>
                                </template>

                                <!-- Badge -->
                                <div class="absolute top-2 left-2 z-20">
                                    <span class="bg-[#9B2D69] text-white text-xs font-bold px-2 py-1 rounded shadow-sm">
                                        Top Seller
                                    </span>
                                </div>

                                <!-- Wishlist -->
                                <button type="button" onclick="event.preventDefault(); window.toggleWishlist(<?php echo e($product->id); ?>)"
                                    class="absolute top-3 right-3 z-20 p-2.5 rounded-full bg-white/90 text-gray-400 hover:text-rose-600 hover:bg-rose-50 transition-colors shadow-md opacity-0 group-hover:opacity-100"
                                    title="Add to Wishlist">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24"
                                        stroke="currentColor" stroke-width="2">
                                        <path stroke-linecap="round" stroke-linejoin="round"
                                            d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z" />
                                    </svg>
                                </button>

                                <!-- Quick Add -->
                                <div
                                    class="absolute bottom-0 inset-x-0 p-4 translate-y-full group-hover:translate-y-0 transition-transform duration-300 ease-in-out">
                                    <form action="<?php echo e(route('cart.add')); ?>" method="POST">
                                        <?php echo csrf_field(); ?>
                                        <input type="hidden" name="product_id" value="<?php echo e($product->id); ?>">
                                        <input type="hidden" name="quantity" value="1">
                                        <button type="submit"
                                            class="w-full bg-[#9B2D69] text-white py-3 px-4 rounded-lg flex items-center justify-center gap-2 uppercase text-xs font-bold tracking-widest hover:bg-[#7a2454] transition-colors shadow-lg shadow-pink-200">
                                            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24"
                                                stroke="currentColor" stroke-width="2">
                                                <path stroke-linecap="round" stroke-linejoin="round"
                                                    d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z" />
                                            </svg>
                                            Add to Cart
                                        </button>
                                    </form>
                                </div>
                            </div>

                            <div class="p-4">
                                <h3 class="text-base font-medium text-gray-900 hover:text-[#9B2D69] transition-colors">
                                    <a href="<?php echo e(route('shop.product', $product->slug)); ?>">
                                        <span aria-hidden="true" class="absolute inset-0"></span>
                                        <?php echo e($product->name); ?>

                                    </a>
                                </h3>
                                <div class="mt-2 flex items-baseline space-x-2">
                                    <p class="text-lg font-bold text-gray-900">₹<?php echo e(number_format($product->sp, 2)); ?></p>
                                    <?php if($product->mrp > $product->sp): ?>
                                        <p class="text-xs text-gray-400 line-through">₹<?php echo e(number_format($product->mrp, 2)); ?></p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <!-- Book a Video Consultation Section -->
    <div id="home-consultation" class="bg-gradient-to-br from-pink-50 via-purple-50 to-pink-100 py-20">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-16">
                <span class="text-[#9B2D69] font-serif italic text-sm mb-2 block">Expert Guidance</span>
                <h2 class="text-3xl md:text-4xl font-bold tracking-tight text-gray-900 font-serif mb-4">Book a Video
                    Consultation</h2>
                <div class="w-24 h-1 bg-[#9B2D69] mx-auto"></div>
                <p class="text-gray-600 max-w-2xl mx-auto mt-4">Get personalized advice from our experts in the comfort of
                    your home</p>
            </div>

            <div class="grid grid-cols-1 lg:grid-cols-2 gap-12">
                <!-- Booking Form -->
                <div class="bg-white rounded-2xl shadow-xl p-8 md:p-10 h-full">
                    <h3 class="text-2xl font-bold text-gray-900 mb-6">Schedule Your Session</h3>

                    <?php if(session('success')): ?>
                        <div class="mb-6 bg-green-50 text-green-700 px-4 py-3 rounded-lg border border-green-200 shadow-sm">
                            <?php echo e(session('success')); ?>

                        </div>
                    <?php endif; ?>

                    <form action="<?php echo e(route('consultation.book')); ?>" method="POST" class="space-y-6"
                        x-data="{ selectedDate: '', selectedTime: '' }">
                        <?php echo csrf_field(); ?>

                        <!-- Name -->
                        <div>
                            <label for="consultation_name" class="block text-sm font-medium text-gray-700 mb-2">Full Name
                                *</label>
                            <input type="text" id="consultation_name" name="name" required
                                class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#9B2D69] focus:border-[#9B2D69] transition-all"
                                placeholder="John Doe">
                        </div>

                        <!-- Email -->
                        <div>
                            <label for="consultation_email" class="block text-sm font-medium text-gray-700 mb-2">Email
                                Address *</label>
                            <input type="email" id="consultation_email" name="email" required
                                class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#9B2D69] focus:border-[#9B2D69] transition-all"
                                placeholder="you@example.com">
                        </div>

                        <!-- Phone Number -->
                        <div>
                            <label for="consultation_phone" class="block text-sm font-medium text-gray-700 mb-2">Phone
                                Number *</label>
                            <input type="tel" id="consultation_phone" name="phone" required
                                class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#9B2D69] focus:border-[#9B2D69] transition-all"
                                placeholder="+91 98765 43210">
                        </div>

                        <!-- Interested Products (Multi-Select) -->
                        <div x-data="{
                            search: '',
                            open: false,
                            items: <?php echo e($subcategories->map(fn($c) => ['id' => $c->name, 'name' => $c->name])->values()->toJson()); ?>,
                            selected: [],
                            init() {
                                this.$watch('selected', value => console.log(value));
                            },
                            get filteredItems() {
                                if (this.search === '') return this.items;
                                return this.items.filter(item => item.name.toLowerCase().includes(this.search.toLowerCase()));
                            },
                            toggle(id) {
                                if (this.selected.includes(id)) {
                                    this.selected = this.selected.filter(i => i !== id);
                                } else {
                                    this.selected.push(id);
                                }
                            }
                        }" class="relative">
                            <label class="block text-sm font-medium text-gray-700 mb-2">Product(s) you wish to see</label>

                            <!-- Hidden Inputs for Form Submission -->
                            <template x-for="item in selected" :key="item">
                                <input type="hidden" name="interested_products[]" :value="item">
                            </template>

                            <!-- Trigger Button -->
                            <button type="button" @click="open = !open" @click.away="open = false"
                                class="w-full px-4 py-3 border border-gray-300 rounded-lg text-left bg-white text-gray-700 focus:ring-2 focus:ring-[#9B2D69] focus:border-[#9B2D69] transition-all flex justify-between items-center">
                                <span x-text="selected.length > 0 ? selected.join(', ') : 'Select Subcategories...'" class="truncate mr-2"></span>
                                <svg class="w-5 h-5 text-gray-400" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                                    <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
                                </svg>
                            </button>

                            <!-- Dropdown Menu -->
                            <div x-show="open" x-transition.opacity
                                class="absolute z-10 w-full mt-1 bg-white border border-gray-300 rounded-lg shadow-lg max-h-60 overflow-hidden flex flex-col">

                                <!-- Search Input -->
                                <div class="p-2 border-b border-gray-200">
                                    <input type="text" x-model="search" placeholder="Search products..."
                                        class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-1 focus:ring-[#9B2D69] text-sm">
                                </div>

                                <!-- List Items -->
                                <div class="overflow-y-auto flex-1 p-1">
                                    <template x-for="item in filteredItems" :key="item.id">
                                        <div @click="toggle(item.id)"
                                            class="cursor-pointer px-3 py-2 rounded-md flex items-center justify-between hover:bg-gray-100 transition-colors">
                                            <span x-text="item.name" class="text-sm text-gray-700"></span>
                                            <div x-show="selected.includes(item.id)" class="text-[#9B2D69]">
                                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path></svg>
                                            </div>
                                        </div>
                                    </template>
                                    <div x-show="filteredItems.length === 0" class="px-3 py-2 text-sm text-gray-500 text-center">
                                        No products found.
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Date -->
                        <div>
                            <label for="consultation_date" class="block text-sm font-medium text-gray-700 mb-2">Preferred
                                Date *</label>
                            <input type="date" id="consultation_date" name="date" required x-model="selectedDate"
                                min="<?php echo e(date('Y-m-d')); ?>"
                                class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#9B2D69] focus:border-[#9B2D69] transition-all">
                        </div>

                        <!-- Time Slot -->
                        <div>
                            <label for="consultation_time" class="block text-sm font-medium text-gray-700 mb-2">Preferred
                                Time Slot *</label>
                            <select id="consultation_time" name="time_slot" required x-model="selectedTime"
                                class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#9B2D69] focus:border-[#9B2D69] transition-all">
                                <option value="">Select a time slot</option>
                                <option value="09:00-10:00">09:00 AM - 10:00 AM</option>
                                <option value="10:00-11:00">10:00 AM - 11:00 AM</option>
                                <option value="11:00-12:00">11:00 AM - 12:00 PM</option>
                                <option value="12:00-13:00">12:00 PM - 01:00 PM</option>
                                <option value="14:00-15:00">02:00 PM - 03:00 PM</option>
                                <option value="15:00-16:00">03:00 PM - 04:00 PM</option>
                                <option value="16:00-17:00">04:00 PM - 05:00 PM</option>
                                <option value="17:00-18:00">05:00 PM - 06:00 PM</option>
                            </select>
                        </div>

                        <!-- Message (Optional) -->
                        <div>
                            <label for="consultation_message"
                                class="block text-sm font-medium text-gray-700 mb-2">Additional Notes (Optional)</label>
                            <textarea id="consultation_message" name="message" rows="3"
                                class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#9B2D69] focus:border-[#9B2D69] transition-all"
                                placeholder="Tell us about your concerns or questions..."></textarea>
                        </div>

                        <!-- Submit Button -->
                        <button type="submit"
                            class="w-full bg-gradient-to-r from-[#9B2D69] to-[#7a2454] text-white py-4 px-6 rounded-lg font-bold uppercase tracking-wider hover:from-[#7a2454] hover:to-[#9B2D69] transform hover:-translate-y-0.5 transition-all duration-200 shadow-lg hover:shadow-xl">
                            <span class="flex items-center justify-center gap-2">
                                <svg class="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M15 10l4.553-2.276A1 1 0 0121 8.618v6.764a1 1 0 01-1.447.894L15 14M5 18h8a2 2 0 002-2V8a2 2 0 00-2-2H5a2 2 0 00-2 2v8a2 2 0 002 2z" />
                                </svg>
                                Book Consultation
                            </span>
                        </button>
                    </form>
                </div>

                <!-- Consultation Information -->
                <div class="space-y-8 h-full flex flex-col">
                    <!-- What to Expect -->
                    <div class="bg-white rounded-2xl shadow-lg p-8 flex-1">
                        <div class="flex items-start gap-4 mb-6">
                            <div class="w-12 h-12 bg-indigo-100 rounded-xl flex items-center justify-center flex-shrink-0">
                                <svg class="w-6 h-6 text-indigo-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                                </svg>
                            </div>
                            <div>
                                <h3 class="text-xl font-bold text-gray-900 mb-3">What You'll Get</h3>
                                <ul class="space-y-3 text-gray-600">
                                    <li class="flex items-start gap-2">
                                        <svg class="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" fill="currentColor"
                                            viewBox="0 0 20 20">
                                            <path fill-rule="evenodd"
                                                d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z"
                                                clip-rule="evenodd" />
                                        </svg>
                                        <span>One-on-one personalized consultation with certified experts</span>
                                    </li>
                                    <li class="flex items-start gap-2">
                                        <svg class="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" fill="currentColor"
                                            viewBox="0 0 20 20">
                                            <path fill-rule="evenodd"
                                                d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z"
                                                clip-rule="evenodd" />
                                        </svg>
                                        <span>Customized product recommendations based on your needs</span>
                                    </li>
                                    <li class="flex items-start gap-2">
                                        <svg class="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" fill="currentColor"
                                            viewBox="0 0 20 20">
                                            <path fill-rule="evenodd"
                                                d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z"
                                                clip-rule="evenodd" />
                                        </svg>
                                        <span>Detailed usage guidelines and lifestyle tips</span>
                                    </li>
                                    <li class="flex items-start gap-2">
                                        <svg class="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" fill="currentColor"
                                            viewBox="0 0 20 20">
                                            <path fill-rule="evenodd"
                                                d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z"
                                                clip-rule="evenodd" />
                                        </svg>
                                        <span>Follow-up support via email for 7 days</span>
                                    </li>
                                    <li class="flex items-start gap-2">
                                        <svg class="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0" fill="currentColor"
                                            viewBox="0 0 20 20">
                                            <path fill-rule="evenodd"
                                                d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z"
                                                clip-rule="evenodd" />
                                        </svg>
                                        <span>30-minute dedicated session via video call</span>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <!-- Terms & Conditions -->
                    <div class="bg-amber-50 rounded-2xl border border-amber-200 p-8">
                        <div class="flex items-start gap-4">
                            <div class="w-12 h-12 bg-amber-100 rounded-xl flex items-center justify-center flex-shrink-0">
                                <svg class="w-6 h-6 text-amber-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
                                </svg>
                            </div>
                            <div>
                                <h3 class="text-xl font-bold text-gray-900 mb-3">Terms & Conditions</h3>
                                <ul class="space-y-2 text-sm text-gray-700">
                                    <li class="flex items-start gap-2">
                                        <span class="text-amber-600 font-bold mt-0.5">•</span>
                                        <span>Consultations are available Monday to Saturday, 9 AM to 6 PM</span>
                                    </li>
                                    <li class="flex items-start gap-2">
                                        <span class="text-amber-600 font-bold mt-0.5">•</span>
                                        <span>Please book at least 24 hours in advance</span>
                                    </li>
                                    <li class="flex items-start gap-2">
                                        <span class="text-amber-600 font-bold mt-0.5">•</span>
                                        <span>Cancellations must be made 12 hours before the scheduled time</span>
                                    </li>
                                    <li class="flex items-start gap-2">
                                        <span class="text-amber-600 font-bold mt-0.5">•</span>
                                        <span>A stable internet connection and video-enabled device are required</span>
                                    </li>
                                    <li class="flex items-start gap-2">
                                        <span class="text-amber-600 font-bold mt-0.5">•</span>
                                        <span>Consultation link will be sent via email 1 hour before the session</span>
                                    </li>
                                    <li class="flex items-start gap-2">
                                        <span class="text-amber-600 font-bold mt-0.5">•</span>
                                        <span>This is for informational purposes only and not a substitute for medical
                                            advice</span>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <!-- Contact Support -->
                    <div class="bg-gradient-to-r from-[#9B2D69] to-[#7a2454] rounded-2xl p-6 text-white">
                        <div class="flex items-center gap-3 mb-2">
                            <svg class="w-6 h-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M18.364 5.636l-3.536 3.536m0 5.656l3.536 3.536M9.172 9.172L5.636 5.636m3.536 9.192l-3.536 3.536M21 12a9 9 0 11-18 0 9 9 0 0118 0zm-5 0a4 4 0 11-8 0 4 4 0 018 0z" />
                            </svg>
                            <h4 class="font-bold text-lg">Need Help?</h4>
                        </div>
                        <p class="text-pink-100 text-sm">
                            Have questions about booking? Contact our support team at
                            <a href="mailto:hairnicheindia@gmail.com" class="underline font-semibold">hairnicheindia@gmail.com</a>
                            or call <a href="tel:9781134384" class="underline font-semibold">97811 34384</a>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Parent Categories Section -->
    <div id="home-collections" class="bg-gray-50 py-20">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <h2 class="text-3xl md:text-4xl font-bold tracking-tight text-gray-900 text-center mb-16 font-serif">
                <span class="border-b-2 border-black pb-2">Browse Collections</span>
            </h2>
            <div class="grid grid-cols-2 md:grid-cols-5 gap-8">
                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <a href="<?php echo e(route('shop.category', $category->slug)); ?>" class="group block text-center">
                        <div
                            class="relative w-full h-full object-fit mx-auto mb-6 overflow-hidden rounded-md shadow-lg group-hover:shadow-2xl transition-all duration-300 transform group-hover:-translate-y-2">
                            <div class="absolute inset-0 bg-black/0 group-hover:bg-black/0 transition-colors duration-300 z-5">
                            </div>
                            <?php if($category->image_url): ?>
                                <img src="<?php echo e($category->image_url); ?>" alt="<?php echo e($category->name); ?>"
                                    class="w-full h-full object-cover transition-transform duration-700 ease-in-out group-hover:scale-80">
                            <?php else: ?>
                                <div class="w-full h-full bg-gray-200 flex items-center justify-center text-gray-400">
                                    <svg class="w-12 h-12" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z">
                                        </path>
                                    </svg>
                                </div>
                            <?php endif; ?>
                        </div>
                        <h3
                            class="text-sm font-bold text-gray-900 uppercase tracking-widest group-hover:text-[#9B2D69] transition-colors relative inline-block">
                            <?php echo e($category->name); ?>

                        </h3>
                    </a>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>

    <!-- Instagram Feed Section -->
    <?php if(isset($settings->instagram_feed_url) && $settings->instagram_feed_url): ?>
        <div id="home-instagram" class="bg-white py-16">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="text-center mb-12">
                    <span class="text-[#9B2D69] font-serif italic text-sm mb-2 block">Follow Us on Instagram</span>
                    <h2 class="text-3xl md:text-4xl font-bold tracking-tight text-gray-900 font-serif mb-4">Our Social Feed</h2>
                    <div class="w-24 h-1 bg-[#9B2D69] mx-auto"></div>
                </div>
                <div class="instagram-feed-container overflow-hidden rounded-2xl shadow-sm border border-gray-100 p-1">
                    <?php echo $settings->instagram_feed_url; ?>

                </div>
            </div>
        </div>
    <?php endif; ?>

    <div id="shop-all" class="bg-white pb-20">
        <?php $__empty_1 = true; $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="relative py-16">
                <!-- Specialized Category Header with Background -->
                <!-- Specialized Category Header with Background -->
                <div class="w-full bg-amber-50 text-gray-900 py-6 mb-12 border-y border-amber-100">
                    <div class="relative max-w-7xl mx-auto px-4 flex flex-col items-center justify-center text-center">
                        <span class="text-amber-600 font-serif italic text-sm mb-1">Discover</span>
                        <h2 class="text-2xl md:text-3xl font-bold uppercase tracking-widest"><?php echo e($category->name); ?></h2>
                    </div>
                </div>

                <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                    <!-- Subcategories Loop -->
                    <?php $__currentLoopData = $category->children; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subcategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($subcategory->subProducts->count() > 0): ?>
                            <div class="mb-20 last:mb-0">
                                <div class="flex items-end justify-between mb-10 border-b border-gray-200 pb-4">
                                    <h3 class="text-2xl font-serif text-gray-900">
                                        <?php echo e($subcategory->name); ?>

                                        <span
                                            class="block text-xs font-sans text-gray-500 mt-1 uppercase tracking-wider font-normal">Featured
                                            Collection</span>
                                    </h3>
                                    <a href="<?php echo e(route('shop.subcategory', [$category->slug, $subcategory->slug])); ?>"
                                        class="text-sm font-bold uppercase tracking-widest text-gray-900 hover:text-[#9B2D69] transition-colors">
                                        View All
                                        <span aria-hidden="true"> &rarr;</span>
                                    </a>
                                </div>

                                <div class="grid grid-cols-2 sm:grid-cols-2 lg:grid-cols-4 gap-8">
                                    <?php $__currentLoopData = $subcategory->subProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div
                                            class="group relative bg-white rounded-xl overflow-hidden border border-gray-100 shadow-sm hover:shadow-2xl transition-all duration-300">
                                            <!-- Product Card Content -->
                                            <div class="aspect-[3/4] w-full overflow-hidden bg-gray-100 relative"
                                                data-ajax-product-id="<?php echo e($product->id); ?>"
                                                x-data="{ activeIndex: 0, get images() { return $store.productImages.data[<?php echo e($product->id); ?>] || ['https://placehold.co/400x600?text=Loading...'] } }">
                                                <template x-if="images.length > 0">
                                                <a href="<?php echo e(route('shop.product', $product->slug)); ?>" class="block h-full w-full"
                                                    title="<?php echo e($product->name); ?>">
                                                    <img :src="images[activeIndex]" alt="<?php echo e($product->name); ?>"
                                                        class="h-full w-full object-cover object-center group-hover:scale-105 transition-transform duration-700 ease-in-out">
                                                </a>
                                                </template>

                                                <!-- Arrows -->
                                                <div
                                                    class="absolute inset-0 flex items-center justify-between opacity-0 group-hover:opacity-100 transition-opacity duration-300 pointer-events-none px-2 z-10">
                                                    <button x-show="images.length > 1"
                                                        @click.prevent="activeIndex = activeIndex === 0 ? images.length - 1 : activeIndex - 1"
                                                        class="pointer-events-auto bg-white/90 hover:bg-indigo-600 hover:text-white text-gray-800 rounded-full p-2 focus:outline-none shadow-sm transition-colors">
                                                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                                d="M15 19l-7-7 7-7"></path>
                                                        </svg>
                                                    </button>
                                                    <button x-show="images.length > 1"
                                                        @click.prevent="activeIndex = activeIndex === images.length - 1 ? 0 : activeIndex + 1"
                                                        class="pointer-events-auto bg-white/90 hover:bg-indigo-600 hover:text-white text-gray-800 rounded-full p-2 focus:outline-none shadow-sm transition-colors">
                                                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                                d="M9 5l7 7-7 7"></path>
                                                        </svg>
                                                    </button>
                                                </div>

                                                <!-- Wishlist -->
                                                <button type="button"
                                                    onclick="event.preventDefault(); window.toggleWishlist(<?php echo e($product->id); ?>)"
                                                    class="absolute top-3 right-3 z-20 p-2.5 rounded-full bg-white/90 text-gray-400 hover:text-rose-600 hover:bg-rose-50 transition-colors shadow-md opacity-0 group-hover:opacity-100"
                                                    title="Add to Wishlist">
                                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24"
                                                        stroke="currentColor" stroke-width="2">
                                                        <path stroke-linecap="round" stroke-linejoin="round"
                                                            d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z" />
                                                    </svg>
                                                </button>

                                                <!-- Quick Add -->
                                                <div
                                                    class="absolute bottom-0 inset-x-0 p-4 translate-y-full group-hover:translate-y-0 transition-transform duration-300 ease-in-out">
                                                    <form action="<?php echo e(route('cart.add')); ?>" method="POST">
                                                        <?php echo csrf_field(); ?>
                                                        <input type="hidden" name="product_id" value="<?php echo e($product->id); ?>">
                                                        <input type="hidden" name="quantity" value="1">
                                                        <button type="submit"
                                                            class="w-full bg-[#9B2D69] text-white py-3 px-4 rounded-lg flex items-center justify-center gap-2 uppercase text-xs font-bold tracking-widest hover:bg-[#7a2454] transition-colors shadow-lg shadow-pink-200">
                                                            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none"
                                                                viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                                                                <path stroke-linecap="round" stroke-linejoin="round"
                                                                    d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z" />
                                                            </svg>
                                                            Add to Cart
                                                        </button>
                                                    </form>
                                                </div>
                                            </div>

                                            <div class="p-4">
                                                <h3 class="text-base font-medium text-gray-900 hover:text-[#9B2D69] transition-colors">
                                                    <a href="<?php echo e(route('shop.product', $product->slug)); ?>">
                                                        <span aria-hidden="true" class="absolute inset-0"></span>
                                                        <?php echo e($product->name); ?>

                                                    </a>
                                                </h3>
                                                <div class="mt-2 flex items-baseline space-x-2">
                                                    <p class="text-lg font-bold text-gray-900">₹<?php echo e(number_format($product->sp, 2)); ?></p>
                                                    <?php if($product->mrp > $product->sp): ?>
                                                        <p class="text-xs text-gray-400 line-through">₹<?php echo e(number_format($product->mrp, 2)); ?></p>
                                                        <span
                                                            class="text-xs font-bold text-green-600 bg-green-50 px-2 py-0.5 rounded-full ml-auto">
                                                            <?php echo e(round((($product->mrp - $product->sp) / $product->mrp) * 100)); ?>% Off
                                                        </span>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    <?php if($category->children->isEmpty() && $category->products->isNotEmpty()): ?>
                        <!-- Fallback for categories with no subcategories -->
                        <div class="mb-16">
                            <div class="grid grid-cols-2 sm:grid-cols-2 lg:grid-cols-4 gap-8">
                                <?php $__currentLoopData = $category->products->take(8); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="group relative bg-white">
                                        <!-- Product Card Content -->
                                        <div class="aspect-[3/4] w-full overflow-hidden bg-gray-100 relative"
                                            data-ajax-product-id="<?php echo e($product->id); ?>"
                                            x-data="{ activeIndex: 0, get images() { return $store.productImages.data[<?php echo e($product->id); ?>] || ['https://placehold.co/400x600?text=Loading...'] } }">
                                            <template x-if="images.length > 0">
                                            <a href="<?php echo e(route('shop.product', $product->slug)); ?>" class="block h-full w-full"
                                                title="<?php echo e($product->name); ?>">
                                                <img :src="images[activeIndex]" alt="<?php echo e($product->name); ?>"
                                                    class="h-full w-full object-cover object-center group-hover:scale-105 transition-transform duration-700 ease-in-out">
                                            </a>
                                            </template>

                                            <!-- Arrows (Simplified) -->
                                            <div
                                                class="absolute inset-0 flex items-center justify-between opacity-0 group-hover:opacity-100 transition-opacity duration-300 pointer-events-none px-2 z-10">
                                                <button x-show="images.length > 1"
                                                    @click.prevent="activeIndex = activeIndex === 0 ? images.length - 1 : activeIndex - 1"
                                                    class="pointer-events-auto bg-white/80 hover:bg-white text-gray-800 rounded-full p-2 focus:outline-none shadow-sm transition-colors">
                                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                            d="M15 19l-7-7 7-7"></path>
                                                    </svg>
                                                </button>
                                                <button x-show="images.length > 1"
                                                    @click.prevent="activeIndex = activeIndex === images.length - 1 ? 0 : activeIndex + 1"
                                                    class="pointer-events-auto bg-white/80 hover:bg-white text-gray-800 rounded-full p-2 focus:outline-none shadow-sm transition-colors">
                                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                            d="M9 5l7 7-7 7"></path>
                                                    </svg>
                                                </button>
                                            </div>

                                            <!-- Wishlist -->
                                            <button type="button"
                                                onclick="event.preventDefault(); window.toggleWishlist(<?php echo e($product->id); ?>)"
                                                class="absolute top-3 right-3 z-20 p-2 rounded-full bg-white/90 hover:bg-white text-gray-400 hover:text-red-500 transition-colors shadow-sm opacity-0 group-hover:opacity-100"
                                                title="Add to Wishlist">
                                                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24"
                                                    stroke="currentColor" stroke-width="2">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z" />
                                                </svg>
                                            </button>

                                            <!-- Quick Add -->
                                            <div
                                                class="absolute bottom-0 inset-x-0 p-4 translate-y-full group-hover:translate-y-0 transition-transform duration-300 ease-in-out">
                                                <form action="<?php echo e(route('cart.add')); ?>" method="POST">
                                                    <?php echo csrf_field(); ?>
                                                    <input type="hidden" name="product_id" value="<?php echo e($product->id); ?>">
                                                    <input type="hidden" name="quantity" value="1">
                                                    <button type="submit"
                                                        class="w-full bg-gray-900 text-white py-3 px-4 uppercase text-xs font-bold tracking-widest hover:bg-black transition-colors shadow-lg">
                                                        Add to Cart
                                                    </button>
                                                </form>
                                            </div>
                                        </div>

                                        <div class="mt-4">
                                            <h3 class="text-base text-gray-900 hover:text-[#9B2D69] transition-colors">
                                                <a href="<?php echo e(route('shop.product', $product->slug)); ?>">
                                                    <span aria-hidden="true" class="absolute inset-0"></span>
                                                    <?php echo e($product->name); ?>

                                                </a>
                                            </h3>
                                            <div class="mt-1 flex items-baseline space-x-2">
                                                <p class="font-bold text-gray-900">₹<?php echo e(number_format($product->sp, 2)); ?></p>
                                                <?php if($product->mrp > $product->sp): ?>
                                                    <p class="text-xs text-gray-500 line-through">₹<?php echo e(number_format($product->mrp, 2)); ?></p>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="text-center py-32 bg-gray-50 rounded-xl max-w-7xl mx-auto px-4">
                <svg class="mx-auto h-16 w-16 text-gray-300 mb-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                        d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10" />
                </svg>
                <h2 class="text-3xl font-bold text-gray-900 mb-3">New Collections Arriving Soon</h2>
                <p class="text-gray-500 max-w-md mx-auto">We are curating the best styles for you. Please check back later for
                    our latest arrivals.</p>
            </div>
        <?php endif; ?>
    </div>

    <!-- Testimonials Section -->
    <?php if(isset($testimonials) && $testimonials->count() > 0): ?>
        <div class="bg-amber-50 py-20 overflow-hidden">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative"
                x-data="{ activeTestimonial: 0, count: <?php echo e($testimonials->count()); ?> }"
                x-init="setInterval(() => { activeTestimonial = activeTestimonial === count - 1 ? 0 : activeTestimonial + 1 }, 5000)">
                <div class="text-center mb-12">
                    <h2 class="text-3xl md:text-4xl font-bold tracking-tight text-gray-900 font-serif mb-4">What Our Clients Say
                    </h2>
                    <div class="w-24 h-1 bg-[#9B2D69] mx-auto"></div>
                </div>

                <div class="relative max-w-4xl mx-auto h-64 md:h-48">
                    <?php $__currentLoopData = $testimonials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $testimonial): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="absolute inset-0 flex flex-col items-center justify-center text-center transition-all duration-700 ease-in-out transform"
                            x-show="activeTestimonial === <?php echo e($index); ?>" x-transition:enter="opacity-0 translate-x-12"
                            x-transition:enter-end="opacity-100 translate-x-0" x-transition:leave="opacity-100 translate-x-0"
                            x-transition:leave-end="opacity-0 -translate-x-12"
                            style="<?php echo e($index === 0 ? 'display: flex' : 'display: none'); ?>"
                            :style="activeTestimonial === <?php echo e($index); ?> ? 'display: flex' : 'display: none'">

                            <div class="mb-6">
                                <div class="flex items-center justify-center space-x-1 text-[#9B2D69] mb-4">
                                    <?php for($i = 0; $i < 5; $i++): ?>
                                        <svg class="w-5 h-5 fill-current" viewBox="0 0 24 24">
                                            <path
                                                d="M12 17.27L18.18 21l-1.64-7.03L22 9.24l-7.19-.61L12 2 9.19 8.63 2 9.24l5.46 4.73L5.82 21z" />
                                        </svg>
                                    <?php endfor; ?>
                                </div>
                                <p class="text-xl md:text-2xl text-gray-700 italic font-light leading-relaxed max-w-2xl px-4">
                                    "<?php echo e($testimonial->content); ?>"</p>
                            </div>

                            <div>
                                <h4 class="font-bold text-gray-900 uppercase tracking-widest"><?php echo e($testimonial->name); ?></h4>
                                <?php if($testimonial->designation): ?>
                                    <span class="text-sm text-gray-500 font-medium"><?php echo e($testimonial->designation); ?></span>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>

                <!-- Indicators -->
                <div class="flex justify-center space-x-2 mt-8">
                    <?php $__currentLoopData = $testimonials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $testimonial): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <button @click="activeTestimonial = <?php echo e($index); ?>"
                            class="w-2 h-2 rounded-full transition-colors duration-300"
                            :class="activeTestimonial === <?php echo e($index); ?> ? 'bg-[#9B2D69] w-4' : 'bg-gray-300 hover:bg-gray-400'"></button>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>

                <div class="text-center mt-12">
                    <a href="<?php echo e(route('testimonials.index')); ?>"
                        class="inline-block border border-gray-900 text-gray-900 px-8 py-3 text-xs font-bold uppercase tracking-widest hover:bg-gray-900 hover:text-white transition-colors duration-300">
                        View All Reviews
                    </a>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <!-- Recent Blog Posts -->
    <?php if(isset($recentBlogs) && $recentBlogs->count() > 0): ?>
        <div class="bg-gray-50 py-20 border-t border-gray-200">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="text-center mb-16">
                    <h2 class="text-3xl md:text-4xl font-bold tracking-tight text-gray-900 font-serif mb-4">From Our Blog</h2>
                    <p class="text-gray-500 max-w-2xl mx-auto">Latest insights, health tips, and Ayurvedic wisdom.</p>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-3 gap-10">
                    <?php $__currentLoopData = $recentBlogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div
                            class="bg-white rounded-xl overflow-hidden shadow-sm hover:shadow-xl transition-shadow duration-300 flex flex-col h-full group">
                            <a href="<?php echo e(route('blogs.show', $blog->slug)); ?>" class="block relative h-64 overflow-hidden">
                                <?php if($blog->image): ?>
                                    <img src="<?php echo e(Storage::url($blog->image)); ?>" alt="<?php echo e($blog->title); ?>"
                                        class="w-full h-full object-cover transform group-hover:scale-105 transition-transform duration-700">
                                <?php else: ?>
                                    <div class="w-full h-full bg-gray-200 flex items-center justify-center text-gray-400">
                                        <svg class="w-12 h-12" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z">
                                            </path>
                                        </svg>
                                    </div>
                                <?php endif; ?>
                                <div class="absolute inset-0 bg-black/10 group-hover:bg-black/0 transition-colors duration-300">
                                </div>
                            </a>

                            <div class="p-8 flex-1 flex flex-col">
                                <div class="text-xs font-bold text-[#9B2D69] uppercase tracking-widest mb-3">
                                    <?php echo e($blog->published_at ? $blog->published_at->format('M d, Y') : ''); ?>

                                </div>
                                <a href="<?php echo e(route('blogs.show', $blog->slug)); ?>" class="block mb-4">
                                    <h3
                                        class="text-xl font-bold text-gray-900 group-hover:text-[#9B2D69] transition-colors line-clamp-2">
                                        <?php echo e($blog->title); ?>

                                    </h3>
                                    <p class="mt-3 text-gray-500 line-clamp-3 leading-relaxed">
                                        <?php echo e($blog->excerpt); ?>

                                    </p>
                                </a>
                                <div class="mt-auto pt-4 flex items-center justify-between">
                                    <a href="<?php echo e(route('blogs.show', $blog->slug)); ?>"
                                        class="text-sm font-bold uppercase tracking-wider text-gray-900 hover:text-[#9B2D69] transition-colors inline-flex items-center group/link">
                                        Read Article <span
                                            class="ml-2 transform group-hover/link:translate-x-1 transition-transform">&rarr;</span>
                                    </a>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>

                <div class="mt-16 text-center">
                    <a href="<?php echo e(route('blogs.index')); ?>"
                        class="inline-block border-2 border-gray-900 text-gray-900 px-10 py-3 font-bold uppercase tracking-widest text-sm hover:bg-gray-900 hover:text-white transition-colors duration-300">
                        View All Posts
                    </a>
                </div>
            </div>
        </div>
    <?php endif; ?>


    <script>
        document.addEventListener('alpine:init', () => {
            Alpine.store('productImages', {
                data: {},
                set(productId, images) {
                    this.data[productId] = images;
                }
            });
        });

        document.addEventListener('DOMContentLoaded', () => {
            const CACHE_KEY = 'home_product_images';
            const CACHE_TTL = 3600000; // 1 hour

            const getCachedData = () => {
                const cached = localStorage.getItem(CACHE_KEY);
                if (!cached) return {};
                const parsed = JSON.parse(cached);
                if (Date.now() - parsed.timestamp > CACHE_TTL) return {};
                return parsed.data || {};
            };

            const setCachedData = (data) => {
                localStorage.setItem(CACHE_KEY, JSON.stringify({
                    timestamp: Date.now(),
                    data: data
                }));
            };

            setTimeout(() => {
                const productIds = Array.from(document.querySelectorAll('[data-ajax-product-id]'))
                    .map(el => el.dataset.ajaxProductId);

                const uniqueIds = [...new Set(productIds)];
                if (uniqueIds.length === 0) return;

                // 1. Show Cache immediately (Instant feel)
                const cache = getCachedData();
                for (const id of uniqueIds) {
                    if (cache[id]) {
                        Alpine.store('productImages').set(id, cache[id]);
                    }
                }

                // 2. Background Revalidation (Always fetch in background to sync)
                fetch(`/api/customer/product-images?ids=${uniqueIds.join(',')}`)
                    .then(res => res.json())
                    .then(freshData => {
                        let changed = false;
                        for (const id in freshData) {
                            // Update UI if data is different from cache
                            if (JSON.stringify(freshData[id]) !== JSON.stringify(cache[id])) {
                                changed = true;
                                Alpine.store('productImages').set(id, freshData[id]);
                            }
                        }

                        // Update cache for next visit
                        if (changed || Object.keys(cache).length === 0) {
                            setCachedData(freshData);
                        }
                    })
                    .catch(err => console.warn('Sync failed:', err));
            }, 50);
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.shop', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/truetransit/public_html/hairniche.in/resources/views/home.blade.php ENDPATH**/ ?>