<?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div
        class="group relative bg-white rounded-2xl overflow-hidden border border-gray-100 shadow-sm hover:shadow-xl transition-all duration-300 flex flex-col h-full">
        <div class="aspect-w-1 aspect-h-1 w-full overflow-hidden bg-gray-50 relative" x-data="{
                        activeIndex: 0,
                        images: [
                            <?php $__currentLoopData = $product->images->sortBy('sort_order'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $img): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                '<?php echo e($img->image_path); ?>',
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php if($product->images->isEmpty()): ?>
                                'https://placehold.co/600x600?text=No+Image'
                            <?php endif; ?>
                        ]
                     }">

            <template x-if="images.length > 0">
                <a href="<?php echo e(route('shop.product', $product->slug)); ?>" class="block h-full w-full aspect-square"
                    title="<?php echo e($product->name); ?>">
                    <img :src="images[activeIndex]" alt="<?php echo e($product->name); ?>"
                        class="h-full w-full object-cover object-center transition-opacity duration-300 group-hover:scale-105 transition-transform duration-700 ease-in-out">
                </a>
            </template>

            <!-- Arrows (Only Desktop) -->
            <div
                class="absolute inset-0 hidden md:flex items-center justify-between opacity-0 group-hover:opacity-100 transition-opacity duration-300 pointer-events-none px-2 z-10">
                <button x-show="images.length > 1"
                    @click.prevent="activeIndex = activeIndex === 0 ? images.length - 1 : activeIndex - 1"
                    class="pointer-events-auto bg-white/95 hover:bg-[#9B2D69] hover:text-white text-gray-800 rounded-full p-2 focus:outline-none shadow-md transition-all">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
                    </svg>
                </button>
                <button x-show="images.length > 1"
                    @click.prevent="activeIndex = activeIndex === images.length - 1 ? 0 : activeIndex + 1"
                    class="pointer-events-auto bg-white/95 hover:bg-[#9B2D69] hover:text-white text-gray-800 rounded-full p-2 focus:outline-none shadow-md transition-all">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                    </svg>
                </button>
            </div>

            <!-- Wishlist Button -->
            <button type="button" onclick="event.preventDefault(); window.toggleWishlist(<?php echo e($product->id); ?>)"
                class="absolute top-2 right-2 md:top-3 md:right-3 z-20 p-2 md:p-2.5 rounded-full bg-white/90 text-gray-400 hover:text-rose-600 hover:bg-rose-50 transition-all shadow-md md:opacity-0 md:group-hover:opacity-100"
                title="Add to Wishlist">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 md:h-5 md:w-5" fill="none" viewBox="0 0 24 24"
                    stroke="currentColor" stroke-width="2">
                    <path stroke-linecap="round" stroke-linejoin="round"
                        d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z" />
                </svg>
            </button>

            <!-- Quick Add / Cart (Desktop Overlay) -->
            <div
                class="absolute bottom-0 inset-x-0 p-4 translate-y-full group-hover:translate-y-0 transition-transform duration-300 ease-in-out hidden md:block">
                <form action="<?php echo e(route('cart.add')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="product_id" value="<?php echo e($product->id); ?>">
                    <input type="hidden" name="quantity" value="1">
                    <button type="submit"
                        class="w-full bg-[#9B2D69] text-white py-3 px-4 rounded-xl flex items-center justify-center gap-2 uppercase text-[10px] font-bold tracking-widest hover:bg-[#7a2454] transition-all shadow-xl shadow-pink-100">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24"
                            stroke="currentColor" stroke-width="2">
                            <path stroke-linecap="round" stroke-linejoin="round"
                                d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z" />
                        </svg>
                        Add to Cart
                    </button>
                </form>
            </div>
        </div>

        <div class="p-4 flex flex-col flex-grow">
            <h3
                class="text-sm md:text-base font-bold text-gray-900 group-hover:text-[#9B2D69] transition-colors line-clamp-2">
                <a href="<?php echo e(route('shop.product', $product->slug)); ?>" title="<?php echo e($product->name); ?>">
                    <?php echo e($product->name); ?>

                </a>
            </h3>

            <div class="mt-auto pt-3 flex items-center justify-between">
                <div class="flex flex-col">
                    <?php if($product->variations->count() > 0): ?>
                        <span class="text-lg font-extrabold text-[#9B2D69]">
                            ₹<?php echo e(number_format($product->variations->min('sp'), 0)); ?>

                        </span>
                        <?php if($product->variations->max('mrp') > $product->variations->min('sp')): ?>
                            <div class="flex items-center gap-2">
                                <span
                                    class="text-xs text-gray-400 line-through">₹<?php echo e(number_format($product->variations->max('mrp'), 0)); ?></span>
                                <span class="text-[10px] font-bold text-green-600 bg-green-50 px-1.5 py-0.5 rounded">
                                    <?php echo e(round((($product->variations->max('mrp') - $product->variations->min('sp')) / $product->variations->max('mrp')) * 100)); ?>%
                                    Off
                                </span>
                            </div>
                        <?php endif; ?>
                    <?php else: ?>
                        <span class="text-sm font-bold text-gray-400">N/A</span>
                    <?php endif; ?>
                </div>

                <!-- Mobile Cart Button -->
                <div class="md:hidden">
                    <form action="<?php echo e(route('cart.add')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="product_id" value="<?php echo e($product->id); ?>">
                        <input type="hidden" name="quantity" value="1">
                        <button type="submit"
                            class="p-2.5 rounded-full bg-gray-900 text-white shadow-lg active:scale-95 transition-all">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24"
                                stroke="currentColor" stroke-width="2.5">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M12 4v16m8-8H4" />
                            </svg>
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php /**PATH /home/truetransit/public_html/hairniche.in/resources/views/shop/partials/product-grid.blade.php ENDPATH**/ ?>