

<?php $__env->startSection('title', 'Register - Hair Niche'); ?>

<?php $__env->startSection('content'); ?>
    <div class="min-h-screen flex items-center justify-center bg-gray-50 py-12 px-4 sm:px-6 lg:px-8">
        <div class="max-w-md w-full space-y-8 bg-white p-10 rounded-2xl shadow-xl">
            <div>
                <h2 class="mt-2 text-center text-3xl font-extrabold text-gray-900 tracking-tight">
                    Create Account
                </h2>
                <p class="mt-2 text-center text-sm text-gray-600">
                    Already have an account?
                    <a href="<?php echo e(route('login')); ?>"
                        class="font-medium text-[#9B2D69] hover:text-[#7a2454] transition-colors">
                        Sign in instead
                    </a>
                </p>
            </div>

            <form class="mt-8 space-y-6" action="<?php echo e(route('register.submit')); ?>" method="POST" x-data="{ 
                                                          password: '', 
                                                          passwordConfirm: '',
                                                          showPassword: false,
                                                          showConfirm: false,
                                                          strength: 0,
                                                          calculateStrength() {
                                                              let score = 0;
                                                              if (this.password.length >= 8) score++;
                                                              if (this.password.match(/[a-z]/) && this.password.match(/[A-Z]/)) score++;
                                                              if (this.password.match(/\d/)) score++;
                                                              if (this.password.match(/[^a-zA-Z\d]/)) score++;
                                                              this.strength = score;
                                                          }
                                                      }">
                <?php echo csrf_field(); ?>

                <div class="space-y-5">
                    <!-- Name -->
                    <div>
                        <label for="name" class="block text-sm font-medium text-gray-700">Full Name</label>
                        <div class="mt-1 relative rounded-md shadow-sm">
                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                <svg class="h-5 w-5 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z" />
                                </svg>
                            </div>
                            <input id="name" name="name" type="text" autocomplete="name" required
                                class="appearance-none block w-full pl-10 px-3 py-3 border border-gray-300 rounded-lg shadow-sm placeholder-gray-400 focus:outline-none focus:ring-[#9B2D69] focus:border-[#9B2D69] sm:text-sm transition-all duration-200"
                                placeholder="John Doe" value="<?php echo e(old('name')); ?>">
                        </div>
                    </div>

                    <!-- Email -->
                    <div>
                        <label for="email-address" class="block text-sm font-medium text-gray-700">Email address</label>
                        <div class="mt-1 relative rounded-md shadow-sm">
                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                <svg class="h-5 w-5 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z" />
                                </svg>
                            </div>
                            <input id="email-address" name="email" type="email" autocomplete="email" required
                                class="appearance-none block w-full pl-10 px-3 py-3 border border-gray-300 rounded-lg shadow-sm placeholder-gray-400 focus:outline-none focus:ring-[#9B2D69] focus:border-[#9B2D69] sm:text-sm transition-all duration-200"
                                placeholder="you@example.com" value="<?php echo e(old('email')); ?>">
                        </div>
                    </div>

                    <!-- Mobile Number -->
                    <div>
                        <label for="mobile" class="block text-sm font-medium text-gray-700">Mobile Number</label>
                        <div class="mt-1 relative rounded-md shadow-sm">
                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                <svg class="h-5 w-5 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z" />
                                </svg>
                            </div>
                            <input id="mobile" name="mobile" type="tel" autocomplete="tel" required
                                class="appearance-none block w-full pl-10 px-3 py-3 border border-gray-300 rounded-lg shadow-sm placeholder-gray-400 focus:outline-none focus:ring-[#9B2D69] focus:border-[#9B2D69] sm:text-sm transition-all duration-200"
                                placeholder="1234567890" value="<?php echo e(old('mobile')); ?>">
                        </div>
                    </div>

                    <!-- Password -->
                    <div>
                        <label for="password" class="block text-sm font-medium text-gray-700">Password</label>
                        <div class="mt-1 relative rounded-md shadow-sm">
                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                <svg class="h-5 w-5 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z" />
                                </svg>
                            </div>
                            <input id="password" name="password" :type="showPassword ? 'text' : 'password'"
                                autocomplete="new-password" required x-model="password" @input="calculateStrength()"
                                class="appearance-none block w-full pl-10 px-3 py-3 border border-gray-300 rounded-lg shadow-sm placeholder-gray-400 focus:outline-none focus:ring-[#9B2D69] focus:border-[#9B2D69] sm:text-sm transition-all duration-200 pr-10"
                                placeholder="Min 8 chars, mixed case & symbols">
                            <div class="absolute inset-y-0 right-0 pr-3 flex items-center cursor-pointer"
                                @click="showPassword = !showPassword">
                                <svg x-show="!showPassword" class="h-5 w-5 text-gray-400 hover:text-gray-600" fill="none"
                                    viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
                                </svg>
                                <svg x-show="showPassword" x-cloak class="h-5 w-5 text-gray-400 hover:text-gray-600"
                                    fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M13.875 18.825A10.05 10.05 0 0112 19c-4.478 0-8.268-2.943-9.543-7a9.97 9.97 0 011.563-3.029m5.858.908a3 3 0 114.243 4.243M9.878 9.878l4.242 4.242M9.88 9.88l-3.29-3.29m7.532 7.532l3.29 3.29M3 3l3.59 3.59m0 0A9.953 9.953 0 0112 5c4.478 0 8.268 2.943 9.543 7a10.025 10.025 0 01-4.132 5.411m0 0L21 21" />
                                </svg>
                            </div>
                        </div>

                        <!-- Password Strength Indicator -->
                        <div class="mt-2" x-show="password.length > 0" x-transition>
                            <div class="flex items-center space-x-1 h-1">
                                <div class="flex-1 rounded-full h-full transition-colors duration-300"
                                    :class="strength >= 1 ? (strength == 1 ? 'bg-red-500' : (strength == 2 ? 'bg-yellow-500' : (strength == 3 ? 'bg-blue-500' : 'bg-green-500'))) : 'bg-gray-200'">
                                </div>
                                <div class="flex-1 rounded-full h-full transition-colors duration-300"
                                    :class="strength >= 2 ? (strength == 2 ? 'bg-yellow-500' : (strength == 3 ? 'bg-blue-500' : 'bg-green-500')) : 'bg-gray-200'">
                                </div>
                                <div class="flex-1 rounded-full h-full transition-colors duration-300"
                                    :class="strength >= 3 ? (strength == 3 ? 'bg-blue-500' : 'bg-green-500') : 'bg-gray-200'">
                                </div>
                                <div class="flex-1 rounded-full h-full transition-colors duration-300"
                                    :class="strength >= 4 ? 'bg-green-500' : 'bg-gray-200'"></div>
                            </div>
                            <p class="text-xs mt-1 transition-colors duration-300"
                                :class="strength < 2 ? 'text-red-500' : (strength < 3 ? 'text-yellow-600' : 'text-green-600')"
                                x-text="strength == 0 ? 'Very Weak' : (strength == 1 ? 'Weak' : (strength == 2 ? 'Fair' : (strength == 3 ? 'Good' : 'Speedy')))">
                            </p>

                            <!-- Detailed Rules -->
                            <ul class="mt-2 space-y-1 text-xs text-gray-500">
                                <li class="flex items-center">
                                    <svg class="h-3 w-3 mr-1"
                                        :class="password.length >= 8 ? 'text-green-500' : 'text-gray-300'"
                                        fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd"
                                            d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z"
                                            clip-rule="evenodd" />
                                    </svg>
                                    At least 8 characters
                                </li>
                                <li class="flex items-center">
                                    <svg class="h-3 w-3 mr-1"
                                        :class="password.match(/[a-z]/) && password.match(/[A-Z]/) ? 'text-green-500' : 'text-gray-300'"
                                        fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd"
                                            d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z"
                                            clip-rule="evenodd" />
                                    </svg>
                                    Mixed uppercase & lowercase
                                </li>
                                <li class="flex items-center">
                                    <svg class="h-3 w-3 mr-1"
                                        :class="password.match(/\d/) ? 'text-green-500' : 'text-gray-300'"
                                        fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd"
                                            d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z"
                                            clip-rule="evenodd" />
                                    </svg>
                                    Contains a number
                                </li>
                                <li class="flex items-center">
                                    <svg class="h-3 w-3 mr-1"
                                        :class="password.match(/[^a-zA-Z\d]/) ? 'text-green-500' : 'text-gray-300'"
                                        fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd"
                                            d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z"
                                            clip-rule="evenodd" />
                                    </svg>
                                    Contains a symbol
                                </li>
                            </ul>
                        </div>
                    </div>

                    <!-- Confirm Password -->
                    <div>
                        <label for="password-confirm" class="block text-sm font-medium text-gray-700">Confirm
                            Password</label>
                        <div class="mt-1 relative rounded-md shadow-sm">
                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                <svg class="h-5 w-5 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z" />
                                </svg>
                            </div>
                            <input id="password-confirm" name="password_confirmation"
                                :type="showConfirm ? 'text' : 'password'" autocomplete="new-password" required
                                x-model="passwordConfirm"
                                class="appearance-none block w-full pl-10 px-3 py-3 border border-gray-300 rounded-lg shadow-sm placeholder-gray-400 focus:outline-none focus:ring-[#9B2D69] focus:border-[#9B2D69] sm:text-sm transition-all duration-200 pr-10"
                                placeholder="Confirm your password">
                            <div class="absolute inset-y-0 right-0 pr-3 flex items-center cursor-pointer"
                                @click="showConfirm = !showConfirm">
                                <svg x-show="!showConfirm" class="h-5 w-5 text-gray-400 hover:text-gray-600" fill="none"
                                    viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
                                </svg>
                                <svg x-show="showConfirm" x-cloak class="h-5 w-5 text-gray-400 hover:text-gray-600"
                                    fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M13.875 18.825A10.05 10.05 0 0112 19c-4.478 0-8.268-2.943-9.543-7a9.97 9.97 0 011.563-3.029m5.858.908a3 3 0 114.243 4.243M9.878 9.878l4.242 4.242M9.88 9.88l-3.29-3.29m7.532 7.532l3.29 3.29M3 3l3.59 3.59m0 0A9.953 9.953 0 0112 5c4.478 0 8.268 2.943 9.543 7a10.025 10.025 0 01-4.132 5.411m0 0L21 21" />
                                </svg>
                            </div>
                        </div>
                        <p x-show="passwordConfirm && password !== passwordConfirm" class="mt-1 text-xs text-red-500">
                            Passwords do not match</p>
                    </div>
                </div>

                <?php if($errors->any()): ?>
                    <div class="rounded-md bg-red-50 p-4 border border-red-200">
                        <div class="flex">
                            <div class="flex-shrink-0">
                                <svg class="h-5 w-5 text-red-400" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"
                                    fill="currentColor" aria-hidden="true">
                                    <path fill-rule="evenodd"
                                        d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z"
                                        clip-rule="evenodd" />
                                </svg>
                            </div>
                            <div class="ml-3">
                                <h3 class="text-sm font-medium text-red-800">
                                    There were errors with your submission
                                </h3>
                                <div class="mt-2 text-sm text-red-700">
                                    <ul class="list-disc pl-5 space-y-1">
                                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li><?php echo e($error); ?></li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

                <div>
                    <button type="submit"
                        class="group relative w-full flex justify-center py-3 px-4 border border-transparent text-sm font-bold rounded-lg text-white bg-[#9B2D69] hover:bg-[#7a2454] focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-[#9B2D69] transition-all duration-200 shadow-md hover:shadow-lg transform hover:-translate-y-0.5">
                        <span class="absolute left-0 inset-y-0 flex items-center pl-3">
                            <svg class="h-5 w-5 text-pink-300 group-hover:text-pink-200 transition-colors"
                                xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor"
                                aria-hidden="true">
                                <path
                                    d="M8 9a3 3 0 100-6 3 3 0 000 6zM8 11a6 6 0 016 6H2a6 6 0 016-6zM16 7a1 1 0 10-2 0 1 1 0 002 0zM16 9a1 1 0 10-2 0 1 1 0 002 0z" />
                            </svg>
                        </span>
                        Create Account
                    </button>
                </div>
            </form>

            <div class="mt-6">
                <div class="relative">
                    <div class="absolute inset-0 flex items-center">
                        <div class="w-full border-t border-gray-300"></div>
                    </div>
                    <div class="relative flex justify-center text-sm">
                        <span class="px-2 bg-white text-gray-500">
                            Or continue with
                        </span>
                    </div>
                </div>

                <div class="mt-6">
                    <a href="<?php echo e(route('auth.google')); ?>"
                        class="w-full flex items-center justify-center px-4 py-3 border border-gray-300 rounded-lg shadow-sm text-sm font-medium text-gray-700 bg-white hover:bg-gray-50 hover:text-gray-900 transition-all duration-200 transform hover:-translate-y-0.5">
                        <img class="h-5 w-5 mr-3" src="https://www.svgrepo.com/show/475656/google-color.svg"
                            alt="Google logo">
                        Sign up with Google
                    </a>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.shop', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/truetransit/public_html/hairniche.in/resources/views/auth/register.blade.php ENDPATH**/ ?>