<?php
    $generalSettings = \App\Models\GeneralSetting::first();
    $fontFamilyConfig = $generalSettings?->admin_font_family ?? "'Inter', sans-serif";
    $fontSize = $generalSettings?->admin_font_size;

    // Check if it's a simple font name or a complex string
    $isCustomGoogleFont = !str_contains($fontFamilyConfig, ',');
    $importFont = $isCustomGoogleFont ? $fontFamilyConfig : null;
    $fontFamilyValue = $isCustomGoogleFont ? "'$fontFamilyConfig', sans-serif" : $fontFamilyConfig;
?>

<?php if($importFont): ?>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=<?php echo e(str_replace(' ', '+', $importFont)); ?>:wght@300;400;500;600;700&display=swap"
        rel="stylesheet">
<?php endif; ?>

<style>
    html {
        <?php if($fontSize): ?>
            font-size:
                <?php echo e($fontSize); ?>

                !important;
        <?php endif; ?>
    }

    body {
        font-family:
            <?php echo $fontFamilyValue; ?>

            !important;
    }
</style><?php /**PATH /home/truetransit/public_html/hairniche.in/resources/views/admin/partials/styles.blade.php ENDPATH**/ ?>