

<?php $__env->startSection('title', 'Testimonials - Hair Niche By Shelly'); ?>

<?php $__env->startSection('content'); ?>
    <div class="bg-white py-16 px-4 sm:px-6 lg:px-8">
        <div class="max-w-7xl mx-auto">
            <div class="text-center">
                <h2 class="text-base font-semibold text-indigo-600 tracking-wide uppercase">Testimonials</h2>
                <p class="mt-1 text-4xl font-extrabold text-gray-900 sm:text-5xl sm:tracking-tight lg:text-6xl">What our
                    customers say</p>
                <p class="max-w-xl mt-5 mx-auto text-xl text-gray-500">Read what our valued customers have to say about
                    their experience with Lugani.</p>
            </div>

            <div class="mt-16 grid gap-8 lg:grid-cols-2 lg:gap-x-12">
                <?php $__empty_1 = true; $__currentLoopData = $testimonials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $testimonial): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="bg-gray-50 rounded-2xl p-8 shadow-sm flex flex-col justify-between">
                        <div>
                            <div class="flex items-center space-x-2 text-amber-400 mb-4">
                                <!-- 5 Stars -->
                                <?php for($i = 0; $i < 5; $i++): ?>
                                    <svg class="w-5 h-5 fill-current" viewBox="0 0 24 24">
                                        <path
                                            d="M12 17.27L18.18 21l-1.64-7.03L22 9.24l-7.19-.61L12 2 9.19 8.63 2 9.24l5.46 4.73L5.82 21z" />
                                    </svg>
                                <?php endfor; ?>
                            </div>
                            <p class="text-gray-600 italic">"<?php echo e($testimonial->content); ?>"</p>
                        </div>
                        <div class="mt-6 flex items-center">
                            <div class="flex-shrink-0">
                                <span
                                    class="inline-block h-10 w-10 rounded-full overflow-hidden bg-gray-100 items-center justify-center flex text-gray-500 font-bold">
                                    <?php echo e(substr($testimonial->name, 0, 1)); ?>

                                </span>
                            </div>
                            <div class="ml-4">
                                <div class="text-base font-medium text-gray-900"><?php echo e($testimonial->name); ?></div>
                                <?php if($testimonial->designation): ?>
                                    <div class="text-sm text-gray-500"><?php echo e($testimonial->designation); ?></div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <div class="col-span-full text-center text-gray-500">No testimonials available yet.</div>
                <?php endif; ?>
            </div>

            <div class="mt-12">
                <?php echo e($testimonials->links()); ?>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.shop', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/truetransit/public_html/hairniche.in/resources/views/pages/testimonials/index.blade.php ENDPATH**/ ?>