
<?php $__env->startPush('schema_markup'); ?>
    <?php
        $contactSchema = \App\Models\SeoSetting::where('page_name', 'contact')->value('schema_markup');
    ?>
    <?php if($contactSchema): ?>
        <?php echo $contactSchema; ?>

    <?php endif; ?>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="bg-white">
        <!-- Header -->
        <div class="bg-gray-50 py-16 px-4 sm:px-6 lg:px-8">
            <div class="max-w-7xl mx-auto text-center">
                <h2 class="text-base font-semibold text-[#9B2D69] tracking-wide uppercase">Contact Us</h2>
                <p class="mt-2 text-3xl leading-8 font-extrabold tracking-tight text-gray-900 sm:text-4xl">Get in touch</p>
                <p class="mt-4 max-w-2xl text-xl text-gray-500 mx-auto">We'd love to hear from you. Send us a message and
                    we'll respond as soon as possible.</p>
            </div>
        </div>

        <!-- Contact Section -->
        <div class="max-w-7xl mx-auto py-16 px-4 sm:px-6 lg:px-8">
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 lg:gap-24">

                <!-- Contact Info (Colorful Cards) -->
                <div class="space-y-8">
                    <div>
                        <h3 class="text-2xl font-bold text-gray-900 tracking-tight">Contact Information</h3>
                        <p class="mt-4 text-lg text-gray-500 leading-relaxed">
                            Have questions about our products or need assistance? We're here to help! Reach out to us
                            through any of the channels below.
                        </p>
                    </div>

                    <div class="grid gap-6">
                        <!-- Phone Card -->
                        <div
                            class="group flex items-center p-6 bg-blue-50 border border-blue-100 rounded-2xl hover:shadow-lg transition-all duration-300 transform hover:-translate-y-1">
                            <div
                                class="flex-shrink-0 p-4 bg-white rounded-xl shadow-sm group-hover:scale-110 transition-transform duration-300">
                                <svg class="h-8 w-8 text-blue-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                                        d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z" />
                                </svg>
                            </div>
                            <div class="ml-6">
                                <p class="text-sm font-bold text-blue-900 uppercase tracking-widest">Call Us</p>
                                <p class="mt-1 text-lg font-medium text-gray-900 font-serif">
                                    <?php echo e($settings->phone_support ?? '+91-1234567890'); ?>

                                </p>
                            </div>
                        </div>

                        <!-- Email Card -->
                        <div
                            class="group flex items-center p-6 bg-purple-50 border border-purple-100 rounded-2xl hover:shadow-lg transition-all duration-300 transform hover:-translate-y-1">
                            <div
                                class="flex-shrink-0 p-4 bg-white rounded-xl shadow-sm group-hover:scale-110 transition-transform duration-300">
                                <svg class="h-8 w-8 text-purple-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                                        d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z" />
                                </svg>
                            </div>
                            <div class="ml-6">
                                <p class="text-sm font-bold text-purple-900 uppercase tracking-widest">Email Us</p>
                                <p class="mt-1 text-lg font-medium text-gray-900">
                                    <?php echo e($settings->email_support ?? 'support@lugani.com'); ?>

                                </p>
                            </div>
                        </div>

                        <!-- Address Card -->
                        <div
                            class="group flex items-center p-6 bg-emerald-50 border border-emerald-100 rounded-2xl hover:shadow-lg transition-all duration-300 transform hover:-translate-y-1">
                            <div
                                class="flex-shrink-0 p-4 bg-white rounded-xl shadow-sm group-hover:scale-110 transition-transform duration-300">
                                <svg class="h-8 w-8 text-emerald-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                                        d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z" />
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                                        d="M15 11a3 3 0 11-6 0 3 3 0 016 0z" />
                                </svg>
                            </div>
                            <div class="ml-6">
                                <p class="text-sm font-bold text-emerald-900 uppercase tracking-widest">Visit Us</p>
                                <p class="mt-1 text-lg font-medium text-gray-900 leading-snug">
                                    <?php echo nl2br(e($settings->address_head ?? '123 Lugani Street, City, Country')); ?>

                                </p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Contact Form -->
                <div class="bg-white rounded-3xl shadow-xl border border-gray-100 overflow-hidden relative">
                    <div
                        class="absolute top-0 left-0 w-full h-2 bg-gradient-to-r from-[#9B2D69] via-purple-500 to-pink-500">
                    </div>
                    <div class="p-8 sm:p-10">
                        <h3 class="text-2xl font-bold text-gray-900 mb-2">Send us a Message</h3>
                        <p class="text-gray-500 mb-8">We usually respond within 24 hours.</p>

                        <?php if(session('success')): ?>
                            <div class="rounded-xl bg-green-50 p-4 mb-6 border border-green-100">
                                <div class="flex">
                                    <div class="flex-shrink-0">
                                        <svg class="h-5 w-5 text-green-500" xmlns="http://www.w3.org/2000/svg"
                                            viewBox="0 0 20 20" fill="currentColor">
                                            <path fill-rule="evenodd"
                                                d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z"
                                                clip-rule="evenodd" />
                                        </svg>
                                    </div>
                                    <div class="ml-3">
                                        <h3 class="text-sm font-medium text-green-800">Message Sent!</h3>
                                        <div class="mt-1 text-sm text-green-700">
                                            <p><?php echo e(session('success')); ?></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>

                        <?php if($errors->any()): ?>
                            <div class="rounded-xl bg-red-50 p-4 mb-6 border border-red-100">
                                <div class="flex">
                                    <div class="flex-shrink-0">
                                        <svg class="h-5 w-5 text-red-500" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"
                                            fill="currentColor">
                                            <path fill-rule="evenodd"
                                                d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z"
                                                clip-rule="evenodd" />
                                        </svg>
                                    </div>
                                    <div class="ml-3">
                                        <h3 class="text-sm font-medium text-red-800">Errors found</h3>
                                        <ul class="mt-1 text-sm text-red-700 list-disc pl-5">
                                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li><?php echo e($error); ?></li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>

                        <form action="<?php echo e(route('pages.contact.store')); ?>" method="POST" class="space-y-6">
                            <?php echo csrf_field(); ?>
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <div>
                                    <label for="name" class="block text-sm font-bold text-gray-700 mb-2">Name</label>
                                    <div class="relative rounded-xl shadow-sm">
                                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                            <svg class="h-5 w-5 text-gray-400" fill="none" viewBox="0 0 24 24"
                                                stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z" />
                                            </svg>
                                        </div>
                                        <input type="text" name="name" id="name" value="<?php echo e(old('name')); ?>"
                                            class="pl-10 block w-full border-gray-200 rounded-xl bg-gray-50 focus:bg-white focus:ring-[#9B2D69] focus:border-[#9B2D69] py-3 sm:text-sm transition-colors"
                                            placeholder="Your name" required>
                                    </div>
                                </div>
                                <div>
                                    <label for="phone" class="block text-sm font-bold text-gray-700 mb-2">Phone</label>
                                    <div class="relative rounded-xl shadow-sm">
                                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                            <svg class="h-5 w-5 text-gray-400" fill="none" viewBox="0 0 24 24"
                                                stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z" />
                                            </svg>
                                        </div>
                                        <input type="tel" name="phone" id="phone" value="<?php echo e(old('phone')); ?>"
                                            class="pl-10 block w-full border-gray-200 rounded-xl bg-gray-50 focus:bg-white focus:ring-[#9B2D69] focus:border-[#9B2D69] py-3 sm:text-sm transition-colors"
                                            placeholder="Phone number">
                                    </div>
                                </div>
                            </div>

                            <div>
                                <label for="email" class="block text-sm font-bold text-gray-700 mb-2">Email</label>
                                <div class="relative rounded-xl shadow-sm">
                                    <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                        <svg class="h-5 w-5 text-gray-400" fill="none" viewBox="0 0 24 24"
                                            stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z" />
                                        </svg>
                                    </div>
                                    <input type="email" name="email" id="email" value="<?php echo e(old('email')); ?>"
                                        class="pl-10 block w-full border-gray-200 rounded-xl bg-gray-50 focus:bg-white focus:ring-[#9B2D69] focus:border-[#9B2D69] py-3 sm:text-sm transition-colors"
                                        placeholder="you@example.com" required>
                                </div>
                            </div>

                            <div>
                                <label for="subject" class="block text-sm font-bold text-gray-700 mb-2">Subject</label>
                                <div class="relative rounded-xl shadow-sm">
                                    <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                        <svg class="h-5 w-5 text-gray-400" fill="none" viewBox="0 0 24 24"
                                            stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z" />
                                        </svg>
                                    </div>
                                    <input type="text" name="subject" id="subject" value="<?php echo e(old('subject')); ?>"
                                        class="pl-10 block w-full border-gray-200 rounded-xl bg-gray-50 focus:bg-white focus:ring-[#9B2D69] focus:border-[#9B2D69] py-3 sm:text-sm transition-colors"
                                        placeholder="What is this about?" required>
                                </div>
                            </div>

                            <div>
                                <label for="message" class="block text-sm font-bold text-gray-700 mb-2">Message</label>
                                <div class="relative rounded-xl shadow-sm">
                                    <textarea id="message" name="message" rows="4"
                                        class="pl-4 block w-full border-gray-200 rounded-xl bg-gray-50 focus:bg-white focus:ring-[#9B2D69] focus:border-[#9B2D69] py-3 sm:text-sm transition-colors"
                                        placeholder="How can we help you today?" required><?php echo e(old('message')); ?></textarea>
                                </div>
                            </div>

                            <div>
                                <button type="submit"
                                    class="w-full flex justify-center py-4 px-4 border border-transparent rounded-xl shadow-lg text-sm font-bold text-white bg-[#9B2D69] hover:bg-[#7a2454] focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-[#9B2D69] transition-all transform hover:-translate-y-0.5">
                                    Send Message
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Store Locations Section -->
    <?php if($stores->count() > 0): ?>
        <div class="bg-gray-50 py-16 px-4 sm:px-6 lg:px-8">
            <div class="max-w-7xl mx-auto">
                <h3 class="text-2xl font-bold text-gray-900 mb-8 text-center uppercase tracking-wide">Our Store Locations</h3>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                    <?php $__currentLoopData = $stores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $store): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="bg-white p-6 rounded-lg shadow-sm border border-gray-100 flex flex-col h-full">
                            <h4 class="text-lg font-bold text-gray-900 mb-2"><?php echo e($store->name); ?></h4>
                            <p class="text-gray-600 mb-4 text-sm leading-relaxed">
                                <?php echo e($store->address_line1); ?><br>
                                <?php if($store->address_line2): ?> <?php echo e($store->address_line2); ?><br> <?php endif; ?>
                                <?php echo e($store->city); ?>, <?php echo e($store->state); ?> <?php echo e($store->postal_code); ?><br>
                                <?php echo e($store->country); ?>

                            </p>

                            <?php if($store->phone): ?>
                                <p class="text-gray-500 text-sm mb-1"><span class="font-medium">Phone:</span> <?php echo e($store->phone); ?></p>
                            <?php endif; ?>
                            <?php if($store->email): ?>
                                <p class="text-gray-500 text-sm mb-4"><span class="font-medium">Email:</span> <?php echo e($store->email); ?></p>
                            <?php endif; ?>

                            <div class="mt-auto">
                                <?php if($store->map_iframe): ?>
                                    <div class="w-full h-64 bg-gray-200 rounded-lg overflow-hidden relative">
                                        <!-- Render raw HTML for iframe -->
                                        <?php echo $store->map_iframe; ?>

                                    </div>
                                <?php else: ?>
                                    <div
                                        class="w-full h-64 bg-gray-100 rounded-lg flex items-center justify-center text-gray-400 text-sm">
                                        Map not available
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.shop', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/truetransit/public_html/hairniche.in/resources/views/pages/contact.blade.php ENDPATH**/ ?>