<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $__env->yieldContent('title', 'Admin Dashboard'); ?> - Hair Niche Admin</title>
    <?php
        $settings = \App\Models\GeneralSetting::first();
    ?>
    <?php if($settings && $settings->favicon): ?>
        <link rel="icon" href="<?php echo e(Storage::url($settings->favicon)); ?>" type="image/x-icon">
    <?php endif; ?>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    <script defer src="https://cdn.jsdelivr.net/npm/@alpinejs/collapse@3.x.x/dist/cdn.min.js"></script>
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <?php echo $__env->make('admin.partials.styles', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <style>
        [x-cloak] {
            display: none !important;
        }
    </style>
    <?php echo $__env->yieldPushContent('styles'); ?>
</head>

<body class="bg-gray-50 flex h-screen overflow-hidden">
    <?php echo $__env->make('admin.partials.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <div class="flex-1 flex flex-col h-screen overflow-hidden">
        <header class="h-16 flex items-center justify-between px-6 bg-white border-b border-gray-200">
            <h2 class="text-2xl font-semibold text-gray-800">
                <?php echo $__env->yieldContent('header_title', View::getSection('title', 'Admin Panel')); ?>
            </h2>
            <div class="flex items-center space-x-4">
                <!-- Support Tickets Icon -->
                <a href="<?php echo e(route('admin.tickets.index')); ?>"
                    class="p-2 text-gray-400 hover:text-gray-600 relative tooltip" title="Support Tickets">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24"
                        stroke="currentColor" stroke-width="2">
                        <path stroke-linecap="round" stroke-linejoin="round"
                            d="M8 10h.01M12 10h.01M16 10h.01M9 16H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-5l-5 5v-5z" />
                    </svg>
                    <?php
                        // Assuming Ticket model exists and status 'open' means unread/actionable
                        $openTicketsCount = \App\Models\Ticket::where('status', 'open')->count();
                    ?>
                    <?php if($openTicketsCount > 0): ?>
                        <span
                            class="absolute top-0 right-0 inline-flex items-center justify-center px-1.5 py-0.5 text-xs font-bold leading-none text-red-100 transform translate-x-1/4 -translate-y-1/4 bg-red-600 rounded-full"><?php echo e($openTicketsCount); ?></span>
                    <?php endif; ?>
                </a>

                <!-- Notifications Icon -->
                <a href="<?php echo e(route('admin.notifications.index')); ?>"
                    class="p-2 text-gray-400 hover:text-gray-600 relative tooltip" title="Notifications">
                    <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9" />
                    </svg>
                    <?php
                        $unreadCount = auth()->user()->unreadNotifications->count();
                    ?>
                    <?php if($unreadCount > 0): ?>
                        <span
                            class="absolute top-0 right-0 inline-flex items-center justify-center px-1.5 py-0.5 text-xs font-bold leading-none text-red-100 transform translate-x-1/4 -translate-y-1/4 bg-red-600 rounded-full"><?php echo e($unreadCount); ?></span>
                    <?php endif; ?>
                </a>
            </div>
        </header>

        <main class="flex-1 overflow-x-hidden overflow-y-auto bg-gray-50 p-6">
            <?php echo $__env->yieldContent('content'); ?>
        </main>
    </div>
    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>

</html><?php /**PATH /home/truetransit/public_html/hairniche.in/resources/views/layouts/admin.blade.php ENDPATH**/ ?>