<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames((['offer']));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter((['offer']), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars, $__key, $__value); ?>

<?php if($offer->target_element): ?>
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            const offerElement = document.getElementById('custom-offer-<?php echo e($offer->id); ?>');
            const targetElement = document.querySelector('<?php echo e($offer->target_element); ?>');
            
            if (offerElement && targetElement) {
                // Determine placement
                const position = '<?php echo e($offer->placement_position ?? "after"); ?>';
                console.log('Moving Offer <?php echo e($offer->id); ?> to', position, 'of', '<?php echo e($offer->target_element); ?>');
                
                if (position === 'before') {
                    targetElement.parentNode.insertBefore(offerElement, targetElement);
                } else if (position === 'after') {
                    // Check if next sibling exists, otherwise append to parent
                    if (targetElement.nextSibling) {
                        targetElement.parentNode.insertBefore(offerElement, targetElement.nextSibling);
                    } else {
                        targetElement.parentNode.appendChild(offerElement);
                    }
                } else if (position === 'inside_start') {
                    targetElement.insertBefore(offerElement, targetElement.firstChild);
                } else if (position === 'inside_end') {
                    targetElement.appendChild(offerElement);
                }
                
                // Show the offer after moving
                offerElement.classList.remove('hidden');
            } else {
                console.warn('Custom Offer Script: Target element "<?php echo e($offer->target_element); ?>" not found.');
                // Fallback: Show it in original position if target not found
                if (offerElement) {
                    offerElement.classList.remove('hidden');
                }
                // Optional: Show it somewhere default or keep hidden? 
                // Currently keeping hidden as fallback might break layout.
            }
        });
    </script>
<?php endif; ?>
<?php /**PATH /home/truetransit/public_html/hairniche.in/resources/views/components/custom-offer-script.blade.php ENDPATH**/ ?>