

<?php $__env->startSection('title', 'Edit Page: ' . $page->title); ?>

<?php $__env->startPush('styles'); ?>
    <link href="https://cdn.quilljs.com/1.3.6/quill.snow.css" rel="stylesheet">
    <style>
        .ql-editor {
            min-height: 300px;
            font-family: 'Inter', sans-serif;
            font-size: 1rem;
        }

        .ql-toolbar.ql-snow {
            border-top-left-radius: 0.5rem;
            border-top-right-radius: 0.5rem;
            border-color: #d1d5db;
        }

        .ql-container.ql-snow {
            border-bottom-left-radius: 0.5rem;
            border-bottom-right-radius: 0.5rem;
            border-color: #d1d5db;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
        <div class="mb-8 flex items-center justify-between">
            <div>
                <h1 class="text-3xl font-extrabold text-gray-900 tracking-tight">Edit Page</h1>
                <p class="mt-2 text-sm text-gray-500">Updating content for <span
                        class="font-medium text-gray-800"><?php echo e($page->title); ?></span></p>
            </div>
            <a href="<?php echo e(route('admin.pages.index')); ?>"
                class="inline-flex items-center px-4 py-2 border border-gray-300 rounded-md shadow-sm text-sm font-medium text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 transition-colors">
                <svg class="-ml-1 mr-2 h-5 w-5 text-gray-500" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"
                    fill="currentColor" aria-hidden="true">
                    <path fill-rule="evenodd"
                        d="M12.707 5.293a1 1 0 010 1.414L9.414 10l3.293 3.293a1 1 0 01-1.414 1.414l-4-4a1 1 0 010-1.414l4-4a1 1 0 011.414 0z"
                        clip-rule="evenodd" />
                </svg>
                Back to Pages
            </a>
        </div>

        <form action="<?php echo e(route('admin.pages.update', $page->id)); ?>" method="POST" id="pageForm" class="space-y-8" x-data='{
                            seoTitle: <?php echo json_encode($page->meta_title ?? "", 15, 512) ?>, 
                            metaDesc: <?php echo json_encode($page->meta_description ?? "", 15, 512) ?>,
                            getWordCount(text) {
                                return text ? text.trim().split(/\s+/).filter(word => word.length > 0).length : 0;
                            },
                            getColorClass(current, max) {
                                const percentage = (current / max) * 100;
                                if (percentage > 100) return "bg-red-500";
                                if (percentage > 80) return "bg-yellow-500";
                                return "bg-green-500";
                            },
                            getTextColorClass(current, max) {
                                const percentage = (current / max) * 100;
                                if (percentage > 100) return "text-red-600";
                                if (percentage > 80) return "text-yellow-600";
                                return "text-green-600";
                            }
                        }'>
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>

            <div class="bg-white p-8 rounded-xl shadow-sm border border-gray-200">
                <!-- Page Content Section -->
                <div class="lg:grid lg:grid-cols-3 lg:gap-6 mb-8">
                    <div class="md:col-span-1">
                        <div class="px-4 sm:px-0">
                            <h3 class="text-lg font-medium leading-6 text-gray-900">Page Content</h3>
                            <p class="mt-1 text-sm text-gray-600">
                                This content will be displayed on the page. Use the editor to format text, add links,
                                and more.
                            </p>
                            <div class="mt-4">
                                <p class="text-xs font-semibold text-gray-500 uppercase tracking-wider">Slug</p>
                                <code
                                    class="block mt-1 bg-gray-100 p-2 rounded text-sm text-gray-700 break-all"><?php echo e($page->slug); ?></code>
                            </div>
                        </div>
                    </div>
                    <div class="mt-5 md:mt-0 md:col-span-2">
                        <label for="content" class="block text-sm font-medium text-gray-700 mb-2">Detailed Content</label>
                        <div class="space-y-1">
                            <!-- Hidden Input to store Quill content -->
                            <input type="hidden" name="content" id="content" value="<?php echo e(old('content', $page->content)); ?>">
                            <!-- Quill Editor Container -->
                            <div id="editor-container"><?php echo old('content', $page->content); ?></div>
                        </div>
                    </div>
                </div>

                <div class="border-t border-gray-200 pt-8">
                    <div class="lg:grid lg:grid-cols-3 lg:gap-6">
                        <div class="md:col-span-1">
                            <div class="px-4 sm:px-0">
                                <h3 class="text-lg font-medium leading-6 text-gray-900">SEO Settings</h3>
                                <p class="mt-1 text-sm text-gray-600">
                                    Optimize this page for search engines. Provide a unique title and description.
                                </p>
                            </div>
                        </div>
                        <div class="mt-5 md:mt-0 md:col-span-2 space-y-6">

                            <!-- Meta Title -->
                            <div>
                                <div class="flex justify-between items-end mb-1">
                                    <label for="meta_title" class="block text-sm font-medium text-gray-700">Meta
                                        Title</label>
                                    <div class="text-xs text-gray-500 flex gap-2 font-medium">
                                        <span><span x-text="getWordCount(seoTitle)">0</span> words</span>
                                        <span>|</span>
                                        <span :class="getTextColorClass(seoTitle.length, 60)">
                                            <span x-text="seoTitle.length">0</span>/60 chars
                                        </span>
                                    </div>
                                </div>
                                <input type="text" name="meta_title" id="meta_title" x-model="seoTitle"
                                    class="block w-full px-4 py-3 rounded-lg border border-gray-300 focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500 transition duration-200 outline-none sm:text-sm"
                                    placeholder="Custom title for search engines">
                                <!-- Progress Bar -->
                                <div class="w-full bg-gray-100 rounded-full h-1.5 mt-2 overflow-hidden">
                                    <div class="h-1.5 rounded-full transition-all duration-300 ease-out"
                                        :class="getColorClass(seoTitle.length, 60)"
                                        :style="`width: ${Math.min((seoTitle.length / 60) * 100, 100)}%`"></div>
                                </div>
                            </div>

                            <!-- Meta Description -->
                            <div>
                                <div class="flex justify-between items-end mb-1">
                                    <label for="meta_description" class="block text-sm font-medium text-gray-700">Meta
                                        Description</label>
                                    <div class="text-xs text-gray-500 flex gap-2 font-medium">
                                        <span><span x-text="getWordCount(metaDesc)">0</span> words</span>
                                        <span>|</span>
                                        <span :class="getTextColorClass(metaDesc.length, 160)">
                                            <span x-text="metaDesc.length">0</span>/160 chars
                                        </span>
                                    </div>
                                </div>
                                <textarea name="meta_description" id="meta_description" rows="4" x-model="metaDesc"
                                    class="block w-full px-4 py-3 rounded-lg border border-gray-300 focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500 transition duration-200 outline-none sm:text-sm"
                                    placeholder="Brief summary of the page content..."></textarea>
                                <!-- Progress Bar -->
                                <div class="w-full bg-gray-100 rounded-full h-1.5 mt-2 overflow-hidden">
                                    <div class="h-1.5 rounded-full transition-all duration-300 ease-out"
                                        :class="getColorClass(metaDesc.length, 160)"
                                        :style="`width: ${Math.min((metaDesc.length / 160) * 100, 100)}%`"></div>
                                </div>
                            </div>

                            <!-- Meta Keywords -->
                            <div>
                                <div class="flex justify-between items-end mb-1">
                                    <label for="meta_keywords" class="block text-sm font-medium text-gray-700">Meta
                                        Keywords</label>
                                </div>
                                <input type="text" name="meta_keywords" id="meta_keywords"
                                    value="<?php echo e(old('meta_keywords', $page->meta_keywords)); ?>"
                                    class="block w-full px-4 py-3 rounded-lg border border-gray-300 focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500 transition duration-200 outline-none sm:text-sm"
                                    placeholder="Comma separated keywords (e.g. hair, beauty, salon)">
                            </div>

                            <!-- Robots Meta -->
                            <div class="pt-2">
                                <label class="flex items-center space-x-3 cursor-pointer">
                                    <input type="checkbox" name="is_nofollow" value="1" <?php echo e(old('is_nofollow', $page->is_nofollow) ? 'checked' : ''); ?>

                                        class="h-4 w-4 text-indigo-600 border-gray-300 rounded focus:ring-indigo-500 cursor-pointer">
                                    <span class="text-sm font-medium text-gray-700">Set rel="nofollow" (No Follow)</span>
                                </label>
                                <p class="mt-1 text-xs text-gray-500 ml-7">
                                    If checked, a <code>&lt;meta name="robots" content="nofollow"&gt;</code> tag will be
                                    added, instructing search engines not to follow links on this page.
                                </p>
                            </div>

                            <!-- Schema Markup -->
                            <div>
                                <label for="schema_markup" class="block text-sm font-medium text-gray-700 mb-2">
                                    Schema Markup (JSON-LD)
                                    <a href="https://validator.schema.org/" target="_blank"
                                        class="ml-1 text-xs text-indigo-600 hover:text-indigo-500 underline font-normal">(Validate)</a>
                                </label>
                                <textarea name="schema_markup" id="schema_markup" rows="8"
                                    class="block w-full px-4 py-3 rounded-lg border border-gray-300 focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500 transition duration-200 outline-none sm:text-sm font-mono text-xs bg-gray-50"
                                    placeholder="Paste your JSON-LD code here..."><?php echo e(old('schema_markup', $page->schema_markup)); ?></textarea>
                                <p class="mt-2 text-xs text-gray-500">
                                    Paste your valid JSON-LD code here. It will be injected into the
                                    <code>&lt;head&gt;</code>.
                                    <br>Example:
                                    <code class="block mt-1 bg-gray-100 p-2 rounded text-xs leading-relaxed">
            &lt;script type="application/ld+json"&gt;
            {
              "@context": "https://schema.org",
              "@type": "WebPage",
              "name": "Page Title",
              "description": "Page Description"
            }
            &lt;/script&gt;
                                                </code>
                                </p>
                            </div>

                        </div>
                    </div>
                </div>
            </div>

            <div class="flex justify-end gap-3 pb-8">
                <a href="<?php echo e(route('admin.pages.index')); ?>"
                    class="bg-white py-3 px-6 border border-gray-300 rounded-lg shadow-sm text-sm font-medium text-gray-700 hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 transition-colors">
                    Cancel
                </a>
                <button type="submit"
                    class="inline-flex justify-center py-3 px-6 border border-transparent shadow-sm text-sm font-medium rounded-lg text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 transition-all duration-200">
                    Save Changes
                </button>
            </div>
        </form>
    </div>

    <?php $__env->startPush('scripts'); ?>
        <script src="https://cdn.quilljs.com/1.3.6/quill.js"></script>
        <script>
            var quill = new Quill('#editor-container', {
                theme: 'snow',
                placeholder: 'Write amazing content here...',
                modules: {
                    toolbar: [
                        [{ 'header': [1, 2, 3, 4, 5, 6, false] }],
                        ['bold', 'italic', 'underline', 'strike'],
                        ['blockquote', 'code-block'],
                        [{ 'list': 'ordered' }, { 'list': 'bullet' }],
                        [{ 'color': [] }, { 'background': [] }],
                        [{ 'align': [] }],
                        ['link', 'image', 'clean']
                    ]
                }
            });

            var form = document.querySelector('#pageForm');
            form.onsubmit = function () {
                var content = document.querySelector('input[name=content]');
                content.value = quill.root.innerHTML;
            };
        </script>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/truetransit/public_html/hairniche.in/resources/views/admin/pages/edit.blade.php ENDPATH**/ ?>