<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Website Settings - Lugani Admin</title>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <?php echo $__env->make('admin.partials.styles', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
</head>

<body class="bg-gray-50 flex h-screen overflow-hidden">
    <?php echo $__env->make('admin.partials.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <div class="flex-1 flex flex-col h-screen overflow-hidden">
        <header class="h-16 flex items-center justify-between px-6 bg-white border-b border-gray-200">
            <h2 class="text-2xl font-semibold text-gray-800">Website Settings</h2>
        </header>
        <main class="flex-1 overflow-x-hidden overflow-y-auto bg-gray-50 p-6">
            <div class="max-w-4xl mx-auto">
                <?php if(session('success')): ?>
                    <div class="mb-4 bg-green-50 border-l-4 border-green-500 p-4 rounded-r-lg text-green-700 font-medium">
                        <?php echo e(session('success')); ?>

                    </div>
                <?php endif; ?>

                <form action="<?php echo e(route('admin.settings.website.update')); ?>" method="POST" enctype="multipart/form-data"
                    class="space-y-6">
                    <?php echo csrf_field(); ?>

                    <div class="bg-white rounded-xl shadow-sm p-6 border border-gray-100">
                        <h3 class="text-lg font-medium text-gray-900 mb-4 border-b pb-2">Basic Information</h3>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <!-- Logo -->
                            <div class="col-span-2">
                                <label class="block text-sm font-medium text-gray-700 mb-2">Website Logo</label>
                                <div class="flex items-center space-x-6">
                                    <?php if($settings->site_logo): ?>
                                        <div class="shrink-0">
                                            <img class="h-16 w-auto object-contain p-1 border rounded"
                                                src="<?php echo e(Storage::url($settings->site_logo)); ?>" alt="Current Logo">
                                        </div>
                                    <?php endif; ?>
                                    <div class="flex-1">
                                        <input type="file" name="site_logo"
                                            class="block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-blue-50 file:text-blue-700 hover:file:bg-blue-100">
                                        <p class="mt-1 text-xs text-gray-500">PNG, JPG, SVG up to 2MB</p>
                                    </div>
                                </div>
                            </div>

                            <!-- App Icon -->
                            <div class="col-span-2 md:col-span-1">
                                <label class="block text-sm font-medium text-gray-700 mb-2">App Icon</label>
                                <div class="flex items-center space-x-6">
                                    <?php if($settings->app_icon): ?>
                                        <div class="shrink-0">
                                            <img class="h-16 w-auto object-contain p-1 border rounded"
                                                src="<?php echo e(Storage::url($settings->app_icon)); ?>" alt="App Icon">
                                        </div>
                                    <?php endif; ?>
                                    <div class="flex-1">
                                        <input type="file" name="app_icon"
                                            class="block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-blue-50 file:text-blue-700 hover:file:bg-blue-100">
                                        <p class="mt-1 text-xs text-gray-500">PNG, JPG, SVG.</p>
                                    </div>
                                </div>
                            </div>

                            <!-- Favicon -->
                            <div class="col-span-2 md:col-span-1">
                                <label class="block text-sm font-medium text-gray-700 mb-2">Favicon</label>
                                <div class="flex items-center space-x-6">
                                    <?php if($settings->favicon): ?>
                                        <div class="shrink-0">
                                            <img class="h-16 w-auto object-contain p-1 border rounded"
                                                src="<?php echo e(Storage::url($settings->favicon)); ?>" alt="Favicon">
                                        </div>
                                    <?php endif; ?>
                                    <div class="flex-1">
                                        <input type="file" name="favicon"
                                            class="block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-blue-50 file:text-blue-700 hover:file:bg-blue-100">
                                        <p class="mt-1 text-xs text-gray-500">ICO, PNG.</p>
                                    </div>
                                </div>
                            </div>

                            <!-- Phone -->
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Sales Phone</label>
                                <input type="text" name="phone_sales" value="<?php echo e($settings->phone_sales); ?>"
                                    class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Support Phone</label>
                                <input type="text" name="phone_support" value="<?php echo e($settings->phone_support); ?>"
                                    class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2">
                            </div>

                            <!-- Email -->
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Sales Email</label>
                                <input type="email" name="email_sales" value="<?php echo e($settings->email_sales); ?>"
                                    class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Support Email</label>
                                <input type="email" name="email_support" value="<?php echo e($settings->email_support); ?>"
                                    class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2">
                            </div>

                            <!-- Address & Maps -->
                            <div class="col-span-2 md:col-span-1">
                                <label class="block text-sm font-medium text-gray-700">Head Office Address</label>
                                <textarea name="address_head" rows="3"
                                    class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2"><?php echo e($settings->address_head); ?></textarea>
                            </div>
                            <div class="col-span-2 md:col-span-1">
                                <label class="block text-sm font-medium text-gray-700">Branch Office Address</label>
                                <textarea name="address_branch" rows="3"
                                    class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2"><?php echo e($settings->address_branch); ?></textarea>
                            </div>
                        </div>
                    </div>

                    <div class="bg-white rounded-xl shadow-sm p-6 border border-gray-100">
                        <h3 class="text-lg font-medium text-gray-900 mb-4 border-b pb-2">Social Media Links</h3>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <?php $social = $settings->social_links ?? []; ?>

                            <!-- Facebook -->
                            <div x-data="{ showSettings: false, val: <?php echo \Illuminate\Support\Js::from($social['facebook'] ?? '')->toHtml() ?> }">
                                <label class="block text-sm font-medium text-gray-700 flex items-center mb-1">
                                    <svg class="h-4 w-4 mr-2" fill="currentColor" viewBox="0 0 24 24">
                                        <path
                                            d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z" />
                                    </svg>
                                    Facebook
                                </label>
                                <div class="flex rounded-md shadow-sm">
                                    <input type="url" name="social_facebook[url]"
                                        value="<?php echo e(is_array($social['facebook'] ?? '') ? ($social['facebook']['url'] ?? '') : ($social['facebook'] ?? '')); ?>"
                                        class="flex-1 block w-full rounded-none rounded-l-md border-gray-300 focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2"
                                        placeholder="https://facebook.com/...">
                                    <button type="button" @click="showSettings = !showSettings"
                                        class="inline-flex items-center px-3 rounded-r-md border border-l-0 border-gray-300 bg-gray-50 text-gray-500 sm:text-sm hover:bg-gray-100">
                                        <svg class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z" />
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                                        </svg>
                                    </button>
                                </div>
                                <div x-show="showSettings" x-cloak
                                    class="mt-2 p-3 bg-gray-50 rounded-lg border border-gray-100 space-y-2">
                                    <div class="flex items-center">
                                        <input type="checkbox" name="social_facebook[new_window]" value="1"
                                            id="fb_new_window" <?php echo e((is_array($social['facebook'] ?? '') && ($social['facebook']['new_window'] ?? false)) ? 'checked' : ''); ?>

                                            class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded">
                                        <label for="fb_new_window" class="ml-2 block text-xs text-gray-700">Open in new
                                            window</label>
                                    </div>
                                    <div class="flex items-center">
                                        <input type="checkbox" name="social_facebook[nofollow]" value="1"
                                            id="fb_nofollow" <?php echo e((is_array($social['facebook'] ?? '') && ($social['facebook']['nofollow'] ?? false)) ? 'checked' : ''); ?>

                                            class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded">
                                        <label for="fb_nofollow" class="ml-2 block text-xs text-gray-700">Add
                                            nofollow</label>
                                    </div>
                                </div>
                            </div>

                            <!-- Instagram -->
                            <div x-data="{ showSettings: false }">
                                <label class="block text-sm font-medium text-gray-700 flex items-center mb-1">
                                    <svg class="h-4 w-4 mr-2" fill="currentColor" viewBox="0 0 24 24">
                                        <path
                                            d="M12 2.163c3.204 0 3.584.012 4.85.07 3.252.148 4.771 1.691 4.919 4.919.058 1.265.069 1.645.069 4.849 0 3.205-.012 3.584-.069 4.849-.149 3.225-1.664 4.771-4.919 4.919-1.266.058-1.644.07-4.85.07-3.204 0-3.584-.012-4.849-.07-3.26-.149-4.771-1.699-4.919-4.92-.058-1.265-.07-1.644-.07-4.849 0-3.204.013-3.583.07-4.849.149-3.227 1.664-4.771 4.919-4.919 1.266-.057 1.645-.069 4.849-.069zm0-2.163c-3.259 0-3.667.014-4.947.072-4.358.2-6.78 2.618-6.98 6.98-.059 1.281-.073 1.689-.073 4.948 0 3.259.014 3.668.072 4.948.2 4.358 2.618 6.78 6.98 6.98 1.281.058 1.689.072 4.948.072 3.259 0 3.668-.014 4.948-.072 4.354-.2 6.782-2.618 6.979-6.98.059-1.28.073-1.689.073-4.948 0-3.259-.014-3.667-.072-4.947-.196-4.354-2.617-6.78-6.979-6.98-1.281-.059-1.69-.073-4.949-.073zm0 5.838c-3.403 0-6.162 2.759-6.162 6.162s2.759 6.163 6.162 6.163 6.162-2.759 6.162-6.163c0-3.403-2.759-6.162-6.162-6.162zm0 10.162c-2.209 0-4-1.79-4-4 0-2.209 1.791-4 4-4s4 1.791 4 4c0 2.21-1.791 4-4 4zm6.406-11.845c-.796 0-1.441.645-1.441 1.44s.645 1.44 1.441 1.44c.795 0 1.439-.645 1.439-1.44s-.644-1.44-1.439-1.44z" />
                                    </svg>
                                    Instagram
                                </label>
                                <div class="flex rounded-md shadow-sm">
                                    <input type="url" name="social_instagram[url]"
                                        value="<?php echo e(is_array($social['instagram'] ?? '') ? ($social['instagram']['url'] ?? '') : ($social['instagram'] ?? '')); ?>"
                                        class="flex-1 block w-full rounded-none rounded-l-md border-gray-300 focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2"
                                        placeholder="https://instagram.com/...">
                                    <button type="button" @click="showSettings = !showSettings"
                                        class="inline-flex items-center px-3 rounded-r-md border border-l-0 border-gray-300 bg-gray-50 text-gray-500 sm:text-sm hover:bg-gray-100">
                                        <svg class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z" />
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                                        </svg>
                                    </button>
                                </div>
                                <div x-show="showSettings" x-cloak
                                    class="mt-2 p-3 bg-gray-50 rounded-lg border border-gray-100 space-y-2">
                                    <div class="flex items-center">
                                        <input type="checkbox" name="social_instagram[new_window]" value="1"
                                            id="ig_new_window" <?php echo e((is_array($social['instagram'] ?? '') && ($social['instagram']['new_window'] ?? false)) ? 'checked' : ''); ?>

                                            class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded">
                                        <label for="ig_new_window" class="ml-2 block text-xs text-gray-700">Open in new
                                            window</label>
                                    </div>
                                    <div class="flex items-center">
                                        <input type="checkbox" name="social_instagram[nofollow]" value="1"
                                            id="ig_nofollow" <?php echo e((is_array($social['instagram'] ?? '') && ($social['instagram']['nofollow'] ?? false)) ? 'checked' : ''); ?>

                                            class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded">
                                        <label for="ig_nofollow" class="ml-2 block text-xs text-gray-700">Add
                                            nofollow</label>
                                    </div>
                                </div>
                            </div>

                            <!-- Twitter -->
                            <div x-data="{ showSettings: false }">
                                <label class="block text-sm font-medium text-gray-700 flex items-center mb-1">Twitter /
                                    X</label>
                                <div class="flex rounded-md shadow-sm">
                                    <input type="url" name="social_twitter[url]"
                                        value="<?php echo e(is_array($social['twitter'] ?? '') ? ($social['twitter']['url'] ?? '') : ($social['twitter'] ?? '')); ?>"
                                        class="flex-1 block w-full rounded-none rounded-l-md border-gray-300 focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2"
                                        placeholder="https://x.com/...">
                                    <button type="button" @click="showSettings = !showSettings"
                                        class="inline-flex items-center px-3 rounded-r-md border border-l-0 border-gray-300 bg-gray-50 text-gray-500 sm:text-sm hover:bg-gray-100">
                                        <svg class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z" />
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                                        </svg>
                                    </button>
                                </div>
                                <div x-show="showSettings" x-cloak
                                    class="mt-2 p-3 bg-gray-50 rounded-lg border border-gray-100 space-y-2">
                                    <div class="flex items-center">
                                        <input type="checkbox" name="social_twitter[new_window]" value="1"
                                            id="tw_new_window" <?php echo e((is_array($social['twitter'] ?? '') && ($social['twitter']['new_window'] ?? false)) ? 'checked' : ''); ?>

                                            class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded">
                                        <label for="tw_new_window" class="ml-2 block text-xs text-gray-700">Open in new
                                            window</label>
                                    </div>
                                    <div class="flex items-center">
                                        <input type="checkbox" name="social_twitter[nofollow]" value="1"
                                            id="tw_nofollow" <?php echo e((is_array($social['twitter'] ?? '') && ($social['twitter']['nofollow'] ?? false)) ? 'checked' : ''); ?>

                                            class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded">
                                        <label for="tw_nofollow" class="ml-2 block text-xs text-gray-700">Add
                                            nofollow</label>
                                    </div>
                                </div>
                            </div>

                            <!-- LinkedIn -->
                            <div x-data="{ showSettings: false }">
                                <label
                                    class="block text-sm font-medium text-gray-700 flex items-center mb-1">LinkedIn</label>
                                <div class="flex rounded-md shadow-sm">
                                    <input type="url" name="social_linkedin[url]"
                                        value="<?php echo e(is_array($social['linkedin'] ?? '') ? ($social['linkedin']['url'] ?? '') : ($social['linkedin'] ?? '')); ?>"
                                        class="flex-1 block w-full rounded-none rounded-l-md border-gray-300 focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2"
                                        placeholder="https://linkedin.com/...">
                                    <button type="button" @click="showSettings = !showSettings"
                                        class="inline-flex items-center px-3 rounded-r-md border border-l-0 border-gray-300 bg-gray-50 text-gray-500 sm:text-sm hover:bg-gray-100">
                                        <svg class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z" />
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                                        </svg>
                                    </button>
                                </div>
                                <div x-show="showSettings" x-cloak
                                    class="mt-2 p-3 bg-gray-50 rounded-lg border border-gray-100 space-y-2">
                                    <div class="flex items-center">
                                        <input type="checkbox" name="social_linkedin[new_window]" value="1"
                                            id="li_new_window" <?php echo e((is_array($social['linkedin'] ?? '') && ($social['linkedin']['new_window'] ?? false)) ? 'checked' : ''); ?>

                                            class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded">
                                        <label for="li_new_window" class="ml-2 block text-xs text-gray-700">Open in new
                                            window</label>
                                    </div>
                                    <div class="flex items-center">
                                        <input type="checkbox" name="social_linkedin[nofollow]" value="1"
                                            id="li_nofollow" <?php echo e((is_array($social['linkedin'] ?? '') && ($social['linkedin']['nofollow'] ?? false)) ? 'checked' : ''); ?>

                                            class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded">
                                        <label for="li_nofollow" class="ml-2 block text-xs text-gray-700">Add
                                            nofollow</label>
                                    </div>
                                </div>
                            </div>

                            <!-- YouTube -->
                            <div x-data="{ showSettings: false }">
                                <label
                                    class="block text-sm font-medium text-gray-700 flex items-center mb-1">YouTube</label>
                                <div class="flex rounded-md shadow-sm">
                                    <input type="url" name="social_youtube[url]"
                                        value="<?php echo e(is_array($social['youtube'] ?? '') ? ($social['youtube']['url'] ?? '') : ($social['youtube'] ?? '')); ?>"
                                        class="flex-1 block w-full rounded-none rounded-l-md border-gray-300 focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2"
                                        placeholder="https://youtube.com/...">
                                    <button type="button" @click="showSettings = !showSettings"
                                        class="inline-flex items-center px-3 rounded-r-md border border-l-0 border-gray-300 bg-gray-50 text-gray-500 sm:text-sm hover:bg-gray-100">
                                        <svg class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z" />
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                                        </svg>
                                    </button>
                                </div>
                                <div x-show="showSettings" x-cloak
                                    class="mt-2 p-3 bg-gray-50 rounded-lg border border-gray-100 space-y-2">
                                    <div class="flex items-center">
                                        <input type="checkbox" name="social_youtube[new_window]" value="1"
                                            id="yt_new_window" <?php echo e((is_array($social['youtube'] ?? '') && ($social['youtube']['new_window'] ?? false)) ? 'checked' : ''); ?>

                                            class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded">
                                        <label for="yt_new_window" class="ml-2 block text-xs text-gray-700">Open in new
                                            window</label>
                                    </div>
                                    <div class="flex items-center">
                                        <input type="checkbox" name="social_youtube[nofollow]" value="1"
                                            id="yt_nofollow" <?php echo e((is_array($social['youtube'] ?? '') && ($social['youtube']['nofollow'] ?? false)) ? 'checked' : ''); ?>

                                            class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded">
                                        <label for="yt_nofollow" class="ml-2 block text-xs text-gray-700">Add
                                            nofollow</label>
                                    </div>
                                </div>
                            </div>

                            <!-- Pinterest -->
                            <div x-data="{ showSettings: false }">
                                <label class="block text-sm font-medium text-gray-700 flex items-center mb-1">
                                    <svg class="h-4 w-4 mr-2" fill="currentColor" viewBox="0 0 24 24">
                                        <path
                                            d="M12.017 0C5.396 0 .029 5.367.029 11.987c0 5.079 3.158 9.417 7.618 11.162-.105-.949-.199-2.403.041-3.439.219-.937 1.406-5.957 1.406-5.957s-.359-.72-.359-1.781c0-1.663.967-2.911 2.168-2.911 1.024 0 1.518.769 1.518 1.688 0 1.029-.653 2.567-.992 3.992-.285 1.193.6 2.165 1.775 2.165 2.128 0 3.768-2.245 3.768-5.487 0-2.861-2.063-4.869-5.008-4.869-3.41 0-5.409 2.562-5.409 5.199 0 1.033.394 2.143.889 2.741.099.12.112.225.085.345-.09.375-.293 1.199-.334 1.363-.053.225-.172.271-.399.165-1.495-.69-2.433-2.878-2.433-4.646 0-3.776 2.748-7.252 7.951-7.252 4.173 0 7.41 2.967 7.41 6.923 0 4.135-2.607 7.462-6.233 7.462-1.214 0-2.354-.629-2.758-1.379l-.749 2.848c-.269 1.045-1.004 2.352-1.498 3.146 1.123.345 2.306.535 3.55.535 6.607 0 11.985-5.365 11.985-11.987C23.97 5.367 18.62 0 12.017 0z" />
                                    </svg>
                                    Pinterest
                                </label>
                                <div class="flex rounded-md shadow-sm">
                                    <input type="url" name="social_pinterest[url]"
                                        value="<?php echo e(is_array($social['pinterest'] ?? '') ? ($social['pinterest']['url'] ?? '') : ($social['pinterest'] ?? '')); ?>"
                                        class="flex-1 block w-full rounded-none rounded-l-md border-gray-300 focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2"
                                        placeholder="https://pinterest.com/...">
                                    <button type="button" @click="showSettings = !showSettings"
                                        class="inline-flex items-center px-3 rounded-r-md border border-l-0 border-gray-300 bg-gray-50 text-gray-500 sm:text-sm hover:bg-gray-100">
                                        <svg class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z" />
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                                        </svg>
                                    </button>
                                </div>
                                <div x-show="showSettings" x-cloak
                                    class="mt-2 p-3 bg-gray-50 rounded-lg border border-gray-100 space-y-2">
                                    <div class="flex items-center">
                                        <input type="checkbox" name="social_pinterest[new_window]" value="1"
                                            id="pin_new_window" <?php echo e((is_array($social['pinterest'] ?? '') && ($social['pinterest']['new_window'] ?? false)) ? 'checked' : ''); ?>

                                            class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded">
                                        <label for="pin_new_window" class="ml-2 block text-xs text-gray-700">Open in new
                                            window</label>
                                    </div>
                                    <div class="flex items-center">
                                        <input type="checkbox" name="social_pinterest[nofollow]" value="1"
                                            id="pin_nofollow" <?php echo e((is_array($social['pinterest'] ?? '') && ($social['pinterest']['nofollow'] ?? false)) ? 'checked' : ''); ?>

                                            class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded">
                                        <label for="pin_nofollow" class="ml-2 block text-xs text-gray-700">Add
                                            nofollow</label>
                                    </div>
                                </div>
                            </div>


                            <div class="col-span-1 md:col-span-2 border-t pt-4 mt-2">
                                <label class="block text-sm font-medium text-gray-700 flex items-center mb-1">
                                    <svg class="h-4 w-4 mr-2" fill="currentColor" viewBox="0 0 24 24">
                                        <path
                                            d="M12 2.163c3.204 0 3.584.012 4.85.07 3.252.148 4.771 1.691 4.919 4.919.058 1.265.069 1.645.069 4.849 0 3.205-.012 3.584-.069 4.849-.149 3.225-1.664 4.771-4.919 4.919-1.266.058-1.644.07-4.85.07-3.204 0-3.584-.012-4.849-.07-3.26-.149-4.771-1.699-4.919-4.92-.058-1.265-.07-1.644-.07-4.849 0-3.204.013-3.583.07-4.849.149-3.227 1.664-4.771 4.919-4.919 1.266-.057 1.645-.069 4.849-.069zm0-2.163c-3.259 0-3.667.014-4.947.072-4.358.2-6.78 2.618-6.98 6.98-.059 1.281-.073 1.689-.073 4.948 0 3.259.014 3.668.072 4.948.2 4.358 2.618 6.78 6.98 6.98 1.281.058 1.689.072 4.948.072 3.259 0 3.668-.014 4.948-.072 4.354-.2 6.782-2.618 6.979-6.98.059-1.28.073-1.689.073-4.948 0-3.259-.014-3.667-.072-4.947-.196-4.354-2.617-6.78-6.979-6.98-1.281-.059-1.69-.073-4.949-.073zm0 5.838c-3.403 0-6.162 2.759-6.162 6.162s2.759 6.163 6.162 6.163 6.162-2.759 6.162-6.163c0-3.403-2.759-6.162-6.162-6.162zm0 10.162c-2.209 0-4-1.79-4-4 0-2.209 1.791-4 4-4s4 1.791 4 4c0 2.21-1.791 4-4 4zm6.406-11.845c-.796 0-1.441.645-1.441 1.44s.645 1.44 1.441 1.44c.795 0 1.439-.645 1.439-1.44s-.644-1.44-1.439-1.44z" />
                                    </svg>
                                    Instagram Feed Emded URL
                                </label>
                                <span class="text-xs text-gray-500 mb-2 block">The URL to fetch/embed your Instagram
                                    feed (e.g., from a widget provider).</span>
                                <input type="text" name="instagram_feed_url" value="<?php echo e($settings->instagram_feed_url); ?>"
                                    class="block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2">
                            </div>
                        </div>
                    </div>

                    <div class="bg-white rounded-xl shadow-sm p-6 border border-gray-100">
                        <h3 class="text-lg font-medium text-gray-900 mb-4 border-b pb-2">Security Settings</h3>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Max Login Attempts</label>
                                <input type="number" name="login_max_attempts"
                                    value="<?php echo e($settings->login_max_attempts ?? 5); ?>" min="1"
                                    class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2">
                                <p class="mt-1 text-xs text-gray-500">Number of failed attempts allowed before blocking.
                                </p>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Lockout Time (Minutes)</label>
                                <input type="number" name="login_decay_minutes"
                                    value="<?php echo e($settings->login_decay_minutes ?? 1); ?>" min="1"
                                    class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm border p-2">
                                <p class="mt-1 text-xs text-gray-500">Duration to block login after exceeding max
                                    attempts.</p>
                            </div>
                        </div>
                    </div>

                    <div class="flex justify-end">
                        <button type="submit"
                            class="bg-blue-600 text-white px-6 py-2 rounded-lg font-medium hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                            Save Settings
                        </button>
                    </div>
                </form>
            </div>
        </main>
    </div>
</body>

</html><?php /**PATH /home/truetransit/public_html/hairniche.in/resources/views/admin/settings/website.blade.php ENDPATH**/ ?>