<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tax Settings - Lugani Admin</title>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <?php echo $__env->make('admin.partials.styles', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
</head>

<body class="bg-gray-50 flex h-screen overflow-hidden">
    <?php echo $__env->make('admin.partials.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <div class="flex-1 flex flex-col h-screen overflow-hidden">
        <header class="h-16 flex items-center justify-between px-6 bg-white border-b border-gray-200">
            <h2 class="text-2xl font-medium text-gray-800 tracking-tight">Tax Settings</h2>
        </header>

        <main class="flex-1 overflow-x-hidden overflow-y-auto bg-gray-50 p-6">
            <?php if(session('success')): ?>
                <div class="mb-4 bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative"
                    role="alert">
                    <span class="block sm:inline"><?php echo e(session('success')); ?></span>
                </div>
            <?php endif; ?>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- Tax Configurations -->
                <div class="bg-white shadow-md rounded-lg p-6">
                    <h3 class="text-lg font-medium text-gray-900 mb-4">General Tax Configuration</h3>
                    <form action="<?php echo e(route('admin.settings.tax.update')); ?>" method="POST">
                        <?php echo csrf_field(); ?>

                        <div class="mb-4">
                            <label class="flex items-center space-x-3">
                                <input type="checkbox" name="product_tax_enabled" value="1"
                                    class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded" <?php echo e($settings->product_tax_enabled ? 'checked' : ''); ?>>
                                <span class="text-sm font-medium text-gray-700">Enable Tax on Products</span>
                            </label>
                            <p class="text-xs text-gray-500 mt-1 ml-7">If enabled, tax will be calculated on product
                                prices based on their tax code or default rate.</p>
                        </div>

                        <div class="mb-4">
                            <label class="flex items-center space-x-3">
                                <input type="checkbox" name="shipping_tax_enabled" value="1"
                                    class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded" <?php echo e($settings->shipping_tax_enabled ? 'checked' : ''); ?>

                                    x-on:change="$dispatch('toggle-shipping-tax')">
                                <span class="text-sm font-medium text-gray-700">Enable Tax on Shipping</span>
                            </label>
                            <p class="text-xs text-gray-500 mt-1 ml-7">If enabled, tax will be calculated on shipping
                                charges.</p>
                        </div>

                        <div class="mb-4 ml-7 p-3 bg-gray-50 rounded-md border border-gray-100"
                            x-data="{ show: <?php echo e($settings->shipping_tax_enabled ? 'true' : 'false'); ?> }" x-show="show"
                            x-on:toggle-shipping-tax.window="show = !show" x-transition>
                            <label for="shipping_tax_rate_id"
                                class="block text-sm font-medium text-gray-700 mb-1">Shipping Tax Rate</label>
                            <select name="shipping_tax_rate_id" id="shipping_tax_rate_id"
                                class="block w-full pl-3 pr-10 py-2 text-base border-gray-300 focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm rounded-md">
                                <option value="">None (0%)</option>
                                <?php $__currentLoopData = $taxRates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($rate->id); ?>" <?php echo e($settings->shipping_tax_rate_id == $rate->id ? 'selected' : ''); ?>>
                                        <?php echo e($rate->name); ?> (<?php echo e($rate->rate); ?>%)
                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <p class="text-xs text-gray-500 mt-1">Select the specific tax rate applicable to shipping
                                charges.</p>
                        </div>

                        <div class="mb-4">
                            <label for="default_tax_rate_id" class="block text-sm font-medium text-gray-700">Default Tax
                                Rate</label>
                            <select name="default_tax_rate_id" id="default_tax_rate_id"
                                class="mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm rounded-md">
                                <option value="">None</option>
                                <?php $__currentLoopData = $taxRates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($rate->id); ?>" <?php echo e($settings->default_tax_rate_id == $rate->id ? 'selected' : ''); ?>>
                                        <?php echo e($rate->name); ?> (<?php echo e($rate->rate); ?>%)
                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <p class="text-xs text-gray-500 mt-1">This rate will be used if a product does not have a
                                specific tax code assigned.</p>
                        </div>

                        <div class="mt-6">
                            <button type="submit"
                                class="w-full bg-blue-600 text-white px-4 py-2 rounded-md hover:bg-blue-700 transition">Save
                                Settings</button>
                        </div>
                    </form>
                </div>

                <!-- Manage Tax Rates Link -->
                <div class="bg-white shadow-md rounded-lg p-6 flex flex-col justify-center items-center text-center">
                    <div class="p-3 bg-blue-100 rounded-full mb-4">
                        <svg class="h-8 w-8 text-blue-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M9 14l6-6m-5.5.5h.01m4.99 5h.01M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16l3.5-2 3.5 2 3.5-2 3.5 2z" />
                        </svg>
                    </div>
                    <h3 class="text-lg font-medium text-gray-900">Manage Tax Rates</h3>
                    <p class="text-sm text-gray-500 mt-2 mb-6">Create, edit, or delete available tax rates for your
                        store.</p>
                    <a href="<?php echo e(route('admin.tax-rates.index')); ?>"
                        class="bg-white border border-gray-300 text-gray-700 px-4 py-2 rounded-md hover:bg-gray-50 transition">
                        View All Tax Rates
                    </a>
                </div>
            </div>
        </main>
    </div>
</body>

</html><?php /**PATH /home/truetransit/public_html/hairniche.in/resources/views/admin/settings/tax.blade.php ENDPATH**/ ?>