<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\Admin\TicketController;
use App\Http\Controllers\Admin\CategoryController;
use App\Http\Controllers\Admin\ProductController;
use App\Http\Controllers\Admin\RoleController;
use App\Http\Controllers\Admin\UserController as AdminUserController;
use App\Http\Controllers\Admin\ClientController;
use App\Http\Controllers\Admin\OrderController;
use App\Http\Controllers\Admin\SubscriberController;
use App\Http\Controllers\Admin\DeliveryAgentController;
use App\Http\Controllers\Admin\StoreController;
use App\Http\Controllers\Admin\DiscountController;
use App\Http\Controllers\Admin\CouponController;
use App\Http\Controllers\Admin\ContactController;
use App\Http\Controllers\Admin\SettingController;
use App\Http\Controllers\Admin\SliderController;
use App\Http\Controllers\Admin\PromotionalBannerController;
use App\Http\Controllers\Admin\ReportController;
use App\Http\Controllers\Admin\TaxRateController;
use Illuminate\Support\Facades\Http;

Route::get('/', [HomeController::class, 'index'])->name('home');

// Shop Routes
use App\Http\Controllers\ShopController;
Route::get('/shop', [ShopController::class, 'index'])->name('shop.index');
Route::get('/collections/{category}', [ShopController::class, 'category'])->name('shop.category');
Route::get('/collections/{category}/{subcategory}', [ShopController::class, 'subcategory'])->name('shop.subcategory');
Route::get('/product/{slug}', [ShopController::class, 'show'])->name('shop.product');
Route::get('/search/suggestions', [ShopController::class, 'searchSuggestions'])->name('shop.search.suggestions');

// Cart Routes
use App\Http\Controllers\CartController;
Route::get('/cart', [CartController::class, 'index'])->name('cart.index');
Route::post('/cart/add', [CartController::class, 'add'])->name('cart.add');
Route::post('/cart/update/{itemId}', [CartController::class, 'update'])->name('cart.update');
Route::get('/cart/remove/{itemId}', [CartController::class, 'remove'])->name('cart.remove');
Route::get('/checkout/check', [CartController::class, 'checkoutCheck'])->name('cart.checkout.check');
Route::get('/checkout', [CartController::class, 'checkout'])->name('checkout.index');

use App\Http\Controllers\CheckoutController;
Route::post('/checkout/process', [CheckoutController::class, 'process'])->name('checkout.process');
Route::get('/checkout/payment/{order}', [CheckoutController::class, 'payment'])->name('checkout.payment');
Route::post('/checkout/cod/{order}', [CheckoutController::class, 'processCod'])->name('checkout.cod');
Route::post('/checkout/free/{order}', [CheckoutController::class, 'processFree'])->name('checkout.free');
Route::post('/checkout/razorpay/{order}', [CheckoutController::class, 'processRazorpay'])->name('checkout.razorpay');
Route::post('/checkout/phonepe/init/{order}', [CheckoutController::class, 'initiatePhonePe'])->name('checkout.phonepe.init');
Route::post('/checkout/phonepe/response/{order}', [CheckoutController::class, 'processPhonePeResponse'])->name('checkout.phonepe.response');
Route::post('/checkout/phonepe/callback', [CheckoutController::class, 'phonepeCallback'])->name('checkout.phonepe.callback');
Route::get('/checkout/success/{order}', [CheckoutController::class, 'success'])->name('checkout.success');

use App\Http\Controllers\ChatbotController;
Route::get('/chatbot/init', [ChatbotController::class, 'index'])->name('chatbot.init');
Route::post('/chatbot/message', [ChatbotController::class, 'sendMessage'])->name('chatbot.message');

Route::post('/cart/coupon/validate', [CartController::class, 'validateCoupon'])->name('cart.coupon.validate');

use App\Http\Controllers\PageController;
Route::controller(PageController::class)->name('pages.')->group(function () {
    // Dynamic Pages
    // Note: We'll put this last or specific valid slugs to avoid conflict with other routes
    Route::get('/page/{slug}', 'show')->name('show'); // e.g. /page/about-us 
    // OR if we want root level like /about-us, we need to be careful.
    // Given the request asks for specific pages, we can map them to the new show logic.

    Route::get('/about-us', function () {
        return (new PageController)->show('about-us');
    })->name('about');
    Route::get('/cancellation-policy', function () {
        return (new PageController)->show('cancellation-policy');
    })->name('cancellation-policy');
    Route::get('/data-deletion', function () {
        return (new PageController)->show('data-deletion');
    })->name('data-deletion');
    Route::get('/privacy-policy', function () {
        return (new PageController)->show('privacy-policy');
    })->name('privacy-policy');
    Route::get('/pricing-refund-policy', function () {
        return (new PageController)->show('pricing-refund-policy');
    })->name('pricing-refund-policy');
    Route::get('/shipping-policy', function () {
        return (new PageController)->show('shipping-policy');
    })->name('shipping-policy');
    Route::get('/terms-conditions', function () {
        return (new PageController)->show('terms-conditions');
    })->name('terms-conditions');

    // Contact
    Route::get('/contact', 'contact')->name('contact');
    Route::post('/contact', 'storeContact')->name('contact.store');
});

// Reseller Routes
use App\Http\Controllers\ResellerController;
Route::get('/become-reseller', [ResellerController::class, 'create'])->name('reseller.create');
Route::post('/become-reseller', [ResellerController::class, 'store'])->name('reseller.store');
Route::get('/become-reseller/success', [ResellerController::class, 'success'])->name('reseller.success');

// Front-end Auth
use App\Http\Controllers\AuthController;
Route::get('/login', [AuthController::class, 'showLogin'])->name('login');
Route::post('/login', [AuthController::class, 'login'])->middleware('throttle:login')->name('login.submit');
// ...
Route::post('/admin/login', [AdminController::class, 'login'])->middleware('throttle:login')->name('admin.login.submit');
Route::get('/register', [AuthController::class, 'showRegister'])->name('register');
Route::post('/register', [AuthController::class, 'register'])->name('register.submit');
Route::post('/logout', [AuthController::class, 'logout'])->name('logout');

// Google Auth
use App\Http\Controllers\Auth\GoogleAuthController;
Route::get('auth/google', [GoogleAuthController::class, 'redirectToGoogle'])->name('auth.google');
Route::get('auth/google/callback', [GoogleAuthController::class, 'handleGoogleCallback'])->name('auth.google.callback');

// Password Reset Routes
use App\Http\Controllers\ForgotPasswordController;
Route::get('password/reset', [ForgotPasswordController::class, 'showLinkRequestForm'])->name('password.request');
Route::post('password/email', [ForgotPasswordController::class, 'sendResetLinkEmail'])->name('password.email');
Route::get('password/reset/{token}', [ForgotPasswordController::class, 'showResetForm'])->name('password.reset');
Route::post('password/reset', [ForgotPasswordController::class, 'reset'])->name('password.update');

// User Dashboard
// User Dashboard
use App\Http\Controllers\UserController;
use App\Http\Controllers\WishlistController;
Route::middleware(['auth'])->group(function () {
    Route::get('/user/dashboard', [UserController::class, 'dashboard'])->name('user.dashboard');
    Route::get('/user/profile', [UserController::class, 'profile'])->name('user.profile');
    Route::post('/user/profile', [UserController::class, 'updateProfile'])->name('user.profile.update');
    Route::get('/user/addresses', [UserController::class, 'addresses'])->name('user.addresses');
    Route::post('/user/addresses', [UserController::class, 'storeAddress'])->name('user.addresses.store');
    Route::put('/user/addresses/{address}', [UserController::class, 'updateAddress'])->name('user.addresses.update');
    Route::delete('/user/addresses/{address}', [UserController::class, 'destroyAddress'])->name('user.addresses.destroy');
    Route::get('/user/orders', [UserController::class, 'orders'])->name('user.orders');
    Route::get('/user/orders/{order}', [UserController::class, 'showOrder'])->name('user.orders.show');
    Route::get('/user/orders/{order}/invoice', [UserController::class, 'downloadInvoice'])->name('user.orders.invoice');
    Route::post('/user/orders/{order}/reorder', [UserController::class, 'reorder'])->name('user.orders.reorder');
    Route::post('/user/orders/{order}/cancel', [UserController::class, 'cancelOrder'])->name('user.orders.cancel');
    Route::get('/user/orders/{order}/location', [UserController::class, 'getOrderLocation'])->name('user.orders.location');
    Route::post('/user/orders/{order}/rate', [UserController::class, 'submitRating'])->name('user.orders.rate');
    Route::post('/user/orders/{order}/return', [\App\Http\Controllers\User\OrderReturnController::class, 'store'])->name('user.orders.return');

    // Newsletter
    Route::post('/newsletter/subscribe', [App\Http\Controllers\SubscriberController::class, 'store'])->name('newsletter.subscribe');

    // Wishlist Routes
    Route::get('/user/wishlist', [WishlistController::class, 'index'])->name('user.wishlist');
    Route::post('/wishlist/toggle', [WishlistController::class, 'toggle'])->name('wishlist.toggle');
    Route::delete('/wishlist/remove/{id}', [WishlistController::class, 'remove'])->name('wishlist.remove');
    Route::post('/wishlist/move-to-cart/{id}', [WishlistController::class, 'moveToCart'])->name('wishlist.move_to_cart');
    Route::post('/cart/move-to-wishlist/{itemId}', [CartController::class, 'moveToWishlist'])->name('cart.move_to_wishlist');

    Route::get('/user/support', [UserController::class, 'support'])->name('user.support');
    Route::get('/user/wallet', [UserController::class, 'wallet'])->name('user.wallet');
    Route::get('/user/settings', [UserController::class, 'settings'])->name('user.settings');
    Route::post('/user/password', [UserController::class, 'updatePassword'])->name('user.password.update');
    Route::post('/user/deactivate', [UserController::class, 'deactivateAccount'])->name('user.account.deactivate');

    // User Payment Methods
    Route::post('/user/payment-methods', [\App\Http\Controllers\User\PaymentMethodController::class, 'store'])->name('user.payment-methods.store');
    Route::delete('/user/payment-methods/{paymentMethod}', [\App\Http\Controllers\User\PaymentMethodController::class, 'destroy'])->name('user.payment-methods.destroy');
    Route::post('/user/payment-methods/{paymentMethod}/default', [\App\Http\Controllers\User\PaymentMethodController::class, 'setDefault'])->name('user.payment-methods.default');

    // Gift Cards
    Route::get('/user/gift-cards', [\App\Http\Controllers\UserGiftCardController::class, 'index'])->name('user.gift-cards.index');
    Route::post('/user/gift-cards', [\App\Http\Controllers\UserGiftCardController::class, 'store'])->name('user.gift-cards.store');

    // Validate Gift Card
    Route::post('/cart/gift-card/validate', [\App\Http\Controllers\CartController::class, 'validateGiftCard'])->name('cart.gift-card.validate');

    // Support Tickets
    Route::get('/user/tickets', [App\Http\Controllers\UserTicketController::class, 'index'])->name('user.tickets.index');
    Route::get('/user/tickets/create/{order}', [App\Http\Controllers\UserTicketController::class, 'create'])->name('user.tickets.create');
    Route::post('/user/tickets/{order}', [App\Http\Controllers\UserTicketController::class, 'store'])->name('user.tickets.store');
    Route::get('/user/tickets/{ticket}', [App\Http\Controllers\UserTicketController::class, 'show'])->name('user.tickets.show');
    Route::post('/user/tickets/{ticket}/reply', [App\Http\Controllers\UserTicketController::class, 'reply'])->name('user.tickets.reply');
    Route::post('/user/tickets/{ticket}/close', [App\Http\Controllers\UserTicketController::class, 'close'])->name('user.tickets.close');

    // Delivery Agent Routes
    Route::prefix('delivery')->name('delivery.')->middleware('agent.status')->group(function () {
        Route::get('/dashboard', [\App\Http\Controllers\DeliveryAgentController::class, 'dashboard'])->name('dashboard');
        Route::get('/profile', [\App\Http\Controllers\DeliveryAgentController::class, 'profile'])->name('profile');
        Route::post('/profile', [\App\Http\Controllers\DeliveryAgentController::class, 'updateProfile'])->name('profile.update');
        Route::get('/orders', [\App\Http\Controllers\DeliveryAgentController::class, 'orders'])->name('orders');
        Route::get('/orders/{id}', [\App\Http\Controllers\DeliveryAgentController::class, 'showOrder'])->name('orders.show');
        Route::post('/orders/{id}/status', [\App\Http\Controllers\DeliveryAgentController::class, 'updateOrderStatus'])->name('orders.update-status');
        Route::get('/notifications', [\App\Http\Controllers\DeliveryAgentController::class, 'notifications'])->name('notifications');
        Route::get('/settings', [\App\Http\Controllers\DeliveryAgentController::class, 'settings'])->name('settings');
        Route::post('/settings', [\App\Http\Controllers\DeliveryAgentController::class, 'updateSettings'])->name('settings.update');
        Route::post('/update-location', [\App\Http\Controllers\DeliveryAgentController::class, 'updateLocation'])->name('update-location');
        Route::get('/wallet', [\App\Http\Controllers\DeliveryAgentController::class, 'wallet'])->name('wallet');
    });
});

Route::get('/admin/login', [AdminController::class, 'showLogin'])->name('admin.login');
Route::post('/admin/login', [AdminController::class, 'login'])->middleware('throttle:login')->name('admin.login.submit');

Route::middleware(['auth'])->group(function () {
    // Admin Ticket Routes
    Route::middleware('permission:view_tickets')->group(function () {
        Route::get('admin/tickets', [TicketController::class, 'index'])->name('admin.tickets.index');
        Route::get('admin/tickets/{ticket}', [TicketController::class, 'show'])->name('admin.tickets.show');
    });
    Route::middleware('permission:manage_tickets')->group(function () {
        Route::post('admin/tickets/{ticket}/reply', [TicketController::class, 'reply'])->name('admin.tickets.reply');
        Route::post('admin/tickets/{ticket}/close', [TicketController::class, 'close'])->name('admin.tickets.close');
    });

    Route::middleware('permission:view_dashboard')->get('/admin/dashboard', [AdminController::class, 'dashboard'])->name('admin.dashboard');
    Route::match(['get', 'post'], '/admin/logout', [AdminController::class, 'logout'])->name('admin.logout');
    Route::get('/admin/profile/change-password', [AdminController::class, 'showChangePasswordForm'])->name('admin.profile.change-password');
    Route::post('/admin/profile/change-password', [AdminController::class, 'updatePassword'])->name('admin.profile.update-password');
    Route::get('/admin/profile', [AdminController::class, 'showProfileForm'])->name('admin.profile.edit');
    Route::post('/admin/profile', [AdminController::class, 'updateProfile'])->name('admin.profile.update');
    Route::get('/admin/profile/login-history', [AdminController::class, 'loginHistory'])->name('admin.profile.login-history');

    // Leadership Board (Sales Overview)
    // Leadership Board (Sales Overview)
    Route::get('/admin/leadership-board/pdf', [\App\Http\Controllers\Admin\LeadershipBoardController::class, 'downloadPdf'])->name('admin.leadership-board.pdf');
    Route::get('/admin/leadership-board', [\App\Http\Controllers\Admin\LeadershipBoardController::class, 'index'])->name('admin.leadership-board.index');

    // Pages (CMS)
    Route::get('/admin/pages', [\App\Http\Controllers\Admin\PageController::class, 'index'])->name('admin.pages.index');
    Route::get('/admin/pages/{page}/edit', [\App\Http\Controllers\Admin\PageController::class, 'edit'])->name('admin.pages.edit');
    Route::put('/admin/pages/{page}', [\App\Http\Controllers\Admin\PageController::class, 'update'])->name('admin.pages.update');

    // Admin Notifications
    Route::get('/admin/notifications', [\App\Http\Controllers\Admin\NotificationController::class, 'index'])->name('admin.notifications.index');
    Route::post('/admin/notifications/mark-all-read', [\App\Http\Controllers\Admin\NotificationController::class, 'markAllAsRead'])->name('admin.notifications.mark-all-read');
    Route::delete('/admin/notifications/{id}', [\App\Http\Controllers\Admin\NotificationController::class, 'destroy'])->name('admin.notifications.destroy');

    // Products Management
    Route::middleware('permission:create_categories')->group(function () {
        Route::get('admin/categories/create', [CategoryController::class, 'create'])->name('admin.categories.create');
        Route::post('admin/categories', [CategoryController::class, 'store'])->name('admin.categories.store');
    });

    Route::middleware('permission:view_categories')->group(function () {
        Route::get('admin/categories', [CategoryController::class, 'index'])->name('admin.categories.index');
        // Route::get('admin/categories/{category}', [CategoryController::class, 'show'])->name('admin.categories.show');
    });

    Route::middleware('permission:edit_categories')->group(function () {
        Route::get('admin/categories/{category}/edit', [CategoryController::class, 'edit'])->name('admin.categories.edit');
        Route::put('admin/categories/{category}', [CategoryController::class, 'update'])->name('admin.categories.update'); // Resource uses PUT/PATCH
        Route::patch('admin/categories/{category}', [CategoryController::class, 'update']);
        Route::post('admin/categories/{category}/toggle-status', [CategoryController::class, 'toggleStatus'])->name('admin.categories.toggle-status');
    });

    Route::middleware('permission:delete_categories')->delete('admin/categories/{category}', [CategoryController::class, 'destroy'])->name('admin.categories.destroy');
    // Helper route for categories
    Route::get('admin/categories/{category}/subcategories', [ProductController::class, 'getSubcategories']);


    // Products
    Route::middleware('permission:create_products')->group(function () {
        Route::post('admin/products/import', [ProductController::class, 'import'])->name('admin.products.import');
        Route::get('admin/products/create', [ProductController::class, 'create'])->name('admin.products.create');
        Route::post('admin/products/duplicate', [ProductController::class, 'duplicate'])->name('admin.products.duplicate');
        Route::post('admin/products', [ProductController::class, 'store'])->name('admin.products.store');
    });

    Route::middleware('permission:view_products')->group(function () {
        Route::get('admin/products/export/pdf', [ProductController::class, 'exportPdf'])->name('admin.products.export-pdf');
        Route::get('admin/products/sample', [ProductController::class, 'downloadSample'])->name('admin.products.sample');
        Route::get('admin/products/search-suggestions', [ProductController::class, 'searchSuggestions'])->name('admin.products.search-suggestions');
        Route::get('admin/products/{product}/sales', [ProductController::class, 'sales'])->name('admin.products.sales');
        Route::get('admin/products', [ProductController::class, 'index'])->name('admin.products.index');
        // Route::get('admin/products/{product}', [ProductController::class, 'show'])->name('admin.products.show');
    });

    Route::middleware('permission:edit_products')->group(function () {
        Route::get('admin/products/{product}/edit', [ProductController::class, 'edit'])->name('admin.products.edit');
        Route::put('admin/products/{product}', [ProductController::class, 'update'])->name('admin.products.update');
        Route::patch('admin/products/{product}', [ProductController::class, 'update']);
        Route::post('admin/products/{product}/toggle-status', [ProductController::class, 'toggleStatus'])->name('admin.products.toggle-status');
        Route::delete('admin/products/images/{productImage}', [ProductController::class, 'deleteImage'])->name('admin.products.delete-image');
        Route::post('admin/products/{product}/images/{image}/default', [ProductController::class, 'setDefaultImage'])->name('admin.products.images.set-default');
        Route::get('admin/products/{product}/variations', [ProductController::class, 'getVariations'])->name('admin.products.get-variations');
        Route::post('admin/products/{product}/quick-update-variations', [ProductController::class, 'updateQuickVariations'])->name('admin.products.update-quick-variations');
    });

    Route::middleware('permission:delete_products')->delete('admin/products/{product}', [ProductController::class, 'destroy'])->name('admin.products.destroy');


    // Users Management
    Route::middleware('permission:create_users')->group(function () {
        Route::get('admin/users/create', [AdminUserController::class, 'create'])->name('admin.users.create');
        Route::post('admin/users', [AdminUserController::class, 'store'])->name('admin.users.store');
    });

    Route::middleware('permission:view_users')->group(function () {
        Route::get('admin/users/export/pdf', [AdminUserController::class, 'exportPdf'])->name('admin.users.export-pdf');
        Route::get('admin/users', [AdminUserController::class, 'index'])->name('admin.users.index');
        // If show is needed, add it here, otherwise comment out or remove if it doesn't exist
        // Route::get('admin/users/{user}', [AdminUserController::class, 'show'])->name('admin.users.show');
    });
    Route::middleware('permission:edit_users')->group(function () {
        Route::get('admin/users/{user}/edit', [AdminUserController::class, 'edit'])->name('admin.users.edit');
        Route::put('admin/users/{user}', [AdminUserController::class, 'update'])->name('admin.users.update');
        Route::patch('admin/users/{user}', [AdminUserController::class, 'update']);
        Route::post('admin/users/{user}/toggle-status', [AdminUserController::class, 'toggleStatus'])->name('admin.users.toggle-status');
    });
    Route::middleware('permission:delete_users')->delete('admin/users/{user}', [AdminUserController::class, 'destroy'])->name('admin.users.destroy');


    // Clients/Customers
    Route::middleware('permission:view_customers')->group(function () {
        Route::get('admin/clients', [ClientController::class, 'index'])->name('admin.clients.index');
        Route::get('admin/clients/{client}', [ClientController::class, 'show'])->name('admin.clients.show');
        Route::get('admin/clients/{client}/orders', [ClientController::class, 'orders'])->name('admin.clients.orders');
        Route::post('admin/clients/{client}/notification', [ClientController::class, 'sendNotification'])->name('admin.clients.send-notification'); // Added
    });


    // Orders
    Route::middleware('permission:view_orders')->group(function () {
        Route::get('admin/orders', [OrderController::class, 'index'])->name('admin.orders.index');
        Route::get('admin/orders/{order}', [OrderController::class, 'show'])->name('admin.orders.show');
        Route::get('admin/orders/{order}/invoice', [OrderController::class, 'downloadInvoice'])->name('admin.orders.invoice');
    });
    Route::middleware('permission:manage_orders')->group(function () {
        Route::get('admin/orders/{order}/edit', [OrderController::class, 'edit'])->name('admin.orders.edit');
        Route::put('admin/orders/{order}', [OrderController::class, 'update'])->name('admin.orders.update');
        Route::patch('admin/orders/{order}', [OrderController::class, 'update']);
        Route::post('admin/orders/{order}/status', [OrderController::class, 'updateStatus'])->name('admin.orders.update-status');
        Route::post('admin/orders/{order}/assign-agent', [OrderController::class, 'assignAgent'])->name('admin.orders.assign-agent');
        Route::post('admin/orders/{order}/generate-quotation', [OrderController::class, 'generateQuotation'])->name('admin.orders.generate-quotation');
    });
    Route::middleware('permission:delete_orders')->delete('admin/orders/{order}', [OrderController::class, 'destroy'])->name('admin.orders.destroy');

    // Returns Management
    Route::middleware('permission:view_returns')->group(function () {
        Route::get('admin/returns', [\App\Http\Controllers\Admin\OrderReturnController::class, 'index'])->name('admin.returns.index');
        Route::get('admin/returns/{return}', [\App\Http\Controllers\Admin\OrderReturnController::class, 'show'])->name('admin.returns.show');
    });

    Route::middleware('permission:manage_returns')->group(function () {
        Route::post('admin/returns/{return}/status', [\App\Http\Controllers\Admin\OrderReturnController::class, 'updateStatus'])->name('admin.returns.update-status');
    });

    Route::middleware('permission:process_refunds')->group(function () {
        Route::post('admin/returns/{return}/refund', [\App\Http\Controllers\Admin\OrderReturnController::class, 'processRefund'])->name('admin.returns.refund');
    });


    // Subscribers
    Route::middleware('permission:view_subscribers')->group(function () {
        Route::get('admin/subscribers', [SubscriberController::class, 'index'])->name('admin.subscribers.index');
        Route::delete('admin/subscribers/{subscriber}', [SubscriberController::class, 'destroy'])->name('admin.subscribers.destroy'); // Usually managed with view or separate perm
    });


    // Roles Management
    Route::middleware('permission:view_roles')->get('admin/roles', [RoleController::class, 'index'])->name('admin.roles.index');
    Route::middleware('permission:create_roles')->group(function () {
        Route::get('admin/roles/create', [RoleController::class, 'create'])->name('admin.roles.create');
        Route::post('admin/roles', [RoleController::class, 'store'])->name('admin.roles.store');
    });
    Route::middleware('permission:edit_roles')->group(function () {
        Route::get('admin/roles/{role}/edit', [RoleController::class, 'edit'])->name('admin.roles.edit');
        Route::put('admin/roles/{role}', [RoleController::class, 'update'])->name('admin.roles.update');
        Route::patch('admin/roles/{role}', [RoleController::class, 'update']);
        Route::post('admin/roles/{role}/toggle-status', [RoleController::class, 'toggleStatus'])->name('admin.roles.toggle-status');
    });
    Route::middleware('permission:delete_roles')->delete('admin/roles/{role}', [RoleController::class, 'destroy'])->name('admin.roles.destroy');


    // Delivery Agents
    Route::middleware('permission:manage_delivery_agents')->group(function () {
        Route::get('admin/delivery-agents/notification', [DeliveryAgentController::class, 'showNotificationForm'])->name('admin.delivery-agents.notification');
        Route::post('admin/delivery-agents/notification', [DeliveryAgentController::class, 'sendNotification'])->name('admin.delivery-agents.send-notification');
        Route::resource('admin/delivery-agents', DeliveryAgentController::class, ['as' => 'admin']);
        Route::post('admin/delivery-agents/{deliveryAgent}/toggle-status', [DeliveryAgentController::class, 'toggleStatus'])->name('admin.delivery-agents.toggle-status');
        Route::delete('admin/delivery-agents/document/{id}', [DeliveryAgentController::class, 'destroyDocument'])->name('admin.delivery-agents.delete-document');
        Route::delete('admin/delivery-agents/vehicle/{id}', [DeliveryAgentController::class, 'destroyVehicle'])->name('admin.delivery-agents.delete-vehicle');
    });

    // Stores
    Route::middleware('permission:manage_stores')->resource('admin/stores', StoreController::class, ['as' => 'admin']);

    // Marketing (Coupons/Discounts)
    Route::middleware('permission:view_coupons')->group(function () {
        Route::get('admin/discounts', [DiscountController::class, 'index'])->name('admin.discounts.index');
        Route::get('admin/coupons', [CouponController::class, 'index'])->name('admin.coupons.index');
    });
    Route::middleware('permission:manage_coupons')->group(function () {
        Route::get('admin/discounts/create', [DiscountController::class, 'create'])->name('admin.discounts.create');
        Route::post('admin/discounts', [DiscountController::class, 'store'])->name('admin.discounts.store');
        Route::get('admin/discounts/{discount}/edit', [DiscountController::class, 'edit'])->name('admin.discounts.edit');
        Route::put('admin/discounts/{discount}', [DiscountController::class, 'update'])->name('admin.discounts.update');
        Route::delete('admin/discounts/{discount}', [DiscountController::class, 'destroy'])->name('admin.discounts.destroy');
        Route::post('admin/discounts/{discount}/toggle-status', [DiscountController::class, 'toggleStatus'])->name('admin.discounts.toggle-status');

        Route::get('admin/coupons/create', [CouponController::class, 'create'])->name('admin.coupons.create');
        Route::post('admin/coupons', [CouponController::class, 'store'])->name('admin.coupons.store');
        Route::get('admin/coupons/{coupon}/edit', [CouponController::class, 'edit'])->name('admin.coupons.edit');
        Route::put('admin/coupons/{coupon}', [CouponController::class, 'update'])->name('admin.coupons.update');
        Route::delete('admin/coupons/{coupon}', [CouponController::class, 'destroy'])->name('admin.coupons.destroy');
        Route::post('admin/coupons/{coupon}/toggle-status', [CouponController::class, 'toggleStatus'])->name('admin.coupons.toggle-status');
    });

    // Contact Submissions
    Route::middleware('permission:view_contacts')->group(function () {
        Route::get('admin/contacts', [ContactController::class, 'index'])->name('admin.contacts.index');
        Route::get('admin/contacts/{contact}', [ContactController::class, 'show'])->name('admin.contacts.show');

        // Video Consultations
        Route::get('admin/consultations', [\App\Http\Controllers\Admin\VideoConsultationController::class, 'index'])->name('admin.consultations.index');
        Route::patch('admin/consultations/{id}/status', [\App\Http\Controllers\Admin\VideoConsultationController::class, 'updateStatus'])->name('admin.consultations.updateStatus');
        Route::delete('admin/consultations/{id}', [\App\Http\Controllers\Admin\VideoConsultationController::class, 'destroy'])->name('admin.consultations.destroy');
    });

    // Gift Cards (Admin View) - Assuming part of Coupons/Marketing or View Coupons
    Route::middleware('permission:view_coupons')->get('admin/gift-cards', [\App\Http\Controllers\Admin\GiftCardController::class, 'index'])->name('admin.gift-cards.index');

    // Reports Routes
    Route::prefix('admin/reports')->name('admin.reports.')->middleware('permission:view_reports')->group(function () {
        Route::get('orders/{status}', [ReportController::class, 'ordersReport'])->name('orders');
        Route::get('payments', [ReportController::class, 'paymentsReport'])->name('payments');
        Route::get('payments/pdf', [ReportController::class, 'downloadPaymentsPdf'])->name('payments.pdf');
        Route::get('clients', [ReportController::class, 'clientsReport'])->name('clients');
        Route::get('traffic', [ReportController::class, 'trafficReport'])->name('traffic');

        // Shipping Report
        Route::get('shipping', [ReportController::class, 'shippingReport'])->name('shipping');
        Route::get('shipping/pdf', [ReportController::class, 'downloadShippingPdf'])->name('shipping.pdf');

        // Tax Report
        Route::get('tax', [ReportController::class, 'taxReport'])->name('tax');
        Route::get('tax/pdf', [ReportController::class, 'downloadTaxPdf'])->name('tax.pdf');

        // Refund Report
        Route::get('refunds', [\App\Http\Controllers\Admin\OrderReturnController::class, 'report'])->name('refunds')->middleware('permission:view_refund_reports');
    });

    // Tax Settings Routes (Separated to fix naming)
    Route::middleware('permission:manage_settings')->resource('admin/tax-rates', TaxRateController::class, ['as' => 'admin']);

    // Settings Routes
    Route::prefix('admin/settings')->name('admin.settings.')->middleware('permission:manage_settings')->group(function () {
        // Website Settings
        Route::get('website', [SettingController::class, 'showWebsite'])->name('website.show');
        Route::post('website', [SettingController::class, 'updateWebsite'])->name('website.update');

        // Cart Settings
        Route::get('cart', [SettingController::class, 'showCart'])->name('cart.show');
        Route::post('cart', [SettingController::class, 'updateCart'])->name('cart.update');

        // Payment Options
        Route::get('payment', [SettingController::class, 'showPayment'])->name('payment.show');
        Route::post('payment', [SettingController::class, 'updatePayment'])->name('payment.update');

        // Payment Gateway
        Route::get('gateway', [SettingController::class, 'showGateway'])->name('gateway.show');
        Route::post('gateway', [SettingController::class, 'updateGateway'])->name('gateway.update');

        // Shipping Settings
        Route::get('shipping', [SettingController::class, 'showShipping'])->name('shipping.show');
        Route::post('shipping', [SettingController::class, 'updateShipping'])->name('shipping.update');

        // Wallet Settings
        Route::get('wallet', [SettingController::class, 'showWallet'])->name('wallet.show');
        Route::post('wallet', [SettingController::class, 'updateWallet'])->name('wallet.update');

        // Store Settings
        Route::get('store', [SettingController::class, 'showStore'])->name('store.show');
        Route::post('store', [SettingController::class, 'updateStore'])->name('store.update');

        // Sliders
        Route::resource('sliders', SliderController::class);
        Route::post('sliders/{slider}/toggle-status', [SliderController::class, 'toggleStatus'])->name('sliders.toggle-status');

        // Promotional Banners
        Route::resource('promotional', PromotionalBannerController::class)->parameters(['promotional' => 'banner']);
        Route::post('promotional/{banner}/toggle-status', [PromotionalBannerController::class, 'toggleStatus'])->name('promotional.toggle-status');
        // SEO Settings
        Route::get('seo', [\App\Http\Controllers\Admin\SeoSettingController::class, 'show'])->name('seo.show');
        Route::post('seo', [\App\Http\Controllers\Admin\SeoSettingController::class, 'update'])->name('seo.update');

        // Policy Rules
        Route::get('policy', [\App\Http\Controllers\Admin\PolicyController::class, 'show'])->name('policy.show');
        Route::post('policy', [\App\Http\Controllers\Admin\PolicyController::class, 'update'])->name('policy.update');

        // Appearance Settings
        Route::get('appearance', [SettingController::class, 'showAppearance'])->name('appearance.show');
        Route::post('appearance', [SettingController::class, 'updateAppearance'])->name('appearance.update');
        // Notification Settings
        Route::get('notification', [SettingController::class, 'showNotification'])->name('notification.show');
        Route::post('notification', [SettingController::class, 'updateNotification'])->name('notification.update');

        // Tax Settings
        Route::get('tax', [SettingController::class, 'showTax'])->name('tax.show');
        Route::post('tax', [SettingController::class, 'updateTax'])->name('tax.update');

        // Logistics Settings
        Route::get('logistics', [SettingController::class, 'showLogistics'])->name('logistics.show');
        Route::post('logistics', [SettingController::class, 'updateLogistics'])->name('logistics.update');

        // Analytics Settings
        Route::get('analytics', [SettingController::class, 'showAnalytics'])->name('analytics.show');
        Route::post('analytics', [SettingController::class, 'updateAnalytics'])->name('analytics.update');

        // Developer Settings
        Route::get('developer', [\App\Http\Controllers\Admin\DeveloperSettingController::class, 'index'])->name('developer.index');
        Route::post('developer/clear-cache', [\App\Http\Controllers\Admin\DeveloperSettingController::class, 'clearCache'])->name('developer.clear-cache');
        Route::post('developer/run-build', [\App\Http\Controllers\Admin\DeveloperSettingController::class, 'runBuild'])->name('developer.run-build');
        Route::get('developer/export-db', [\App\Http\Controllers\Admin\DeveloperSettingController::class, 'exportDatabase'])->name('developer.export-db');
        Route::post('developer/import-db', [\App\Http\Controllers\Admin\DeveloperSettingController::class, 'importDatabase'])->name('developer.import-db');
        Route::post('developer/migrate-db', [\App\Http\Controllers\Admin\DeveloperSettingController::class, 'migrateDatabase'])->name('developer.migrate-db');
        Route::post('developer/db-seed', [\App\Http\Controllers\Admin\DeveloperSettingController::class, 'runSeeder'])->name('developer.db-seed');
        
        // Custom Offers
        Route::resource('custom_offers', \App\Http\Controllers\Admin\CustomOfferController::class);
    });

    // Blog
    Route::middleware('permission:view_blogs')->get('admin/blogs', [\App\Http\Controllers\Admin\BlogController::class, 'index'])->name('admin.blogs.index');
    Route::middleware('permission:create_blogs')->group(function () {
        Route::get('admin/blogs/create', [\App\Http\Controllers\Admin\BlogController::class, 'create'])->name('admin.blogs.create');
        Route::post('admin/blogs', [\App\Http\Controllers\Admin\BlogController::class, 'store'])->name('admin.blogs.store');
    });
    Route::middleware('permission:edit_blogs')->group(function () {
        Route::get('admin/blogs/{blog}/edit', [\App\Http\Controllers\Admin\BlogController::class, 'edit'])->name('admin.blogs.edit');
        Route::put('admin/blogs/{blog}', [\App\Http\Controllers\Admin\BlogController::class, 'update'])->name('admin.blogs.update');
        Route::patch('admin/blogs/{blog}', [\App\Http\Controllers\Admin\BlogController::class, 'update']);
        Route::post('admin/blogs/{blog}/toggle-status', [\App\Http\Controllers\Admin\BlogController::class, 'toggleStatus'])->name('admin.blogs.toggle-status');
    });
    Route::middleware('permission:delete_blogs')->delete('admin/blogs/{blog}', [\App\Http\Controllers\Admin\BlogController::class, 'destroy'])->name('admin.blogs.destroy');

    // Testimonials
    Route::middleware('permission:manage_settings')->resource('admin/testimonials', \App\Http\Controllers\Admin\TestimonialController::class, ['as' => 'admin']);

    // Email Templates
    Route::resource('admin/email-templates', \App\Http\Controllers\Admin\EmailTemplateController::class, ['as' => 'admin']);

    // Bulk Email
    Route::get('admin/bulk-email', [\App\Http\Controllers\Admin\BulkEmailController::class, 'index'])->name('admin.bulk-email.index');
    Route::post('admin/bulk-email/send', [\App\Http\Controllers\Admin\BulkEmailController::class, 'send'])->name('admin.bulk-email.send');
    Route::get('admin/bulk-email/{id}/logs', [\App\Http\Controllers\Admin\BulkEmailController::class, 'showLogs'])->name('admin.bulk-email.logs');
    Route::post('admin/bulk-email/{id}/resend', [\App\Http\Controllers\Admin\BulkEmailController::class, 'resend'])->name('admin.bulk-email.resend');
    Route::delete('admin/bulk-email/{id}', [\App\Http\Controllers\Admin\BulkEmailController::class, 'destroy'])->name('admin.bulk-email.destroy');

    // System Errors
    Route::middleware('permission:manage_settings')->group(function () {
        Route::get('admin/system-errors', [\App\Http\Controllers\Admin\SystemErrorController::class, 'index'])->name('admin.system-errors.index');
        Route::get('admin/system-errors/{error}', [\App\Http\Controllers\Admin\SystemErrorController::class, 'show'])->name('admin.system-errors.show');
        Route::post('admin/system-errors/{error}/resolve', [\App\Http\Controllers\Admin\SystemErrorController::class, 'resolve'])->name('admin.system-errors.resolve');
        Route::delete('admin/system-errors/{error}', [\App\Http\Controllers\Admin\SystemErrorController::class, 'destroy'])->name('admin.system-errors.destroy');
        Route::post('admin/system-errors/clear-all', [\App\Http\Controllers\Admin\SystemErrorController::class, 'clearAll'])->name('admin.system-errors.clear-all');
    });

    // Resellers Management
    Route::middleware('permission:manage_users')->group(function () {
        Route::get('admin/resellers', [\App\Http\Controllers\Admin\ResellerController::class, 'index'])->name('admin.resellers.index');
        Route::get('admin/resellers/{reseller}', [\App\Http\Controllers\Admin\ResellerController::class, 'show'])->name('admin.resellers.show');
        Route::post('admin/resellers/{reseller}/status', [\App\Http\Controllers\Admin\ResellerController::class, 'updateStatus'])->name('admin.resellers.update-status');
        Route::delete('admin/resellers/{reseller}', [\App\Http\Controllers\Admin\ResellerController::class, 'destroy'])->name('admin.resellers.destroy');
    });

    // Funnel Analytics
    Route::middleware('permission:view_reports')->group(function () {
        Route::get('admin/analytics/funnel', [\App\Http\Controllers\Admin\AnalyticsController::class, 'funnel'])->name('admin.analytics.funnel');
        Route::get('admin/analytics/session/{sessionId}', [\App\Http\Controllers\Admin\AnalyticsController::class, 'viewSession'])->name('admin.analytics.session');
    });
    // AI Chatbot
    Route::middleware('permission:manage_settings')->group(function () {
        Route::get('admin/chatbot', [\App\Http\Controllers\Admin\ChatbotController::class, 'index'])->name('admin.chatbot.index');
        Route::post('admin/chatbot/settings', [\App\Http\Controllers\Admin\ChatbotController::class, 'updateSettings'])->name('admin.chatbot.update-settings');
        Route::post('admin/chatbot/training', [\App\Http\Controllers\Admin\ChatbotController::class, 'storeTrainingData'])->name('admin.chatbot.training.store');
        Route::delete('admin/chatbot/training/{id}', [\App\Http\Controllers\Admin\ChatbotController::class, 'destroyTrainingData'])->name('admin.chatbot.training.destroy');
        Route::post('admin/chatbot/learn', [\App\Http\Controllers\Admin\ChatbotController::class, 'learn'])->name('admin.chatbot.learn');
    });
});

// Blog Routes (Public)
Route::get('/blogs', [\App\Http\Controllers\BlogController::class, 'index'])->name('blogs.index');
Route::get('/blogs/{slug}', [\App\Http\Controllers\BlogController::class, 'show'])->name('blogs.show');

// Testimonials (Public)
Route::get('/testimonials', [\App\Http\Controllers\TestimonialController::class, 'index'])->name('testimonials.index');

// Reseller Panel Routes
Route::prefix('reseller')->name('reseller.')->group(function () {
    // Auth
    Route::get('login', [\App\Http\Controllers\Reseller\Auth\LoginController::class, 'showLoginForm'])->name('login');
    Route::post('login', [\App\Http\Controllers\Reseller\Auth\LoginController::class, 'login'])->name('login.submit');

    // Dashboard
    Route::middleware(['auth', 'role:Reseller'])->group(function () {
        Route::get('dashboard', [\App\Http\Controllers\Reseller\DashboardController::class, 'index'])->name('dashboard');

        // Profile
        Route::get('profile', [\App\Http\Controllers\Reseller\DashboardController::class, 'profile'])->name('profile');
        Route::post('profile', [\App\Http\Controllers\Reseller\DashboardController::class, 'updateProfile'])->name('profile.update');

        // Settings (Change Password)
        // Re-using user change password route or creating specific one?
        // Let's use the generic User one if feasible, but user might be redirected differently.
        // For simplicity, we can link to user.settings or implement logic here.
        // The prompt says "settings(change password just like client change password)".
        // Client uses `user.password.update`. We can reuse that route if we are logged in as User.

        // Orders
        Route::get('orders/create', [\App\Http\Controllers\Reseller\OrderController::class, 'create'])->name('orders.create');
        Route::post('orders', [\App\Http\Controllers\Reseller\OrderController::class, 'store'])->name('orders.store');
        Route::get('orders', [\App\Http\Controllers\Reseller\OrderController::class, 'index'])->name('orders.index');
        Route::get('orders/{order}', [\App\Http\Controllers\Reseller\OrderController::class, 'show'])->name('orders.show');
        Route::post('orders/{order}/accept-quotation', [\App\Http\Controllers\Reseller\OrderController::class, 'acceptQuotation'])->name('orders.accept-quotation');
        Route::get('orders/{order}/invoice', [\App\Http\Controllers\Reseller\OrderController::class, 'downloadInvoice'])->name('orders.invoice');
    });
});

// Video Consultation (Use full namespace to avoid import issue)
Route::post('/consultation/book', [\App\Http\Controllers\VideoConsultationController::class, 'store'])->name('consultation.book');


// Utility Route to Fix Storage Link on Shared Hosting
Route::get('/fix-storage-permissions', function () {
    $targetPath = storage_path('app/public');
    $linkPath = public_path('storage');

    // 1. Check if target exists
    if (!file_exists($targetPath)) {
        return "Error: The target directory [{$targetPath}] does not exist. Please upload your 'storage/app/public' folder.";
    }

    // 2. Check if link already exists
    if (file_exists($linkPath)) {
        // If it's a directory (often happens on FTP upload if 'storage' folder was uploaded instead of linked)
        if (is_dir($linkPath) && !is_link($linkPath)) {
            return "Error: [{$linkPath}] is a real directory, not a symbolic link. <br>Please delete the 'storage' folder inside your 'public' directory using FTP or File Manager, then refresh this page.";
        }
    }

    // 3. Attempt to create the link
    try {
        // If link exists, it might be broken or pointing wrong, let's try to recreate it if possible, 
        // or Artisan::call('storage:link') handles this better.
        // Let's use Artisan directly as it's cleaner.
        \Illuminate\Support\Facades\Artisan::call('storage:link');
        return "Success! Symbolic link has been created/repaired. <a href='/'>Go to Home</a>";
    } catch (\Exception $e) {
        // Fallback to manual symlink if Artisan fails (some hosts block it)
        try {
            if (file_exists($linkPath)) {
                // Try to unlink if it exists as a link
                if (is_link($linkPath))
                    unlink($linkPath);
            }
            symlink($targetPath, $linkPath);
            return "Success! Symbolic link created manually. <a href='/'>Go to Home</a>";
        } catch (\Exception $e2) {
            return "Failed to create link: " . $e2->getMessage() . "<br><br>Target: $targetPath<br>Link: $linkPath";
        }
    }
});
Route::get('/test-code',function(){
    $response = Http::get('http://127.0.0.1:8080/about');
    return $response->json();
});