<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

// Customer / Client API
Route::prefix('customer')->group(function () {
    // Auth
    Route::post('register', [\App\Http\Controllers\Api\CustomerAuthController::class, 'register']);
    Route::post('login', [\App\Http\Controllers\Api\CustomerAuthController::class, 'login']);

    // Public
    Route::get('home', [\App\Http\Controllers\Api\CustomerHomeController::class, 'index']);
    Route::get('categories', [\App\Http\Controllers\Api\CustomerCategoryController::class, 'index']);
    Route::get('products', [\App\Http\Controllers\Api\CustomerProductController::class, 'index']);
    Route::get('products/{id}', [\App\Http\Controllers\Api\CustomerProductController::class, 'show']);
    Route::get('product-images', [\App\Http\Controllers\Api\CustomerProductController::class, 'getImagesBatch']);

    // Protected
    Route::middleware('auth:sanctum')->group(function () {
        Route::post('logout', [\App\Http\Controllers\Api\CustomerAuthController::class, 'logout']);
        Route::get('user', [\App\Http\Controllers\Api\CustomerAuthController::class, 'user']);

        // Orders
        Route::get('orders', [\App\Http\Controllers\Api\CustomerOrderController::class, 'index']);
        Route::get('orders/{id}', [\App\Http\Controllers\Api\CustomerOrderController::class, 'show']);
        Route::get('orders/{id}/invoice.pdf', [\App\Http\Controllers\Api\CustomerOrderController::class, 'downloadInvoice'])->name('api.customer.orders.invoice');
        Route::post('orders/{id}/cancel', [\App\Http\Controllers\Api\CustomerOrderController::class, 'cancel']);
        Route::post('orders/{id}/rate', [\App\Http\Controllers\Api\CustomerOrderController::class, 'rate']);
        Route::post('orders/{id}/reorder', [\App\Http\Controllers\Api\CustomerOrderController::class, 'reorder']);

        // Addresses
        Route::get('addresses/countries', [\App\Http\Controllers\Api\CustomerAddressController::class, 'getCountries']);
        Route::get('addresses', [\App\Http\Controllers\Api\CustomerAddressController::class, 'index']);
        Route::post('addresses', [\App\Http\Controllers\Api\CustomerAddressController::class, 'store']);
        Route::put('addresses/{id}', [\App\Http\Controllers\Api\CustomerAddressController::class, 'update']);
        Route::delete('addresses/{id}', [\App\Http\Controllers\Api\CustomerAddressController::class, 'destroy']);
        Route::post('addresses/{id}/default', [\App\Http\Controllers\Api\CustomerAddressController::class, 'setDefault']);

        // Wallet
        Route::get('wallet', [\App\Http\Controllers\Api\CustomerWalletController::class, 'index']);

        // Gift Cards
        Route::get('gift-cards', [\App\Http\Controllers\Api\CustomerGiftCardController::class, 'index']);
        Route::post('gift-cards', [\App\Http\Controllers\Api\CustomerGiftCardController::class, 'store']); // Create/Purchase
        Route::post('gift-cards/redeem', [\App\Http\Controllers\Api\CustomerGiftCardController::class, 'redeem']); // Redeem

        // Support Tickets
        Route::get('tickets', [\App\Http\Controllers\Api\CustomerTicketController::class, 'index']);
        Route::post('tickets', [\App\Http\Controllers\Api\CustomerTicketController::class, 'store']);
        Route::get('tickets/{id}', [\App\Http\Controllers\Api\CustomerTicketController::class, 'show']);
        Route::post('tickets/{id}/reply', [\App\Http\Controllers\Api\CustomerTicketController::class, 'reply']);
        Route::post('tickets/{id}/close', [\App\Http\Controllers\Api\CustomerTicketController::class, 'close']);

        // Settings & Profile
        Route::get('settings', [\App\Http\Controllers\Api\CustomerSettingsController::class, 'index']);
        Route::post('settings/profile', [\App\Http\Controllers\Api\CustomerSettingsController::class, 'updateProfile']);
        Route::post('settings/password', [\App\Http\Controllers\Api\CustomerSettingsController::class, 'updatePassword']);
        Route::post('settings/deactivate', [\App\Http\Controllers\Api\CustomerSettingsController::class, 'deactivateAccount']);
        Route::post('update-fcm-token', [\App\Http\Controllers\Api\CustomerSettingsController::class, 'updateFcmToken']); // Added


        // Wishlist
        Route::get('wishlist', [\App\Http\Controllers\Api\CustomerWishlistController::class, 'index']);
        Route::post('wishlist/toggle', [\App\Http\Controllers\Api\CustomerWishlistController::class, 'toggle']);
        Route::delete('wishlist/clear', [\App\Http\Controllers\Api\CustomerWishlistController::class, 'clear']);
        Route::delete('wishlist/{productId}', [\App\Http\Controllers\Api\CustomerWishlistController::class, 'destroy']);

        // Cart
        Route::get('cart', [\App\Http\Controllers\Api\CustomerCartController::class, 'index']);
        Route::post('cart/add', [\App\Http\Controllers\Api\CustomerCartController::class, 'add']);
        Route::put('cart/{itemId}', [\App\Http\Controllers\Api\CustomerCartController::class, 'update']);
        Route::delete('cart/clear', [\App\Http\Controllers\Api\CustomerCartController::class, 'clear']);
        Route::delete('cart/{itemId}', [\App\Http\Controllers\Api\CustomerCartController::class, 'remove']);

        // Checkout
        Route::post('checkout/summary', [\App\Http\Controllers\Api\CustomerCheckoutController::class, 'preview']); // Added back
        Route::post('checkout/place-order', [\App\Http\Controllers\Api\CustomerCheckoutController::class, 'placeOrder']);
        Route::post('checkout/verify-payment', [\App\Http\Controllers\Api\CustomerCheckoutController::class, 'verifyPayment']);

        // Notifications
        Route::get('notifications', [\App\Http\Controllers\Api\CustomerNotificationController::class, 'index']);
        Route::post('notifications/{id}/read', [\App\Http\Controllers\Api\CustomerNotificationController::class, 'markAsRead']);
        Route::post('notifications/read-all', [\App\Http\Controllers\Api\CustomerNotificationController::class, 'markAllAsRead']);
        Route::delete('notifications/{id}', [\App\Http\Controllers\Api\CustomerNotificationController::class, 'destroy']);
        Route::delete('notifications/clear-all', [\App\Http\Controllers\Api\CustomerNotificationController::class, 'clearAll']);
    });
});

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

Route::prefix('delivery-agent')->group(function () {
    Route::post('login', [\App\Http\Controllers\Api\DeliveryAgentAuthController::class, 'login']);

    Route::middleware(['auth:sanctum', 'agent.status'])->group(function () {
        Route::post('logout', [\App\Http\Controllers\Api\DeliveryAgentAuthController::class, 'logout']);
        Route::get('dashboard', [\App\Http\Controllers\Api\DeliveryAgentOrderController::class, 'dashboard']);
        Route::get('profile', [\App\Http\Controllers\Api\DeliveryAgentProfileController::class, 'show']);
        Route::post('profile', [\App\Http\Controllers\Api\DeliveryAgentProfileController::class, 'update']);
        Route::get('settings', [\App\Http\Controllers\Api\DeliveryAgentSettingsController::class, 'index']);
        Route::post('settings/toggle-availability', [\App\Http\Controllers\Api\DeliveryAgentSettingsController::class, 'toggleAvailability']);
        Route::post('settings/update-password', [\App\Http\Controllers\Api\DeliveryAgentSettingsController::class, 'updatePassword']);
        Route::post('settings/deactivate', [\App\Http\Controllers\Api\DeliveryAgentSettingsController::class, 'deactivateAccount']);
        Route::post('update-fcm-token', [\App\Http\Controllers\Api\DeliveryAgentProfileController::class, 'updateFcmToken']);

        // Notifications
        Route::get('notifications', [\App\Http\Controllers\Api\DeliveryAgentNotificationController::class, 'index']);
        Route::post('notifications/{id}/read', [\App\Http\Controllers\Api\DeliveryAgentNotificationController::class, 'markAsRead']);
        Route::post('notifications/read-all', [\App\Http\Controllers\Api\DeliveryAgentNotificationController::class, 'markAllAsRead']);
        Route::delete('notifications/{id}', [\App\Http\Controllers\Api\DeliveryAgentNotificationController::class, 'destroy']);
        Route::delete('notifications/clear-all', [\App\Http\Controllers\Api\DeliveryAgentNotificationController::class, 'clearAll']);

        // Orders
        Route::get('orders', [\App\Http\Controllers\Api\DeliveryAgentOrderController::class, 'index']);
        Route::get('orders/{id}', [\App\Http\Controllers\Api\DeliveryAgentOrderController::class, 'show']);
        Route::post('orders/{id}/status', [\App\Http\Controllers\Api\DeliveryAgentOrderController::class, 'updateStatus']);
    });
});

Route::prefix('reseller')->group(function () {
    Route::post('login', [\App\Http\Controllers\Api\ResellerAuthController::class, 'login']);
    Route::post('signup', [\App\Http\Controllers\Api\ResellerAuthController::class, 'signup']);

    Route::middleware('auth:sanctum')->group(function () {
        Route::post('logout', [\App\Http\Controllers\Api\ResellerAuthController::class, 'logout']);
        Route::get('dashboard', [\App\Http\Controllers\Api\ResellerDashboardController::class, 'index']);
        Route::get('profile', [\App\Http\Controllers\Api\ResellerProfileController::class, 'show']);
        Route::post('profile', [\App\Http\Controllers\Api\ResellerProfileController::class, 'update']);
        Route::post('change-password', [\App\Http\Controllers\Api\ResellerProfileController::class, 'changePassword']);

        // Orders & Products
        Route::get('orders', [\App\Http\Controllers\Api\ResellerOrderController::class, 'index']);
        Route::post('orders', [\App\Http\Controllers\Api\ResellerOrderController::class, 'store']);
        Route::get('orders/{id}', [\App\Http\Controllers\Api\ResellerOrderController::class, 'show']);
        Route::post('orders/{id}/accept-quotation', [\App\Http\Controllers\Api\ResellerOrderController::class, 'acceptQuotation']);
        Route::get('products', [\App\Http\Controllers\Api\ResellerOrderController::class, 'products']);

        Route::get('/user', function (Request $request) {
            return $request->user();
        });
    });
});