@extends('layouts.shop')

@section('title', 'My Wishlist')

@section('content')
    <div class="bg-gray-50 min-h-screen">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-16">
            <div class="md:flex md:space-x-8">
                @include('user.partials.sidebar')

                <div class="md:w-3/4">
                    <h1 class="text-3xl font-extrabold text-gray-900 mb-8 uppercase tracking-wide flex items-center">
                        <svg class="h-8 w-8 mr-3 text-rose-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z" />
                        </svg>
                        My Wishlist
                    </h1>

                    @if($wishlists->count() > 0)
                        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6">
                            @foreach($wishlists as $item)
                                <div class="group relative bg-white border border-gray-100 rounded-3xl p-4 shadow-sm hover:shadow-xl transition-all duration-300 transform hover:-translate-y-1">
                                    <div
                                        class="w-full min-h-56 bg-gray-100 aspect-w-1 aspect-h-1 rounded-2xl overflow-hidden group-hover:opacity-95 relative">
                                        @php
                                            $img = null;
                                            $mainImage = $item->product->images->sortBy('sort_order')->first();
                                            if ($mainImage) {
                                                $img = $mainImage->image_path;
                                            } else {
                                                if ($item->product->variations->isNotEmpty()) {
                                                    $img = $item->product->variations->first()->image_path;
                                                }
                                            }
                                            $imagePath = $img ? $img : 'https://placehold.co/500x500?text=No+Image';

                                            $isOutOfStock = true;
                                            if ($item->product->variations->sum('stock') > 0) {
                                                $isOutOfStock = false;
                                            }
                                        @endphp
                                        <a href="{{ route('shop.product', $item->product->slug) }}" class="block w-full h-full">
                                            <img src="{{ $imagePath }}" alt="{{ $item->product->name }}"
                                                class="w-full h-full object-center object-cover transition-transform duration-500 group-hover:scale-110">
                                        </a>

                                        <div class="absolute top-2 right-2 z-10">
                                            <form action="{{ route('wishlist.remove', $item->id) }}" method="POST" onsubmit="return confirm('Are you sure you want to remove this item?');">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit"
                                                    class="p-2 bg-white/90 backdrop-blur-sm rounded-full text-gray-400 hover:text-rose-600 hover:bg-white shadow-sm transition-all duration-200 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-rose-500"
                                                    title="Remove from wishlist">
                                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" viewBox="0 0 20 20" fill="currentColor">
                                                        <path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clip-rule="evenodd" />
                                                    </svg>
                                                </button>
                                            </form>
                                        </div>

                                        @if(!$isOutOfStock)
                                            <div
                                                class="absolute bottom-4 left-4 right-4 translate-y-full opacity-0 group-hover:translate-y-0 group-hover:opacity-100 transition-all duration-300">
                                                <form action="{{ route('wishlist.move_to_cart', $item->id) }}" method="POST">
                                                    @csrf
                                                    <button type="submit"
                                                        class="w-full bg-white/95 backdrop-blur-sm border border-gray-200 rounded-xl py-2 px-3 flex items-center justify-center text-xs font-bold text-gray-900 hover:bg-gray-900 hover:text-white shadow-lg transition-colors">
                                                        <svg class="h-4 w-4 mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 3h2l.4 2M7 13h10l4-8H5.4M7 13L5.4 5M7 13l-2.293 2.293c-.63.63-.184 1.707.707 1.707H17m0 0a2 2 0 100 4 2 2 0 000-4zm-8 2a2 2 0 11-4 0 2 2 0 014 0z" />
                                                        </svg>
                                                        Move to Cart
                                                    </button>
                                                </form>
                                            </div>
                                        @else
                                            <div class="absolute inset-0 bg-white/60 backdrop-blur-[1px] flex items-center justify-center">
                                                <span class="bg-gray-900 text-white px-3 py-1.5 rounded-lg text-xs font-bold transform -rotate-12">OUT OF STOCK</span>
                                            </div>
                                        @endif
                                    </div>
                                    <div class="mt-4">
                                        <h3 class="text-sm font-bold text-gray-900 truncate" title="{{ $item->product->name }}">
                                            <a href="{{ route('shop.product', $item->product->slug) }}">
                                                {{ $item->product->name }}
                                            </a>
                                        </h3>
                                        
                                        @php
                                            $minPrice = $item->product->variations->min('sp');
                                            $totalStock = $item->product->variations->sum('stock');
                                            $threshold = $settings->min_stock_threshold ?? 5;
                                        @endphp
                                
                                        <div class="flex justify-between items-center mt-2">
                                            <p class="text-base font-extrabold text-indigo-600">₹{{ number_format($minPrice, 2) }}</p>
                                            
                                            @if($isOutOfStock)
                                                <p class="text-[10px] text-rose-600 font-bold bg-rose-50 px-2 py-0.5 rounded-md">Unavailable</p>
                                            @elseif($totalStock <= $threshold)
                                                <p class="text-[10px] text-amber-600 font-bold bg-amber-50 px-2 py-0.5 rounded-md">Low Stock</p>
                                            @else
                                                <p class="text-[10px] text-emerald-600 font-bold bg-emerald-50 px-2 py-0.5 rounded-md">In Stock</p>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @else
                        <div class="text-center py-20 bg-white rounded-3xl border-2 border-dashed border-gray-200">
                            <div class="mx-auto h-20 w-20 bg-rose-50 rounded-full flex items-center justify-center mb-6">
                                <svg class="h-10 w-10 text-rose-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z" />
                                </svg>
                            </div>
                            <h3 class="mt-2 text-xl font-bold text-gray-900">Your wishlist is empty</h3>
                            <p class="mt-2 text-gray-500 max-w-sm mx-auto mb-8">Start saving your favorite items to find them easily later.</p>
                            <a href="{{ route('shop.index') }}"
                                class="inline-flex items-center px-8 py-4 border border-transparent shadow-lg text-sm font-bold rounded-xl text-white bg-gradient-to-r from-rose-500 to-pink-600 hover:from-rose-600 hover:to-pink-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-rose-500 transition-all transform hover:-translate-y-1">
                                Start Shopping
                                <svg class="h-5 w-5 ml-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3" />
                                </svg>
                            </a>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection