@extends('layouts.shop')

@section('title', 'My Wallet')

@section('content')
    <div class="bg-gray-50 min-h-screen">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-16">
            <div class="md:flex md:space-x-8">
                <!-- Sidebar -->
                @include('user.partials.sidebar')

                <!-- Main Content -->
                <div class="md:w-3/4">
                    <!-- Wallet Balance Card -->
                    <div class="bg-white rounded-3xl shadow-lg border border-gray-100 p-8 mb-8 relative overflow-hidden">
                        <div class="absolute top-0 right-0 -mr-16 -mt-16 w-64 h-64 rounded-full bg-green-50 opacity-50">
                        </div>
                        <div class="relative z-10">
                            <h2 class="text-2xl font-bold text-gray-900">Wallet Balance</h2>
                            <div class="mt-4 flex items-baseline">
                                <span class="text-5xl font-extrabold text-green-600">{{ $user->wallet_balance ?? 0 }}</span>
                                <span class="ml-2 text-xl font-medium text-gray-500">Points</span>
                            </div>
                            <p class="mt-2 text-sm text-gray-500">Worth approx
                                ₹{{ number_format(($user->wallet_balance ?? 0) / ((\App\Models\GeneralSetting::firstOrNew()->wallet_exchange_rate ?? 100) ?: 100), 2) }}
                            </p>
                        </div>
                    </div>

                    <!-- History -->
                    <div class="bg-white rounded-3xl shadow-lg border border-gray-100 overflow-hidden">
                        <div class="px-6 py-5 border-b border-gray-100 bg-gray-50/50">
                            <h3 class="text-lg font-bold text-gray-900">Transaction History</h3>
                        </div>
                        <div class="overflow-x-auto">
                            <table class="min-w-full divide-y divide-gray-200">
                                <thead class="bg-gray-50">
                                    <tr>
                                        <th scope="col"
                                            class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                            Date</th>
                                        <th scope="col"
                                            class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                            Description</th>
                                        <th scope="col"
                                            class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                            Type</th>
                                        <th scope="col"
                                            class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">
                                            Points</th>
                                    </tr>
                                </thead>
                                <tbody class="bg-white divide-y divide-gray-200">
                                    @forelse($transactions as $transaction)
                                        <tr>
                                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                                {{ $transaction->created_at->format('d M Y, h:i A') }}
                                            </td>
                                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900 font-medium">
                                                {{ $transaction->description }}
                                                @if($transaction->reference_type == 'App\Models\Order')
                                                    <a href="{{ route('user.orders.show', $transaction->reference_id) }}"
                                                        class="text-indigo-600 hover:text-indigo-900 ml-1 text-xs underline">View
                                                        Order</a>
                                                @endif
                                            </td>
                                            <td class="px-6 py-4 whitespace-nowrap text-sm">
                                                @if($transaction->type == 'credit')
                                                    <span
                                                        class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-green-100 text-green-800">Credit</span>
                                                @else
                                                    <span
                                                        class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-red-100 text-red-800">Debit</span>
                                                @endif
                                            </td>
                                            <td
                                                class="px-6 py-4 whitespace-nowrap text-sm text-right font-bold {{ $transaction->type == 'credit' ? 'text-green-600' : 'text-red-600' }}">
                                                {{ $transaction->type == 'credit' ? '+' : '-' }}{{ $transaction->amount }}
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="4" class="px-6 py-12 text-center text-gray-500">
                                                <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor"
                                                    viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z">
                                                    </path>
                                                </svg>
                                                <p class="mt-2 text-sm font-medium">No wallet transactions yet.</p>
                                            </td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                        <div class="px-6 py-4 border-t border-gray-200">
                            {{ $transactions->links() }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection