@extends('layouts.shop')

@section('title', 'Ticket #' . $ticket->ticket_number . ' - Hair Niche By Shelly')

@section('content')
    <div class="bg-gray-50 min-h-screen">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-10">
            <div class="mb-6">
                <a href="{{ route('user.tickets.index') }}" class="text-indigo-600 hover:text-indigo-800 font-medium">
                    &larr; Back to Tickets
                </a>
            </div>

            <div class="flex flex-col md:flex-row gap-6">
                <!-- Ticket Info -->
                <div class="md:w-1/3 space-y-6">
                    <div class="bg-white shadow rounded-lg overflow-hidden">
                        <div class="px-4 py-5 sm:px-6 border-b border-gray-200">
                            <h3 class="text-lg leading-6 font-medium text-gray-900">Ticket Details</h3>
                        </div>
                        <div class="px-4 py-5 sm:p-6 space-y-4">
                            <div>
                                <span class="text-sm font-medium text-gray-500">Subject</span>
                                <p class="mt-1 text-sm text-gray-900 font-semibold">{{ $ticket->subject }}</p>
                            </div>
                            <div>
                                <span class="text-sm font-medium text-gray-500">Ticket ID</span>
                                <p class="mt-1 text-sm text-gray-900">{{ $ticket->ticket_number }}</p>
                            </div>
                            <div>
                                <span class="text-sm font-medium text-gray-500">Status</span>
                                <p class="mt-1">
                                    <span
                                        class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full {{ $ticket->status === 'open' ? 'bg-green-100 text-green-800' : 'bg-gray-100 text-gray-800' }}">
                                        {{ ucfirst($ticket->status) }}
                                    </span>
                                </p>
                            </div>
                            <div>
                                <span class="text-sm font-medium text-gray-500">Order</span>
                                <p class="mt-1 text-sm text-gray-900">
                                    <a href="{{ route('user.orders.show', $ticket->order_id) }}"
                                        class="text-indigo-600 hover:underline">
                                        #{{ $ticket->order->order_number }}
                                    </a>
                                </p>
                            </div>
                            @if($ticket->status === 'open')
                                <div class="pt-4 border-t border-gray-200">
                                    <form action="{{ route('user.tickets.close', $ticket->id) }}" method="POST">
                                        @csrf
                                        <button type="submit"
                                            class="w-full inline-flex justify-center items-center px-4 py-2 border border-transparent shadow-sm text-sm font-medium rounded-md text-red-700 bg-red-100 hover:bg-red-200 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500">
                                            Close Ticket
                                        </button>
                                    </form>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>

                <!-- Conversation -->
                <div class="md:w-2/3">
                    <div class="bg-white shadow rounded-lg flex flex-col h-[600px]">
                        <div class="px-4 py-5 sm:px-6 border-b border-gray-200 bg-gray-50">
                            <h3 class="text-lg leading-6 font-medium text-gray-900">Conversation</h3>
                        </div>

                        <div class="flex-1 overflow-y-auto p-4 space-y-4 bg-gray-50" id="messages-container">
                            @foreach($ticket->messages as $message)

                                <div class="flex {{ $message->user_id === auth()->id() ? 'justify-end' : 'justify-start' }}">
                                    <div
                                        class="{{ $message->user_id === auth()->id() ? 'bg-blue-600 text-white' : 'bg-white border border-gray-200 text-gray-900' }} rounded-lg px-4 py-2 max-w-sm shadow-sm relative">
                                        <p class="text-sm">{{ $message->message }}</p>
                                        @if($message->attachment_path)
                                            <div class="mt-2 text-xs">
                                                <a href="{{ asset('storage/' . $message->attachment_path) }}" target="_blank"
                                                    class="underline flex items-center {{ $message->user_id === auth()->id() ? 'text-blue-200' : 'text-indigo-600' }}">
                                                    <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                            d="M15.172 7l-6.586 6.586a2 2 0 102.828 2.828l6.414-6.586a4 4 0 00-5.656-5.656l-6.415 6.585a6 6 0 108.486 8.486L20.5 13">
                                                        </path>
                                                    </svg>
                                                    Attachment
                                                </a>
                                            </div>
                                        @endif
                                        <p
                                            class="text-[10px] mt-1 {{ $message->user_id === auth()->id() ? 'text-blue-200 text-right' : 'text-gray-400' }}">
                                            {{ $message->created_at->format('M d, h:i A') }}
                                            @if($message->user_id !== auth()->id())
                                                &bull; {{ $message->user->name }} (Support)
                                            @endif
                                        </p>
                                    </div>
                                </div>
                            @endforeach
                        </div>

                        @if($ticket->status === 'open')
                            <div class="p-4 border-t border-gray-200 bg-white rounded-b-lg">
                                <form action="{{ route('user.tickets.reply', $ticket->id) }}" method="POST"
                                    enctype="multipart/form-data">
                                    @csrf
                                    <div class="space-y-3">
                                        <div>
                                            <label for="message" class="sr-only">Message</label>
                                            <textarea id="message" name="message" rows="3" required
                                                class="shadow-sm focus:ring-blue-500 focus:border-blue-500 block w-full sm:text-sm border-gray-300 rounded-md"
                                                placeholder="Type your reply here..."></textarea>
                                        </div>
                                        <div class="flex justify-between items-center">
                                            <div class="flex items-center">
                                                <label for="attachment"
                                                    class="cursor-pointer text-gray-400 hover:text-gray-600">
                                                    <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                            d="M15.172 7l-6.586 6.586a2 2 0 102.828 2.828l6.414-6.586a4 4 0 00-5.656-5.656l-6.415 6.585a6 6 0 108.486 8.486L20.5 13" />
                                                    </svg>
                                                    <input type="file" name="attachment" id="attachment" class="hidden">
                                                </label>
                                                <span id="file-name"
                                                    class="text-xs text-gray-500 ml-2 truncate max-w-[150px]"></span>
                                            </div>
                                            <button type="submit"
                                                class="inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md shadow-sm text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                                                Send Reply
                                            </button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        @else
                            <div class="p-4 bg-gray-50 text-center text-sm text-gray-500 border-t border-gray-200">
                                This ticket is closed. You can no longer reply.
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Scroll to bottom of chat
        const messagesContainer = document.getElementById('messages-container');
        messagesContainer.scrollTop = messagesContainer.scrollHeight;

        // File name display
        const fileInput = document.getElementById('attachment');
        const fileNameSpan = document.getElementById('file-name');
        if (fileInput) {
            fileInput.addEventListener('change', function () {
                if (this.files && this.files.length > 0) {
                    fileNameSpan.textContent = this.files[0].name;
                } else {
                    fileNameSpan.textContent = '';
                }
            });
        }
    </script>
@endsection