@extends('layouts.shop')

@section('title', 'My Support Tickets - Hair Niche By Shelly')

@section('content')
    <div class="bg-gray-50 min-h-screen">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-16">
            <div class="md:flex md:space-x-8">
                @include('user.partials.sidebar')

                <div class="md:w-3/4">
                    <h1 class="text-3xl font-extrabold text-gray-900 mb-8 uppercase tracking-wide flex items-center">
                        <svg class="h-8 w-8 mr-3 text-indigo-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M8 10h.01M12 10h.01M16 10h.01M9 16H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-5l-5 5v-5z" />
                        </svg>
                        Support Tickets
                    </h1>

                    <!-- Ticket Tabs -->
                    <div class="border-b border-gray-200 mb-8">
                        <nav class="-mb-px flex flex-wrap gap-8">
                            <a href="?status=open"
                                class="{{ $status == 'open' ? 'border-indigo-500 text-indigo-600' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300' }} flake whitespace-nowrap py-4 px-1 border-b-2 font-bold text-sm transition-colors duration-200 uppercase tracking-wide">
                                Open Tickets <span
                                    class="bg-gray-100 text-gray-600 py-0.5 px-2 rounded-full text-xs ml-2">{{ $counts['open'] }}</span>
                            </a>
                            <a href="?status=closed"
                                class="{{ $status == 'closed' ? 'border-indigo-500 text-indigo-600' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300' }} flake whitespace-nowrap py-4 px-1 border-b-2 font-bold text-sm transition-colors duration-200 uppercase tracking-wide">
                                Closed Tickets <span
                                    class="bg-gray-100 text-gray-600 py-0.5 px-2 rounded-full text-xs ml-2">{{ $counts['closed'] }}</span>
                            </a>
                        </nav>
                    </div>

                    <!-- Tickets List -->
                    <div class="space-y-6">
                        @forelse($tickets as $ticket)
                            <!-- Ticket Card -->
                            <div
                                class="bg-white border boundary-gray-100 rounded-2xl p-6 shadow-sm hover:shadow-md transition-all duration-300 group border border-gray-100">
                                <div
                                    class="flex flex-col md:flex-row justify-between md:items-center pb-4 border-b border-gray-50 mb-4">
                                    <div>
                                        <h3 class="text-lg font-bold text-gray-900 flex items-center">
                                            <span class="bg-indigo-100 text-indigo-600 p-1.5 rounded-lg mr-2">
                                                <svg class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M7 8h10M7 12h4m1 8l-4-4H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-3l-4 4z" />
                                                </svg>
                                            </span>
                                            {{ $ticket->subject }}
                                        </h3>
                                        <div
                                            class="flex flex-col sm:flex-row sm:items-center text-xs text-gray-500 mt-1 ml-10 space-y-1 sm:space-y-0 sm:space-x-4">
                                            <span>ticket #{{ $ticket->ticket_number }}</span>
                                            <span class="hidden sm:inline">&bull;</span>
                                            <span>Created {{ $ticket->created_at->format('M d, Y h:i A') }}</span>
                                            <span class="hidden sm:inline">&bull;</span>
                                            <span>Order #{{ $ticket->order->order_number }}</span>
                                        </div>
                                    </div>
                                    <div class="mt-4 md:mt-0 ml-10 md:ml-0">
                                        @php
                                            $statusClasses = [
                                                'open' => 'bg-green-100 text-green-800 border-green-200',
                                                'closed' => 'bg-gray-100 text-gray-800 border-gray-200',
                                            ];
                                            $currentClass = $statusClasses[$ticket->status] ?? 'bg-gray-100 text-gray-800 border-gray-200';
                                        @endphp
                                        <span
                                            class="inline-flex items-center px-3 py-1 rounded-full text-xs font-bold uppercase tracking-wider border {{ $currentClass }}">
                                            <span class="w-2 h-2 rounded-full bg-current mr-2 opacity-75"></span>
                                            {{ $ticket->status }}
                                        </span>
                                    </div>
                                </div>

                                <div class="flex justify-end items-center ml-10 md:ml-0">
                                    <a href="{{ route('user.tickets.show', $ticket->id) }}"
                                        class="group/btn flex items-center bg-white border border-gray-300 text-gray-700 px-5 py-2.5 rounded-xl text-sm font-bold uppercase tracking-wider hover:bg-gray-50 transition-all duration-300 shadow-sm">
                                        View Conversation
                                        <svg class="h-4 w-4 ml-2 transform group-hover/btn:translate-x-1 transition-transform"
                                            fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M14 5l7 7m0 0l-7 7m7-7H3" />
                                        </svg>
                                    </a>
                                </div>
                            </div>
                        @empty
                            <div class="text-center py-20 bg-white rounded-3xl border-2 border-dashed border-gray-200">
                                <div class="bg-gray-50 p-4 rounded-full shadow-sm inline-block mb-4">
                                    <svg class="h-12 w-12 text-indigo-400" fill="none" viewBox="0 0 24 24"
                                        stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M8 10h.01M12 10h.01M16 10h.01M9 16H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-5l-5 5v-5z" />
                                    </svg>
                                </div>
                                <h3 class="mt-2 text-lg font-bold text-gray-900">No tickets found</h3>
                                <p class="mt-1 text-sm text-gray-500 mb-8 max-w-sm mx-auto">
                                    You don't have any {{ $status }} support tickets.
                                </p>
                            </div>
                        @endforelse

                        <div class="mt-4">
                            {{ $tickets->links() }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection