@extends('layouts.shop')

@section('title', 'Help & Support - Hair Niche By Shelly')

@section('content')
    <div class="bg-gray-50 min-h-screen">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-16">
            <div class="md:flex md:space-x-8">
                @include('user.partials.sidebar')

                <div class="md:w-3/4">
                    <h1 class="text-3xl font-extrabold text-gray-900 mb-8 uppercase tracking-wide flex items-center">
                        <svg class="h-8 w-8 mr-3 text-[#9B2D69]" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M18.364 5.636l-3.536 3.536m0 5.656l3.536 3.536M9.172 9.172L5.636 5.636m3.536 9.192l-3.536 3.536M21 12a9 9 0 11-18 0 9 9 0 0118 0zm-5 0a4 4 0 11-8 0 4 4 0 018 0z" />
                        </svg>
                        Help & Support
                    </h1>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-8 mb-12">
                        <!-- Contact Cards -->
                        <div
                            class="bg-gradient-to-br from-pink-50 to-purple-50 border border-pink-100 rounded-2xl p-6 shadow-sm hover:shadow-md transition-shadow">
                            <div class="flex items-center mb-4">
                                <div class="bg-white p-3 rounded-full shadow-sm mr-4 text-[#9B2D69]">
                                    <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z" />
                                    </svg>
                                </div>
                                <div>
                                    <h3 class="font-bold text-gray-900">Customer Care</h3>
                                    <p class="text-sm text-gray-500">Mon-Sat, 9am - 6pm</p>
                                </div>
                            </div>
                            <p class="text-lg font-bold text-gray-800">+91 98765 43210</p>
                        </div>

                        <div
                            class="bg-gradient-to-br from-purple-50 to-indigo-50 border border-purple-100 rounded-2xl p-6 shadow-sm hover:shadow-md transition-shadow">
                            <div class="flex items-center mb-4">
                                <div class="bg-white p-3 rounded-full shadow-sm mr-4 text-purple-600">
                                    <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z" />
                                    </svg>
                                </div>
                                <div>
                                    <h3 class="font-bold text-gray-900">Email Support</h3>
                                    <p class="text-sm text-gray-500">24/7 Assistance</p>
                                </div>
                            </div>
                            <p class="text-lg font-bold text-gray-800">support@lugani.com</p>
                        </div>
                    </div>

                    <!-- FAQ Section -->
                    <div>
                        <h2 class="text-xl font-bold text-gray-900 mb-6 flex items-center">
                            <span class="w-2 h-8 bg-[#9B2D69] rounded-full mr-3"></span>
                            Frequently Asked Questions
                        </h2>
                        <div class="space-y-4">
                            <div class="bg-white border border-gray-100 rounded-2xl p-6 shadow-sm">
                                <h3 class="text-lg font-bold text-gray-900 mb-2">How can I track my order?</h3>
                                <p class="text-gray-600">You can track your order status in the "My Orders" section of your
                                    dashboard. Once shipped, you'll see a "Track Order" button with real-time updates.</p>
                            </div>
                            <div class="bg-white border border-gray-100 rounded-2xl p-6 shadow-sm">
                                <h3 class="text-lg font-bold text-gray-900 mb-2">What is your return policy?</h3>
                                <p class="text-gray-600">We offer a 7-day return policy for unused items in original
                                    condition.
                                    Please visit our <a href="{{ route('pages.pricing-refund-policy') }}"
                                        class="text-[#9B2D69] hover:underline">Refund Policy</a> page for more details.</p>
                            </div>
                            <div class="bg-white border border-gray-100 rounded-2xl p-6 shadow-sm">
                                <h3 class="text-lg font-bold text-gray-900 mb-2">How do I change my shipping address?</h3>
                                <p class="text-gray-600">You can manage your saved addresses in the "My Addresses" section.
                                    For
                                    pending orders, please contact customer care immediately.</p>
                            </div>
                        </div>
                    </div>

                    <!-- Send Message Form -->
                    <div class="mt-12">
                        <h2 class="text-xl font-bold text-gray-900 mb-6 flex items-center">
                            <span class="w-2 h-8 bg-[#9B2D69] rounded-full mr-3"></span>
                            Send us a message
                        </h2>
                        <div class="bg-white border border-gray-100 rounded-2xl p-8 shadow-sm">
                            <form action="#" method="POST">
                                @csrf
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                                    <div>
                                        <label class="block text-sm font-semibold text-gray-700 mb-2">Subject</label>
                                        <input type="text" name="subject"
                                            class="w-full pl-4 border border-gray-200 rounded-xl shadow-sm focus:border-[#9B2D69] focus:ring-[#9B2D69] py-3 bg-white transition-all duration-200"
                                            placeholder="How can we help?">
                                    </div>
                                    <div>
                                        <label class="block text-sm font-semibold text-gray-700 mb-2">Order ID
                                            (Optional)</label>
                                        <input type="text" name="order_id"
                                            class="w-full pl-4 border border-gray-200 rounded-xl shadow-sm focus:border-[#9B2D69] focus:ring-[#9B2D69] py-3 bg-white transition-all duration-200"
                                            placeholder="e.g. #12345">
                                    </div>
                                    <div class="md:col-span-2">
                                        <label class="block text-sm font-semibold text-gray-700 mb-2">Message</label>
                                        <textarea name="message" rows="4"
                                            class="w-full pl-4 border border-gray-200 rounded-xl shadow-sm focus:border-[#9B2D69] focus:ring-[#9B2D69] py-3 bg-white transition-all duration-200"
                                            placeholder="Describe your issue..."></textarea>
                                    </div>
                                </div>
                                <div class="flex justify-end">
                                    <button type="submit"
                                        class="bg-[#9B2D69] text-white px-8 py-3 rounded-xl uppercase tracking-wider text-sm font-bold hover:bg-[#7a2454] transition-all duration-300 shadow-lg hover:shadow-xl flex items-center">
                                        Send Message
                                        <svg class="h-4 w-4 ml-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M14 5l7 7m0 0l-7 7m7-7H3" />
                                        </svg>
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection