@extends('layouts.shop')

@section('title', 'Account Settings - Hair Niche By Shelly')

@section('content')
    <div class="bg-gray-50 min-h-screen">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-16">
            <div class="md:flex md:space-x-8">
                @include('user.partials.sidebar')

                <div class="md:w-3/4 space-y-8">
                    <h1 class="text-3xl font-bold text-gray-900 mb-8 uppercase tracking-wide">Settings</h1>

                    <!-- Payment Details -->
                    <div class="bg-white border border-gray-100 rounded-2xl p-8 shadow-sm mb-8" x-data="{ type: 'bank_transfer' }">
                        <h3 class="text-xl font-bold text-gray-900 mb-6 flex items-center">
                            <div class="p-2 bg-indigo-100 rounded-lg mr-3">
                                <svg class="h-6 w-6 text-indigo-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z" />
                                </svg>
                            </div>
                            Payment Details
                        </h3>

                        <!-- List Existing Methods -->
                        @if($user->paymentMethods->count() > 0)
                            <div class="space-y-4 mb-8">
                                <h4 class="text-sm font-semibold text-gray-700 uppercase tracking-wider">Saved Methods</h4>
                                @foreach($user->paymentMethods as $method)
                                    <div class="flex items-center justify-between p-4 border rounded-xl {{ $method->is_default ? 'border-indigo-500 bg-indigo-50' : 'border-gray-200' }}">
                                        <div>
                                            <div class="flex items-center">
                                                <span class="font-bold text-gray-900 text-sm">
                                                    {{ $method->type === 'bank_transfer' ? 'Bank Transfer' : 'UPI' }}
                                                </span>
                                                @if($method->is_default)
                                                    <span class="ml-2 px-2 py-0.5 text-xs font-bold text-indigo-700 bg-indigo-200 rounded-full">Default</span>
                                                @endif
                                            </div>
                                            <div class="text-sm text-gray-600 mt-1">
                                                @if($method->type === 'bank_transfer')
                                                    {{ $method->bank_name }} - {{ $method->account_number }}
                                                    <br>
                                                    <span class="text-xs text-gray-500">
                                                        IFSC: {{ $method->ifsc_code }} | Branch: {{ $method->branch }}
                                                    </span>
                                                @else
                                                    {{ $method->upi_id }}
                                                @endif
                                            </div>
                                        </div>
                                        <div class="flex items-center space-x-2">
                                            @if(!$method->is_default)
                                                <form action="{{ route('user.payment-methods.default', $method->id) }}" method="POST">
                                                    @csrf
                                                    <button type="submit" class="text-xs text-indigo-600 hover:text-indigo-800 font-medium">Set Default</button>
                                                </form>
                                            @endif
                                            <form action="{{ route('user.payment-methods.destroy', $method->id) }}" method="POST" onsubmit="return confirm('Delete this payment method?');">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="text-gray-400 hover:text-rose-600">
                                                    <svg class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16" />
                                                    </svg>
                                                </button>
                                            </form>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        @endif

                        <!-- Add New Method -->
                        <div class="border-t border-gray-100 pt-8 mt-6">
                            <h4 class="text-lg font-bold text-gray-900 mb-6 flex items-center">
                                <svg class="h-5 w-5 text-indigo-500 mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6" />
                                </svg>
                                Add New Payment Method
                            </h4>
                            <form action="{{ route('user.payment-methods.store') }}" method="POST">
                                @csrf

                                <!-- Payment Type Selector -->
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-8">
                                    <!-- Bank Transfer Option -->
                                    <label class="relative flex items-start p-4 cursor-pointer rounded-xl border transition-all duration-200"
                                        :class="type === 'bank_transfer' ? 'border-indigo-500 ring-2 ring-indigo-500 ring-opacity-50 bg-indigo-50/50' : 'border-gray-200 hover:border-indigo-200 hover:bg-gray-50'">
                                        <div class="flex items-center h-5">
                                            <input type="radio" name="type" value="bank_transfer" x-model="type" class="h-4 w-4 text-indigo-600 border-gray-300 focus:ring-indigo-500">
                                        </div>
                                        <div class="ml-3">
                                            <span class="block text-sm font-bold text-gray-900">Bank Transfer</span>
                                            <span class="block text-xs text-gray-500 mt-1">Direct deposit to your bank account</span>
                                        </div>
                                    </label>

                                    <!-- UPI Option -->
                                    <label class="relative flex items-start p-4 cursor-pointer rounded-xl border transition-all duration-200"
                                        :class="type === 'upi' ? 'border-indigo-500 ring-2 ring-indigo-500 ring-opacity-50 bg-indigo-50/50' : 'border-gray-200 hover:border-indigo-200 hover:bg-gray-50'">
                                        <div class="flex items-center h-5">
                                            <input type="radio" name="type" value="upi" x-model="type" class="h-4 w-4 text-indigo-600 border-gray-300 focus:ring-indigo-500">
                                        </div>
                                        <div class="ml-3">
                                            <span class="block text-sm font-bold text-gray-900">UPI ID</span>
                                            <span class="block text-xs text-gray-500 mt-1">Google Pay, PhonePe, Paytm, etc.</span>
                                        </div>
                                    </label>
                                </div>

                                <!-- Bank Details Fields -->
                                <div x-show="type === 'bank_transfer'" x-transition:enter="transition ease-out duration-200" x-transition:enter-start="opacity-0 translate-y-2" x-transition:enter-end="opacity-100 translate-y-0" class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                    <div class="col-span-2 md:col-span-1">
                                        <label class="block text-sm font-semibold text-gray-700 mb-2">Bank Name</label>
                                        <div class="relative">
                                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                                <svg class="h-5 w-5 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4" />
                                                </svg>
                                            </div>
                                            <input type="text" name="bank_name" class="w-full pl-10 border border-gray-200 rounded-xl shadow-sm focus:border-indigo-500 focus:ring-indigo-500 py-3 bg-white transition-all duration-200" placeholder="e.g. HDFC Bank">
                                        </div>
                                    </div>
                                    <div class="col-span-2 md:col-span-1">
                                        <label class="block text-sm font-semibold text-gray-700 mb-2">Account Number</label>
                                        <div class="relative">
                                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                                <svg class="h-5 w-5 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 20l4-16m2 16l4-16M6 9h14M4 15h14" />
                                                </svg>
                                            </div>
                                            <input type="text" name="account_number" class="w-full pl-10 border border-gray-200 rounded-xl shadow-sm focus:border-indigo-500 focus:ring-indigo-500 py-3 bg-white transition-all duration-200" placeholder="0000 0000 0000 0000">
                                        </div>
                                    </div>
                                    <div class="col-span-2 md:col-span-1">
                                        <label class="block text-sm font-semibold text-gray-700 mb-2">IFSC Code</label>
                                        <div class="relative">
                                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                                <svg class="h-5 w-5 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 20l4-16m4 4l4 4-4 4M6 16l-4-4 4-4" />
                                                </svg>
                                            </div>
                                            <input type="text" name="ifsc_code" class="w-full pl-10 border border-gray-200 rounded-xl shadow-sm focus:border-indigo-500 focus:ring-indigo-500 py-3 bg-white transition-all duration-200 uppercase" placeholder="HDFC0001234">
                                        </div>
                                    </div>
                                    <div class="col-span-2 md:col-span-1">
                                        <label class="block text-sm font-semibold text-gray-700 mb-2">Branch Name</label>
                                        <div class="relative">
                                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                                <svg class="h-5 w-5 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z" />
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z" />
                                                </svg>
                                            </div>
                                            <input type="text" name="branch" class="w-full pl-10 border border-gray-200 rounded-xl shadow-sm focus:border-indigo-500 focus:ring-indigo-500 py-3 bg-white transition-all duration-200" placeholder="e.g. Mumbai Main Branch">
                                        </div>
                                    </div>
                                </div>

                                <!-- UPI ID Fields -->
                                <div x-show="type === 'upi'" style="display: none;" x-transition:enter="transition ease-out duration-200" x-transition:enter-start="opacity-0 translate-y-2" x-transition:enter-end="opacity-100 translate-y-0">
                                    <div>
                                        <label class="block text-sm font-semibold text-gray-700 mb-2">UPI ID</label>
                                        <div class="relative">
                                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                                <svg class="h-5 w-5 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 18h.01M8 21h8a2 2 0 002-2V5a2 2 0 00-2-2H8a2 2 0 00-2 2v14a2 2 0 002 2z" />
                                                </svg>
                                            </div>
                                            <input type="text" name="upi_id" class="w-full pl-10 border border-gray-200 rounded-xl shadow-sm focus:border-indigo-500 focus:ring-indigo-500 py-3 bg-white transition-all duration-200" placeholder="username@bank">
                                        </div>
                                        <p class="text-xs text-gray-500 mt-2">Enter your Virtual Payment Address (VPA).</p>
                                    </div>
                                </div>

                                <div class="mt-8 flex justify-end">
                                    <button type="submit" class="bg-gradient-to-r from-indigo-600 to-purple-600 text-white px-8 py-3 rounded-xl uppercase tracking-wider text-sm font-bold hover:from-indigo-700 hover:to-purple-700 shadow-lg hover:shadow-xl transition-all duration-300 transform hover:-translate-y-1 flex items-center">
                                        <span>Save Payment Details</span>
                                        <svg class="h-4 w-4 ml-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                                        </svg>
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>

                    <!-- Change Password -->
                    <div class="bg-white border border-gray-100 rounded-2xl p-8 shadow-sm">
                        <h3 class="text-xl font-bold text-gray-900 mb-6 flex items-center">
                            <div class="p-2 bg-indigo-100 rounded-lg mr-3">
                                <svg class="h-6 w-6 text-indigo-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z" />
                                </svg>
                            </div>
                            Change Password
                        </h3>
                        @if(session('success'))
                            <div
                                class="bg-emerald-50 border border-emerald-200 text-emerald-700 px-4 py-3 rounded-xl relative mb-4 flex items-center">
                                <svg class="h-5 w-5 mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                                </svg>
                                {{ session('success') }}
                            </div>
                        @endif
                        <form action="{{ route('user.password.update') }}" method="POST">
                            @csrf
                            <div class="space-y-6">
                                <div>
                                    <label class="block text-sm font-semibold text-gray-700 mb-2">Current Password</label>
                                    <div class="relative">
                                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                            <svg class="h-5 w-5 text-gray-400" fill="none" viewBox="0 0 24 24"
                                                stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z" />
                                            </svg>
                                        </div>
                                        <input type="password" name="current_password" required
                                            class="w-full pl-10 border border-gray-200 rounded-xl shadow-sm focus:border-indigo-500 focus:ring-indigo-500 py-3 bg-white transition-all duration-200">
                                    </div>
                                    @error('current_password') <span
                                    class="text-rose-500 text-xs mt-1 block font-medium">{{ $message }}</span> @enderror
                                </div>
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                    <div x-data="{ 
                                            show: false, 
                                            password: '', 
                                            get strength() {
                                                let s = 0;
                                                if (this.password.length > 7) s += 1;
                                                if (this.password.match(/[a-z]/) && this.password.match(/[A-Z]/)) s += 1;
                                                if (this.password.match(/\d/)) s += 1;
                                                if (this.password.match(/[^a-zA-Z\d]/)) s += 1;
                                                return s;
                                            }
                                        }">
                                        <label class="block text-sm font-semibold text-gray-700 mb-2">New Password</label>
                                        <div class="relative">
                                            <div
                                                class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                                <svg class="h-5 w-5 text-gray-400" fill="none" viewBox="0 0 24 24"
                                                    stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z" />
                                                </svg>
                                            </div>
                                            <input :type="show ? 'text' : 'password'" name="password" required
                                                x-model="password"
                                                class="w-full pl-10 pr-10 border border-gray-200 rounded-xl shadow-sm focus:border-indigo-500 focus:ring-indigo-500 py-3 bg-white transition-all duration-200">
                                            <button type="button" @click="show = !show"
                                                class="absolute inset-y-0 right-0 pr-3 flex items-center text-gray-400 hover:text-gray-600 focus:outline-none">
                                                <svg x-show="!show" class="h-5 w-5" fill="none" viewBox="0 0 24 24"
                                                    stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
                                                </svg>
                                                <svg x-show="show" x-cloak class="h-5 w-5" fill="none" viewBox="0 0 24 24"
                                                    stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M13.875 18.825A10.05 10.05 0 0112 19c-4.478 0-8.268-2.943-9.542-7a10.05 10.05 0 011.563-3.026m5.858.908a3 3 0 114.243 4.243M9.878 9.878l4.242 4.242M9.88 9.88l-3.29-3.29m7.532 7.532l3.29 3.29M3 3l3.59 3.59m0 0A9.953 9.953 0 0112 5c4.478 0 8.268 2.943 9.542 7a10.057 10.057 0 01-2.078 3.578m-3.9 3.9l1.414-1.414" />
                                                </svg>
                                            </button>
                                        </div>

                                        <!-- Strength Indicator -->
                                        <div class="mt-2" x-show="password.length > 0" x-transition>
                                            <div class="flex space-x-1 h-1.5">
                                                <div class="h-full rounded-full transition-all duration-300 flex-1"
                                                    :class="strength > 0 ? (strength > 1 ? 'bg-indigo-500' : 'bg-red-500') : 'bg-gray-200'">
                                                </div>
                                                <div class="h-full rounded-full transition-all duration-300 flex-1"
                                                    :class="strength > 1 ? (strength > 2 ? 'bg-indigo-500' : 'bg-yellow-500') : 'bg-gray-200'">
                                                </div>
                                                <div class="h-full rounded-full transition-all duration-300 flex-1"
                                                    :class="strength > 2 ? (strength > 3 ? 'bg-indigo-500' : 'bg-blue-400') : 'bg-gray-200'">
                                                </div>
                                                <div class="h-full rounded-full transition-all duration-300 flex-1"
                                                    :class="strength > 3 ? 'bg-green-500' : 'bg-gray-200'"></div>
                                            </div>
                                            <p class="text-xs mt-1 text-gray-500 text-right"
                                                x-text="['Weak', 'Fair', 'Good', 'Strong'][strength - 1] || 'Very Weak'">
                                            </p>
                                        </div>

                                        <!-- Password Rules -->
                                        <div class="mt-2 space-y-1">
                                            <p class="text-xs flex items-center"
                                                :class="password.length > 7 ? 'text-green-600' : 'text-gray-500'">
                                                <svg class="w-3 h-3 mr-1" fill="none" viewBox="0 0 24 24"
                                                    stroke="currentColor">
                                                    <path x-show="password.length > 7" stroke-linecap="round"
                                                        stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                                                    <path x-show="!(password.length > 7)" stroke-linecap="round"
                                                        stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                                                </svg>
                                                Min 8 characters
                                            </p>
                                            <p class="text-xs flex items-center"
                                                :class="password.match(/[a-z]/) && password.match(/[A-Z]/) ? 'text-green-600' : 'text-gray-500'">
                                                <svg class="w-3 h-3 mr-1" fill="none" viewBox="0 0 24 24"
                                                    stroke="currentColor">
                                                    <path x-show="password.match(/[a-z]/) && password.match(/[A-Z]/)"
                                                        stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M5 13l4 4L19 7" />
                                                    <path x-show="!(password.match(/[a-z]/) && password.match(/[A-Z]/))"
                                                        stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M6 18L18 6M6 6l12 12" />
                                                </svg>
                                                Mixed case (A-z)
                                            </p>
                                            <p class="text-xs flex items-center"
                                                :class="password.match(/\d/) ? 'text-green-600' : 'text-gray-500'">
                                                <svg class="w-3 h-3 mr-1" fill="none" viewBox="0 0 24 24"
                                                    stroke="currentColor">
                                                    <path x-show="password.match(/\d/)" stroke-linecap="round"
                                                        stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                                                    <path x-show="!(password.match(/\d/))" stroke-linecap="round"
                                                        stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                                                </svg>
                                                Contains number
                                            </p>
                                            <p class="text-xs flex items-center"
                                                :class="password.match(/[^a-zA-Z\d]/) ? 'text-green-600' : 'text-gray-500'">
                                                <svg class="w-3 h-3 mr-1" fill="none" viewBox="0 0 24 24"
                                                    stroke="currentColor">
                                                    <path x-show="password.match(/[^a-zA-Z\d]/)" stroke-linecap="round"
                                                        stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                                                    <path x-show="!(password.match(/[^a-zA-Z\d]/))" stroke-linecap="round"
                                                        stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                                                </svg>
                                                Contains symbol
                                            </p>
                                        </div>
                                    </div>
                                    <div>
                                        <label class="block text-sm font-semibold text-gray-700 mb-2">Confirm New
                                            Password</label>
                                        <div class="relative">
                                            <div
                                                class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                                <svg class="h-5 w-5 text-gray-400" fill="none" viewBox="0 0 24 24"
                                                    stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z" />
                                                </svg>
                                            </div>
                                            <input type="password" name="password_confirmation" required
                                                class="w-full pl-10 border border-gray-200 rounded-xl shadow-sm focus:border-indigo-500 focus:ring-indigo-500 py-3 bg-white transition-all duration-200">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="mt-8 flex justify-end">
                                <button type="submit"
                                    class="bg-gradient-to-r from-indigo-600 to-purple-600 text-white px-8 py-3 rounded-xl uppercase tracking-wider text-sm font-bold hover:from-indigo-700 hover:to-purple-700 shadow-lg hover:shadow-xl transition-all duration-300 transform hover:-translate-y-1 flex items-center">
                                    <span>Update Password</span>
                                    <svg class="h-4 w-4 ml-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                                    </svg>
                                </button>
                            </div>
                        </form>
                    </div>

                    <!-- Deactivate Account -->
                    <div class="bg-rose-50 border border-rose-100 rounded-2xl p-8 transition-colors hover:bg-rose-100/50">
                        <h3 class="text-xl font-bold text-rose-700 mb-4 flex items-center">
                            <svg class="h-6 w-6 mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z" />
                            </svg>
                            Danger Zone
                        </h3>
                        <p class="text-sm text-rose-800 mb-6 bg-rose-100 p-4 rounded-xl border border-rose-200">
                            <strong>Warning:</strong> Deactivating your account will disable your access to the dashboard
                            and
                            you will not be able to place new orders. Your past order history will be retained for our
                            records.
                        </p>
                        <form action="{{ route('user.account.deactivate') }}" method="POST"
                            onsubmit="return confirm('Are you sure you want to deactivate your account? This action cannot be undone by you.');">
                            @csrf
                            <button type="submit"
                                class="bg-white text-rose-600 border border-rose-200 px-6 py-3 rounded-xl uppercase tracking-wider text-sm font-bold hover:bg-rose-600 hover:text-white shadow-sm hover:shadow-md transition-all duration-300">
                                Deactivate My Account
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection