@extends('layouts.shop')

@section('title', 'My Profile - Hair Niche By Shelly')

@section('content')
    <div class="bg-gray-50 min-h-screen">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-16">
            <div class="md:flex md:space-x-8">
                <!-- Sidebar -->
                @include('user.partials.sidebar')

                <!-- Main Content -->
                <div class="md:w-3/4">
                    <h1 class="text-3xl font-bold text-gray-900 mb-8 uppercase tracking-wide">My Profile</h1>

                    <div class="bg-white border border-gray-100 rounded-3xl shadow-lg p-6">
                        <!-- Updated rounded and shadow -->
                        @if(session('success'))
                            <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative mb-4"
                                role="alert">
                                <span class="block sm:inline">{{ session('success') }}</span>
                            </div>
                        @endif

                        <form action="{{ route('user.profile.update') }}" method="POST" enctype="multipart/form-data">
                            @csrf

                            <div
                                class="flex items-center space-x-6 mb-10 p-6 bg-gradient-to-r from-gray-50 to-white rounded-xl border border-gray-100">
                                <div class="shrink-0 relative group">
                                    <div class="h-28 w-28 rounded-full overflow-hidden shadow-lg border-4 border-white">
                                        @if($user->profile_photo_path)
                                            <img class="h-full w-full object-cover transition-transform duration-500 group-hover:scale-110"
                                                src="{{ Storage::url($user->profile_photo_path) }}" alt="{{ $user->name }}" />
                                        @else
                                            <div
                                                class="h-full w-full bg-emerald-100 flex items-center justify-center text-4xl font-bold text-emerald-600">
                                                {{ substr($user->name, 0, 1) }}
                                            </div>
                                        @endif
                                    </div>
                                    <label
                                        class="absolute bottom-1 right-1 bg-white p-2 rounded-full shadow-md cursor-pointer hover:bg-gray-50 transition-colors border border-gray-200 group-hover:scale-110"
                                        title="Change Photo">
                                        <svg class="h-4 w-4 text-gray-600" fill="none" viewBox="0 0 24 24"
                                            stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M3 9a2 2 0 012-2h.93a2 2 0 001.664-.89l.812-1.22A2 2 0 0110.07 4h3.86a2 2 0 011.664.89l.812 1.22A2 2 0 0018.07 7H19a2 2 0 012 2v9a2 2 0 01-2 2H5a2 2 0 01-2-2V9z" />
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M15 13a3 3 0 11-6 0 3 3 0 016 0z" />
                                        </svg>
                                        <input type="file" name="profile_photo" class="hidden" accept="image/*" />
                                    </label>
                                </div>
                                <div>
                                    <h3 class="text-lg font-bold text-gray-900">Profile Photo</h3>
                                    <p class="text-sm text-gray-500">Update your account picture. Max 2MB.</p>
                                </div>
                            </div>

                            <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                                <div>
                                    <label class="block text-sm font-semibold text-gray-700 mb-2">Full Name</label>
                                    <div class="relative">
                                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                            <svg class="h-5 w-5 text-gray-400" fill="none" viewBox="0 0 24 24"
                                                stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z" />
                                            </svg>
                                        </div>
                                        <input type="text" name="name" value="{{ $user->name }}"
                                            class="w-full pl-10 border border-gray-200 rounded-xl shadow-sm focus:border-[#9B2D69] focus:ring-[#9B2D69] py-3 bg-white transition-all duration-200"
                                            placeholder="Enter your full name">
                                    </div>
                                </div>
                                <div>
                                    <label
                                        class="block text-sm font-semibold text-gray-700 mb-2 group relative cursor-help">
                                        Email Address
                                        <span
                                            class="hidden group-hover:inline-block ml-2 text-xs text-gray-400 bg-gray-100 rounded px-2 py-0.5">Cannot
                                            be changed</span>
                                    </label>
                                    <div class="relative">
                                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                            <svg class="h-5 w-5 text-gray-400" fill="none" viewBox="0 0 24 24"
                                                stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z" />
                                            </svg>
                                        </div>
                                        <input type="email" value="{{ $user->email }}" readonly
                                            class="w-full pl-10 border border-gray-200 rounded-xl shadow-inner bg-gray-50 text-gray-500 cursor-not-allowed py-3">
                                    </div>
                                </div>
                                <div>
                                    <label class="block text-sm font-semibold text-gray-700 mb-2">WhatsApp Number</label>
                                    <div class="relative">
                                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                            <svg class="h-5 w-5 text-gray-400" fill="none" viewBox="0 0 24 24"
                                                stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z" />
                                            </svg>
                                        </div>
                                        <input type="text" name="whatsapp_number" value="{{ $user->whatsapp_number }}"
                                            class="w-full pl-10 border border-gray-200 rounded-xl shadow-sm focus:border-[#9B2D69] focus:ring-[#9B2D69] py-3 bg-white transition-all duration-200"
                                            placeholder="+91 XXXXX XXXXX">
                                    </div>
                                </div>
                                <div>
                                    <label class="block text-sm font-semibold text-gray-700 mb-2">Date of Birth</label>
                                    <div class="relative">
                                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                            <svg class="h-5 w-5 text-gray-400" fill="none" viewBox="0 0 24 24"
                                                stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
                                            </svg>
                                        </div>
                                        <input type="date" name="dob" value="{{ $user->dob }}"
                                            class="w-full pl-10 border border-gray-200 rounded-xl shadow-sm focus:border-[#9B2D69] focus:ring-[#9B2D69] py-3 bg-white transition-all duration-200">
                                    </div>
                                </div>
                                <div>
                                    <label class="block text-sm font-semibold text-gray-700 mb-2">Gender</label>
                                    <div class="relative">
                                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                            <svg class="h-5 w-5 text-gray-400" fill="none" viewBox="0 0 24 24"
                                                stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z" />
                                            </svg>
                                        </div>
                                        <select name="gender"
                                            class="w-full pl-10 border border-gray-200 rounded-xl shadow-sm focus:border-[#9B2D69] focus:ring-[#9B2D69] py-3 bg-white transition-all duration-200">
                                            <option value="">Select Gender</option>
                                            <option value="male" {{ $user->gender == 'male' ? 'selected' : '' }}>Male</option>
                                            <option value="female" {{ $user->gender == 'female' ? 'selected' : '' }}>Female
                                            </option>
                                            <option value="other" {{ $user->gender == 'other' ? 'selected' : '' }}>Other
                                            </option>
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <div class="mt-10 flex justify-end">
                                <button type="submit"
                                    class="bg-[#9B2D69] text-white px-8 py-3 rounded-xl uppercase tracking-wider text-sm font-bold hover:bg-[#7a2454] shadow-lg hover:shadow-xl transition-all duration-300 transform hover:-translate-y-1 flex items-center">
                                    <span>Update Profile</span>
                                    <svg class="w-4 h-4 ml-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M14 5l7 7m0 0l-7 7m7-7H3" />
                                    </svg>
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection