@extends('layouts.shop')

@section('title', 'My Orders - Hair Niche By Shelly')

@section('content')
    <div class="bg-gray-50 min-h-screen">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 pt-8 pb-24 md:py-16">
            <div class="md:flex md:space-x-8">
                @include('user.partials.sidebar')

                <div class="md:w-3/4">
                    <h1 class="text-3xl font-extrabold text-gray-900 mb-8 uppercase tracking-wide flex items-center">
                        <svg class="h-8 w-8 mr-3 text-amber-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z" />
                        </svg>
                        My Orders
                    </h1>

                    <form action="{{ route('user.orders') }}" method="GET"
                        class="mb-8 bg-white p-6 rounded-3xl shadow-sm border border-gray-100">
                        <input type="hidden" name="status" value="{{ $status }}">

                        <div class="grid grid-cols-1 md:grid-cols-12 gap-6 items-end">
                            <div class="md:col-span-4">
                                <label for="start_date"
                                    class="block text-xs font-bold text-gray-500 uppercase tracking-wider mb-2">Start
                                    Date</label>
                                <input type="date" name="start_date" id="start_date" value="{{ request('start_date') }}"
                                    class="w-full border-gray-200 bg-gray-50 rounded-xl shadow-sm focus:ring-amber-500 focus:border-amber-500 focus:bg-white transition-all py-3 px-4 text-sm font-medium">
                            </div>

                            <div class="md:col-span-4">
                                <label for="end_date"
                                    class="block text-xs font-bold text-gray-500 uppercase tracking-wider mb-2">End
                                    Date</label>
                                <input type="date" name="end_date" id="end_date" value="{{ request('end_date') }}"
                                    class="w-full border-gray-200 bg-gray-50 rounded-xl shadow-sm focus:ring-amber-500 focus:border-amber-500 focus:bg-white transition-all py-3 px-4 text-sm font-medium">
                            </div>

                            <div class="md:col-span-4 flex items-center space-x-3">
                                <button type="submit"
                                    class="flex-1 bg-gradient-to-r from-amber-500 to-orange-600 text-white px-6 py-3 rounded-xl text-sm font-bold uppercase tracking-wider hover:from-amber-600 hover:to-orange-700 transition-all duration-300 shadow-md hover:shadow-lg focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-amber-500">
                                    Filter
                                </button>

                                @if(request('start_date') || request('end_date'))
                                    <a href="{{ route('user.orders', ['status' => $status]) }}"
                                        class="px-4 py-3 bg-gray-100 text-gray-600 rounded-xl text-sm font-bold uppercase tracking-wider hover:bg-gray-200 transition-colors">
                                        Clear
                                    </a>
                                @endif
                            </div>
                        </div>
                    </form>

                    <!-- Order Tabs -->
                    <div class="border-b border-gray-200 mb-8 overflow-x-auto scrollbar-hide">
                        <nav class="-mb-px flex sm:justify-between items-center min-w-max sm:w-full space-x-4 sm:space-x-0" aria-label="Tabs">
                            <a href="?status=all"
                                class="{{ $status == 'all' ? 'border-amber-500 text-amber-600' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300' }} group whitespace-nowrap py-4 px-1 border-b-2 font-bold text-[10px] sm:text-xs md:text-sm transition-colors duration-200 uppercase tracking-wide flex flex-col md:flex-row items-center justify-center text-center">
                                All <span class="hidden md:inline ml-1">Orders</span>
                                <span
                                    class="{{ $status == 'all' ? 'bg-amber-100 text-amber-600' : 'bg-gray-100 text-gray-600' }} mt-1 md:mt-0 md:ml-2 py-0.5 px-1.5 md:px-2.5 rounded-full text-[10px] md:text-xs font-medium">{{ $counts['all'] }}</span>
                            </a>
                            <a href="?status=pending"
                                class="{{ $status == 'pending' ? 'border-amber-500 text-amber-600' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300' }} group whitespace-nowrap py-4 px-1 border-b-2 font-bold text-[10px] sm:text-xs md:text-sm transition-colors duration-200 uppercase tracking-wide flex flex-col md:flex-row items-center justify-center text-center">
                                Pending
                                <span
                                    class="{{ $status == 'pending' ? 'bg-amber-100 text-amber-600' : 'bg-gray-100 text-gray-600' }} mt-1 md:mt-0 md:ml-2 py-0.5 px-1.5 md:px-2.5 rounded-full text-[10px] md:text-xs font-medium">{{ $counts['pending'] }}</span>
                            </a>
                            <a href="?status=processing"
                                class="{{ $status == 'processing' ? 'border-amber-500 text-amber-600' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300' }} group whitespace-nowrap py-4 px-1 border-b-2 font-bold text-[10px] sm:text-xs md:text-sm transition-colors duration-200 uppercase tracking-wide flex flex-col md:flex-row items-center justify-center text-center">
                                Process<span class="hidden sm:inline">ing</span>
                                <span
                                    class="{{ $status == 'processing' ? 'bg-amber-100 text-amber-600' : 'bg-gray-100 text-gray-600' }} mt-1 md:mt-0 md:ml-2 py-0.5 px-1.5 md:px-2.5 rounded-full text-[10px] md:text-xs font-medium">{{ $counts['processing'] }}</span>
                            </a>
                            <a href="?status=shipped"
                                class="{{ $status == 'shipped' ? 'border-amber-500 text-amber-600' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300' }} group whitespace-nowrap py-4 px-1 border-b-2 font-bold text-[10px] sm:text-xs md:text-sm transition-colors duration-200 uppercase tracking-wide flex flex-col md:flex-row items-center justify-center text-center">
                                Transit
                                <span
                                    class="{{ $status == 'shipped' ? 'bg-amber-100 text-amber-600' : 'bg-gray-100 text-gray-600' }} mt-1 md:mt-0 md:ml-2 py-0.5 px-1.5 md:px-2.5 rounded-full text-[10px] md:text-xs font-medium">{{ $counts['shipped'] }}</span>
                            </a>
                            <a href="?status=completed"
                                class="{{ $status == 'completed' ? 'border-amber-500 text-amber-600' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300' }} group whitespace-nowrap py-4 px-1 border-b-2 font-bold text-[10px] sm:text-xs md:text-sm transition-colors duration-200 uppercase tracking-wide flex flex-col md:flex-row items-center justify-center text-center">
                                Complete<span class="hidden sm:inline">d</span>
                                <span
                                    class="{{ $status == 'completed' ? 'bg-amber-100 text-amber-600' : 'bg-gray-100 text-gray-600' }} mt-1 md:mt-0 md:ml-2 py-0.5 px-1.5 md:px-2.5 rounded-full text-[10px] md:text-xs font-medium">{{ $counts['completed'] }}</span>
                            </a>
                            <a href="?status=cancelled"
                                class="{{ $status == 'cancelled' ? 'border-amber-500 text-amber-600' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300' }} group whitespace-nowrap py-4 px-1 border-b-2 font-bold text-[10px] sm:text-xs md:text-sm transition-colors duration-200 uppercase tracking-wide flex flex-col md:flex-row items-center justify-center text-center">
                                Cancel<span class="hidden sm:inline">led</span>
                                <span
                                    class="{{ $status == 'cancelled' ? 'bg-amber-100 text-amber-600' : 'bg-gray-100 text-gray-600' }} mt-1 md:mt-0 md:ml-2 py-0.5 px-1.5 md:px-2.5 rounded-full text-[10px] md:text-xs font-medium">{{ $counts['cancelled'] }}</span>
                            </a>
                            <a href="?status=returned"
                                class="{{ $status == 'returned' ? 'border-amber-500 text-amber-600' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300' }} group whitespace-nowrap py-4 px-1 border-b-2 font-bold text-[10px] sm:text-xs md:text-sm transition-colors duration-200 uppercase tracking-wide flex flex-col md:flex-row items-center justify-center text-center">
                                Return<span class="hidden sm:inline">ed</span>
                                <span
                                    class="{{ $status == 'returned' ? 'bg-amber-100 text-amber-600' : 'bg-gray-100 text-gray-600' }} mt-1 md:mt-0 md:ml-2 py-0.5 px-1.5 md:px-2.5 rounded-full text-[10px] md:text-xs font-medium">{{ $counts['returned'] }}</span>
                            </a>
                        </nav>
                    </div>

                    <!-- Orders List -->
                    <div class="space-y-6">
                        @forelse($orders as $order)
                            <!-- Order Card -->
                            <div
                                class="bg-white border border-gray-100 rounded-2xl p-4 sm:p-6 shadow-sm hover:shadow-md transition-all duration-300 group">
                                <div
                                    class="flex flex-col md:flex-row justify-between md:items-center pb-4 border-b border-gray-50 mb-4">
                                    <div>
                                        <h3 class="text-lg font-bold text-gray-900 flex items-center">
                                            <span class="bg-gray-100 text-gray-600 p-1.5 rounded-lg mr-2">
                                                <svg class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-3 7h3m-3 4h3m-6-4h.01M9 16h.01" />
                                                </svg>
                                            </span>
                                            Order #{{ $order->order_number }}
                                        </h3>
                                        <p class="text-xs text-gray-500 mt-1 sm:ml-10">Placed on
                                            {{ $order->created_at->format('M d, Y') }} at
                                            {{ $order->created_at->format('h:i A') }}
                                        </p>
                                    </div>
                                    <div class="mt-4 md:mt-0 sm:ml-10 md:ml-0">
                                        @php
                                            $statusClasses = [
                                                'pending' => 'bg-amber-100 text-amber-800 border-amber-200',
                                                'processed' => 'bg-blue-100 text-blue-800 border-blue-200',
                                                'shipped' => 'bg-indigo-100 text-indigo-800 border-indigo-200',
                                                'transit' => 'bg-indigo-100 text-indigo-800 border-indigo-200',
                                                'completed' => 'bg-emerald-100 text-emerald-800 border-emerald-200',
                                                'cancelled' => 'bg-rose-100 text-rose-800 border-rose-200',
                                                'returned' => 'bg-gray-100 text-gray-800 border-gray-200',
                                            ];

                                            $statusLabel = ucfirst($order->status);
                                            $currentClass = $statusClasses[$order->status] ?? 'bg-gray-100 text-gray-800 border-gray-200';

                                            if ($order->returnRequest) {
                                                $rStatus = $order->returnRequest->status;
                                                $statusLabel = 'Return ' . ucfirst(str_replace('_', ' ', $rStatus));

                                                if ($rStatus == 'requested')
                                                    $currentClass = 'bg-yellow-100 text-yellow-800 border-yellow-200';
                                                elseif ($rStatus == 'approved')
                                                    $currentClass = 'bg-blue-100 text-blue-800 border-blue-200';
                                                elseif ($rStatus == 'rejected')
                                                    $currentClass = 'bg-red-100 text-red-800 border-red-200';
                                                elseif ($rStatus == 'received')
                                                    $currentClass = 'bg-purple-100 text-purple-800 border-purple-200';
                                                elseif ($rStatus == 'refund_initiated')
                                                    $currentClass = 'bg-indigo-100 text-indigo-800 border-indigo-200';
                                                elseif ($rStatus == 'refunded')
                                                    $currentClass = 'bg-green-100 text-green-800 border-green-200';
                                            }
                                        @endphp
                                        <span
                                            class="inline-flex items-center px-3 py-1 rounded-full text-xs font-bold uppercase tracking-wider border {{ $currentClass }}">
                                            <span class="w-2 h-2 rounded-full bg-current mr-2 opacity-75"></span>
                                            {{ $statusLabel }}
                                        </span>

                                        @if($order->agentRating || $order->productReviews->isNotEmpty())
                                            @php
                                                $avgRating = 0;
                                                $totalRatings = 0;
                                                if ($order->agentRating) {
                                                    $avgRating += $order->agentRating->rating;
                                                    $totalRatings++;
                                                }
                                                foreach ($order->productReviews as $pr) {
                                                    $avgRating += $pr->rating;
                                                    $totalRatings++;
                                                }
                                                $finalAvg = $totalRatings > 0 ? round($avgRating / $totalRatings, 1) : 0;
                                            @endphp
                                            <a href="{{ route('user.orders.show', $order->id) }}#ratings-section"
                                                class="inline-flex items-center px-3 py-1 rounded-full text-xs font-bold uppercase tracking-wider border bg-amber-50 text-amber-700 border-amber-200 ml-2 hover:bg-amber-100 transition-colors">
                                                <svg class="w-3 h-3 fill-current mr-1" viewBox="0 0 20 20">
                                                    <path
                                                        d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z" />
                                                </svg>
                                                Rating: {{ $finalAvg }}
                                            </a>
                                        @endif
                                    </div>
                                </div>

                                <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center gap-4 sm:ml-10">
                                    <div>
                                        <p class="text-sm text-gray-500">Total Amount</p>
                                        <p class="text-xl font-extrabold text-gray-900">
                                            ₹{{ number_format($order->total_amount, 2) }}</p>
                                    </div>
                                    <div class="flex flex-wrap gap-2 sm:gap-3 w-full sm:w-auto">
                                        @if($order->status == 'completed')
                                            <form action="{{ route('user.orders.reorder', $order->id) }}" method="POST"
                                                class="flex-1 sm:flex-none">
                                                @csrf
                                                <button type="submit"
                                                    class="w-full flex items-center justify-center bg-white border border-gray-300 text-gray-700 px-4 sm:px-5 py-2 sm:py-2.5 rounded-xl text-xs sm:text-sm font-bold uppercase tracking-wider hover:bg-gray-50 transition-all duration-300 shadow-sm">
                                                    Reorder
                                                </button>
                                            </form>
                                        @endif

                                        @if(in_array($order->status, ['pending', 'completed']))
                                            <a href="{{ route('user.tickets.create', $order->id) }}"
                                                class="flex-1 sm:flex-none flex items-center justify-center bg-white border border-gray-300 text-gray-700 px-4 sm:px-5 py-2 sm:py-2.5 rounded-xl text-xs sm:text-sm font-bold uppercase tracking-wider hover:bg-gray-50 transition-all duration-300 shadow-sm">
                                                Support
                                            </a>
                                        @endif

                                        <a href="{{ route('user.orders.show', $order->id) }}"
                                            class="flex-1 sm:flex-none group/btn flex items-center justify-center bg-gradient-to-r from-amber-500 to-orange-600 text-white px-4 sm:px-5 py-2 sm:py-2.5 rounded-xl text-xs sm:text-sm font-bold uppercase tracking-wider hover:from-amber-600 hover:to-orange-700 transition-all duration-300 shadow-lg hover:shadow-amber-200">
                                            View Details
                                            <svg class="h-4 w-4 ml-2 transform group-hover/btn:translate-x-1 transition-transform"
                                                fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M14 5l7 7m0 0l-7 7m7-7H3" />
                                            </svg>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        @empty
                            <div class="text-center py-20 bg-white rounded-3xl border-2 border-dashed border-gray-200">
                                <div class="bg-gray-50 p-4 rounded-full shadow-sm inline-block mb-4">
                                    <svg class="h-12 w-12 text-amber-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z" />
                                    </svg>
                                </div>
                                <h3 class="mt-2 text-lg font-bold text-gray-900">No orders found</h3>
                                <p class="mt-1 text-sm text-gray-500 mb-8 max-w-sm mx-auto">It seems you haven't placed any
                                    orders
                                    in this category yet. Start exploring our collection!</p>
                                <a href="{{ route('home') }}"
                                    class="inline-flex items-center px-8 py-3 border border-transparent shadow-lg text-sm font-bold rounded-xl text-white bg-gradient-to-r from-amber-500 to-orange-600 hover:from-amber-600 hover:to-orange-700 transform hover:-translate-y-1 transition-all">
                                    Start Shopping
                                    <svg class="h-5 w-5 ml-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M17 8l4 4m0 0l-4 4m4-4H3" />
                                    </svg>
                                </a>
                            </div>
                        @endforelse
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection