@extends('layouts.shop')

@section('title', 'My Gift Cards - Hair Niche By Shelly')

@section('content')
    <div class="bg-gray-50 min-h-screen">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-16">
            <div class="md:flex md:space-x-8">
                <!-- Sidebar -->
                @include('user.partials.sidebar')

                <!-- Main Content -->
                <div class="md:w-3/4">
                    <div class="bg-white overflow-hidden shadow-xl sm:rounded-lg p-6">
                        <h2 class="text-2xl font-semibold text-gray-800 mb-6">Gift Cards</h2>

                        @if(session('success'))
                            <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative mb-4"
                                role="alert">
                                <span class="block sm:inline">{{ session('success') }}</span>
                            </div>
                        @endif

                        @if(session('error'))
                            <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-4"
                                role="alert">
                                <span class="block sm:inline">{{ session('error') }}</span>
                            </div>
                        @endif

                        <div class="grid grid-cols-1 gap-8">
                            <!-- Create Gift Card -->
                            <div class="bg-gray-50 p-6 rounded-xl border border-gray-200">
                                <h3 class="text-xl font-bold text-gray-900 mb-6 flex items-center">
                                    <svg class="h-6 w-6 mr-2 text-indigo-600" fill="none" viewBox="0 0 24 24"
                                        stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                                    </svg>
                                    Create a New Gift Card
                                </h3>

                                <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                                    <!-- Form -->
                                    <form action="{{ route('user.gift-cards.store') }}" method="POST" class="space-y-5">
                                        @csrf
                                        <div>
                                            <label for="amount"
                                                class="block text-sm font-semibold text-gray-700 mb-1.5">Amount
                                                ({{ config('app.currency', '₹') }})</label>
                                            <div class="relative rounded-md shadow-sm">
                                                <div
                                                    class="pointer-events-none absolute inset-y-0 left-0 flex items-center pl-3">
                                                    <span
                                                        class="text-gray-500 sm:text-sm">{{ config('app.currency', '₹') }}</span>
                                                </div>
                                                <input type="number" name="amount" id="amount" required min="1" step="1"
                                                    class="block w-full rounded-lg border-gray-300 pl-8 focus:border-indigo-500 focus:ring-indigo-500 py-3 sm:text-sm shadow-sm"
                                                    placeholder="0.00">
                                            </div>
                                            <p class="mt-2 text-xs text-indigo-600 font-medium flex items-center">
                                                <svg class="h-4 w-4 mr-1" fill="none" viewBox="0 0 24 24"
                                                    stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z" />
                                                </svg>
                                                Wallet Balance:
                                                {{ config('app.currency', '₹') }}{{ auth()->user()->wallet_balance }}
                                            </p>
                                        </div>
                                        <div>
                                            <label for="recipient_email"
                                                class="block text-sm font-semibold text-gray-700 mb-1.5">Recipient Email
                                                <span class="text-gray-400 font-normal">(Optional)</span></label>
                                            <div class="relative rounded-md shadow-sm">
                                                <div
                                                    class="pointer-events-none absolute inset-y-0 left-0 flex items-center pl-3">
                                                    <svg class="h-5 w-5 text-gray-400" fill="none" viewBox="0 0 24 24"
                                                        stroke="currentColor">
                                                        <path stroke-linecap="round" stroke-linejoin="round"
                                                            stroke-width="2"
                                                            d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z" />
                                                    </svg>
                                                </div>
                                                <input type="email" name="recipient_email" id="recipient_email"
                                                    class="block w-full rounded-lg border-gray-300 pl-10 focus:border-indigo-500 focus:ring-indigo-500 py-3 sm:text-sm shadow-sm"
                                                    placeholder="friend@example.com">
                                            </div>
                                            <p class="mt-2 text-xs text-gray-500">If specified, only this email can redeem
                                                the card.</p>
                                        </div>
                                        <button type="submit"
                                            class="w-full flex justify-center py-3 px-4 border border-transparent rounded-lg shadow-md text-sm font-bold text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 transition-all transform hover:-translate-y-0.5">
                                            Create Gift Card
                                        </button>
                                    </form>

                                    <!-- Rules -->
                                    <div class="bg-white p-5 rounded-lg border border-gray-100 shadow-sm">
                                        <h4
                                            class="text-sm font-bold text-gray-900 uppercase tracking-widest mb-3 border-b border-gray-100 pb-2">
                                            Gift Card Rules
                                        </h4>
                                        <ul class="list-disc pl-5 space-y-2 text-sm text-gray-600">
                                            <li><span class="font-semibold text-gray-800">Validity:</span> Gift cards are
                                                valid for
                                                {{ \App\Models\GeneralSetting::value('gift_card_expiry_days') ?? 365 }} days
                                                from the date of creation.</li>
                                            <li><span class="font-semibold text-gray-800">Usage:</span> Can be used to
                                                purchase any item on our store, including sale items.</li>
                                            <li><span class="font-semibold text-gray-800">Wallet Deduction:</span> Creating
                                                a gift card deducts the amount directly from your wallet balance.</li>
                                            <li><span class="font-semibold text-gray-800">Transferable:</span> Unless locked
                                                to a specific recipient email, codes can be shared with anyone.</li>
                                            <li><span class="font-semibold text-gray-800">No Refunds:</span> Once created,
                                                gift cards cannot be refunded back to the wallet.</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>

                            <!-- My Created Gift Cards -->
                            @if(isset($receivedGiftCards) && $receivedGiftCards->count() > 0)
                                <div class="bg-indigo-50 border border-indigo-100 rounded-xl p-6 mb-8">
                                    <h3 class="text-xl font-bold text-indigo-900 mb-4 flex items-center">
                                        <svg class="h-6 w-6 mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M12 8v13m0-13V6a2 2 0 112 2h-2zm0 0V5.5A2.5 2.5 0 109.5 8H12zm-7 4h14M5 12a2 2 0 110-4h14a2 2 0 110 4M5 12v7a2 2 0 002 2h10a2 2 0 002-2v-7" />
                                        </svg>
                                        Received Gift Cards
                                    </h3>
                                    <div class="space-y-4">
                                        @foreach($receivedGiftCards as $card)
                                            <div
                                                class="bg-white border border-indigo-200 rounded-lg p-5 shadow-sm flex flex-col md:flex-row justify-between items-start md:items-center transform transition-all hover:scale-[1.01]">
                                                <div>
                                                    <div class="flex items-center mb-1" x-data="{ copied: false }">
                                                        <span class="text-sm font-bold text-gray-500 mr-2">Code:</span>
                                                        <code class="px-2 py-1 bg-gray-100 rounded text-indigo-700 font-mono font-bold select-all">{{ $card->code }}</code>
                                                        <button @click="navigator.clipboard.writeText('{{ $card->code }}'); copied = true; setTimeout(() => copied = false, 2000)" 
                                                                class="ml-2 text-gray-400 hover:text-indigo-600 focus:outline-none transition-colors"
                                                                title="Copy Code">
                                                            <svg x-show="!copied" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 16H6a2 2 0 01-2-2V6a2 2 0 012-2h8a2 2 0 012 2v2m-6 12h8a2 2 0 002-2v-8a2 2 0 00-2-2h-8a2 2 0 00-2 2v8a2 2 0 002 2z" />
                                                            </svg>
                                                            <svg x-show="copied" x-cloak class="h-5 w-5 text-green-500" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                                                            </svg>
                                                        </button>
                                                    </div>
                                                    <p class="text-xs text-gray-500">From: {{ $card->creator->name ?? 'Unknown' }}
                                                        ({{ $card->creator->email ?? 'N/A' }})</p>
                                                    <p class="text-xs text-gray-500">Expires:
                                                        {{ $card->expires_at->format('M d, Y') }}</p>
                                                </div>
                                                <div class="mt-3 md:mt-0 text-right">
                                                    <p class="text-lg font-bold text-gray-900">
                                                        {{ config('app.currency', '₹') }}{{ number_format($card->amount, 2) }}</p>
                                                    <span
                                                        class="px-2 py-0.5 inline-flex text-xs leading-5 font-semibold rounded-full 
                                                                    {{ $card->status === 'active' ? 'bg-green-100 text-green-800' : ($card->status === 'redeemed' ? 'bg-gray-100 text-gray-500' : 'bg-red-100 text-red-800') }}">
                                                        {{ ucfirst($card->status) }}
                                                    </span>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            @endif

                            <div>
                                <h3 class="text-lg font-medium text-gray-900 mb-4">My Created Gift Cards</h3>
                                @if($giftCards->count() > 0)
                                    <div class="space-y-4">
                                        @foreach($giftCards as $card)
                                            <div
                                                class="bg-white border border-gray-200 rounded-lg p-4 shadow-sm flex flex-col sm:flex-row justify-between items-start sm:items-center">
                                                <div>
                                                    <div class="flex items-center text-sm font-bold text-gray-900 mb-1" x-data="{ copied: false }">
                                                        <span class="mr-2">Code: {{ $card->code }}</span>
                                                        <button @click="navigator.clipboard.writeText('{{ $card->code }}'); copied = true; setTimeout(() => copied = false, 2000)" 
                                                                class="text-gray-400 hover:text-indigo-600 focus:outline-none transition-colors"
                                                                title="Copy Code">
                                                            <svg x-show="!copied" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 16H6a2 2 0 01-2-2V6a2 2 0 012-2h8a2 2 0 012 2v2m-6 12h8a2 2 0 002-2v-8a2 2 0 00-2-2h-8a2 2 0 00-2 2v8a2 2 0 002 2z" />
                                                            </svg>
                                                            <svg x-show="copied" x-cloak class="h-4 w-4 text-green-500" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                                                            </svg>
                                                        </button>
                                                    </div>
                                                    <p class="text-xs text-gray-500">Amount:
                                                        {{ config('app.currency', '₹') }}{{ number_format($card->amount, 2) }}
                                                    </p>
                                                    <p class="text-xs text-gray-500">To: {{ $card->recipient_email ?? 'Any' }}</p>
                                                    <p class="text-xs text-gray-400">Expires:
                                                        {{ $card->expires_at->format('M d, Y') }}
                                                    </p>
                                                </div>
                                                <div class="mt-2 sm:mt-0">
                                                    <span
                                                        class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full 
                                                                            {{ $card->status === 'active' ? 'bg-green-100 text-green-800' : ($card->status === 'redeemed' ? 'bg-blue-100 text-blue-800' : 'bg-red-100 text-red-800') }}">
                                                        {{ ucfirst($card->status) }}
                                                    </span>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                @else
                                    <p class="text-gray-500 text-sm">You haven't created any gift cards yet.</p>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection