@extends('layouts.shop')

@section('title', 'My Account - Hair Niche By Shelly')

@section('content')
    <div class="bg-gray-50 min-h-screen">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-16">
            <div class="md:flex md:space-x-8">
                <!-- Sidebar -->
                @include('user.partials.sidebar')

                <!-- Main Content -->
                <div class="md:w-3/4">
                    <!-- Welcome Banner -->
                    <div
                        class="relative overflow-hidden rounded-3xl bg-gradient-to-r from-violet-600 to-indigo-600 p-10 mb-10 shadow-xl">
                        <div class="relative z-10">
                            <h1 class="text-3xl font-extrabold text-white mb-2 tracking-tight">
                                Welcome back, {{ Auth::user()->name }}!
                            </h1>
                            <p class="text-indigo-100 text-lg max-w-xl">
                                Here's what's happening with your account today. You can manage your orders, check your
                                wishlist, and update your profile settings.
                            </p>
                            <div class="mt-8 flex space-x-4">
                                <a href="{{ route('shop.index') }}"
                                    class="px-6 py-3 bg-white text-indigo-600 rounded-xl font-bold text-sm shadow-md hover:bg-gray-50 transition-colors uppercase tracking-wide">
                                    Browse Shop
                                </a>
                                <a href="{{ route('user.orders') }}"
                                    class="px-6 py-3 bg-indigo-500/30 text-white border border-white/20 rounded-xl font-bold text-sm hover:bg-indigo-500/40 transition-colors uppercase tracking-wide backdrop-blur-sm">
                                    View Orders
                                </a>
                            </div>
                        </div>
                        <!-- Decorative Circles -->
                        <div class="absolute top-0 right-0 -mr-20 -mt-20 w-96 h-96 rounded-full bg-white/10 blur-3xl"></div>
                        <div class="absolute bottom-0 right-10 w-64 h-64 rounded-full bg-white/5 blur-2xl"></div>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-10">
                        <!-- Stat Cards -->
                        <div
                            class="group relative overflow-hidden bg-gradient-to-br from-blue-500 to-blue-600 p-6 rounded-2xl shadow-lg border border-blue-400 hover:shadow-xl transition-all duration-300 transform hover:-translate-y-1">
                            <div class="flex justify-between items-start z-10 relative">
                                <div>
                                    <p class="text-xs font-bold text-blue-100 uppercase tracking-wider">Total Orders</p>
                                    <p class="text-4xl font-extrabold text-white mt-2">{{ $totalOrders }}</p>
                                </div>
                                <div
                                    class="bg-white/20 p-3 rounded-xl text-white backdrop-blur-sm group-hover:bg-white/30 transition-colors duration-300">
                                    <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z" />
                                    </svg>
                                </div>
                            </div>
                            <p class="mt-4 text-xs font-medium text-blue-100">Lifetime purchases</p>
                            <div
                                class="absolute bottom-0 right-0 w-24 h-24 bg-white/10 rounded-full -mr-10 -mb-10 group-hover:scale-150 transition-transform duration-500 ease-in-out">
                            </div>
                        </div>

                        <div
                            class="group relative overflow-hidden bg-gradient-to-br from-amber-400 to-orange-500 p-6 rounded-2xl shadow-lg border border-amber-300 hover:shadow-xl transition-all duration-300 transform hover:-translate-y-1">
                            <div class="flex justify-between items-start z-10 relative">
                                <div>
                                    <p class="text-xs font-bold text-amber-100 uppercase tracking-wider">Pending</p>
                                    <p class="text-4xl font-extrabold text-white mt-2">{{ $pendingOrders }}</p>
                                </div>
                                <div
                                    class="bg-white/20 p-3 rounded-xl text-white backdrop-blur-sm group-hover:bg-white/30 transition-colors duration-300">
                                    <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z" />
                                    </svg>
                                </div>
                            </div>
                            <p class="mt-4 text-xs font-medium text-amber-100">Processing orders</p>
                            <div
                                class="absolute bottom-0 right-0 w-24 h-24 bg-white/10 rounded-full -mr-10 -mb-10 group-hover:scale-150 transition-transform duration-500 ease-in-out">
                            </div>
                        </div>

                        <div
                            class="group relative overflow-hidden bg-gradient-to-br from-rose-500 to-pink-600 p-6 rounded-2xl shadow-lg border border-rose-400 hover:shadow-xl transition-all duration-300 transform hover:-translate-y-1">
                            <div class="flex justify-between items-start z-10 relative">
                                <div>
                                    <p class="text-xs font-bold text-rose-100 uppercase tracking-wider">Wishlist</p>
                                    <p class="text-4xl font-extrabold text-white mt-2">{{ $wishlistCount }}</p>
                                </div>
                                <div
                                    class="bg-white/20 p-3 rounded-xl text-white backdrop-blur-sm group-hover:bg-white/30 transition-colors duration-300">
                                    <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z" />
                                    </svg>
                                </div>
                            </div>
                            <p class="mt-4 text-xs font-medium text-rose-100">Saved items</p>
                            <div
                                class="absolute bottom-0 right-0 w-24 h-24 bg-white/10 rounded-full -mr-10 -mb-10 group-hover:scale-150 transition-transform duration-500 ease-in-out">
                            </div>
                        </div>

                        <div
                            class="group relative overflow-hidden bg-gradient-to-br from-emerald-500 to-teal-600 p-6 rounded-2xl shadow-lg border border-emerald-400 hover:shadow-xl transition-all duration-300 transform hover:-translate-y-1">
                            <div class="flex justify-between items-start z-10 relative">
                                <div>
                                    <p class="text-xs font-bold text-emerald-100 uppercase tracking-wider">Wallet</p>
                                    <p class="text-4xl font-extrabold text-white mt-2">
                                        {{ number_format(Auth::user()->wallet_balance ?? 0, 2) }}</p>
                                </div>
                                <div
                                    class="bg-white/20 p-3 rounded-xl text-white backdrop-blur-sm group-hover:bg-white/30 transition-colors duration-300">
                                    <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                                    </svg>
                                </div>
                            </div>
                            <p class="mt-4 text-xs font-medium text-emerald-100">Available points</p>
                            <div
                                class="absolute bottom-0 right-0 w-24 h-24 bg-white/10 rounded-full -mr-10 -mb-10 group-hover:scale-150 transition-transform duration-500 ease-in-out">
                            </div>
                        </div>
                    </div>

                    <div class="bg-white border border-gray-100 rounded-3xl shadow-sm overflow-hidden">
                        <div class="px-8 py-6 border-b border-gray-50 flex items-center justify-between">
                            <h2 class="text-xl font-bold text-gray-900 flex items-center">
                                <svg class="h-5 w-5 mr-3 text-indigo-600" fill="none" viewBox="0 0 24 24"
                                    stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-3 7h3m-3 4h3m-6-4h.01M9 16h.01" />
                                </svg>
                                Recent Orders
                            </h2>
                            <a href="{{ route('user.orders') }}"
                                class="text-sm font-bold text-indigo-600 hover:text-indigo-800 transition-colors bg-indigo-50 px-3 py-1.5 rounded-lg hover:bg-indigo-100">
                                View All
                            </a>
                        </div>

                        <div class="overflow-x-auto">
                            @if(isset($recentOrders) && $recentOrders->count() > 0)
                                <table class="min-w-full divide-y divide-gray-100">
                                    <thead class="bg-gray-50/50">
                                        <tr>
                                            <th scope="col"
                                                class="px-8 py-4 text-left text-xs font-extrabold text-gray-500 uppercase tracking-wider">
                                                Order</th>
                                            <th scope="col"
                                                class="px-6 py-4 text-left text-xs font-extrabold text-gray-500 uppercase tracking-wider">
                                                Date</th>
                                            <th scope="col"
                                                class="px-6 py-4 text-left text-xs font-extrabold text-gray-500 uppercase tracking-wider">
                                                Status</th>
                                            <th scope="col"
                                                class="px-6 py-4 text-left text-xs font-extrabold text-gray-500 uppercase tracking-wider">
                                                Total</th>
                                            <th scope="col"
                                                class="px-6 py-4 text-right text-xs font-extrabold text-gray-500 uppercase tracking-wider">
                                                Action</th>
                                        </tr>
                                    </thead>
                                    <tbody class="bg-white divide-y divide-gray-100">
                                        @foreach($recentOrders as $order)
                                            <tr class="hover:bg-gray-50/50 transition-colors duration-200">
                                                <td class="px-8 py-4 whitespace-nowrap">
                                                    <span class="text-sm font-bold text-gray-900">#{{ $order->order_number }}</span>
                                                </td>
                                                <td class="px-6 py-4 whitespace-nowrap">
                                                    <span
                                                        class="text-sm text-gray-600">{{ $order->created_at->format('M d, Y') }}</span>
                                                </td>
                                                <td class="px-6 py-4 whitespace-nowrap">
                                                    @php
                                                        $statusClasses = [
                                                            'pending' => 'bg-amber-100 text-amber-800 border-amber-200',
                                                            'processing' => 'bg-blue-100 text-blue-800 border-blue-200',
                                                            'shipped' => 'bg-indigo-100 text-indigo-800 border-indigo-200',
                                                            'completed' => 'bg-emerald-100 text-emerald-800 border-emerald-200',
                                                            'cancelled' => 'bg-rose-100 text-rose-800 border-rose-200',
                                                        ];
                                                        $currentClass = $statusClasses[$order->status] ?? 'bg-gray-100 text-gray-800 border-gray-200';
                                                    @endphp
                                                    <span
                                                        class="px-3 py-1 inline-flex text-xs leading-5 font-bold rounded-full border {{ $currentClass }}">
                                                        {{ ucfirst($order->status) }}
                                                    </span>
                                                </td>
                                                <td class="px-6 py-4 whitespace-nowrap">
                                                    <span
                                                        class="text-sm font-bold text-gray-900">₹{{ number_format($order->total_amount, 2) }}</span>
                                                </td>
                                                <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                                                    <a href="{{ route('user.orders.show', $order->id) }}"
                                                        class="text-indigo-600 hover:text-indigo-900 font-bold inline-flex items-center group">
                                                        Details
                                                        <svg class="h-4 w-4 ml-1 transform group-hover:translate-x-1 transition-transform"
                                                            fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                                d="M9 5l7 7-7 7" />
                                                        </svg>
                                                    </a>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            @else
                                <div class="text-center py-16">
                                    <div
                                        class="inline-flex items-center justify-center w-16 h-16 rounded-full bg-gray-50 mb-4 animate-pulse">
                                        <svg class="h-8 w-8 text-gray-300" fill="none" viewBox="0 0 24 24"
                                            stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z" />
                                        </svg>
                                    </div>
                                    <h3 class="text-lg font-bold text-gray-900">No recent orders</h3>
                                    <p class="mt-2 text-sm text-gray-500 max-w-sm mx-auto mb-8">You haven't placed any orders
                                        yet. Start your shopping journey today!</p>
                                    <a href="{{ route('shop.index') }}"
                                        class="inline-flex items-center px-6 py-3 border border-transparent shadow-lg text-sm font-bold rounded-xl text-white bg-gradient-to-r from-indigo-500 to-violet-600 hover:from-indigo-600 hover:to-violet-700 transition-all transform hover:-translate-y-1">
                                        Start Shopping
                                        <svg class="h-5 w-5 ml-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M17 8l4 4m0 0l-4 4m4-4H3" />
                                        </svg>
                                    </a>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection