@extends('layouts.shop')

@section('title', 'My Addresses - Hair Niche By Shelly')

@section('content')
    <div class="bg-gray-50 min-h-screen" x-data="addressRequest()">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-16">
            <div class="md:flex md:space-x-8">
                @include('user.partials.sidebar')

                <div class="md:w-3/4">
                    <h1 class="text-3xl font-extrabold text-gray-900 mb-8 uppercase tracking-wide flex items-center">
                        <svg class="h-8 w-8 mr-3 text-teal-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z" />
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M15 11a3 3 0 11-6 0 3 3 0 016 0z" />
                        </svg>
                        My Addresses
                    </h1>

                    <!-- Add New Address Button -->
                    <div class="mb-10">
                        <button @click="openModal('create')"
                            class="group flex items-center justify-between w-full md:w-auto bg-gradient-to-r from-teal-500 to-emerald-600 text-white px-8 py-3 rounded-xl uppercase tracking-wider text-sm font-bold hover:shadow-lg hover:from-teal-600 hover:to-emerald-700 transition-all duration-300 transform hover:-translate-y-0.5">
                            <span class="flex items-center">
                                <svg class="h-5 w-5 mr-2 group-hover:rotate-90 transition-transform duration-300"
                                    fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M12 4v16m8-8H4" />
                                </svg>
                                Add New Address
                            </span>
                        </button>

                        <!-- Form Container -->
                        <div x-show="open" x-transition:enter="transition ease-out duration-300"
                            x-transition:enter-start="opacity-0 transform -translate-y-4"
                            x-transition:enter-end="opacity-100 transform translate-y-0"
                            x-transition:leave="transition ease-in duration-200"
                            x-transition:leave-start="opacity-100 transform translate-y-0"
                            x-transition:leave-end="opacity-0 transform -translate-y-4"
                            class="mt-8 bg-white border border-gray-100 p-8 rounded-2xl shadow-xl" x-cloak>

                            <div class="flex items-center justify-between mb-8 border-b border-gray-100 pb-4">
                                <h3 class="text-xl font-bold text-gray-900 flex items-center">
                                    <div class="p-2 bg-teal-50 rounded-lg mr-3">
                                        <svg class="h-6 w-6 text-teal-600" fill="none" viewBox="0 0 24 24"
                                            stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4" />
                                        </svg>
                                    </div>
                                    <span x-text="isEditing ? 'Edit Address' : 'New Address Details'"></span>
                                </h3>
                                <button @click="open = false" class="text-gray-400 hover:text-gray-600 transition-colors">
                                    <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M6 18L18 6M6 6l12 12" />
                                    </svg>
                                </button>
                            </div>

                            <form
                                :action="isEditing ? '{{ url('user/addresses') }}/' + form.id : '{{ route('user.addresses.store') }}'"
                                method="POST">
                                @csrf
                                <template x-if="isEditing">
                                    <input type="hidden" name="_method" value="PUT">
                                </template>

                                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                    <div>
                                        <label class="block text-sm font-semibold text-gray-700 mb-2">Full Name <span
                                                class="text-rose-500">*</span></label>
                                        <div class="relative">
                                            <div
                                                class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                                <svg class="h-5 w-5 text-gray-400" fill="none" viewBox="0 0 24 24"
                                                    stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z" />
                                                </svg>
                                            </div>
                                            <input type="text" name="name" x-model="form.name" required
                                                class="w-full pl-10 border border-gray-200 rounded-xl shadow-sm focus:border-teal-500 focus:ring-teal-500 py-3 bg-white transition-all duration-200"
                                                placeholder="Recipient's Name">
                                        </div>
                                    </div>
                                    <div>
                                        <label class="block text-sm font-semibold text-gray-700 mb-2">Phone Number <span
                                                class="text-rose-500">*</span></label>
                                        <div class="relative">
                                            <div
                                                class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                                <svg class="h-5 w-5 text-gray-400" fill="none" viewBox="0 0 24 24"
                                                    stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z" />
                                                </svg>
                                            </div>
                                            <input type="text" name="phone" x-model="form.phone" required
                                                class="w-full pl-10 border border-gray-200 rounded-xl shadow-sm focus:border-teal-500 focus:ring-teal-500 py-3 bg-white transition-all duration-200"
                                                placeholder="10-digit mobile number">
                                        </div>
                                    </div>
                                    <div>
                                        <label class="block text-sm font-semibold text-gray-700 mb-2">Pincode <span
                                                class="text-rose-500">*</span></label>
                                        <div class="relative">
                                            <div
                                                class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                                <svg class="h-5 w-5 text-gray-400" fill="none" viewBox="0 0 24 24"
                                                    stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z" />
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M15 11a3 3 0 11-6 0 3 3 0 016 0z" />
                                                </svg>
                                            </div>
                                            <input type="text" name="postal_code" x-model="form.postal_code" required
                                                class="w-full pl-10 border border-gray-200 rounded-xl shadow-sm focus:border-teal-500 focus:ring-teal-500 py-3 bg-white transition-all duration-200"
                                                placeholder="6-digit code">
                                        </div>
                                    </div>
                                    <div>
                                        <label class="block text-sm font-semibold text-gray-700 mb-2">City <span
                                                class="text-rose-500">*</span></label>
                                        <div class="relative">
                                            <div
                                                class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                                <svg class="h-5 w-5 text-gray-400" fill="none" viewBox="0 0 24 24"
                                                    stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4" />
                                                </svg>
                                            </div>
                                            <input type="text" name="city" x-model="form.city" required
                                                class="w-full pl-10 border border-gray-200 rounded-xl shadow-sm focus:border-teal-500 focus:ring-teal-500 py-3 bg-white transition-all duration-200">
                                        </div>
                                    </div>
                                    <div class="md:col-span-2">
                                        <label class="block text-sm font-semibold text-gray-700 mb-2">State <span
                                                class="text-rose-500">*</span></label>
                                        <div class="relative">
                                            <div
                                                class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                                <svg class="h-5 w-5 text-gray-400" fill="none" viewBox="0 0 24 24"
                                                    stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M3.055 11H5a2 2 0 012 2v1a2 2 0 002 2 2 2 0 012 2v2.945M8 3.935V5.5A2.5 2.5 0 0010.5 8h.5a2 2 0 012 2 2 2 0 104 0 2 2 0 012-2h1.064M15 20.488V18a2 2 0 012-2h3.064M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                                                </svg>
                                            </div>
                                            <input type="text" name="state" x-model="form.state" required
                                                class="w-full pl-10 border border-gray-200 rounded-xl shadow-sm focus:border-teal-500 focus:ring-teal-500 py-3 bg-white transition-all duration-200">
                                        </div>
                                    </div>
                                    <div class="md:col-span-2">
                                        <label class="block text-sm font-semibold text-gray-700 mb-2">Country <span
                                                class="text-rose-500">*</span></label>
                                        <div class="relative">
                                            <div
                                                class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                                <svg class="h-5 w-5 text-gray-400" fill="none" viewBox="0 0 24 24"
                                                    stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M3.055 11H5a2 2 0 012 2v1a2 2 0 002 2 2 2 0 012 2v2.945M8 3.935V5.5A2.5 2.5 0 0010.5 8h.5a2 2 0 012 2 2 2 0 104 0 2 2 0 012-2h1.064M15 20.488V18a2 2 0 012-2h3.064M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                                                </svg>
                                            </div>
                                            <select name="country" x-model="form.country" required
                                                class="w-full pl-10 border border-gray-200 rounded-xl shadow-sm focus:border-teal-500 focus:ring-teal-500 py-3 bg-white transition-all duration-200">
                                                <option value="India">India</option>
                                                <option value="United States">United States</option>
                                                <option value="Canada">Canada</option>
                                                <option value="United Kingdom">United Kingdom</option>
                                                <option value="Australia">Australia</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="md:col-span-2">
                                        <label class="block text-sm font-semibold text-gray-700 mb-2">Address Line 1 <span
                                                class="text-rose-500">*</span></label>
                                        <div class="relative">
                                            <div
                                                class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                                <svg class="h-5 w-5 text-gray-400" fill="none" viewBox="0 0 24 24"
                                                    stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6" />
                                                </svg>
                                            </div>
                                            <input type="text" name="address_line1" x-model="form.address_line1" required
                                                class="w-full pl-10 border border-gray-200 rounded-xl shadow-sm focus:border-teal-500 focus:ring-teal-500 py-3 bg-white transition-all duration-200"
                                                placeholder="House No, Building, Street Area">
                                        </div>
                                    </div>
                                    <div class="md:col-span-2">
                                        <label class="block text-sm font-semibold text-gray-700 mb-2">Address Line 2
                                            (Optional)</label>
                                        <div class="relative">
                                            <div
                                                class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                                <svg class="h-5 w-5 text-gray-400" fill="none" viewBox="0 0 24 24"
                                                    stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z" />
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M15 11a3 3 0 11-6 0 3 3 0 016 0z" />
                                                </svg>
                                            </div>
                                            <input type="text" name="address_line2" x-model="form.address_line2"
                                                class="w-full pl-10 border border-gray-200 rounded-xl shadow-sm focus:border-teal-500 focus:ring-teal-500 py-3 bg-white transition-all duration-200"
                                                placeholder="Landmark, etc.">
                                        </div>
                                    </div>

                                    <div class="md:col-span-2">
                                        <label class="block text-sm font-semibold text-gray-700 mb-4">Address Type <span
                                                class="text-rose-500">*</span></label>
                                        <div class="flex flex-wrap gap-4">
                                            <label class="cursor-pointer">
                                                <input type="radio" name="type" value="home" x-model="form.type"
                                                    class="peer sr-only">
                                                <div
                                                    class="px-5 py-2.5 rounded-lg border border-gray-200 text-gray-600 hover:bg-gray-50 peer-checked:bg-teal-50 peer-checked:text-teal-700 peer-checked:border-teal-200 transition-all flex items-center">
                                                    <svg class="h-4 w-4 mr-2" fill="none" viewBox="0 0 24 24"
                                                        stroke="currentColor">
                                                        <path stroke-linecap="round" stroke-linejoin="round"
                                                            stroke-width="2"
                                                            d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6" />
                                                    </svg>
                                                    Home
                                                </div>
                                            </label>
                                            <label class="cursor-pointer">
                                                <input type="radio" name="type" value="office" x-model="form.type"
                                                    class="peer sr-only">
                                                <div
                                                    class="px-5 py-2.5 rounded-lg border border-gray-200 text-gray-600 hover:bg-gray-50 peer-checked:bg-teal-50 peer-checked:text-teal-700 peer-checked:border-teal-200 transition-all flex items-center">
                                                    <svg class="h-4 w-4 mr-2" fill="none" viewBox="0 0 24 24"
                                                        stroke="currentColor">
                                                        <path stroke-linecap="round" stroke-linejoin="round"
                                                            stroke-width="2"
                                                            d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4" />
                                                    </svg>
                                                    Office
                                                </div>
                                            </label>
                                            <label class="cursor-pointer">
                                                <input type="radio" name="type" value="other" x-model="form.type"
                                                    class="peer sr-only">
                                                <div
                                                    class="px-5 py-2.5 rounded-lg border border-gray-200 text-gray-600 hover:bg-gray-50 peer-checked:bg-teal-50 peer-checked:text-teal-700 peer-checked:border-teal-200 transition-all flex items-center">
                                                    <svg class="h-4 w-4 mr-2" fill="none" viewBox="0 0 24 24"
                                                        stroke="currentColor">
                                                        <path stroke-linecap="round" stroke-linejoin="round"
                                                            stroke-width="2"
                                                            d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z" />
                                                        <path stroke-linecap="round" stroke-linejoin="round"
                                                            stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z" />
                                                    </svg>
                                                    Other
                                                </div>
                                            </label>
                                        </div>
                                    </div>

                                    <div class="md:col-span-2 grid grid-cols-2 gap-6" x-show="form.type === 'office'">
                                        <div>
                                            <label class="block text-sm font-semibold text-gray-700 mb-2">Open Time
                                                (Optional)</label>
                                            <div class="relative">
                                                <div
                                                    class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                                    <svg class="h-5 w-5 text-gray-400" fill="none" viewBox="0 0 24 24"
                                                        stroke="currentColor">
                                                        <path stroke-linecap="round" stroke-linejoin="round"
                                                            stroke-width="2"
                                                            d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z" />
                                                    </svg>
                                                </div>
                                                <input type="time" name="open_time" x-model="form.open_time"
                                                    class="w-full pl-10 border border-gray-200 rounded-xl shadow-sm focus:border-teal-500 focus:ring-teal-500 py-3 bg-white transition-all duration-200">
                                            </div>
                                        </div>
                                        <div>
                                            <label class="block text-sm font-semibold text-gray-700 mb-2">Close Time
                                                (Optional)</label>
                                            <div class="relative">
                                                <div
                                                    class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                                    <svg class="h-5 w-5 text-gray-400" fill="none" viewBox="0 0 24 24"
                                                        stroke="currentColor">
                                                        <path stroke-linecap="round" stroke-linejoin="round"
                                                            stroke-width="2"
                                                            d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z" />
                                                    </svg>
                                                </div>
                                                <input type="time" name="close_time" x-model="form.close_time"
                                                    class="w-full pl-10 border border-gray-200 rounded-xl shadow-sm focus:border-teal-500 focus:ring-teal-500 py-3 bg-white transition-all duration-200">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="md:col-span-2 mt-2">
                                        <label class="inline-flex items-center cursor-pointer group">
                                            <input type="checkbox" name="is_default" x-model="form.is_default"
                                                class="text-teal-600 focus:ring-teal-500 rounded h-5 w-5 border-gray-300 transition duration-150 ease-in-out bg-white">
                                            <span
                                                class="ml-3 text-sm font-medium text-gray-700 group-hover:text-teal-700">Make
                                                this my default delivery address</span>
                                        </label>
                                    </div>
                                </div>

                                <div class="mt-10 flex justify-end space-x-4">
                                    <button @click="open = false" type="button"
                                        class="px-8 py-3 border border-gray-200 rounded-xl text-sm font-bold text-gray-600 hover:bg-gray-50 hover:text-gray-800 transition-colors">
                                        Cancel
                                    </button>
                                    <button type="submit" x-text="isEditing ? 'Update Address' : 'Save Address'"
                                        class="bg-gradient-to-r from-teal-500 to-emerald-600 text-white px-8 py-3 rounded-xl uppercase tracking-wider text-sm font-bold hover:shadow-lg hover:from-teal-600 hover:to-emerald-700 transition-all duration-300 transform hover:-translate-y-0.5">
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>

                    <!-- Addresses List -->
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                        @forelse($addresses as $address)
                            <div
                                class="bg-white border text-left {{ $address->is_default ? 'border-teal-500 ring-1 ring-teal-500 shadow-md' : 'border-gray-100 shadow-sm' }} p-8 rounded-2xl relative transition-all duration-300 hover:shadow-lg hover:-translate-y-1 group">
                                @if($address->is_default)
                                    <span
                                        class="absolute top-4 right-4 bg-teal-50 text-teal-700 text-xs font-bold px-3 py-1 rounded-full border border-teal-100 uppercase tracking-wide flex items-center">
                                        <svg class="h-3 w-3 mr-1" fill="currentColor" viewBox="0 0 20 20">
                                            <path fill-rule="evenodd"
                                                d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z"
                                                clip-rule="evenodd" />
                                        </svg>
                                        Default
                                    </span>
                                @endif

                                <div class="flex items-center mb-4">
                                    <div
                                        class="p-3 {{ $address->type == 'home' ? 'bg-blue-50 text-blue-600' : ($address->type == 'office' ? 'bg-purple-50 text-purple-600' : 'bg-orange-50 text-orange-600') }} rounded-xl mr-4 group-hover:scale-110 transition-transform">
                                        @if($address->type == 'home')
                                            <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6" />
                                            </svg>
                                        @elseif($address->type == 'office')
                                            <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4" />
                                            </svg>
                                        @else
                                            <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z" />
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M15 11a3 3 0 11-6 0 3 3 0 016 0z" />
                                            </svg>
                                        @endif
                                    </div>
                                    <div>
                                        <h4 class="font-bold text-gray-900 text-lg">{{ $address->name }}</h4>
                                        <span
                                            class="text-xs font-semibold uppercase tracking-wider text-gray-400">{{ ucfirst($address->type) }}</span>
                                    </div>
                                </div>

                                <div class="space-y-2 mb-6">
                                    <p class="text-gray-600 text-sm flex items-start">
                                        <svg class="h-5 w-5 mr-2 text-gray-400 shrink-0 mt-0.5" fill="none" viewBox="0 0 24 24"
                                            stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z" />
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M15 11a3 3 0 11-6 0 3 3 0 016 0z" />
                                        </svg>
                                        <span>{{ $address->address_line1 }}
                                            @if($address->address_line2), {{ $address->address_line2 }} @endif
                                            <br>{{ $address->city }}, {{ $address->state }} - <span
                                                class="font-semibold text-gray-800">{{ $address->postal_code }}</span></span>
                                    </p>
                                    <p class="text-gray-600 text-sm flex items-center">
                                        <svg class="h-5 w-5 mr-2 text-gray-400" fill="none" viewBox="0 0 24 24"
                                            stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z" />
                                        </svg>
                                        {{ $address->phone }}
                                    </p>
                                    @if($address->type == 'office' && $address->open_time)
                                        <p
                                            class="text-gray-500 text-xs flex items-center mt-2 bg-gray-50 p-2 rounded-lg inline-block">
                                            <svg class="h-4 w-4 mr-1.5 text-gray-400" fill="none" viewBox="0 0 24 24"
                                                stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z" />
                                            </svg>
                                            {{ \Carbon\Carbon::parse($address->open_time)->format('g:i A') }} -
                                            {{ \Carbon\Carbon::parse($address->close_time)->format('g:i A') }}
                                        </p>
                                    @endif
                                </div>

                                <div
                                    class="flex items-center space-x-3 text-sm font-semibold border-t border-gray-100 pt-4 mt-auto">
                                    <button @click="openModal('edit', {{ json_encode($address) }})"
                                        class="flex items-center text-teal-600 hover:text-teal-800 transition-colors px-3 py-1.5 hover:bg-teal-50 rounded-lg">
                                        <svg class="h-4 w-4 mr-1.5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z" />
                                        </svg>
                                        Edit
                                    </button>
                                    <form action="{{ route('user.addresses.destroy', $address->id) }}" method="POST"
                                        onsubmit="return confirm('Are you sure you want to delete this address?');">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit"
                                            class="flex items-center text-rose-500 hover:text-rose-700 transition-colors px-3 py-1.5 hover:bg-rose-50 rounded-lg">
                                            <svg class="h-4 w-4 mr-1.5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16" />
                                            </svg>
                                            Delete
                                        </button>
                                    </form>
                                </div>
                            </div>
                        @empty
                            <div
                                class="col-span-1 md:col-span-2 text-center py-16 bg-gray-50 border-2 border-dashed border-gray-200 rounded-2xl">
                                <div class="mx-auto h-16 w-16 bg-gray-100 rounded-full flex items-center justify-center mb-4">
                                    <svg class="h-8 w-8 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z" />
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M15 11a3 3 0 11-6 0 3 3 0 016 0z" />
                                    </svg>
                                </div>
                                <h3 class="text-lg font-medium text-gray-900">No addresses saved</h3>
                                <p class="mt-2 text-sm text-gray-500">Add an address to speed up your checkout process.</p>
                            </div>
                        @endforelse
                    </div>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
        <script>
            function addressRequest() {
                return {
                    open: false,
                    isEditing: false,
                    form: {
                        id: null,
                        name: '',
                        phone: '',
                        postal_code: '',
                        address_line1: '',
                        address_line2: '',
                        city: '',
                        state: '',
                        country: 'India',
                        type: 'home',
                        open_time: '',
                        close_time: '',
                        is_default: false
                    },
                    openModal(mode, address = null) {
                        this.isEditing = mode === 'edit';
                        if (this.isEditing && address) {
                            this.form = {
                                id: address.id,
                                name: address.name,
                                phone: address.phone,
                                postal_code: address.postal_code, // Adjusted
                                address_line1: address.address_line1,
                                address_line2: address.address_line2,
                                city: address.city,
                                state: address.state,
                                country: address.country || 'India',
                                type: address.type,
                                open_time: address.open_time,
                                close_time: address.close_time,
                                is_default: !!address.is_default
                            };
                        } else {
                            this.resetForm();
                        }
                        this.open = true;

                        // Scroll to form
                        this.$nextTick(() => {
                            window.scrollTo({ top: 0, behavior: 'smooth' });
                        });
                    },
                    resetForm() {
                        this.form = {
                            id: null,
                            name: '',
                            phone: '',
                            postal_code: '',
                            address_line1: '',
                            address_line2: '',
                            city: '',
                            state: '',
                            country: 'India',
                            type: 'home',
                            open_time: '',
                            close_time: '',
                            is_default: false
                        };
                    }
                }
            }
        </script>
    @endpush
@endsection